/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy$RegionEntry$;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy$ShardSuitabilityOrdering$;
import org.apache.pekko.cluster.sharding.internal.LeastShardAllocationStrategy$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

@InternalApi
public class LeastShardAllocationStrategy
extends AbstractLeastShardAllocationStrategy {
    private final int absoluteLimit;
    private final double relativeLimit;

    public LeastShardAllocationStrategy(int absoluteLimit, double relativeLimit) {
        this.absoluteLimit = absoluteLimit;
        this.relativeLimit = relativeLimit;
    }

    @Override
    public Future<Set<String>> rebalance(Map<ActorRef, IndexedSeq<String>> currentShardAllocations, Set<String> rebalanceInProgress) {
        if (rebalanceInProgress.nonEmpty()) {
            return LeastShardAllocationStrategy$.org$apache$pekko$cluster$sharding$internal$LeastShardAllocationStrategy$$$emptyRebalanceResult;
        }
        Vector sortedRegionEntries = (Vector)this.regionEntriesFor(currentShardAllocations).toVector().sorted((Ordering)AbstractLeastShardAllocationStrategy$ShardSuitabilityOrdering$.MODULE$);
        if (!this.isAGoodTimeToRebalance((Iterable<AbstractLeastShardAllocationStrategy.RegionEntry>)sortedRegionEntries)) {
            return LeastShardAllocationStrategy$.org$apache$pekko$cluster$sharding$internal$LeastShardAllocationStrategy$$$emptyRebalanceResult;
        }
        int numberOfShards = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)sortedRegionEntries.map((Function1 & Serializable)_$1 -> _$1.shardIds().size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int numberOfRegions = sortedRegionEntries.size();
        if (numberOfRegions == 0 || numberOfShards == 0) {
            return LeastShardAllocationStrategy$.org$apache$pekko$cluster$sharding$internal$LeastShardAllocationStrategy$$$emptyRebalanceResult;
        }
        int optimalPerRegion = numberOfShards / numberOfRegions + (numberOfShards % numberOfRegions == 0 ? 0 : 1);
        Set result1 = this.rebalancePhase1$1(numberOfShards, optimalPerRegion, (Iterable)sortedRegionEntries);
        if (result1.nonEmpty()) {
            return Future$.MODULE$.successful((Object)result1);
        }
        return this.rebalancePhase2$1(numberOfShards, optimalPerRegion, (Iterable)sortedRegionEntries);
    }

    public String toString() {
        return new StringBuilder(31).append("LeastShardAllocationStrategy(").append(this.absoluteLimit).append(",").append(this.relativeLimit).append(")").toString();
    }

    private final int limit$1(int numberOfShards) {
        return package$.MODULE$.max(1, package$.MODULE$.min((int)(this.relativeLimit * (double)numberOfShards), this.absoluteLimit));
    }

    private final Set rebalancePhase1$1(int numberOfShards, int optimalPerRegion, Iterable sortedEntries) {
        ReusableBuilder selected = scala.package$.MODULE$.Vector().newBuilder();
        sortedEntries.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            AbstractLeastShardAllocationStrategy.RegionEntry regionEntry = x$1;
            if (regionEntry != null) {
                AbstractLeastShardAllocationStrategy.RegionEntry regionEntry2 = AbstractLeastShardAllocationStrategy$RegionEntry$.MODULE$.unapply(regionEntry);
                ActorRef actorRef = regionEntry2._1();
                Member member = regionEntry2._2();
                IndexedSeq<String> indexedSeq = regionEntry2._3();
                IndexedSeq<String> shardIds = indexedSeq;
                if (shardIds.size() > optimalPerRegion) {
                    selected.$plus$plus$eq((IterableOnce)shardIds.take(shardIds.size() - optimalPerRegion));
                    return;
                }
                return;
            }
            throw new MatchError((Object)regionEntry);
        });
        Vector result = (Vector)selected.result();
        return result.take(this.limit$1(numberOfShards)).toSet();
    }

    private final Future rebalancePhase2$1(int numberOfShards, int optimalPerRegion, Iterable sortedEntries) {
        int countBelowOptimal = BoxesRunTime.unboxToInt((Object)sortedEntries.iterator().map((Function1 & Serializable)entry -> package$.MODULE$.max(0, optimalPerRegion - 1 - entry.shardIds().size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (countBelowOptimal == 0) {
            return LeastShardAllocationStrategy$.org$apache$pekko$cluster$sharding$internal$LeastShardAllocationStrategy$$$emptyRebalanceResult;
        }
        ReusableBuilder selected = scala.package$.MODULE$.Vector().newBuilder();
        sortedEntries.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            AbstractLeastShardAllocationStrategy.RegionEntry regionEntry = x$1;
            if (regionEntry != null) {
                AbstractLeastShardAllocationStrategy.RegionEntry regionEntry2 = AbstractLeastShardAllocationStrategy$RegionEntry$.MODULE$.unapply(regionEntry);
                ActorRef actorRef = regionEntry2._1();
                Member member = regionEntry2._2();
                IndexedSeq<String> indexedSeq = regionEntry2._3();
                IndexedSeq<String> shardIds = indexedSeq;
                if (shardIds.size() >= optimalPerRegion) {
                    selected.$plus$eq(shardIds.head());
                    return;
                }
                return;
            }
            throw new MatchError((Object)regionEntry);
        });
        Set result = ((Vector)selected.result()).take(package$.MODULE$.min(countBelowOptimal, this.limit$1(numberOfShards))).toSet();
        return Future$.MODULE$.successful((Object)result);
    }
}

