/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy;
import scala.collection.immutable.Seq;

@InternalApi
public abstract class LimitBasedEntityPassivationStrategy
extends EntityPassivationStrategy {
    private int activeShards = 1;
    private int perRegionLimit;
    private int perShardLimit;

    public LimitBasedEntityPassivationStrategy(int initialLimit) {
        this.perRegionLimit = initialLimit;
        this.perShardLimit = this.perRegionLimit();
    }

    public int activeShards() {
        return this.activeShards;
    }

    public void activeShards_$eq(int x$1) {
        this.activeShards = x$1;
    }

    public int perRegionLimit() {
        return this.perRegionLimit;
    }

    public void perRegionLimit_$eq(int x$1) {
        this.perRegionLimit = x$1;
    }

    public int perShardLimit() {
        return this.perShardLimit;
    }

    public void perShardLimit_$eq(int x$1) {
        this.perShardLimit = x$1;
    }

    @Override
    public Seq<String> limitUpdated(int newPerRegionLimit) {
        this.perRegionLimit_$eq(newPerRegionLimit);
        this.perShardLimit_$eq(this.perRegionLimit() / this.activeShards());
        return this.passivateEntitiesOnLimitUpdate();
    }

    @Override
    public Seq<String> shardsUpdated(int newActiveShards) {
        this.activeShards_$eq(newActiveShards);
        this.perShardLimit_$eq(this.perRegionLimit() / this.activeShards());
        return this.passivateEntitiesOnLimitUpdate();
    }

    public abstract Seq<String> passivateEntitiesOnLimitUpdate();
}

