/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.TimerSchedulerImpl;
import org.apache.pekko.actor.Timers;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.Shard$EntitiesMovedToOtherShard$;
import org.apache.pekko.cluster.sharding.ShardRegion;
import org.apache.pekko.cluster.sharding.ShardRegion$StartEntity$;
import org.apache.pekko.cluster.sharding.ShardRegion$StartEntityAck$;
import org.apache.pekko.cluster.sharding.internal.RememberEntityStarter$;
import org.apache.pekko.cluster.sharding.internal.RememberEntityStarter$ResendUnAcked$;
import org.apache.pekko.cluster.sharding.internal.RememberEntityStarter$StartBatch$;
import org.apache.pekko.event.LoggingAdapter;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class RememberEntityStarter
implements Actor,
ActorLogging,
Timers {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;
    private final ActorRef region;
    private final ActorRef shard;
    private final String shardId;
    private final ExecutionContext ec;
    private Set<String> idsLeftToStart;
    private Set<String> waitingForAck;
    private Set<String> entitiesMoved;

    public static Props props(ActorRef actorRef, ActorRef actorRef2, String string, Set<String> set, ClusterShardingSettings clusterShardingSettings) {
        return RememberEntityStarter$.MODULE$.props(actorRef, actorRef2, string, set, clusterShardingSettings);
    }

    public RememberEntityStarter(ActorRef region, ActorRef shard, String shardId, Set<String> ids, ClusterShardingSettings settings) {
        this.region = region;
        this.shard = shard;
        this.shardId = shardId;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        Timers.$init$((Timers)this);
        this.ec = this.context().dispatcher();
        Predef$.MODULE$.require(ids.nonEmpty());
        this.idsLeftToStart = Set$.MODULE$.empty();
        this.waitingForAck = Set$.MODULE$.empty();
        this.entitiesMoved = Set$.MODULE$.empty();
        this.log().debug("Shard starting [{}] remembered entities using strategy [{}]", (Object)BoxesRunTime.boxToInteger((int)ids.size()), (Object)settings.tuningParameters().entityRecoveryStrategy());
        String string = settings.tuningParameters().entityRecoveryStrategy();
        if ("all".equals(string)) {
            this.idsLeftToStart = Set$.MODULE$.empty();
            this.startBatch(ids);
        } else if ("constant".equals(string)) {
            this.idsLeftToStart = ids;
            this.timers().startTimerWithFixedDelay((Object)"constant", (Object)RememberEntityStarter$StartBatch$.MODULE$.apply(settings.tuningParameters().entityRecoveryConstantRateStrategyNumberOfEntities()), settings.tuningParameters().entityRecoveryConstantRateStrategyFrequency());
            this.org$apache$pekko$cluster$sharding$internal$RememberEntityStarter$$startBatch(settings.tuningParameters().entityRecoveryConstantRateStrategyNumberOfEntities());
        } else {
            throw new MatchError((Object)string);
        }
        this.timers().startTimerWithFixedDelay((Object)"retry", (Object)RememberEntityStarter$ResendUnAcked$.MODULE$, settings.tuningParameters().retryInterval());
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
        return this.org$apache$pekko$actor$Timers$$_timers;
    }

    public void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$0) {
        this.org$apache$pekko$actor$Timers$$_timers = x$0;
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
        Actor.aroundReceive$((Actor)this, (PartialFunction)receive, (Object)msg);
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ RememberEntityStarter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof StartBatch) {
                    int n;
                    StartBatch startBatch = RememberEntityStarter$StartBatch$.MODULE$.unapply((StartBatch)object);
                    int batchSize = n = startBatch._1();
                    return true;
                }
                if (object instanceof ShardRegion.StartEntityAck) {
                    ShardRegion.StartEntityAck startEntityAck = ShardRegion$StartEntityAck$.MODULE$.unapply((ShardRegion.StartEntityAck)object);
                    String string = startEntityAck._1();
                    String string2 = startEntityAck._2();
                    String entityId = string;
                    String ackFromShardId = string2;
                    return true;
                }
                return RememberEntityStarter$ResendUnAcked$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof StartBatch) {
                    int n;
                    StartBatch startBatch = RememberEntityStarter$StartBatch$.MODULE$.unapply((StartBatch)object);
                    int batchSize = n = startBatch._1();
                    this.$outer.org$apache$pekko$cluster$sharding$internal$RememberEntityStarter$$startBatch(batchSize);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ShardRegion.StartEntityAck) {
                    ShardRegion.StartEntityAck startEntityAck = ShardRegion$StartEntityAck$.MODULE$.unapply((ShardRegion.StartEntityAck)object);
                    String string = startEntityAck._1();
                    String string2 = startEntityAck._2();
                    String entityId = string;
                    String ackFromShardId = string2;
                    this.$outer.org$apache$pekko$cluster$sharding$internal$RememberEntityStarter$$onAck(entityId, ackFromShardId);
                    return BoxedUnit.UNIT;
                }
                if (RememberEntityStarter$ResendUnAcked$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$cluster$sharding$internal$RememberEntityStarter$$retryUnacked();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void org$apache$pekko$cluster$sharding$internal$RememberEntityStarter$$onAck(String entityId, String ackFromShardId) {
        this.idsLeftToStart = (Set)this.idsLeftToStart.$minus((Object)entityId);
        this.waitingForAck = (Set)this.waitingForAck.$minus((Object)entityId);
        String string = this.shardId;
        String string2 = ackFromShardId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.entitiesMoved = (Set)this.entitiesMoved.$plus((Object)entityId);
        }
        if (this.waitingForAck.isEmpty() && this.idsLeftToStart.isEmpty()) {
            if (this.entitiesMoved.nonEmpty()) {
                this.log().info("Found [{}] entities moved to new shard(s)", (Object)BoxesRunTime.boxToInteger((int)this.entitiesMoved.size()));
                this.shard.$bang((Object)Shard$EntitiesMovedToOtherShard$.MODULE$.apply(this.entitiesMoved), this.self());
            }
            this.context().stop(this.self());
            return;
        }
    }

    public void org$apache$pekko$cluster$sharding$internal$RememberEntityStarter$$startBatch(int batchSize) {
        Set newIdsLeftToStart;
        this.log().debug("Starting batch of [{}] remembered entities", (Object)BoxesRunTime.boxToInteger((int)batchSize));
        Tuple2 tuple2 = this.idsLeftToStart.splitAt(batchSize);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set batch = (Set)tuple2._1();
        Set newIdsLeftToStart2 = (Set)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)batch, (Object)newIdsLeftToStart2);
        Set batch2 = (Set)tuple22._1();
        this.idsLeftToStart = newIdsLeftToStart = (Set)tuple22._2();
        this.startBatch((Set<String>)batch2);
    }

    private void startBatch(Set<String> entityIds) {
        this.waitingForAck = (Set)this.waitingForAck.union(entityIds);
        entityIds.foreach((Function1)(JProcedure1 & Serializable)entityId -> this.region.$bang((Object)ShardRegion$StartEntity$.MODULE$.apply((String)entityId), this.self()));
    }

    public void org$apache$pekko$cluster$sharding$internal$RememberEntityStarter$$retryUnacked() {
        if (this.waitingForAck.nonEmpty()) {
            this.log().debug("Found [{}] remembered entities waiting for StartEntityAck, retrying", (Object)BoxesRunTime.boxToInteger((int)this.waitingForAck.size()));
            this.waitingForAck.foreach((Function1)(JProcedure1 & Serializable)id -> this.region.$bang((Object)ShardRegion$StartEntity$.MODULE$.apply((String)id), this.self()));
            return;
        }
    }

    public static final class StartBatch
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final int batchSize;

        public static StartBatch apply(int n) {
            return RememberEntityStarter$StartBatch$.MODULE$.apply(n);
        }

        public static StartBatch fromProduct(Product product) {
            return RememberEntityStarter$StartBatch$.MODULE$.fromProduct(product);
        }

        public static StartBatch unapply(StartBatch startBatch) {
            return RememberEntityStarter$StartBatch$.MODULE$.unapply(startBatch);
        }

        public StartBatch(int batchSize) {
            this.batchSize = batchSize;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.batchSize());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StartBatch)) return false;
            StartBatch startBatch = (StartBatch)object;
            if (this.batchSize() != startBatch.batchSize()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StartBatch;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StartBatch";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "batchSize";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int batchSize() {
            return this.batchSize;
        }

        public StartBatch copy(int batchSize) {
            return new StartBatch(batchSize);
        }

        public int copy$default$1() {
            return this.batchSize();
        }

        public int _1() {
            return this.batchSize();
        }
    }
}

