/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy$PassivateEntities$;
import org.apache.pekko.cluster.sharding.internal.IdleCheck;
import org.apache.pekko.cluster.sharding.internal.LimitBasedEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.SegmentedLeastRecentlyUsedReplacementPolicy;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class SegmentedLeastRecentlyUsedEntityPassivationStrategy
extends LimitBasedEntityPassivationStrategy {
    private final Option<IdleCheck> idleCheck;
    private final SegmentedLeastRecentlyUsedReplacementPolicy active;

    public SegmentedLeastRecentlyUsedEntityPassivationStrategy(int initialLimit, Seq<Object> proportions, Option<IdleCheck> idleCheck) {
        this.idleCheck = idleCheck;
        super(initialLimit);
        this.active = new SegmentedLeastRecentlyUsedReplacementPolicy(initialLimit, proportions, idleCheck.isDefined());
    }

    public SegmentedLeastRecentlyUsedReplacementPolicy active() {
        return this.active;
    }

    @Override
    public Seq<String> passivateEntitiesOnLimitUpdate() {
        return this.active().updateLimit(this.perShardLimit());
    }

    @Override
    public Seq<String> entityTouched(String id) {
        return this.active().update(id);
    }

    @Override
    public void entityTerminated(String id) {
        this.active().remove(id);
    }

    @Override
    public Option<FiniteDuration> scheduledInterval() {
        return this.idleCheck.map((Function1 & Serializable)_$2 -> _$2.interval());
    }

    @Override
    public Seq<String> intervalPassed() {
        return (Seq)this.idleCheck.fold(SegmentedLeastRecentlyUsedEntityPassivationStrategy::intervalPassed$$anonfun$3, (Function1 & Serializable)idle -> this.active().removeIdle(idle.timeout()));
    }

    private static final Seq intervalPassed$$anonfun$3() {
        return EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
    }
}

