/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities;
import org.apache.pekko.util.SegmentedRecencyList;
import org.apache.pekko.util.SegmentedRecencyList$;
import scala.Function1;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@InternalApi
public final class SegmentedLeastRecentlyUsedReplacementPolicy
extends ActiveEntities {
    private final Seq<Object> proportions;
    private int limit;
    private final SegmentedRecencyList<String> segmentedRecencyList;

    public SegmentedLeastRecentlyUsedReplacementPolicy(int initialLimit, Seq<Object> proportions, boolean idleEnabled) {
        this.proportions = proportions;
        this.limit = initialLimit;
        this.segmentedRecencyList = idleEnabled ? SegmentedRecencyList.withOverallRecency$.MODULE$.empty(this.segmentLimits()) : SegmentedRecencyList$.MODULE$.empty(this.segmentLimits());
    }

    private Seq<Object> segmentLimits() {
        Seq higherLimits = (Seq)((IterableOps)this.proportions.drop(1)).map((Function1)(JFunction1.mcID.sp & Serializable)p -> (int)(p * (double)this.limit));
        int n = this.limit - BoxesRunTime.unboxToInt((Object)higherLimits.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return (Seq)higherLimits.$plus$colon((Object)BoxesRunTime.boxToInteger((int)n));
    }

    @Override
    public int size() {
        return this.segmentedRecencyList.size();
    }

    @Override
    public boolean isActive(String id) {
        return this.segmentedRecencyList.contains((Object)id);
    }

    @Override
    public Seq<String> updateLimit(int newLimit) {
        this.limit = newLimit;
        this.segmentedRecencyList.updateLimits(this.segmentLimits());
        return this.removeExcess();
    }

    @Override
    public Seq<String> update(String id) {
        this.segmentedRecencyList.update((Object)id);
        return this.removeExcess();
    }

    @Override
    public String select() {
        return (String)this.segmentedRecencyList.leastRecent();
    }

    @Override
    public void remove(String id) {
        this.segmentedRecencyList.remove((Object)id);
    }

    @Override
    public Seq<String> removeIdle(FiniteDuration timeout) {
        return this.segmentedRecencyList.removeOverallLeastRecentOutside(timeout);
    }

    private Seq<String> removeExcess() {
        return this.segmentedRecencyList.removeLeastRecentOverLimit();
    }
}

