/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.pubsub;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.cluster.pubsub.DistributedPubSubSettings;
import org.apache.pekko.routing.BroadcastRoutingLogic$;
import org.apache.pekko.routing.RandomRoutingLogic$;
import org.apache.pekko.routing.RoundRobinRoutingLogic;
import org.apache.pekko.routing.RoundRobinRoutingLogic$;
import org.apache.pekko.routing.RoutingLogic;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.ModuleSerializationProxy;

public final class DistributedPubSubSettings$
implements Serializable {
    public static final DistributedPubSubSettings$ MODULE$ = new DistributedPubSubSettings$();

    private DistributedPubSubSettings$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DistributedPubSubSettings$.class);
    }

    public DistributedPubSubSettings apply(ActorSystem system) {
        return this.apply(system.settings().config().getConfig("pekko.cluster.pub-sub"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public DistributedPubSubSettings apply(Config config) {
        Option<String> option = this.roleOption(config.getString("role"));
        String string = config.getString("routing-logic");
        switch (string == null ? 0 : string.hashCode()) {
            case -1662301013: {
                if (!"round-robin".equals(string)) break;
                RoundRobinRoutingLogic roundRobinRoutingLogic = RoundRobinRoutingLogic$.MODULE$.apply();
                return new DistributedPubSubSettings(option, (RoutingLogic)roundRobinRoutingLogic, new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("gossip-interval", package$.MODULE$.MILLISECONDS()))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("removed-time-to-live", package$.MODULE$.MILLISECONDS()))).millis(), config.getInt("max-delta-elements"), config.getBoolean("send-to-dead-letters-when-no-subscribers"));
            }
            case -1618876223: {
                if (!"broadcast".equals(string)) break;
                RoundRobinRoutingLogic roundRobinRoutingLogic = BroadcastRoutingLogic$.MODULE$.apply();
                return new DistributedPubSubSettings(option, (RoutingLogic)roundRobinRoutingLogic, new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("gossip-interval", package$.MODULE$.MILLISECONDS()))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("removed-time-to-live", package$.MODULE$.MILLISECONDS()))).millis(), config.getInt("max-delta-elements"), config.getBoolean("send-to-dead-letters-when-no-subscribers"));
            }
            case -938285885: {
                if (!"random".equals(string)) break;
                RoundRobinRoutingLogic roundRobinRoutingLogic = RandomRoutingLogic$.MODULE$.apply();
                return new DistributedPubSubSettings(option, (RoutingLogic)roundRobinRoutingLogic, new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("gossip-interval", package$.MODULE$.MILLISECONDS()))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("removed-time-to-live", package$.MODULE$.MILLISECONDS()))).millis(), config.getInt("max-delta-elements"), config.getBoolean("send-to-dead-letters-when-no-subscribers"));
            }
            case -560580647: {
                if (!"consistent-hashing".equals(string)) break;
                throw new IllegalArgumentException("'consistent-hashing' routing logic can't be used by the pub-sub mediator");
            }
        }
        String other = string;
        throw new IllegalArgumentException(new StringBuilder(27).append("Unknown 'routing-logic': [").append(other).append("]").toString());
    }

    public DistributedPubSubSettings create(ActorSystem system) {
        return this.apply(system);
    }

    public DistributedPubSubSettings create(Config config) {
        return this.apply(config);
    }

    public Option<String> roleOption(String role) {
        String string = role;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply((Object)role);
    }
}

