/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.pubsub.protobuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Internal$Bucket$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Internal$Delta$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Internal$SendToOneSubscriber$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Internal$Status$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Internal$ValueHolder$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Publish$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Send$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$SendToAll$;
import org.apache.pekko.cluster.pubsub.protobuf.msg.DistributedPubSubMessages;
import org.apache.pekko.protobufv3.internal.ByteString;
import org.apache.pekko.protobufv3.internal.MessageLite;
import org.apache.pekko.remote.ByteStringUtils$;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class DistributedPubSubMessageSerializer
extends SerializerWithStringManifest
implements BaseSerializer {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DistributedPubSubMessageSerializer.class.getDeclaredField("serialization$lzy1"));
    private int identifier;
    private final ExtendedActorSystem system;
    private volatile Object serialization$lzy1;
    private final String StatusManifest;
    private final String DeltaManifest;
    private final String SendManifest;
    private final String SendToAllManifest;
    private final String PublishManifest;
    private final String SendToOneSubscriberManifest;
    private final HashMap<String, Function1<byte[], Object>> fromBinaryMap;

    public DistributedPubSubMessageSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$((BaseSerializer)this);
        int BufferSize = 4096;
        this.StatusManifest = "A";
        this.DeltaManifest = "B";
        this.SendManifest = "C";
        this.SendToAllManifest = "D";
        this.PublishManifest = "E";
        this.SendToOneSubscriberManifest = "F";
        Object[] objectArray = new Tuple2[6];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.StatusManifest);
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Function1 & Serializable)bytes -> this.statusFromBinary((byte[])bytes));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DeltaManifest);
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Function1 & Serializable)bytes -> this.deltaFromBinary((byte[])bytes));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.SendManifest);
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Function1 & Serializable)bytes -> this.sendFromBinary((byte[])bytes));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.SendToAllManifest);
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Function1 & Serializable)bytes -> this.sendToAllFromBinary((byte[])bytes));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.PublishManifest);
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Function1 & Serializable)bytes -> this.publishFromBinary((byte[])bytes));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.SendToOneSubscriberManifest);
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Function1 & Serializable)bytes -> this.sendToOneSubscriberFromBinary((byte[])bytes));
        this.fromBinaryMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Statics.releaseFence();
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$0) {
        this.identifier = x$0;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                        object2 = serialization == null ? LazyVals.NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String manifest(Object obj) {
        Object object = obj;
        if (object instanceof DistributedPubSubMediator.Internal.Status) {
            return this.StatusManifest;
        }
        if (object instanceof DistributedPubSubMediator.Internal.Delta) {
            return this.DeltaManifest;
        }
        if (object instanceof DistributedPubSubMediator.Send) {
            return this.SendManifest;
        }
        if (object instanceof DistributedPubSubMediator.SendToAll) {
            return this.SendToAllManifest;
        }
        if (object instanceof DistributedPubSubMediator.Publish) {
            return this.PublishManifest;
        }
        if (object instanceof DistributedPubSubMediator.Internal.SendToOneSubscriber) {
            return this.SendToOneSubscriberManifest;
        }
        throw new IllegalArgumentException(new StringBuilder(37).append("Can't serialize object of type ").append(obj.getClass()).append(" in [").append(this.getClass().getName()).append("]").toString());
    }

    public byte[] toBinary(Object obj) {
        Object object = obj;
        if (object instanceof DistributedPubSubMediator.Internal.Status) {
            DistributedPubSubMediator.Internal.Status m = (DistributedPubSubMediator.Internal.Status)object;
            return this.compress((MessageLite)this.statusToProto(m));
        }
        if (object instanceof DistributedPubSubMediator.Internal.Delta) {
            DistributedPubSubMediator.Internal.Delta m = (DistributedPubSubMediator.Internal.Delta)object;
            return this.compress((MessageLite)this.deltaToProto(m));
        }
        if (object instanceof DistributedPubSubMediator.Send) {
            DistributedPubSubMediator.Send m = (DistributedPubSubMediator.Send)object;
            return this.sendToProto(m).toByteArray();
        }
        if (object instanceof DistributedPubSubMediator.SendToAll) {
            DistributedPubSubMediator.SendToAll m = (DistributedPubSubMediator.SendToAll)object;
            return this.sendToAllToProto(m).toByteArray();
        }
        if (object instanceof DistributedPubSubMediator.Publish) {
            DistributedPubSubMediator.Publish m = (DistributedPubSubMediator.Publish)object;
            return this.publishToProto(m).toByteArray();
        }
        if (object instanceof DistributedPubSubMediator.Internal.SendToOneSubscriber) {
            DistributedPubSubMediator.Internal.SendToOneSubscriber m = (DistributedPubSubMediator.Internal.SendToOneSubscriber)object;
            return this.sendToOneSubscriberToProto(m).toByteArray();
        }
        throw new IllegalArgumentException(new StringBuilder(37).append("Can't serialize object of type ").append(obj.getClass()).append(" in [").append(this.getClass().getName()).append("]").toString());
    }

    public Object fromBinary(byte[] bytes, String manifest) {
        Option option = this.fromBinaryMap.get((Object)manifest);
        if (option instanceof Some) {
            Function1 f = (Function1)((Some)option).value();
            return f.apply((Object)bytes);
        }
        if (None$.MODULE$.equals(option)) {
            throw new NotSerializableException(new StringBuilder(63).append("Unimplemented deserialization of message with manifest [").append(manifest).append("] in [").append(this.getClass().getName()).append("]").toString());
        }
        throw new MatchError((Object)option);
    }

    private byte[] compress(MessageLite msg) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        try (GZIPOutputStream zip = new GZIPOutputStream(bos);){
            msg.writeTo((OutputStream)zip);
        }
        return bos.toByteArray();
    }

    private byte[] decompress(byte[] bytes) {
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            DistributedPubSubMessageSerializer.readChunk$1(in, out, buffer);
        }
        finally {
            in.close();
        }
        return out.toByteArray();
    }

    private DistributedPubSubMessages.Address.Builder addressToProto(Address address) {
        Address address2 = address;
        if (address2 != null) {
            Address address3 = Address$.MODULE$.unapply(address2);
            String string = address3._1();
            String string2 = address3._2();
            Option option = address3._3();
            Option option2 = address3._4();
            String protocol = string;
            String system = string2;
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return DistributedPubSubMessages.Address.newBuilder().setSystem(system).setHostname(host).setPort(port).setProtocol(protocol);
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(57).append("Address [").append(address).append("] could not be serialized: host or port missing.").toString());
    }

    private Address addressFromProto(DistributedPubSubMessages.Address address) {
        return Address$.MODULE$.apply(address.getProtocol(), address.getSystem(), address.getHostname(), address.getPort());
    }

    private DistributedPubSubMessages.Status statusToProto(DistributedPubSubMediator.Internal.Status status) {
        List versions = package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)status.versions().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Address a = (Address)tuple2._1();
                long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return DistributedPubSubMessages.Status.Version.newBuilder().setAddress(this.addressToProto(a)).setTimestamp(v).build();
            }
            throw new MatchError((Object)tuple2);
        })).toVector()).asJava();
        return DistributedPubSubMessages.Status.newBuilder().addAllVersions(versions).setReplyToStatus(status.isReplyToStatus()).build();
    }

    private DistributedPubSubMediator.Internal.Status statusFromBinary(byte[] bytes) {
        return this.statusFromProto(DistributedPubSubMessages.Status.parseFrom(this.decompress(bytes)));
    }

    private DistributedPubSubMediator.Internal.Status statusFromProto(DistributedPubSubMessages.Status status) {
        boolean isReplyToStatus = status.hasReplyToStatus() ? status.getReplyToStatus() : false;
        return DistributedPubSubMediator$Internal$Status$.MODULE$.apply((Map<Address, Object>)package.JavaConverters$.MODULE$.ListHasAsScala(status.getVersionsList()).asScala().iterator().map((Function1 & Serializable)v -> {
            Address address = (Address)Predef$.MODULE$.ArrowAssoc((Object)this.addressFromProto(v.getAddress()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address, (Object)BoxesRunTime.boxToLong((long)v.getTimestamp()));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), isReplyToStatus);
    }

    private DistributedPubSubMessages.Delta deltaToProto(DistributedPubSubMediator.Internal.Delta delta) {
        List buckets = package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)delta.buckets().map((Function1 & Serializable)b -> {
            List entries = package.JavaConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)b.content().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    DistributedPubSubMediator.Internal.ValueHolder value = (DistributedPubSubMediator.Internal.ValueHolder)tuple2._2();
                    DistributedPubSubMessages.Delta.Entry.Builder b = DistributedPubSubMessages.Delta.Entry.newBuilder().setKey(key).setVersion(value.version());
                    value.ref().foreach((Function1 & Serializable)r -> b.setRef(Serialization$.MODULE$.serializedActorPath(r)));
                    return b.build();
                }
                throw new MatchError((Object)tuple2);
            })).toVector()).asJava();
            return DistributedPubSubMessages.Delta.Bucket.newBuilder().setOwner(this.addressToProto(b.owner())).setVersion(b.version()).addAllContent(entries).build();
        })).toVector()).asJava();
        return DistributedPubSubMessages.Delta.newBuilder().addAllBuckets(buckets).build();
    }

    private DistributedPubSubMediator.Internal.Delta deltaFromBinary(byte[] bytes) {
        return this.deltaFromProto(DistributedPubSubMessages.Delta.parseFrom(this.decompress(bytes)));
    }

    private DistributedPubSubMediator.Internal.Delta deltaFromProto(DistributedPubSubMessages.Delta delta) {
        return DistributedPubSubMediator$Internal$Delta$.MODULE$.apply((Iterable<DistributedPubSubMediator.Internal.Bucket>)((Iterable)package.JavaConverters$.MODULE$.ListHasAsScala(delta.getBucketsList()).asScala().toVector().map((Function1 & Serializable)b -> {
            TreeMap content = TreeMap$.MODULE$.from((IterableOnce)package.JavaConverters$.MODULE$.ListHasAsScala(b.getContentList()).asScala().iterator().map((Function1 & Serializable)entry -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)entry.getKey());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)DistributedPubSubMediator$Internal$ValueHolder$.MODULE$.apply(entry.getVersion(), (Option<ActorRef>)(entry.hasRef() ? Some$.MODULE$.apply((Object)this.resolveActorRef(entry.getRef())) : None$.MODULE$)));
            }), (Ordering)Ordering.String$.MODULE$);
            return DistributedPubSubMediator$Internal$Bucket$.MODULE$.apply(this.addressFromProto(b.getOwner()), b.getVersion(), (TreeMap<String, DistributedPubSubMediator.Internal.ValueHolder>)content);
        })));
    }

    private ActorRef resolveActorRef(String path) {
        return this.system().provider().resolveActorRef(path);
    }

    private DistributedPubSubMessages.Send sendToProto(DistributedPubSubMediator.Send send) {
        return DistributedPubSubMessages.Send.newBuilder().setPath(send.path()).setLocalAffinity(send.localAffinity()).setPayload(this.payloadToProto(send.msg())).build();
    }

    private DistributedPubSubMediator.Send sendFromBinary(byte[] bytes) {
        return this.sendFromProto(DistributedPubSubMessages.Send.parseFrom(bytes));
    }

    private DistributedPubSubMediator.Send sendFromProto(DistributedPubSubMessages.Send send) {
        return DistributedPubSubMediator$Send$.MODULE$.apply(send.getPath(), this.payloadFromProto(send.getPayload()), send.getLocalAffinity());
    }

    private DistributedPubSubMessages.SendToAll sendToAllToProto(DistributedPubSubMediator.SendToAll sendToAll) {
        return DistributedPubSubMessages.SendToAll.newBuilder().setPath(sendToAll.path()).setAllButSelf(sendToAll.allButSelf()).setPayload(this.payloadToProto(sendToAll.msg())).build();
    }

    private DistributedPubSubMediator.SendToAll sendToAllFromBinary(byte[] bytes) {
        return this.sendToAllFromProto(DistributedPubSubMessages.SendToAll.parseFrom(bytes));
    }

    private DistributedPubSubMediator.SendToAll sendToAllFromProto(DistributedPubSubMessages.SendToAll sendToAll) {
        return DistributedPubSubMediator$SendToAll$.MODULE$.apply(sendToAll.getPath(), this.payloadFromProto(sendToAll.getPayload()), sendToAll.getAllButSelf());
    }

    private DistributedPubSubMessages.Publish publishToProto(DistributedPubSubMediator.Publish publish) {
        return DistributedPubSubMessages.Publish.newBuilder().setTopic(publish.topic()).setPayload(this.payloadToProto(publish.msg())).build();
    }

    private DistributedPubSubMediator.Publish publishFromBinary(byte[] bytes) {
        return this.publishFromProto(DistributedPubSubMessages.Publish.parseFrom(bytes));
    }

    private DistributedPubSubMediator.Publish publishFromProto(DistributedPubSubMessages.Publish publish) {
        return DistributedPubSubMediator$Publish$.MODULE$.apply(publish.getTopic(), this.payloadFromProto(publish.getPayload()));
    }

    private DistributedPubSubMessages.SendToOneSubscriber sendToOneSubscriberToProto(DistributedPubSubMediator.Internal.SendToOneSubscriber sendToOneSubscriber) {
        return DistributedPubSubMessages.SendToOneSubscriber.newBuilder().setPayload(this.payloadToProto(sendToOneSubscriber.msg())).build();
    }

    private DistributedPubSubMediator.Internal.SendToOneSubscriber sendToOneSubscriberFromBinary(byte[] bytes) {
        return this.sendToOneSubscriberFromProto(DistributedPubSubMessages.SendToOneSubscriber.parseFrom(bytes));
    }

    private DistributedPubSubMediator.Internal.SendToOneSubscriber sendToOneSubscriberFromProto(DistributedPubSubMessages.SendToOneSubscriber sendToOneSubscriber) {
        return DistributedPubSubMediator$Internal$SendToOneSubscriber$.MODULE$.apply(this.payloadFromProto(sendToOneSubscriber.getPayload()));
    }

    private DistributedPubSubMessages.Payload payloadToProto(Object msg) {
        Object m = msg;
        Serializer msgSerializer = this.serialization().findSerializerFor(m);
        DistributedPubSubMessages.Payload.Builder builder = DistributedPubSubMessages.Payload.newBuilder().setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(msgSerializer.toBinary(m))).setSerializerId(msgSerializer.identifier());
        String ms = Serializers$.MODULE$.manifestFor(msgSerializer, m);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ms))) {
            builder.setMessageManifest(ByteString.copyFromUtf8((String)ms));
        }
        return builder.build();
    }

    private Object payloadFromProto(DistributedPubSubMessages.Payload payload) {
        String manifest = payload.hasMessageManifest() ? payload.getMessageManifest().toStringUtf8() : "";
        return this.serialization().deserialize(payload.getEnclosedMessage().toByteArray(), payload.getSerializerId(), manifest).get();
    }

    private static final void readChunk$1(GZIPInputStream in$1, ByteArrayOutputStream out$1, byte[] buffer$1) {
        int n;
        while (-1 != (n = in$1.read(buffer$1))) {
            int n2 = n;
            out$1.write(buffer$1, 0, n2);
        }
        return;
    }
}

