/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.client;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorIdentity;
import org.apache.pekko.actor.ActorIdentity$;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorPath$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Identify$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.cluster.client.ClusterClient$;
import org.apache.pekko.cluster.client.ClusterClient$Internal$HeartbeatTick$;
import org.apache.pekko.cluster.client.ClusterClient$Internal$ReconnectTimeout$;
import org.apache.pekko.cluster.client.ClusterClient$Internal$RefreshContactsTick$;
import org.apache.pekko.cluster.client.ClusterClient$Publish$;
import org.apache.pekko.cluster.client.ClusterClient$Send$;
import org.apache.pekko.cluster.client.ClusterClient$SendToAll$;
import org.apache.pekko.cluster.client.ClusterClientSettings;
import org.apache.pekko.cluster.client.ClusterReceptionist;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$Contacts$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$GetContacts$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$Heartbeat$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$HeartbeatRsp$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$ReceptionistShutdown$;
import org.apache.pekko.cluster.client.ContactPointAdded;
import org.apache.pekko.cluster.client.ContactPointAdded$;
import org.apache.pekko.cluster.client.ContactPointRemoved;
import org.apache.pekko.cluster.client.ContactPointRemoved$;
import org.apache.pekko.cluster.client.ContactPoints$;
import org.apache.pekko.cluster.client.GetContactPoints$;
import org.apache.pekko.cluster.client.SubscribeContactPoints$;
import org.apache.pekko.cluster.client.UnsubscribeContactPoints$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Publish$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$Send$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator$SendToAll$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.DeadlineFailureDetector;
import org.apache.pekko.remote.FailureDetector$;
import org.apache.pekko.util.MessageBuffer;
import org.apache.pekko.util.MessageBuffer$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;

public final class ClusterClient
implements Actor,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    public final ClusterClientSettings org$apache$pekko$cluster$client$ClusterClient$$settings;
    private final DeadlineFailureDetector failureDetector;
    private HashSet contactPaths;
    private final HashSet initialContactsSel;
    private HashSet contacts;
    private HashSet contactPathsPublished;
    private Vector subscribers;
    private final Cancellable heartbeatTask;
    private Option refreshContactsTask;
    private MessageBuffer buffer;

    public static Props props(ClusterClientSettings clusterClientSettings) {
        return ClusterClient$.MODULE$.props(clusterClientSettings);
    }

    public ClusterClient(ClusterClientSettings settings) {
        this.org$apache$pekko$cluster$client$ClusterClient$$settings = settings;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        Predef$.MODULE$.require(settings.initialContacts().nonEmpty(), ClusterClient::$init$$$anonfun$2);
        this.failureDetector = new DeadlineFailureDetector(settings.acceptableHeartbeatPause(), settings.heartbeatInterval(), FailureDetector$.MODULE$.defaultClock());
        this.contactPaths = (HashSet)settings.initialContacts().to(IterableFactory$.MODULE$.toFactory((IterableFactory)HashSet$.MODULE$));
        this.initialContactsSel = (HashSet)this.contactPaths().map((Function1 & Serializable)path -> this.context().actorSelection(path));
        this.contacts = this.initialContactsSel();
        this.sendGetContacts();
        this.contactPathsPublished = this.contactPaths();
        this.subscribers = package$.MODULE$.Vector().empty();
        this.heartbeatTask = this.context().system().scheduler().scheduleWithFixedDelay(settings.heartbeatInterval(), settings.heartbeatInterval(), this.self(), (Object)ClusterClient$Internal$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.refreshContactsTask = None$.MODULE$;
        this.scheduleRefreshContactsTick(settings.establishingGetContactsInterval());
        this.self().$bang((Object)ClusterClient$Internal$RefreshContactsTick$.MODULE$, this.self());
        this.buffer = MessageBuffer$.MODULE$.empty();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public DeadlineFailureDetector failureDetector() {
        return this.failureDetector;
    }

    public HashSet<ActorPath> contactPaths() {
        return this.contactPaths;
    }

    public void contactPaths_$eq(HashSet<ActorPath> x$1) {
        this.contactPaths = x$1;
    }

    public HashSet<ActorSelection> initialContactsSel() {
        return this.initialContactsSel;
    }

    public HashSet<ActorSelection> contacts() {
        return this.contacts;
    }

    public void contacts_$eq(HashSet<ActorSelection> x$1) {
        this.contacts = x$1;
    }

    public HashSet<ActorPath> contactPathsPublished() {
        return this.contactPathsPublished;
    }

    public void contactPathsPublished_$eq(HashSet<ActorPath> x$1) {
        this.contactPathsPublished = x$1;
    }

    public Vector<ActorRef> subscribers() {
        return this.subscribers;
    }

    public void subscribers_$eq(Vector<ActorRef> x$1) {
        this.subscribers = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    public Option<Cancellable> refreshContactsTask() {
        return this.refreshContactsTask;
    }

    public void refreshContactsTask_$eq(Option<Cancellable> x$1) {
        this.refreshContactsTask = x$1;
    }

    public MessageBuffer buffer() {
        return this.buffer;
    }

    public void buffer_$eq(MessageBuffer x$1) {
        this.buffer = x$1;
    }

    public void scheduleRefreshContactsTick(FiniteDuration interval) {
        this.refreshContactsTask().foreach((Function1 & Serializable)_$1 -> _$1.cancel());
        this.refreshContactsTask_$eq((Option<Cancellable>)Some$.MODULE$.apply((Object)this.context().system().scheduler().scheduleWithFixedDelay(interval, interval, this.self(), (Object)ClusterClient$Internal$RefreshContactsTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self())));
    }

    public void postStop() {
        Actor.postStop$((Actor)this);
        this.heartbeatTask().cancel();
        this.refreshContactsTask().foreach((Function1 & Serializable)_$2 -> _$2.cancel());
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.establishing().orElse(this.contactPointMessages());
    }

    public PartialFunction<Object, BoxedUnit> establishing() {
        Option connectTimerCancelable = this.org$apache$pekko$cluster$client$ClusterClient$$settings.reconnectTimeout().map((Function1 & Serializable)timeout -> this.context().system().scheduler().scheduleOnce(timeout, this.self(), (Object)ClusterClient$Internal$ReconnectTimeout$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self()));
        return new Serializable(connectTimerCancelable, this){
            private final Option connectTimerCancelable$1;
            private final /* synthetic */ ClusterClient $outer;
            {
                this.connectTimerCancelable$1 = connectTimerCancelable$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ClusterReceptionist.Internal.Contacts) {
                    IndexedSeq<String> indexedSeq;
                    ClusterReceptionist.Internal.Contacts contacts = ClusterReceptionist$Internal$Contacts$.MODULE$.unapply((ClusterReceptionist.Internal.Contacts)object);
                    IndexedSeq<String> contactPoints = indexedSeq = contacts._1();
                    return true;
                }
                if (object instanceof ActorIdentity) {
                    ActorIdentity actorIdentity = ActorIdentity$.MODULE$.unapply((ActorIdentity)object);
                    Object object2 = actorIdentity._1();
                    Option option = actorIdentity._2();
                    if (option instanceof Some) {
                        ActorRef receptionist = (ActorRef)((Some)option).value();
                        return true;
                    }
                    if (None$.MODULE$.equals(option)) {
                        return true;
                    }
                }
                if (ClusterClient$Internal$HeartbeatTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (ClusterClient$Internal$RefreshContactsTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Send) {
                    Send send = ClusterClient$Send$.MODULE$.unapply((Send)object);
                    String string = send._1();
                    Object object3 = send._2();
                    boolean bl = send._3();
                    String path = string;
                    Object msg = object3;
                    boolean localAffinity = bl;
                    return true;
                }
                if (object instanceof SendToAll) {
                    SendToAll sendToAll = ClusterClient$SendToAll$.MODULE$.unapply((SendToAll)object);
                    String string = sendToAll._1();
                    Object object4 = sendToAll._2();
                    String path = string;
                    Object msg = object4;
                    return true;
                }
                if (object instanceof Publish) {
                    Publish publish = ClusterClient$Publish$.MODULE$.unapply((Publish)object);
                    String string = publish._1();
                    Object object5 = publish._2();
                    String topic = string;
                    Object msg = object5;
                    return true;
                }
                if (ClusterClient$Internal$ReconnectTimeout$.MODULE$.equals(object)) {
                    return true;
                }
                return ClusterReceptionist$Internal$ReceptionistShutdown$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ClusterReceptionist.Internal.Contacts) {
                    ClusterReceptionist.Internal.Contacts contacts = ClusterReceptionist$Internal$Contacts$.MODULE$.unapply((ClusterReceptionist.Internal.Contacts)object);
                    IndexedSeq<String> indexedSeq = contacts._1();
                    IndexedSeq<String> contactPoints = indexedSeq;
                    if (contactPoints.nonEmpty()) {
                        this.$outer.contactPaths_$eq((HashSet<ActorPath>)((HashSet)((IterableOnceOps)contactPoints.map(ClusterClient::org$apache$pekko$cluster$client$ClusterClient$$anon$1$$_$applyOrElse$$anonfun$1)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)HashSet$.MODULE$))));
                        this.$outer.contacts_$eq((HashSet<ActorSelection>)((HashSet)this.$outer.contactPaths().map((Function1 & Serializable)path -> this.$outer.context().actorSelection(path))));
                        this.$outer.contacts().foreach((Function1)(JProcedure1 & Serializable)_$3 -> ActorSelection$.MODULE$.toScala(_$3).$bang((Object)Identify$.MODULE$.apply((Object)Array$.MODULE$.emptyByteArray()), this.$outer.self()));
                    }
                    this.$outer.publishContactPoints();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ActorIdentity) {
                    ActorIdentity actorIdentity = ActorIdentity$.MODULE$.unapply((ActorIdentity)object);
                    Object object2 = actorIdentity._1();
                    Option option = actorIdentity._2();
                    if (option instanceof Some) {
                        ActorRef receptionist = (ActorRef)((Some)option).value();
                        this.$outer.log().info("Connected to [{}]", (Object)receptionist.path());
                        this.$outer.scheduleRefreshContactsTick(this.$outer.org$apache$pekko$cluster$client$ClusterClient$$settings.refreshContactsInterval());
                        this.$outer.sendBuffered(receptionist);
                        this.$outer.context().become(this.$outer.active(receptionist).orElse(this.$outer.contactPointMessages()));
                        this.connectTimerCancelable$1.foreach(ClusterClient::org$apache$pekko$cluster$client$ClusterClient$$anon$1$$_$applyOrElse$$anonfun$4);
                        this.$outer.failureDetector().heartbeat();
                        this.$outer.self().$bang((Object)ClusterClient$Internal$HeartbeatTick$.MODULE$, this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    if (None$.MODULE$.equals(option)) {
                        return BoxedUnit.UNIT;
                    }
                }
                if (ClusterClient$Internal$HeartbeatTick$.MODULE$.equals(object)) {
                    this.$outer.failureDetector().heartbeat();
                    return BoxedUnit.UNIT;
                }
                if (ClusterClient$Internal$RefreshContactsTick$.MODULE$.equals(object)) {
                    this.$outer.sendGetContacts();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Send) {
                    Send send = ClusterClient$Send$.MODULE$.unapply((Send)object);
                    String string = send._1();
                    Object object3 = send._2();
                    boolean bl = send._3();
                    String path2 = string;
                    Object msg = object3;
                    boolean localAffinity = bl;
                    this.$outer.buffer(DistributedPubSubMediator$Send$.MODULE$.apply(path2, msg, localAffinity));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof SendToAll) {
                    SendToAll sendToAll = ClusterClient$SendToAll$.MODULE$.unapply((SendToAll)object);
                    String string = sendToAll._1();
                    Object object4 = sendToAll._2();
                    String path3 = string;
                    Object msg = object4;
                    this.$outer.buffer(DistributedPubSubMediator$SendToAll$.MODULE$.apply(path3, msg, DistributedPubSubMediator$SendToAll$.MODULE$.$lessinit$greater$default$3()));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Publish) {
                    Publish publish = ClusterClient$Publish$.MODULE$.unapply((Publish)object);
                    String string = publish._1();
                    Object object5 = publish._2();
                    String topic = string;
                    Object msg = object5;
                    this.$outer.buffer(DistributedPubSubMediator$Publish$.MODULE$.apply(topic, msg));
                    return BoxedUnit.UNIT;
                }
                if (ClusterClient$Internal$ReconnectTimeout$.MODULE$.equals(object)) {
                    this.$outer.log().warning("Receptionist reconnect not successful within {} stopping cluster client", this.$outer.org$apache$pekko$cluster$client$ClusterClient$$settings.reconnectTimeout());
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (ClusterReceptionist$Internal$ReceptionistShutdown$.MODULE$.equals(object)) {
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$cluster$client$ClusterClient$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.String ), applyOrElse$$anonfun$2(org.apache.pekko.actor.ActorPath ), applyOrElse$$anonfun$3(org.apache.pekko.actor.ActorSelection ), org$apache$pekko$cluster$client$ClusterClient$$anon$1$$_$applyOrElse$$anonfun$4(org.apache.pekko.actor.Cancellable )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active(ActorRef receptionist) {
        return new Serializable(receptionist, this){
            private final ActorRef receptionist$1;
            private final /* synthetic */ ClusterClient $outer;
            {
                this.receptionist$1 = receptionist$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Send) {
                    Send send = ClusterClient$Send$.MODULE$.unapply((Send)object);
                    String string = send._1();
                    Object object2 = send._2();
                    boolean bl = send._3();
                    String path = string;
                    Object msg = object2;
                    boolean localAffinity = bl;
                    return true;
                }
                if (object instanceof SendToAll) {
                    SendToAll sendToAll = ClusterClient$SendToAll$.MODULE$.unapply((SendToAll)object);
                    String string = sendToAll._1();
                    Object object3 = sendToAll._2();
                    String path = string;
                    Object msg = object3;
                    return true;
                }
                if (object instanceof Publish) {
                    Publish publish = ClusterClient$Publish$.MODULE$.unapply((Publish)object);
                    String string = publish._1();
                    Object object4 = publish._2();
                    String topic = string;
                    Object msg = object4;
                    return true;
                }
                if (ClusterClient$Internal$HeartbeatTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (ClusterReceptionist$Internal$HeartbeatRsp$.MODULE$.equals(object)) {
                    return true;
                }
                if (ClusterClient$Internal$RefreshContactsTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ClusterReceptionist.Internal.Contacts) {
                    IndexedSeq<String> indexedSeq;
                    ClusterReceptionist.Internal.Contacts contacts = ClusterReceptionist$Internal$Contacts$.MODULE$.unapply((ClusterReceptionist.Internal.Contacts)object);
                    IndexedSeq<String> contactPoints = indexedSeq = contacts._1();
                    return true;
                }
                if (object instanceof ActorIdentity) {
                    return true;
                }
                return ClusterReceptionist$Internal$ReceptionistShutdown$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Send) {
                    Send send = ClusterClient$Send$.MODULE$.unapply((Send)object);
                    String string = send._1();
                    Object object2 = send._2();
                    boolean bl = send._3();
                    String path2 = string;
                    Object msg = object2;
                    boolean localAffinity = bl;
                    this.receptionist$1.forward((Object)DistributedPubSubMediator$Send$.MODULE$.apply(path2, msg, localAffinity), this.$outer.context());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof SendToAll) {
                    SendToAll sendToAll = ClusterClient$SendToAll$.MODULE$.unapply((SendToAll)object);
                    String string = sendToAll._1();
                    Object object3 = sendToAll._2();
                    String path3 = string;
                    Object msg = object3;
                    this.receptionist$1.forward((Object)DistributedPubSubMediator$SendToAll$.MODULE$.apply(path3, msg, DistributedPubSubMediator$SendToAll$.MODULE$.$lessinit$greater$default$3()), this.$outer.context());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Publish) {
                    Publish publish = ClusterClient$Publish$.MODULE$.unapply((Publish)object);
                    String string = publish._1();
                    Object object4 = publish._2();
                    String topic = string;
                    Object msg = object4;
                    this.receptionist$1.forward((Object)DistributedPubSubMediator$Publish$.MODULE$.apply(topic, msg), this.$outer.context());
                    return BoxedUnit.UNIT;
                }
                if (ClusterClient$Internal$HeartbeatTick$.MODULE$.equals(object)) {
                    if (!this.$outer.failureDetector().isAvailable()) {
                        this.$outer.log().info("Lost contact with [{}], reestablishing connection", (Object)this.receptionist$1);
                        this.$outer.reestablish();
                        return BoxedUnit.UNIT;
                    }
                    this.receptionist$1.$bang((Object)ClusterReceptionist$Internal$Heartbeat$.MODULE$, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (ClusterReceptionist$Internal$HeartbeatRsp$.MODULE$.equals(object)) {
                    this.$outer.failureDetector().heartbeat();
                    return BoxedUnit.UNIT;
                }
                if (ClusterClient$Internal$RefreshContactsTick$.MODULE$.equals(object)) {
                    this.receptionist$1.$bang((Object)ClusterReceptionist$Internal$GetContacts$.MODULE$, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterReceptionist.Internal.Contacts) {
                    ClusterReceptionist.Internal.Contacts contacts = ClusterReceptionist$Internal$Contacts$.MODULE$.unapply((ClusterReceptionist.Internal.Contacts)object);
                    IndexedSeq<String> indexedSeq = contacts._1();
                    IndexedSeq<String> contactPoints = indexedSeq;
                    if (contactPoints.nonEmpty()) {
                        this.$outer.contactPaths_$eq((HashSet<ActorPath>)((HashSet)((IterableOnceOps)contactPoints.map(ClusterClient::org$apache$pekko$cluster$client$ClusterClient$$anon$2$$_$applyOrElse$$anonfun$5)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)HashSet$.MODULE$))));
                        this.$outer.contacts_$eq((HashSet<ActorSelection>)((HashSet)this.$outer.contactPaths().map((Function1 & Serializable)path -> this.$outer.context().actorSelection(path))));
                    }
                    this.$outer.publishContactPoints();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ActorIdentity) {
                    return BoxedUnit.UNIT;
                }
                if (ClusterReceptionist$Internal$ReceptionistShutdown$.MODULE$.equals(object)) {
                    ActorRef actorRef = this.receptionist$1;
                    ActorRef actorRef2 = this.$outer.sender();
                    if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                        this.$outer.log().info("Receptionist [{}] is shutting down, reestablishing connection", (Object)this.receptionist$1);
                        this.$outer.reestablish();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$cluster$client$ClusterClient$$anon$2$$_$applyOrElse$$anonfun$5(java.lang.String ), applyOrElse$$anonfun$6(org.apache.pekko.actor.ActorPath )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> contactPointMessages() {
        return new Serializable(this){
            private final /* synthetic */ ClusterClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (SubscribeContactPoints$.MODULE$.equals(object)) {
                    return true;
                }
                if (UnsubscribeContactPoints$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef subscriber = actorRef = terminated._1();
                    return true;
                }
                return GetContactPoints$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (SubscribeContactPoints$.MODULE$.equals(object)) {
                    ActorRef subscriber = this.$outer.sender();
                    subscriber.$bang((Object)ContactPoints$.MODULE$.apply((Set<ActorPath>)this.$outer.contactPaths()), this.$outer.self());
                    this.$outer.subscribers_$eq((Vector<ActorRef>)((Vector)this.$outer.subscribers().$colon$plus((Object)subscriber)));
                    this.$outer.context().watch(subscriber);
                    return BoxedUnit.UNIT;
                }
                if (UnsubscribeContactPoints$.MODULE$.equals(object)) {
                    ActorRef subscriber = this.$outer.sender();
                    this.$outer.subscribers_$eq((Vector<ActorRef>)((Vector)this.$outer.subscribers().filterNot(arg_0 -> ClusterClient.org$apache$pekko$cluster$client$ClusterClient$$anon$3$$_$applyOrElse$$anonfun$7(subscriber, arg_0))));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef subscriber = actorRef = terminated._1();
                    this.$outer.self().tell((Object)UnsubscribeContactPoints$.MODULE$, subscriber);
                    return BoxedUnit.UNIT;
                }
                if (GetContactPoints$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang((Object)ContactPoints$.MODULE$.apply((Set<ActorPath>)this.$outer.contactPaths()), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$cluster$client$ClusterClient$$anon$3$$_$applyOrElse$$anonfun$7(org.apache.pekko.actor.ActorRef org.apache.pekko.actor.ActorRef )}, serializedLambda);
            }
        };
    }

    public void sendGetContacts() {
        HashSet sendTo;
        Object object = this.contacts().isEmpty() ? this.initialContactsSel() : (sendTo = this.contacts().size() == 1 ? (HashSet)this.initialContactsSel().union(this.contacts()) : this.contacts());
        if (this.log().isDebugEnabled()) {
            this.log().debug(new StringBuilder(25).append("Sending GetContacts to [").append(sendTo.mkString(",")).append("]").toString());
        }
        sendTo.foreach((Function1)(JProcedure1 & Serializable)_$6 -> ActorSelection$.MODULE$.toScala(_$6).$bang((Object)ClusterReceptionist$Internal$GetContacts$.MODULE$, this.self()));
    }

    public void buffer(Object msg) {
        if (this.org$apache$pekko$cluster$client$ClusterClient$$settings.bufferSize() == 0) {
            this.log().debug("Receptionist not available and buffering is disabled, dropping message [{}]", (Object)msg.getClass().getName());
            return;
        }
        if (this.buffer().size() == this.org$apache$pekko$cluster$client$ClusterClient$$settings.bufferSize()) {
            Tuple2 tuple2 = this.buffer().head();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object m = tuple2._1();
            Object m2 = m;
            this.buffer().dropHead();
            this.log().debug("Receptionist not available, buffer is full, dropping first message [{}]", (Object)m2.getClass().getName());
            this.buffer().append(msg, this.sender());
            return;
        }
        this.log().debug("Receptionist not available, buffering message type [{}]", (Object)msg.getClass().getName());
        this.buffer().append(msg, this.sender());
    }

    public void sendBuffered(ActorRef receptionist) {
        this.log().debug("Sending buffered messages to receptionist");
        this.buffer().foreach((Function2)(JProcedure2 & Serializable)(msg, snd) -> receptionist.tell(msg, snd));
        this.buffer_$eq(MessageBuffer$.MODULE$.empty());
    }

    public void publishContactPoints() {
        this.contactPaths().withFilter((Function1 & Serializable)cp -> !this.contactPathsPublished().contains(cp)).foreach((Function1)(JProcedure1 & Serializable)cp -> {
            ContactPointAdded contactPointAdded = ContactPointAdded$.MODULE$.apply((ActorPath)cp);
            this.subscribers().foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.$bang((Object)contactPointAdded, this.self()));
        });
        this.contactPathsPublished().withFilter((Function1 & Serializable)cp -> !this.contactPaths().contains(cp)).foreach((Function1)(JProcedure1 & Serializable)cp -> {
            ContactPointRemoved contactPointRemoved = ContactPointRemoved$.MODULE$.apply((ActorPath)cp);
            this.subscribers().foreach((Function1)(JProcedure1 & Serializable)_$8 -> _$8.$bang((Object)contactPointRemoved, this.self()));
        });
        this.contactPathsPublished_$eq(this.contactPaths());
    }

    public void reestablish() {
        this.sendGetContacts();
        this.scheduleRefreshContactsTick(this.org$apache$pekko$cluster$client$ClusterClient$$settings.establishingGetContactsInterval());
        this.context().become(this.establishing().orElse(this.contactPointMessages()));
        this.failureDetector().heartbeat();
    }

    private static final Object $init$$$anonfun$2() {
        return "initialContacts must be defined";
    }

    public static final /* synthetic */ ActorPath org$apache$pekko$cluster$client$ClusterClient$$anon$1$$_$applyOrElse$$anonfun$1(String s) {
        return ActorPath$.MODULE$.fromString(s);
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$client$ClusterClient$$anon$1$$_$applyOrElse$$anonfun$4(Cancellable _$4) {
        return _$4.cancel();
    }

    public static final /* synthetic */ ActorPath org$apache$pekko$cluster$client$ClusterClient$$anon$2$$_$applyOrElse$$anonfun$5(String s) {
        return ActorPath$.MODULE$.fromString(s);
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$client$ClusterClient$$anon$3$$_$applyOrElse$$anonfun$7(ActorRef subscriber$1, ActorRef _$5) {
        ActorRef actorRef = _$5;
        ActorRef actorRef2 = subscriber$1;
        return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
    }

    public static final class Publish
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String topic;
        private final Object msg;

        public static Publish apply(String string, Object object) {
            return ClusterClient$Publish$.MODULE$.apply(string, object);
        }

        public static Publish fromProduct(Product product) {
            return ClusterClient$Publish$.MODULE$.fromProduct(product);
        }

        public static Publish unapply(Publish publish) {
            return ClusterClient$Publish$.MODULE$.unapply(publish);
        }

        public Publish(String topic, Object msg) {
            this.topic = topic;
            this.msg = msg;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Publish)) return false;
            Publish publish = (Publish)object;
            String string = this.topic();
            String string2 = publish.topic();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!BoxesRunTime.equals((Object)this.msg(), (Object)publish.msg())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Publish;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Publish";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "topic";
            }
            if (1 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String topic() {
            return this.topic;
        }

        public Object msg() {
            return this.msg;
        }

        public Publish copy(String topic, Object msg) {
            return new Publish(topic, msg);
        }

        public String copy$default$1() {
            return this.topic();
        }

        public Object copy$default$2() {
            return this.msg();
        }

        public String _1() {
            return this.topic();
        }

        public Object _2() {
            return this.msg();
        }
    }

    public static final class Send
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String path;
        private final Object msg;
        private final boolean localAffinity;

        public static Send apply(String string, Object object, boolean bl) {
            return ClusterClient$Send$.MODULE$.apply(string, object, bl);
        }

        public static Send fromProduct(Product product) {
            return ClusterClient$Send$.MODULE$.fromProduct(product);
        }

        public static Send unapply(Send send) {
            return ClusterClient$Send$.MODULE$.unapply(send);
        }

        public Send(String path, Object msg, boolean localAffinity) {
            this.path = path;
            this.msg = msg;
            this.localAffinity = localAffinity;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.msg()));
            n = Statics.mix((int)n, (int)(this.localAffinity() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Send)) return false;
            Send send = (Send)object;
            if (this.localAffinity() != send.localAffinity()) return false;
            String string = this.path();
            String string2 = send.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!BoxesRunTime.equals((Object)this.msg(), (Object)send.msg())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Send;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Send";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "path";
                }
                case 1: {
                    return "msg";
                }
                case 2: {
                    return "localAffinity";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String path() {
            return this.path;
        }

        public Object msg() {
            return this.msg;
        }

        public boolean localAffinity() {
            return this.localAffinity;
        }

        public Send(String path, Object msg) {
            this(path, msg, false);
        }

        public Send copy(String path, Object msg, boolean localAffinity) {
            return new Send(path, msg, localAffinity);
        }

        public String copy$default$1() {
            return this.path();
        }

        public Object copy$default$2() {
            return this.msg();
        }

        public boolean copy$default$3() {
            return this.localAffinity();
        }

        public String _1() {
            return this.path();
        }

        public Object _2() {
            return this.msg();
        }

        public boolean _3() {
            return this.localAffinity();
        }
    }

    public static final class SendToAll
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String path;
        private final Object msg;

        public static SendToAll apply(String string, Object object) {
            return ClusterClient$SendToAll$.MODULE$.apply(string, object);
        }

        public static SendToAll fromProduct(Product product) {
            return ClusterClient$SendToAll$.MODULE$.fromProduct(product);
        }

        public static SendToAll unapply(SendToAll sendToAll) {
            return ClusterClient$SendToAll$.MODULE$.unapply(sendToAll);
        }

        public SendToAll(String path, Object msg) {
            this.path = path;
            this.msg = msg;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SendToAll)) return false;
            SendToAll sendToAll = (SendToAll)object;
            String string = this.path();
            String string2 = sendToAll.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!BoxesRunTime.equals((Object)this.msg(), (Object)sendToAll.msg())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SendToAll;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SendToAll";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            if (1 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String path() {
            return this.path;
        }

        public Object msg() {
            return this.msg;
        }

        public SendToAll copy(String path, Object msg) {
            return new SendToAll(path, msg);
        }

        public String copy$default$1() {
            return this.path();
        }

        public Object copy$default$2() {
            return this.msg();
        }

        public String _1() {
            return this.path();
        }

        public Object _2() {
            return this.msg();
        }
    }
}

