/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.client;

import com.typesafe.config.Config;
import java.util.Set;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.cluster.client.ClusterClientSettings$;
import org.apache.pekko.util.ccompat.package;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.concurrent.duration.FiniteDuration;

public final class ClusterClientSettings
implements NoSerializationVerificationNeeded {
    private final scala.collection.immutable.Set initialContacts;
    private final FiniteDuration establishingGetContactsInterval;
    private final FiniteDuration refreshContactsInterval;
    private final FiniteDuration heartbeatInterval;
    private final FiniteDuration acceptableHeartbeatPause;
    private final int bufferSize;
    private final Option reconnectTimeout;

    public static ClusterClientSettings apply(ActorSystem actorSystem) {
        return ClusterClientSettings$.MODULE$.apply(actorSystem);
    }

    public static ClusterClientSettings apply(Config config) {
        return ClusterClientSettings$.MODULE$.apply(config);
    }

    public static ClusterClientSettings create(ActorSystem actorSystem) {
        return ClusterClientSettings$.MODULE$.create(actorSystem);
    }

    public static ClusterClientSettings create(Config config) {
        return ClusterClientSettings$.MODULE$.create(config);
    }

    public ClusterClientSettings(scala.collection.immutable.Set<ActorPath> initialContacts, FiniteDuration establishingGetContactsInterval, FiniteDuration refreshContactsInterval, FiniteDuration heartbeatInterval, FiniteDuration acceptableHeartbeatPause, int bufferSize, Option<FiniteDuration> reconnectTimeout) {
        this.initialContacts = initialContacts;
        this.establishingGetContactsInterval = establishingGetContactsInterval;
        this.refreshContactsInterval = refreshContactsInterval;
        this.heartbeatInterval = heartbeatInterval;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.bufferSize = bufferSize;
        this.reconnectTimeout = reconnectTimeout;
        Predef$.MODULE$.require(bufferSize >= 0 && bufferSize <= 10000, ClusterClientSettings::$init$$$anonfun$1);
    }

    public scala.collection.immutable.Set<ActorPath> initialContacts() {
        return this.initialContacts;
    }

    public FiniteDuration establishingGetContactsInterval() {
        return this.establishingGetContactsInterval;
    }

    public FiniteDuration refreshContactsInterval() {
        return this.refreshContactsInterval;
    }

    public FiniteDuration heartbeatInterval() {
        return this.heartbeatInterval;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Option<FiniteDuration> reconnectTimeout() {
        return this.reconnectTimeout;
    }

    public ClusterClientSettings(scala.collection.immutable.Set<ActorPath> initialContacts, FiniteDuration establishingGetContactsInterval, FiniteDuration refreshContactsInterval, FiniteDuration heartbeatInterval, FiniteDuration acceptableHeartbeatPause, int bufferSize) {
        this(initialContacts, establishingGetContactsInterval, refreshContactsInterval, heartbeatInterval, acceptableHeartbeatPause, bufferSize, (Option<FiniteDuration>)None$.MODULE$);
    }

    public ClusterClientSettings withInitialContacts(scala.collection.immutable.Set<ActorPath> initialContacts) {
        Predef$.MODULE$.require(initialContacts.nonEmpty(), ClusterClientSettings::withInitialContacts$$anonfun$1);
        return this.copy(initialContacts, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public ClusterClientSettings withInitialContacts(Set<ActorPath> initialContacts) {
        return this.withInitialContacts((scala.collection.immutable.Set<ActorPath>)package.JavaConverters$.MODULE$.SetHasAsScala(initialContacts).asScala().toSet());
    }

    public ClusterClientSettings withEstablishingGetContactsInterval(FiniteDuration establishingGetContactsInterval) {
        return this.copy(this.copy$default$1(), establishingGetContactsInterval, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public ClusterClientSettings withRefreshContactsInterval(FiniteDuration refreshContactsInterval) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), refreshContactsInterval, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
    }

    public ClusterClientSettings withHeartbeat(FiniteDuration heartbeatInterval, FiniteDuration acceptableHeartbeatPause) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), heartbeatInterval, acceptableHeartbeatPause, this.copy$default$6(), this.copy$default$7());
    }

    public ClusterClientSettings withBufferSize(int bufferSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), bufferSize, this.copy$default$7());
    }

    public ClusterClientSettings withReconnectTimeout(Option<FiniteDuration> reconnectTimeout) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), reconnectTimeout);
    }

    private ClusterClientSettings copy(scala.collection.immutable.Set<ActorPath> initialContacts, FiniteDuration establishingGetContactsInterval, FiniteDuration refreshContactsInterval, FiniteDuration heartbeatInterval, FiniteDuration acceptableHeartbeatPause, int bufferSize, Option<FiniteDuration> reconnectTimeout) {
        return new ClusterClientSettings(initialContacts, establishingGetContactsInterval, refreshContactsInterval, heartbeatInterval, acceptableHeartbeatPause, bufferSize, reconnectTimeout);
    }

    private scala.collection.immutable.Set<ActorPath> copy$default$1() {
        return this.initialContacts();
    }

    private FiniteDuration copy$default$2() {
        return this.establishingGetContactsInterval();
    }

    private FiniteDuration copy$default$3() {
        return this.refreshContactsInterval();
    }

    private FiniteDuration copy$default$4() {
        return this.heartbeatInterval();
    }

    private FiniteDuration copy$default$5() {
        return this.acceptableHeartbeatPause();
    }

    private int copy$default$6() {
        return this.bufferSize();
    }

    private Option<FiniteDuration> copy$default$7() {
        return this.reconnectTimeout();
    }

    private static final Object $init$$$anonfun$1() {
        return "bufferSize must be >= 0 and <= 10000";
    }

    private static final Object withInitialContacts$$anonfun$1() {
        return "initialContacts must be defined";
    }
}

