/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.client;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URLEncoder;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.client.ClusterClientUnreachable;
import org.apache.pekko.cluster.client.ClusterClientUnreachable$;
import org.apache.pekko.cluster.client.ClusterClientUp;
import org.apache.pekko.cluster.client.ClusterClientUp$;
import org.apache.pekko.cluster.client.ClusterClients$;
import org.apache.pekko.cluster.client.ClusterReceptionist;
import org.apache.pekko.cluster.client.ClusterReceptionist$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$CheckDeadlines$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$Contacts$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$GetContacts$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$Heartbeat$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$HeartbeatRsp$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$Ping$;
import org.apache.pekko.cluster.client.ClusterReceptionist$Internal$ReceptionistShutdown$;
import org.apache.pekko.cluster.client.ClusterReceptionistSettings;
import org.apache.pekko.cluster.client.GetClusterClients$;
import org.apache.pekko.cluster.client.SubscribeClusterClients$;
import org.apache.pekko.cluster.client.UnsubscribeClusterClients$;
import org.apache.pekko.cluster.pubsub.DistributedPubSubMediator;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.DeadlineFailureDetector;
import org.apache.pekko.remote.FailureDetector$;
import org.apache.pekko.routing.ConsistentHash;
import org.apache.pekko.routing.ConsistentHash$;
import org.apache.pekko.routing.MurmurHash$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public final class ClusterReceptionist
implements Actor,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    public final ActorRef org$apache$pekko$cluster$client$ClusterReceptionist$$pubSubMediator;
    public final ClusterReceptionistSettings org$apache$pekko$cluster$client$ClusterReceptionist$$settings;
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private SortedSet nodes;
    private final int virtualNodesFactor;
    private ConsistentHash consistentHash;
    private HashMap clientInteractions;
    private HashSet clientsPublished;
    private Vector subscribers;
    private final Cancellable checkDeadlinesTask;

    public static Props props(ActorRef actorRef, ClusterReceptionistSettings clusterReceptionistSettings) {
        return ClusterReceptionist$.MODULE$.props(actorRef, clusterReceptionistSettings);
    }

    public ClusterReceptionist(ActorRef pubSubMediator, ClusterReceptionistSettings settings) {
        this.org$apache$pekko$cluster$client$ClusterReceptionist$$pubSubMediator = pubSubMediator;
        this.org$apache$pekko$cluster$client$ClusterReceptionist$$settings = settings;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        scala.collection.immutable.Set set = this.cluster().selfRoles();
        Predef$.MODULE$.require(settings.role().forall((Function1 & Serializable)elem -> set.contains(elem)), () -> this.$init$$$anonfun$5(settings));
        Ordering ringOrdering = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable)(a, b) -> {
            int hb;
            int ha = ClusterReceptionist.hashFor$1(a);
            return ha < (hb = ClusterReceptionist.hashFor$1(b)) || ha == hb && Member$.MODULE$.addressOrdering().compare(a, b) < 0;
        });
        this.nodes = (SortedSet)SortedSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Address[0]), (Object)ringOrdering);
        this.virtualNodesFactor = 10;
        this.consistentHash = ConsistentHash$.MODULE$.apply(this.nodes(), this.virtualNodesFactor(), ClassTag$.MODULE$.apply(Address.class));
        this.clientInteractions = HashMap$.MODULE$.empty();
        this.clientsPublished = HashSet$.MODULE$.empty();
        this.subscribers = package$.MODULE$.Vector().empty();
        Scheduler scheduler = this.context().system().scheduler();
        FiniteDuration finiteDuration = settings.failureDetectionInterval();
        FiniteDuration finiteDuration2 = settings.failureDetectionInterval();
        this.checkDeadlinesTask = scheduler.scheduleWithFixedDelay(finiteDuration, finiteDuration2, this.self(), (Object)ClusterReceptionist$Internal$CheckDeadlines$.MODULE$, (ExecutionContext)this.context().dispatcher(), scheduler.scheduleWithFixedDelay$default$6(finiteDuration, finiteDuration2, this.self(), (Object)ClusterReceptionist$Internal$CheckDeadlines$.MODULE$));
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    public SortedSet<Address> nodes() {
        return this.nodes;
    }

    public void nodes_$eq(SortedSet<Address> x$1) {
        this.nodes = x$1;
    }

    public int virtualNodesFactor() {
        return this.virtualNodesFactor;
    }

    public ConsistentHash<Address> consistentHash() {
        return this.consistentHash;
    }

    public void consistentHash_$eq(ConsistentHash<Address> x$1) {
        this.consistentHash = x$1;
    }

    public HashMap<ActorRef, DeadlineFailureDetector> clientInteractions() {
        return this.clientInteractions;
    }

    public void clientInteractions_$eq(HashMap<ActorRef, DeadlineFailureDetector> x$1) {
        this.clientInteractions = x$1;
    }

    public HashSet<ActorRef> clientsPublished() {
        return this.clientsPublished;
    }

    public void clientsPublished_$eq(HashSet<ActorRef> x$1) {
        this.clientsPublished = x$1;
    }

    public Vector<ActorRef> subscribers() {
        return this.subscribers;
    }

    public void subscribers_$eq(Vector<ActorRef> x$1) {
        this.subscribers = x$1;
    }

    public Cancellable checkDeadlinesTask() {
        return this.checkDeadlinesTask;
    }

    public void preStart() {
        Actor.preStart$((Actor)this);
        Predef$.MODULE$.require(!this.cluster().isTerminated(), ClusterReceptionist::preStart$$anonfun$1);
        this.cluster().subscribe(this.self(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
    }

    public void postStop() {
        Actor.postStop$((Actor)this);
        this.cluster().unsubscribe(this.self());
        this.checkDeadlinesTask().cancel();
        this.clientInteractions().keySet().foreach((Function1)(JProcedure1 & Serializable)_$9 -> _$9.$bang((Object)ClusterReceptionist$Internal$ReceptionistShutdown$.MODULE$, this.self()));
    }

    public boolean matchingRole(Member m) {
        return this.org$apache$pekko$cluster$client$ClusterReceptionist$$settings.role().forall((Function1 & Serializable)role -> m.hasRole(role));
    }

    public ActorRef responseTunnel(ActorRef client) {
        String encName = URLEncoder.encode(client.path().toSerializationFormat(), "utf-8");
        Option option = this.context().child(encName);
        if (option instanceof Some) {
            ActorRef tunnel = (ActorRef)((Some)option).value();
            return tunnel;
        }
        if (None$.MODULE$.equals(option)) {
            return this.context().actorOf(Props$.MODULE$.apply(Internal.ClientResponseTunnel.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{client, this.org$apache$pekko$cluster$client$ClusterReceptionist$$settings.responseTunnelReceiveTimeout()})), encName);
        }
        throw new MatchError((Object)option);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ ClusterReceptionist $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof DistributedPubSubMediator.Send || object instanceof DistributedPubSubMediator.SendToAll || object instanceof DistributedPubSubMediator.Publish) {
                    Product msg = (Product)object;
                    return true;
                }
                if (ClusterReceptionist$Internal$Heartbeat$.MODULE$.equals(object)) {
                    return true;
                }
                if (ClusterReceptionist$Internal$GetContacts$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState state = (ClusterEvent.CurrentClusterState)object;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    Member member;
                    ClusterEvent.MemberUp memberUp = ClusterEvent.MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member m = member = memberUp._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent.MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return true;
                }
                if (SubscribeClusterClients$.MODULE$.equals(object)) {
                    return true;
                }
                if (UnsubscribeClusterClients$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef subscriber = actorRef = terminated._1();
                    return true;
                }
                if (GetClusterClients$.MODULE$.equals(object)) {
                    return true;
                }
                return ClusterReceptionist$Internal$CheckDeadlines$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof DistributedPubSubMediator.Send || object instanceof DistributedPubSubMediator.SendToAll || object instanceof DistributedPubSubMediator.Publish) {
                    Product msg = (Product)object;
                    ActorRef tunnel = this.$outer.responseTunnel(this.$outer.sender());
                    tunnel.$bang((Object)ClusterReceptionist$Internal$Ping$.MODULE$, this.$outer.self());
                    this.$outer.org$apache$pekko$cluster$client$ClusterReceptionist$$pubSubMediator.tell((Object)msg, tunnel);
                    return BoxedUnit.UNIT;
                }
                if (ClusterReceptionist$Internal$Heartbeat$.MODULE$.equals(object)) {
                    if (this.$outer.verboseHeartbeat()) {
                        this.$outer.log().debug("Heartbeat from client [{}]", (Object)this.$outer.sender().path());
                    }
                    this.$outer.sender().$bang((Object)ClusterReceptionist$Internal$HeartbeatRsp$.MODULE$, this.$outer.self());
                    this.$outer.updateClientInteractions(this.$outer.sender());
                    return BoxedUnit.UNIT;
                }
                if (ClusterReceptionist$Internal$GetContacts$.MODULE$.equals(object)) {
                    if (this.$outer.org$apache$pekko$cluster$client$ClusterReceptionist$$settings.numberOfContacts() >= this.$outer.nodes().size()) {
                        Internal.Contacts contacts = ClusterReceptionist$Internal$Contacts$.MODULE$.apply((IndexedSeq<String>)((IndexedSeq)this.$outer.nodes().iterator().map((Function1 & Serializable)a -> this.$outer.self().path().toStringWithAddress(a)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$))));
                        if (this.$outer.log().isDebugEnabled()) {
                            this.$outer.log().debug("Client [{}] gets contactPoints [{}] (all nodes)", (Object)this.$outer.sender().path(), (Object)contacts.contactPoints().mkString(","));
                        }
                        this.$outer.sender().$bang((Object)contacts, this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    Address a2 = (Address)this.$outer.consistentHash().nodeFor(this.$outer.sender().path().toStringWithAddress(this.$outer.cluster().selfAddress()));
                    SortedSet first = (SortedSet)((IterableOps)((IterableOps)this.$outer.nodes().rangeFrom((Object)a2)).tail()).take(this.$outer.org$apache$pekko$cluster$client$ClusterReceptionist$$settings.numberOfContacts());
                    SortedSet slice = first.size() == this.$outer.org$apache$pekko$cluster$client$ClusterReceptionist$$settings.numberOfContacts() ? first : (SortedSet)first.union((Set)this.$outer.nodes().take(this.$outer.org$apache$pekko$cluster$client$ClusterReceptionist$$settings.numberOfContacts() - first.size()));
                    Internal.Contacts contacts = ClusterReceptionist$Internal$Contacts$.MODULE$.apply((IndexedSeq<String>)((IndexedSeq)slice.iterator().map((Function1 & Serializable)a -> this.$outer.self().path().toStringWithAddress(a)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$))));
                    if (this.$outer.log().isDebugEnabled()) {
                        this.$outer.log().debug("Client [{}] gets contactPoints [{}]", (Object)this.$outer.sender().path(), (Object)contacts.contactPoints().mkString(","));
                    }
                    this.$outer.sender().$bang((Object)contacts, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState state = (ClusterEvent.CurrentClusterState)object;
                    this.$outer.nodes_$eq((SortedSet<Address>)((SortedSet)this.$outer.nodes().empty().union((Set)state.members().collect((PartialFunction)new Serializable(this){
                        private final /* synthetic */ $anon$4 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Member x) {
                            Member member;
                            Member m = member = x;
                            MemberStatus memberStatus = m.status();
                            MemberStatus.Joining$ joining$ = MemberStatus.Joining$.MODULE$;
                            return (memberStatus == null ? joining$ != null : !memberStatus.equals(joining$)) && this.$outer.org$apache$pekko$cluster$client$ClusterReceptionist$_$$anon$$$outer().matchingRole(m);
                        }

                        public final Object applyOrElse(Member x, Function1 function1) {
                            Member member;
                            Member m = member = x;
                            MemberStatus memberStatus = m.status();
                            MemberStatus.Joining$ joining$ = MemberStatus.Joining$.MODULE$;
                            if ((memberStatus == null ? joining$ != null : !memberStatus.equals(joining$)) && this.$outer.org$apache$pekko$cluster$client$ClusterReceptionist$_$$anon$$$outer().matchingRole(m)) {
                                return m.address();
                            }
                            return function1.apply((Object)x);
                        }
                    }, Address$.MODULE$.addressOrdering()))));
                    this.$outer.consistentHash_$eq((ConsistentHash<Address>)ConsistentHash$.MODULE$.apply(this.$outer.nodes(), this.$outer.virtualNodesFactor(), ClassTag$.MODULE$.apply(Address.class)));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    ClusterEvent.MemberUp memberUp = ClusterEvent.MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member member = memberUp._1();
                    Member m = member;
                    if (this.$outer.matchingRole(m)) {
                        this.$outer.nodes_$eq((SortedSet<Address>)((SortedSet)this.$outer.nodes().$plus((Object)m.address())));
                        this.$outer.consistentHash_$eq((ConsistentHash<Address>)ConsistentHash$.MODULE$.apply(this.$outer.nodes(), this.$outer.virtualNodesFactor(), ClassTag$.MODULE$.apply(Address.class)));
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent.MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    Address address = m.address();
                    Address address2 = this.$outer.cluster().selfAddress();
                    if (!(address != null ? !address.equals(address2) : address2 != null)) {
                        this.$outer.context().stop(this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    if (this.$outer.matchingRole(m)) {
                        this.$outer.nodes_$eq((SortedSet<Address>)((SortedSet)this.$outer.nodes().$minus((Object)m.address())));
                        this.$outer.consistentHash_$eq((ConsistentHash<Address>)ConsistentHash$.MODULE$.apply(this.$outer.nodes(), this.$outer.virtualNodesFactor(), ClassTag$.MODULE$.apply(Address.class)));
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return BoxedUnit.UNIT;
                }
                if (SubscribeClusterClients$.MODULE$.equals(object)) {
                    ActorRef subscriber = this.$outer.sender();
                    subscriber.$bang((Object)ClusterClients$.MODULE$.apply((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.$outer.clientInteractions().keySet().to(IterableFactory$.MODULE$.toFactory((IterableFactory)HashSet$.MODULE$)))), this.$outer.self());
                    this.$outer.subscribers_$eq((Vector<ActorRef>)((Vector)this.$outer.subscribers().$colon$plus((Object)subscriber)));
                    this.$outer.context().watch(subscriber);
                    return BoxedUnit.UNIT;
                }
                if (UnsubscribeClusterClients$.MODULE$.equals(object)) {
                    ActorRef subscriber = this.$outer.sender();
                    this.$outer.subscribers_$eq((Vector<ActorRef>)((Vector)this.$outer.subscribers().filterNot(arg_0 -> ClusterReceptionist.org$apache$pekko$cluster$client$ClusterReceptionist$$anon$4$$_$applyOrElse$$anonfun$8(subscriber, arg_0))));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef subscriber = actorRef = terminated._1();
                    this.$outer.self().tell((Object)UnsubscribeClusterClients$.MODULE$, subscriber);
                    return BoxedUnit.UNIT;
                }
                if (GetClusterClients$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang((Object)ClusterClients$.MODULE$.apply((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.$outer.clientInteractions().keySet().to(IterableFactory$.MODULE$.toFactory((IterableFactory)HashSet$.MODULE$)))), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (ClusterReceptionist$Internal$CheckDeadlines$.MODULE$.equals(object)) {
                    this.$outer.clientInteractions_$eq((HashMap<ActorRef, DeadlineFailureDetector>)((HashMap)this.$outer.clientInteractions().filter(ClusterReceptionist::org$apache$pekko$cluster$client$ClusterReceptionist$$anon$4$$_$applyOrElse$$anonfun$9)));
                    this.$outer.publishClientsUnreachable();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            public final /* synthetic */ ClusterReceptionist org$apache$pekko$cluster$client$ClusterReceptionist$_$$anon$$$outer() {
                return this.$outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$4(org.apache.pekko.actor.Address ), $anonfun$5(org.apache.pekko.actor.Address ), org$apache$pekko$cluster$client$ClusterReceptionist$$anon$4$$_$applyOrElse$$anonfun$8(org.apache.pekko.actor.ActorRef org.apache.pekko.actor.ActorRef ), org$apache$pekko$cluster$client$ClusterReceptionist$$anon$4$$_$applyOrElse$$anonfun$9(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public void updateClientInteractions(ActorRef client) {
        Option option = this.clientInteractions().get((Object)client);
        if (option instanceof Some) {
            DeadlineFailureDetector failureDetector = (DeadlineFailureDetector)((Some)option).value();
            failureDetector.heartbeat();
            return;
        }
        if (None$.MODULE$.equals(option)) {
            DeadlineFailureDetector failureDetector = new DeadlineFailureDetector(this.org$apache$pekko$cluster$client$ClusterReceptionist$$settings.acceptableHeartbeatPause(), this.org$apache$pekko$cluster$client$ClusterReceptionist$$settings.heartbeatInterval(), FailureDetector$.MODULE$.defaultClock());
            failureDetector.heartbeat();
            ActorRef actorRef = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)client);
            this.clientInteractions_$eq((HashMap<ActorRef, DeadlineFailureDetector>)((HashMap)this.clientInteractions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef, (Object)failureDetector))));
            this.log().debug("Received new contact from [{}]", (Object)client.path());
            ClusterClientUp clusterClientUp = ClusterClientUp$.MODULE$.apply(client);
            this.subscribers().foreach((Function1)(JProcedure1 & Serializable)_$11 -> _$11.$bang((Object)clusterClientUp, this.self()));
            this.clientsPublished_$eq((HashSet<ActorRef>)((HashSet)this.clientInteractions().keySet().to(IterableFactory$.MODULE$.toFactory((IterableFactory)HashSet$.MODULE$))));
            return;
        }
        throw new MatchError((Object)option);
    }

    public void publishClientsUnreachable() {
        HashSet publishableClients = (HashSet)this.clientInteractions().keySet().to(IterableFactory$.MODULE$.toFactory((IterableFactory)HashSet$.MODULE$));
        this.clientsPublished().withFilter((Function1 & Serializable)c -> !publishableClients.contains(c)).foreach((Function1)(JProcedure1 & Serializable)c -> {
            this.log().debug("Lost contact with [{}]", (Object)c.path());
            ClusterClientUnreachable clusterClientUnreachable = ClusterClientUnreachable$.MODULE$.apply((ActorRef)c);
            this.subscribers().foreach((Function1)(JProcedure1 & Serializable)_$12 -> _$12.$bang((Object)clusterClientUnreachable, this.self()));
        });
        this.clientsPublished_$eq((HashSet<ActorRef>)publishableClients);
    }

    private final Object $init$$$anonfun$5(ClusterReceptionistSettings settings$2) {
        return new StringBuilder(47).append("This cluster member [").append(this.cluster().selfAddress()).append("] doesn't have the role [").append(settings$2.role()).append("]").toString();
    }

    private static final int hashFor$1(Address node) {
        Address address = node;
        if (address != null) {
            Address address2 = Address$.MODULE$.unapply(address);
            String string = address2._1();
            String string2 = address2._2();
            Option option = address2._3();
            Option option2 = address2._4();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return MurmurHash$.MODULE$.stringHash(new StringBuilder(1).append(host).append(":").append(port).toString());
                }
            }
        }
        throw new IllegalStateException(new StringBuilder(40).append("Unexpected address without host/port: [").append(node).append("]").toString());
    }

    private static final Object preStart$$anonfun$1() {
        return "Cluster node must not be terminated";
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$client$ClusterReceptionist$$anon$4$$_$applyOrElse$$anonfun$8(ActorRef subscriber$2, ActorRef _$10) {
        ActorRef actorRef = _$10;
        ActorRef actorRef2 = subscriber$2;
        return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$client$ClusterReceptionist$$anon$4$$_$applyOrElse$$anonfun$9(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            DeadlineFailureDetector failureDetector = (DeadlineFailureDetector)tuple2._2();
            return failureDetector.isAvailable();
        }
        throw new MatchError((Object)tuple2);
    }
}

