/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.client;

import com.typesafe.config.Config;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.cluster.client.ClusterReceptionistSettings$;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public final class ClusterReceptionistSettings
implements NoSerializationVerificationNeeded {
    private final Option role;
    private final int numberOfContacts;
    private final FiniteDuration responseTunnelReceiveTimeout;
    private FiniteDuration _heartbeatInterval;
    private FiniteDuration _acceptableHeartbeatPause;
    private FiniteDuration _failureDetectionInterval;

    public static ClusterReceptionistSettings apply(ActorSystem actorSystem) {
        return ClusterReceptionistSettings$.MODULE$.apply(actorSystem);
    }

    public static ClusterReceptionistSettings apply(Config config) {
        return ClusterReceptionistSettings$.MODULE$.apply(config);
    }

    public static ClusterReceptionistSettings create(ActorSystem actorSystem) {
        return ClusterReceptionistSettings$.MODULE$.create(actorSystem);
    }

    public static ClusterReceptionistSettings create(Config config) {
        return ClusterReceptionistSettings$.MODULE$.create(config);
    }

    public static Option<String> roleOption(String string) {
        return ClusterReceptionistSettings$.MODULE$.roleOption(string);
    }

    public ClusterReceptionistSettings(Option<String> role, int numberOfContacts, FiniteDuration responseTunnelReceiveTimeout) {
        this.role = role;
        this.numberOfContacts = numberOfContacts;
        this.responseTunnelReceiveTimeout = responseTunnelReceiveTimeout;
        this._heartbeatInterval = new package.DurationInt(package$.MODULE$.DurationInt(2)).seconds();
        this._acceptableHeartbeatPause = new package.DurationInt(package$.MODULE$.DurationInt(13)).seconds();
        this._failureDetectionInterval = new package.DurationInt(package$.MODULE$.DurationInt(2)).second();
    }

    public Option<String> role() {
        return this.role;
    }

    public int numberOfContacts() {
        return this.numberOfContacts;
    }

    public FiniteDuration responseTunnelReceiveTimeout() {
        return this.responseTunnelReceiveTimeout;
    }

    public ClusterReceptionistSettings withRole(String role) {
        return this.copy(ClusterReceptionistSettings$.MODULE$.roleOption(role), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ClusterReceptionistSettings withRole(Option<String> role) {
        return this.copy(role, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ClusterReceptionistSettings withNumberOfContacts(int numberOfContacts) {
        return this.copy(this.copy$default$1(), numberOfContacts, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ClusterReceptionistSettings withResponseTunnelReceiveTimeout(FiniteDuration responseTunnelReceiveTimeout) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), responseTunnelReceiveTimeout, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public ClusterReceptionistSettings withHeartbeat(FiniteDuration heartbeatInterval, FiniteDuration acceptableHeartbeatPause, FiniteDuration failureDetectionInterval) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), heartbeatInterval, acceptableHeartbeatPause, failureDetectionInterval);
    }

    public FiniteDuration heartbeatInterval() {
        return this._heartbeatInterval;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this._acceptableHeartbeatPause;
    }

    public FiniteDuration failureDetectionInterval() {
        return this._failureDetectionInterval;
    }

    public ClusterReceptionistSettings(Option<String> role, int numberOfContacts, FiniteDuration responseTunnelReceiveTimeout, FiniteDuration heartbeatInterval, FiniteDuration acceptableHeartbeatPause, FiniteDuration failureDetectionInterval) {
        this(role, numberOfContacts, responseTunnelReceiveTimeout);
        this._heartbeatInterval = heartbeatInterval;
        this._acceptableHeartbeatPause = acceptableHeartbeatPause;
        this._failureDetectionInterval = failureDetectionInterval;
    }

    private ClusterReceptionistSettings copy(Option<String> role, int numberOfContacts, FiniteDuration responseTunnelReceiveTimeout, FiniteDuration heartbeatInterval, FiniteDuration acceptableHeartbeatPause, FiniteDuration failureDetectionInterval) {
        return new ClusterReceptionistSettings(role, numberOfContacts, responseTunnelReceiveTimeout, heartbeatInterval, acceptableHeartbeatPause, failureDetectionInterval);
    }

    private Option<String> copy$default$1() {
        return this.role();
    }

    private int copy$default$2() {
        return this.numberOfContacts();
    }

    private FiniteDuration copy$default$3() {
        return this.responseTunnelReceiveTimeout();
    }

    private FiniteDuration copy$default$4() {
        return this.heartbeatInterval();
    }

    private FiniteDuration copy$default$5() {
        return this.acceptableHeartbeatPause();
    }

    private FiniteDuration copy$default$6() {
        return this.failureDetectionInterval();
    }
}

