/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterHeartbeatReceiver$;
import org.apache.pekko.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import org.apache.pekko.cluster.ClusterHeartbeatSenderState;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterLogMarker$;
import org.apache.pekko.cluster.ClusterMessage;
import org.apache.pekko.cluster.HeartbeatNodeRing;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.event.ActorWithLogClass;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.remote.HeartbeatMessage;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r%wACA\u0001\u0003\u0007A\t!a\u0001\u0002\u0014\u0019Q\u0011qCA\u0002\u0011\u0003\t\u0019!!\u0007\t\u000f\u0005\u001d\u0012\u0001\"\u0001\u0002,\u00191\u0011QF\u0001C\u0003_A!\"a\u0017\u0004\u0005+\u0007I\u0011AA/\u0011)\t)g\u0001B\tB\u0003%\u0011q\f\u0005\u000b\u0003O\u001a!Q3A\u0005\u0002\u0005%\u0004BCA9\u0007\tE\t\u0015!\u0003\u0002l!Q\u00111O\u0002\u0003\u0016\u0004%\t!!\u001b\t\u0015\u0005U4A!E!\u0002\u0013\tY\u0007C\u0004\u0002(\r!\t!a\u001e\t\u0013\u0005\r5!!A\u0005\u0002\u0005\u0015\u0005\"CAG\u0007E\u0005I\u0011AAH\u0011%\t)kAI\u0001\n\u0003\t9\u000bC\u0005\u0002,\u000e\t\n\u0011\"\u0001\u0002(\"I\u0011QV\u0002\u0002\u0002\u0013\u0005\u0013q\u0016\u0005\n\u0003\u0003\u001c\u0011\u0011!C\u0001\u0003\u0007D\u0011\"a3\u0004\u0003\u0003%\t!!4\t\u0013\u0005e7!!A\u0005B\u0005m\u0007\"CAu\u0007\u0005\u0005I\u0011AAv\u0011%\t)pAA\u0001\n\u0003\n9\u0010C\u0005\u0002z\u000e\t\t\u0011\"\u0011\u0002|\"I\u0011Q`\u0002\u0002\u0002\u0013\u0005\u0013q`\u0004\n\u0005\u0007\t\u0011\u0011!E\u0001\u0005\u000b1\u0011\"!\f\u0002\u0003\u0003E\tAa\u0002\t\u000f\u0005\u001d\u0002\u0004\"\u0001\u0003\u0016!I\u0011\u0011 \r\u0002\u0002\u0013\u0015\u00131 \u0005\n\u0005/A\u0012\u0011!CA\u00053A\u0011B!\t\u0019\u0003\u0003%\tIa\t\t\u0013\tU\u0002$!A\u0005\n\t]bA\u0002B \u0003\t\u0013\t\u0005\u0003\u0006\u0002\\y\u0011)\u001a!C\u0001\u0005\u0007B!\"!\u001a\u001f\u0005#\u0005\u000b\u0011\u0002B#\u0011)\t9G\bBK\u0002\u0013\u0005\u0011\u0011\u000e\u0005\u000b\u0003cr\"\u0011#Q\u0001\n\u0005-\u0004BCA:=\tU\r\u0011\"\u0001\u0002j!Q\u0011Q\u000f\u0010\u0003\u0012\u0003\u0006I!a\u001b\t\u000f\u0005\u001db\u0004\"\u0001\u0003L!I\u00111\u0011\u0010\u0002\u0002\u0013\u0005!Q\u000b\u0005\n\u0003\u001bs\u0012\u0013!C\u0001\u0005;B\u0011\"!*\u001f#\u0003%\t!a*\t\u0013\u0005-f$%A\u0005\u0002\u0005\u001d\u0006\"CAW=\u0005\u0005I\u0011IAX\u0011%\t\tMHA\u0001\n\u0003\t\u0019\rC\u0005\u0002Lz\t\t\u0011\"\u0001\u0003b!I\u0011\u0011\u001c\u0010\u0002\u0002\u0013\u0005\u00131\u001c\u0005\n\u0003St\u0012\u0011!C\u0001\u0005KB\u0011\"!>\u001f\u0003\u0003%\t%a>\t\u0013\u0005eh$!A\u0005B\u0005m\b\"CA\u007f=\u0005\u0005I\u0011\tB5\u000f%\u0011i'AA\u0001\u0012\u0003\u0011yGB\u0005\u0003@\u0005\t\t\u0011#\u0001\u0003r!9\u0011qE\u001a\u0005\u0002\tU\u0004\"CA}g\u0005\u0005IQIA~\u0011%\u00119bMA\u0001\n\u0003\u00139\bC\u0005\u0003\"M\n\t\u0011\"!\u0003\u0000!I!QG\u001a\u0002\u0002\u0013%!qG\u0004\b\u0005\u000f\u000b\u0001\u0012\u0011BE\r\u001d\u0011Y)\u0001EA\u0005\u001bCq!a\n;\t\u0003\u0011y\tC\u0005\u0002.j\n\t\u0011\"\u0011\u00020\"I\u0011\u0011\u0019\u001e\u0002\u0002\u0013\u0005\u00111\u0019\u0005\n\u0003\u0017T\u0014\u0011!C\u0001\u0005#C\u0011\"!7;\u0003\u0003%\t%a7\t\u0013\u0005%((!A\u0005\u0002\tU\u0005\"CA{u\u0005\u0005I\u0011IA|\u0011%\tIPOA\u0001\n\u0003\nY\u0010C\u0005\u00036i\n\t\u0011\"\u0003\u00038\u00191!\u0011T\u0001C\u00057C!\"a\u0017E\u0005+\u0007I\u0011\u0001B\"\u0011)\t)\u0007\u0012B\tB\u0003%!Q\t\u0005\b\u0003O!E\u0011\u0001BO\u0011%\t\u0019\tRA\u0001\n\u0003\u0011\u0019\u000bC\u0005\u0002\u000e\u0012\u000b\n\u0011\"\u0001\u0003^!I\u0011Q\u0016#\u0002\u0002\u0013\u0005\u0013q\u0016\u0005\n\u0003\u0003$\u0015\u0011!C\u0001\u0003\u0007D\u0011\"a3E\u0003\u0003%\tAa*\t\u0013\u0005eG)!A\u0005B\u0005m\u0007\"CAu\t\u0006\u0005I\u0011\u0001BV\u0011%\t)\u0010RA\u0001\n\u0003\n9\u0010C\u0005\u0002z\u0012\u000b\t\u0011\"\u0011\u0002|\"I\u0011Q #\u0002\u0002\u0013\u0005#qV\u0004\n\u0005g\u000b\u0011\u0011!E\u0001\u0005k3\u0011B!'\u0002\u0003\u0003E\tAa.\t\u000f\u0005\u001d2\u000b\"\u0001\u0003@\"I\u0011\u0011`*\u0002\u0002\u0013\u0015\u00131 \u0005\n\u0005/\u0019\u0016\u0011!CA\u0005\u0003D\u0011B!\tT\u0003\u0003%\tI!2\t\u0013\tU2+!A\u0005\n\t]b!CA\f\u0003\u0007\u0001\u00111\u0001Bf\u0011\u001d\t9#\u0017C\u0001\u0005'D\u0011\"!\u0002Z\u0005\u0004%\tAa6\t\u0011\t}\u0017\f)A\u0005\u00053D\u0011B!9Z\u0005\u0004%\tAa9\t\u0011\t\u0015\u0018\f)A\u0005\u0003[D\u0011Ba:Z\u0005\u0004%IA!;\t\u0011\tU\u0018\f)A\u0005\u0005WD\u0011Ba>Z\u0005\u0004%\tA!?\t\u0011\r\u001d\u0011\f)A\u0005\u0005wD\u0011\"a\u001aZ\u0001\u0004%\t!a1\t\u0013\r%\u0011\f1A\u0005\u0002\r-\u0001\u0002CA93\u0002\u0006K!!2\t\u000f\rU\u0011\f\"\u0001\u0004\u0018!I1QD-C\u0002\u0013\u00051q\u0004\u0005\t\u0007OI\u0006\u0015!\u0003\u0004\"!I1\u0011F-A\u0002\u0013\u000511\u0006\u0005\n\u0007gI\u0006\u0019!C\u0001\u0007kA\u0001b!\u000fZA\u0003&1Q\u0006\u0005\n\u0007wI&\u0019!C\u0001\u0007{A\u0001b!\u0012ZA\u0003%1q\b\u0005\n\u0007\u000fJ\u0006\u0019!C\u0005\u0003SB\u0011b!\u0013Z\u0001\u0004%Iaa\u0013\t\u0011\r=\u0013\f)Q\u0005\u0003WBqa!\u0015Z\t\u0003\u001a\u0019\u0006C\u0004\u0004Ve#\tea\u0015\t\u000f\r]\u0013\f\"\u0001\u0004Z!91QM-\u0005\u0002\r\u001d\u0004bBB<3\u0012\u00051q\r\u0005\b\u0007sJF\u0011AB4\u0011\u001d\u0019Y(\u0017C\u0001\u0007{Bqaa'Z\t\u0003\u0019i\nC\u0004\u0004$f#\ta!*\t\u000f\r%\u0016\f\"\u0001\u0004,\"91qV-\u0005\u0002\rE\u0006bBB[3\u0012\u000511\u000b\u0005\b\u0007oKF\u0011BB*\u0011\u001d\u0019I,\u0017C\u0001\u0007wCqaa1Z\t\u0003\u0019)-\u0001\fDYV\u001cH/\u001a:IK\u0006\u0014HOY3biN+g\u000eZ3s\u0015\u0011\t)!a\u0002\u0002\u000f\rdWo\u001d;fe*!\u0011\u0011BA\u0006\u0003\u0015\u0001Xm[6p\u0015\u0011\ti!a\u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t\"A\u0002pe\u001e\u00042!!\u0006\u0002\u001b\t\t\u0019A\u0001\fDYV\u001cH/\u001a:IK\u0006\u0014HOY3biN+g\u000eZ3s'\r\t\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0011\u0011\u0011E\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003K\tyB\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\u0011\u00111\u0003\u0002\n\u0011\u0016\f'\u000f\u001e2fCR\u001cRbAA\u000e\u0003c\t9$a\u0011\u0002P\u0005U\u0003\u0003BA\u000b\u0003gIA!!\u000e\u0002\u0004\tq1\t\\;ti\u0016\u0014X*Z:tC\u001e,\u0007\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\t\u0005u\u0012qA\u0001\u0007e\u0016lw\u000e^3\n\t\u0005\u0005\u00131\b\u0002\u0011\u0011\u0016\f'\u000f\u001e2fCRlUm]:bO\u0016\u0004B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0005\u0003\u0013\n9!A\u0003bGR|'/\u0003\u0003\u0002N\u0005\u001d#!\u0006#fC\u0012dU\r\u001e;feN+\b\u000f\u001d:fgNLwN\u001c\t\u0005\u0003;\t\t&\u0003\u0003\u0002T\u0005}!a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003;\t9&\u0003\u0003\u0002Z\u0005}!\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00024s_6,\"!a\u0018\u0011\t\u0005\u0015\u0013\u0011M\u0005\u0005\u0003G\n9EA\u0004BI\u0012\u0014Xm]:\u0002\u000b\u0019\u0014x.\u001c\u0011\u0002\u0015M,\u0017/^3oG\u0016t%/\u0006\u0002\u0002lA!\u0011QDA7\u0013\u0011\ty'a\b\u0003\t1{gnZ\u0001\fg\u0016\fX/\u001a8dK:\u0013\b%A\tde\u0016\fG/[8o)&lWMT1o_N\f!c\u0019:fCRLwN\u001c+j[\u0016t\u0015M\\8tAQA\u0011\u0011PA?\u0003\u007f\n\t\tE\u0002\u0002|\ri\u0011!\u0001\u0005\b\u00037R\u0001\u0019AA0\u0011\u001d\t9G\u0003a\u0001\u0003WBq!a\u001d\u000b\u0001\u0004\tY'\u0001\u0003d_BLH\u0003CA=\u0003\u000f\u000bI)a#\t\u0013\u0005m3\u0002%AA\u0002\u0005}\u0003\"CA4\u0017A\u0005\t\u0019AA6\u0011%\t\u0019h\u0003I\u0001\u0002\u0004\tY'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E%\u0006BA0\u0003'[#!!&\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0003?\u000by\"\u0001\u0006b]:|G/\u0019;j_:LA!a)\u0002\u001a\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0016\u0016\u0005\u0003W\n\u0019*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\f\u0005\u0003\u00024\u0006uVBAA[\u0015\u0011\t9,!/\u0002\t1\fgn\u001a\u0006\u0003\u0003w\u000bAA[1wC&!\u0011qXA[\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0019\t\u0005\u0003;\t9-\u0003\u0003\u0002J\u0006}!aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAh\u0003+\u0004B!!\b\u0002R&!\u00111[A\u0010\u0005\r\te.\u001f\u0005\n\u0003/\f\u0012\u0011!a\u0001\u0003\u000b\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAo!\u0019\ty.!:\u0002P6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\fy\"\u0001\u0006d_2dWm\u0019;j_:LA!a:\u0002b\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti/a=\u0011\t\u0005u\u0011q^\u0005\u0005\u0003c\fyBA\u0004C_>dW-\u00198\t\u0013\u0005]7#!AA\u0002\u0005=\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0015\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002n\n\u0005\u0001\"CAl-\u0005\u0005\t\u0019AAh\u0003%AU-\u0019:uE\u0016\fG\u000fE\u0002\u0002|a\u0019R\u0001\u0007B\u0005\u0003+\u0002BBa\u0003\u0003\u0012\u0005}\u00131NA6\u0003sj!A!\u0004\u000b\t\t=\u0011qD\u0001\beVtG/[7f\u0013\u0011\u0011\u0019B!\u0004\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0003\u0006\u0005)\u0011\r\u001d9msRA\u0011\u0011\u0010B\u000e\u0005;\u0011y\u0002C\u0004\u0002\\m\u0001\r!a\u0018\t\u000f\u0005\u001d4\u00041\u0001\u0002l!9\u00111O\u000eA\u0002\u0005-\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005K\u0011\t\u0004\u0005\u0004\u0002\u001e\t\u001d\"1F\u0005\u0005\u0005S\tyB\u0001\u0004PaRLwN\u001c\t\u000b\u0003;\u0011i#a\u0018\u0002l\u0005-\u0014\u0002\u0002B\u0018\u0003?\u0011a\u0001V;qY\u0016\u001c\u0004\"\u0003B\u001a9\u0005\u0005\t\u0019AA=\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003:A!\u00111\u0017B\u001e\u0013\u0011\u0011i$!.\u0003\r=\u0013'.Z2u\u00051AU-\u0019:uE\u0016\fGOU:q'5q\u00121DA\u0019\u0003o\t\u0019%a\u0014\u0002VU\u0011!Q\t\t\u0005\u0003+\u00119%\u0003\u0003\u0003J\u0005\r!!D+oSF,X-\u00113ee\u0016\u001c8\u000f\u0006\u0005\u0003N\t=#\u0011\u000bB*!\r\tYH\b\u0005\b\u00037*\u0003\u0019\u0001B#\u0011\u001d\t9'\na\u0001\u0003WBq!a\u001d&\u0001\u0004\tY\u0007\u0006\u0005\u0003N\t]#\u0011\fB.\u0011%\tYF\nI\u0001\u0002\u0004\u0011)\u0005C\u0005\u0002h\u0019\u0002\n\u00111\u0001\u0002l!I\u00111\u000f\u0014\u0011\u0002\u0003\u0007\u00111N\u000b\u0003\u0005?RCA!\u0012\u0002\u0014R!\u0011q\u001aB2\u0011%\t9\u000eLA\u0001\u0002\u0004\t)\r\u0006\u0003\u0002n\n\u001d\u0004\"CAl]\u0005\u0005\t\u0019AAh)\u0011\tiOa\u001b\t\u0013\u0005]\u0017'!AA\u0002\u0005=\u0017\u0001\u0004%fCJ$(-Z1u%N\u0004\bcAA>gM)1Ga\u001d\u0002VAa!1\u0002B\t\u0005\u000b\nY'a\u001b\u0003NQ\u0011!q\u000e\u000b\t\u0005\u001b\u0012IHa\u001f\u0003~!9\u00111\f\u001cA\u0002\t\u0015\u0003bBA4m\u0001\u0007\u00111\u000e\u0005\b\u0003g2\u0004\u0019AA6)\u0011\u0011\tI!\"\u0011\r\u0005u!q\u0005BB!)\tiB!\f\u0003F\u0005-\u00141\u000e\u0005\n\u0005g9\u0014\u0011!a\u0001\u0005\u001b\nQ\u0002S3beR\u0014W-\u0019;US\u000e\\\u0007cAA>u\ti\u0001*Z1si\n,\u0017\r\u001e+jG.\u001crAOA\u000e\u0003\u001f\n)\u0006\u0006\u0002\u0003\nR!\u0011q\u001aBJ\u0011%\t9NPA\u0001\u0002\u0004\t)\r\u0006\u0003\u0002n\n]\u0005\"CAl\u0001\u0006\u0005\t\u0019AAh\u0005Y)\u0005\u0010]3di\u0016$g)\u001b:ti\"+\u0017M\u001d;cK\u0006$8c\u0002#\u0002\u001c\u0005=\u0013Q\u000b\u000b\u0005\u0005?\u0013\t\u000bE\u0002\u0002|\u0011Cq!a\u0017H\u0001\u0004\u0011)\u0005\u0006\u0003\u0003 \n\u0015\u0006\"CA.\u0011B\u0005\t\u0019\u0001B#)\u0011\tyM!+\t\u0013\u0005]G*!AA\u0002\u0005\u0015G\u0003BAw\u0005[C\u0011\"a6O\u0003\u0003\u0005\r!a4\u0015\t\u00055(\u0011\u0017\u0005\n\u0003/\f\u0016\u0011!a\u0001\u0003\u001f\fa#\u0012=qK\u000e$X\r\u001a$jeN$\b*Z1si\n,\u0017\r\u001e\t\u0004\u0003w\u001a6#B*\u0003:\u0006U\u0003\u0003\u0003B\u0006\u0005w\u0013)Ea(\n\t\tu&Q\u0002\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDC\u0001B[)\u0011\u0011yJa1\t\u000f\u0005mc\u000b1\u0001\u0003FQ!!q\u0019Be!\u0019\tiBa\n\u0003F!I!1G,\u0002\u0002\u0003\u0007!qT\n\u00063\u0006m!Q\u001a\t\u0005\u0003\u000b\u0012y-\u0003\u0003\u0003R\u0006\u001d#!B!di>\u0014HC\u0001Bk!\r\t)\"W\u000b\u0003\u00053\u0004B!!\u0006\u0003\\&!!Q\\A\u0002\u0005\u001d\u0019E.^:uKJ\f\u0001b\u00197vgR,'\u000fI\u0001\u0011m\u0016\u0014(m\\:f\u0011\u0016\f'\u000f\u001e2fCR,\"!!<\u0002#Y,'OY8tK\"+\u0017M\u001d;cK\u0006$\b%A\u0007dYV\u001cH/\u001a:M_\u001e<WM]\u000b\u0003\u0005W\u0004BA!<\u0003r:\u0019!q^.\u000e\u0003eKAAa=\u0003\\\ni1\t\\;ti\u0016\u0014Hj\\4hKJ\fab\u00197vgR,'\u000fT8hO\u0016\u0014\b%\u0001\u000fgS2$XM]%oi\u0016\u0014h.\u00197DYV\u001cH/\u001a:NK6\u0014WM]:\u0016\u0005\tm\b\u0003CA\u000f\u0005{\u001c\t!!<\n\t\t}\u0018q\u0004\u0002\n\rVt7\r^5p]F\u0002B!!\u0006\u0004\u0004%!1QAA\u0002\u0005\u0019iU-\u001c2fe\u0006ib-\u001b7uKJLe\u000e^3s]\u0006d7\t\\;ti\u0016\u0014X*Z7cKJ\u001c\b%\u0001\btKF,XM\\2f\u001dJ|F%Z9\u0015\t\r511\u0003\t\u0005\u0003;\u0019y!\u0003\u0003\u0004\u0012\u0005}!\u0001B+oSRD\u0011\"a6e\u0003\u0003\u0005\r!!2\u0002\u001bM,GN\u001a%fCJ$(-Z1u)\t\u0019I\u0002E\u0002\u0004\u001c\rq1!!\u0006\u0001\u0003=1\u0017-\u001b7ve\u0016$U\r^3di>\u0014XCAB\u0011!\u0019\tIda\t\u0002`%!1QEA\u001e\u0005]1\u0015-\u001b7ve\u0016$U\r^3di>\u0014(+Z4jgR\u0014\u00180\u0001\tgC&dWO]3EKR,7\r^8sA\u0005)1\u000f^1uKV\u00111Q\u0006\t\u0005\u0003+\u0019y#\u0003\u0003\u00042\u0005\r!aG\"mkN$XM\u001d%fCJ$(-Z1u'\u0016tG-\u001a:Ti\u0006$X-A\u0005ti\u0006$Xm\u0018\u0013fcR!1QBB\u001c\u0011%\t9N[A\u0001\u0002\u0004\u0019i#\u0001\u0004ti\u0006$X\rI\u0001\u000eQ\u0016\f'\u000f\u001e2fCR$\u0016m]6\u0016\u0005\r}\u0002\u0003BA#\u0007\u0003JAaa\u0011\u0002H\tY1)\u00198dK2d\u0017M\u00197f\u00039AW-\u0019:uE\u0016\fG\u000fV1tW\u0002\nQ\u0002^5dWRKW.Z:uC6\u0004\u0018!\u0005;jG.$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR!1QBB'\u0011%\t9n\\A\u0001\u0002\u0004\tY'\u0001\buS\u000e\\G+[7fgR\fW\u000e\u001d\u0011\u0002\u0011A\u0014Xm\u0015;beR$\"a!\u0004\u0002\u0011A|7\u000f^*u_B\f\u0011\u0003[3beR\u0014W-\u0019;SK\u000e,\u0017N^3s)\u0011\u0019Yf!\u0019\u0011\t\u0005\u00153QL\u0005\u0005\u0007?\n9E\u0001\bBGR|'oU3mK\u000e$\u0018n\u001c8\t\u000f\r\r4\u000f1\u0001\u0002`\u00059\u0011\r\u001a3sKN\u001c\u0018a\u0002:fG\u0016Lg/Z\u000b\u0003\u0007S\u0002Baa\u001b\u0004r9!\u0011QIB7\u0013\u0011\u0019y'a\u0012\u0002\u000b\u0005\u001bGo\u001c:\n\t\rM4Q\u000f\u0002\b%\u0016\u001cW-\u001b<f\u0015\u0011\u0019y'a\u0012\u0002\u0019%t\u0017\u000e^5bY&T\u0018N\\4\u0002\r\u0005\u001cG/\u001b<f\u0003\u0011Ig.\u001b;\u0015\t\r51q\u0010\u0005\b\u0007\u0003;\b\u0019ABB\u0003!\u0019h.\u00199tQ>$\b\u0003BBC\u0007+sAaa\"\u0004\u0012:!1\u0011RBH\u001d\u0011\u0019Yi!$\u000e\u0005\u0005-\u0011\u0002BA\u0005\u0003\u0017IA!!\u0002\u0002\b%!11SA\u0002\u00031\u0019E.^:uKJ,e/\u001a8u\u0013\u0011\u00199j!'\u0003'\r+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\u000b\t\rM\u00151A\u0001\nC\u0012$W*Z7cKJ$Ba!\u0004\u0004 \"91\u0011\u0015=A\u0002\r\u0005\u0011!A7\u0002\u0019I,Wn\u001c<f\u001b\u0016l'-\u001a:\u0015\t\r51q\u0015\u0005\b\u0007CK\b\u0019AB\u0001\u0003E)hN]3bG\"\f'\r\\3NK6\u0014WM\u001d\u000b\u0005\u0007\u001b\u0019i\u000bC\u0004\u0004\"j\u0004\ra!\u0001\u0002\u001fI,\u0017m\u00195bE2,W*Z7cKJ$Ba!\u0004\u00044\"91\u0011U>A\u0002\r\u0005\u0011!\u00035fCJ$(-Z1u\u0003E\u0019\u0007.Z2l)&\u001c7.\u00138uKJ4\u0018\r\\\u0001\rQ\u0016\f'\u000f\u001e2fCR\u00146\u000f\u001d\u000b\u0005\u0007\u001b\u0019i\fC\u0004\u0004@z\u0004\ra!1\u0002\u0011I,7\u000f]8og\u0016\u00042aa\u0007\u001f\u0003U!(/[4hKJ4\u0015N]:u\u0011\u0016\f'\u000f\u001e2fCR$Ba!\u0004\u0004H\"9\u00111L@A\u0002\t\u0015\u0003")
public class ClusterHeartbeatSender
implements Actor {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Cluster.ClusterLogger clusterLogger;
    private final Function1<Member, Object> filterInternalClusterMembers;
    private int sequenceNr;
    private final FailureDetectorRegistry<Address> failureDetector;
    private ClusterHeartbeatSenderState state;
    private final Cancellable heartbeatTask;
    private long org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp;
    private final ActorContext context;
    private final ActorRef self;

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    private Cluster.ClusterLogger clusterLogger() {
        return this.clusterLogger;
    }

    public Function1<Member, Object> filterInternalClusterMembers() {
        return this.filterInternalClusterMembers;
    }

    public int sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(int x$1) {
        this.sequenceNr = x$1;
    }

    public Heartbeat selfHeartbeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1);
        return new Heartbeat(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public ClusterHeartbeatSenderState state() {
        return this.state;
    }

    public void state_$eq(ClusterHeartbeatSenderState x$1) {
        this.state = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    private long org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp() {
        return this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp;
    }

    public void org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(long x$1) {
        this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp = x$1;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
    }

    public void postStop() {
        this.state().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)a -> {
            ClusterHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.initializing();
    }

    public PartialFunction<Object, BoxedUnit> initializing() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    this.$outer.context().become(this.$outer.active());
                    return (B1)BoxedUnit.UNIT;
                }
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(System.nanoTime());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    return true;
                }
                return ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof HeartbeatRsp) {
                    HeartbeatRsp heartbeatRsp = (HeartbeatRsp)A1;
                    this.$outer.heartbeatRsp(heartbeatRsp);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.UnreachableMember) {
                    ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                    Member m = unreachableMember.member();
                    this.$outer.unreachableMember(m);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.ReachableMember) {
                    ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                    Member m = reachableMember.member();
                    this.$outer.reachableMember(m);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ExpectedFirstHeartbeat) {
                    ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof HeartbeatRsp) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return true;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    return true;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    return true;
                }
                return object instanceof ExpectedFirstHeartbeat;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet nodes2 = (SortedSet)snapshot.members().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1))) {
                    return (B1)A1.uniqueAddress();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Member x1) {
                Member member = x1;
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, SortedSet$.MODULE$.newCanBuildFrom(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
        Set unreachable = (Set)snapshot.unreachable().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterHeartbeatSender $outer;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply(A1))) {
                    return (B1)A1.uniqueAddress();
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Member x2) {
                Member member = x2;
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)member));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.state_$eq(this.state().init((Set<UniqueAddress>)nodes2, (Set<UniqueAddress>)unreachable));
    }

    public void addMember(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
        if ((uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) && !this.state().contains(m.uniqueAddress()) && BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) {
            this.state_$eq(this.state().addMember(m.uniqueAddress()));
            return;
        }
    }

    public void removeMember(Member m) {
        if (BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                this.context().stop(this.self());
                return;
            }
            this.state_$eq(this.state().removeMember(m.uniqueAddress()));
            return;
        }
    }

    public void unreachableMember(Member m) {
        this.state_$eq(this.state().unreachableMember(m.uniqueAddress()));
    }

    public void reachableMember(Member m) {
        this.state_$eq(this.state().reachableMember(m.uniqueAddress()));
    }

    public void heartbeat() {
        Heartbeat nextHB = this.selfHeartbeat();
        this.state().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)to -> {
            ClusterHeartbeatSender.$anonfun$heartbeat$1(this, nextHB, to);
            return BoxedUnit.UNIT;
        });
        this.checkTickInterval();
    }

    private void checkTickInterval() {
        long now = System.nanoTime();
        if (now - this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp() >= this.cluster().settings().HeartbeatInterval().toNanos() * 2L) {
            this.clusterLogger().logWarning(ClusterLogMarker$.MODULE$.heartbeatStarvation(), "Scheduled sending of heartbeat was delayed. Previous heartbeat was sent [{}] ms ago, expected interval is [{}] ms. This may cause failure detection to mark members as unreachable. The reason can be thread starvation, CPU overload, or GC.", (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(now - this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp())), (Object)BoxesRunTime.boxToLong((long)this.cluster().settings().HeartbeatInterval().toMillis()));
        }
        this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp_$eq(now);
    }

    public void heartbeatRsp(HeartbeatRsp response) {
        if (this.verboseHeartbeat()) {
            this.clusterLogger().logDebug("Heartbeat response from [{}]", response.from().address());
        }
        this.state_$eq(this.state().heartbeatRsp(response.from()));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        if (this.state().activeReceivers().apply((Object)from) && !this.failureDetector().isMonitoring((Object)from.address())) {
            if (this.verboseHeartbeat()) {
                this.clusterLogger().logDebug("Trigger extra expected heartbeat from [{}]", from.address());
            }
            this.failureDetector().heartbeat((Object)from.address());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$filterInternalClusterMembers$1(ClusterHeartbeatSender $this, Member x$1) {
        String string = x$1.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(ClusterHeartbeatSender $this, UniqueAddress a) {
        $this.failureDetector().remove((Object)a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(ClusterHeartbeatSender $this, Heartbeat nextHB$1, UniqueAddress to) {
        BoxedUnit boxedUnit;
        if ($this.failureDetector().isMonitoring((Object)to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("Heartbeat to [{}]", to.address());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("First Heartbeat to [{}]", to.address());
            }
            boxedUnit = $this.cluster().scheduler().scheduleOnce($this.cluster().settings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang((Object)nextHB$1, $this.self());
    }

    public ClusterHeartbeatSender() {
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.clusterLogger = new Cluster.ClusterLogger(this.cluster(), Logging$.MODULE$.withMarker(this.context().system(), (Object)new ActorWithLogClass((Actor)this, ClusterLogClass$.MODULE$.ClusterHeartbeat()), LogSource$.MODULE$.fromActorWithLoggerClass()));
        this.filterInternalClusterMembers = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterHeartbeatSender.$anonfun$filterInternalClusterMembers$1(this, x$1));
        this.sequenceNr = 0;
        this.failureDetector = this.cluster().failureDetector();
        this.state = new ClusterHeartbeatSenderState(new HeartbeatNodeRing(this.cluster().selfUniqueAddress(), (Set<UniqueAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{this.cluster().selfUniqueAddress()}))), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.cluster().settings().MonitoredByNrOfMembers()), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.failureDetector());
        this.heartbeatTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()), this.cluster().settings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp = System.nanoTime() + this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()).toNanos();
    }

    public static final class ExpectedFirstHeartbeat
    implements Product,
    scala.Serializable {
        private final UniqueAddress from;

        public UniqueAddress from() {
            return this.from;
        }

        public ExpectedFirstHeartbeat copy(UniqueAddress from) {
            return new ExpectedFirstHeartbeat(from);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public String productPrefix() {
            return "ExpectedFirstHeartbeat";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.from();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExpectedFirstHeartbeat;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExpectedFirstHeartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)x$1;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = expectedFirstHeartbeat.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public ExpectedFirstHeartbeat(UniqueAddress from) {
            this.from = from;
            Product.$init$((Product)this);
        }
    }

    public static final class Heartbeat
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final Address from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public Address from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public Heartbeat copy(Address from, long sequenceNr, long creationTimeNanos) {
            return new Heartbeat(from, sequenceNr, creationTimeNanos);
        }

        public Address copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public String productPrefix() {
            return "Heartbeat";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.from();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.sequenceNr());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.creationTimeNanos());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Heartbeat;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Heartbeat)) return false;
            boolean bl = true;
            if (!bl) return false;
            Heartbeat heartbeat = (Heartbeat)x$1;
            Address address = this.from();
            Address address2 = heartbeat.from();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!address.equals(address2)) return false;
            if (this.sequenceNr() != heartbeat.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeat.creationTimeNanos()) return false;
            return true;
        }

        public Heartbeat(Address from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
            Product.$init$((Product)this);
        }
    }

    public static final class HeartbeatRsp
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final UniqueAddress from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public UniqueAddress from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public HeartbeatRsp copy(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            return new HeartbeatRsp(from, sequenceNr, creationTimeNanos);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public String productPrefix() {
            return "HeartbeatRsp";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.from();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.sequenceNr());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.creationTimeNanos());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof HeartbeatRsp;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof HeartbeatRsp)) return false;
            boolean bl = true;
            if (!bl) return false;
            HeartbeatRsp heartbeatRsp = (HeartbeatRsp)x$1;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = heartbeatRsp.from();
            if (uniqueAddress == null) {
                if (uniqueAddress2 != null) {
                    return false;
                }
            } else if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
            if (this.sequenceNr() != heartbeatRsp.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeatRsp.creationTimeNanos()) return false;
            return true;
        }

        public HeartbeatRsp(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
            Product.$init$((Product)this);
        }
    }
}

