/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterHeartbeatReceiver$;
import org.apache.pekko.cluster.ClusterHeartbeatSender;
import org.apache.pekko.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterSettings;
import org.apache.pekko.cluster.CrossDcHeartbeatingState;
import org.apache.pekko.cluster.CrossDcHeartbeatingState$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.event.ActorWithLogClass;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.remote.FailureDetectorRegistry;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r-d!\u00025j\u0001%\f\bB\u0002@\u0001\t\u0003\t\t\u0001\u0003\u0005k\u0001\t\u0007I\u0011AA\u0004\u0011!\ty\u0001\u0001Q\u0001\n\u0005%\u0001\"CA\t\u0001\t\u0007I\u0011AA\n\u0011!\tY\u0002\u0001Q\u0001\n\u0005U\u0001\"CA\u000f\u0001\t\u0007I\u0011BA\u0010\u0011!\tY\u0003\u0001Q\u0001\n\u0005\u0005\u0002\"CA\u0017\u0001\u0001\u0007I\u0011AA\n\u0011%\ty\u0003\u0001a\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0015BA\u000b\u0011%\ty\u0004\u0001b\u0001\n\u0003\t\t\u0005\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\"\u0011%\t\t\u0006\u0001b\u0001\n\u0003\t\u0019\u0006\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA+\u0011%\t9\u0007\u0001b\u0001\n\u0003\tI\u0007\u0003\u0005\u0002~\u0001\u0001\u000b\u0011BA6\u0011%\ty\b\u0001a\u0001\n\u0003\t\t\tC\u0005\u0002\n\u0002\u0001\r\u0011\"\u0001\u0002\f\"A\u0011q\u0012\u0001!B\u0013\t\u0019\tC\u0004\u0002\u0012\u0002!\t!a%\t\u0013\u0005\r\u0006\u00011A\u0005\u0002\u0005\u0015\u0006\"CAW\u0001\u0001\u0007I\u0011AAX\u0011!\t\u0019\f\u0001Q!\n\u0005\u001d\u0006\"CA[\u0001\t\u0007I\u0011AA\\\u0011!\ty\f\u0001Q\u0001\n\u0005e\u0006bBAa\u0001\u0011\u0005\u00131\u0019\u0005\b\u0003\u000b\u0004A\u0011IAb\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!6\u0001\t\u0003\t9\u000eC\u0004\u0002h\u0002!\t!a6\t\u000f\u0005%\b\u0001\"\u0001\u0002X\"9\u00111\u001e\u0001\u0005\u0002\u0005]\u0007bBAw\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqAa\u0007\u0001\t\u0003\t\u0019\rC\u0004\u0003\u001e\u0001!\tAa\b\t\u000f\t-\u0002\u0001\"\u0001\u0003.!9!\u0011\u0007\u0001\u0005\n\tM\u0002b\u0002B\u001b\u0001\u0011%\u00111Y\u0004\t\u0005\u000bJ\u0007\u0012A6\u0003H\u00199\u0001.\u001bE\u0001W\n%\u0003B\u0002@+\t\u0003\u0011YEB\u0005\u0003N)\u0002\n1%\t\u0003P\u00191!q\u000b\u0016C\u00053BaA`\u0017\u0005\u0002\t\u001d\u0004\"\u0003B7[\u0005\u0005I\u0011\u0001B4\u0011%\u0011y'LA\u0001\n\u0003\u0012\t\bC\u0005\u0003\u00046\n\t\u0011\"\u0001\u0003\u0006\"I!QR\u0017\u0002\u0002\u0013\u0005!q\u0012\u0005\n\u00053k\u0013\u0011!C!\u00057C\u0011B!+.\u0003\u0003%\tAa+\t\u0013\t=V&!A\u0005B\tE\u0006\"\u0003BZ[\u0005\u0005I\u0011\tB[\u0011%\u00119,LA\u0001\n\u0003\u0012IlB\u0005\u0003>*\n\t\u0011#\u0001\u0003@\u001aI!q\u000b\u0016\u0002\u0002#\u0005!\u0011\u0019\u0005\u0007}f\"\tAa4\t\u0013\tM\u0016(!A\u0005F\tU\u0006\"\u0003Bis\u0005\u0005I\u0011\u0011B4\u0011%\u0011\u0019.OA\u0001\n\u0003\u0013)\u000eC\u0005\u0003\\f\n\t\u0011\"\u0003\u0003^\u001aI!Q\u001d\u0016\u0011\u0002G\u0005\"q\u001d\u0004\n\u0005WT\u0003\u0013aI\u0011\u0005[4aAa=+\u0005\nU\bB\u0003B}\u0003\nU\r\u0011\"\u0001\u0002&\"Q!1`!\u0003\u0012\u0003\u0006I!a*\t\ry\fE\u0011\u0001B\u007f\u0011%\u0011i'QA\u0001\n\u0003\u0019\u0019\u0001C\u0005\u0004\b\u0005\u000b\n\u0011\"\u0001\u0004\n!I!qN!\u0002\u0002\u0013\u0005#\u0011\u000f\u0005\n\u0005\u0007\u000b\u0015\u0011!C\u0001\u0005\u000bC\u0011B!$B\u0003\u0003%\ta!\b\t\u0013\te\u0015)!A\u0005B\tm\u0005\"\u0003BU\u0003\u0006\u0005I\u0011AB\u0011\u0011%\u0011y+QA\u0001\n\u0003\u0012\t\fC\u0005\u00034\u0006\u000b\t\u0011\"\u0011\u00036\"I!qW!\u0002\u0002\u0013\u00053QE\u0004\n\u0007{Q\u0013\u0011!E\u0001\u0007\u007f1\u0011Ba=+\u0003\u0003E\ta!\u0011\t\ry\u0004F\u0011AB%\u0011%\u0011\u0019\fUA\u0001\n\u000b\u0012)\fC\u0005\u0003RB\u000b\t\u0011\"!\u0004L!I!1\u001b)\u0002\u0002\u0013\u00055q\n\u0005\n\u00057\u0004\u0016\u0011!C\u0005\u0005;4aa!\u000b+\u0005\u000e-\u0002B\u0002@W\t\u0003\u0019i\u0003C\u0005\u0003nY\u000b\t\u0011\"\u0001\u0004.!I!q\u000e,\u0002\u0002\u0013\u0005#\u0011\u000f\u0005\n\u0005\u00073\u0016\u0011!C\u0001\u0005\u000bC\u0011B!$W\u0003\u0003%\ta!\r\t\u0013\tee+!A\u0005B\tm\u0005\"\u0003BU-\u0006\u0005I\u0011AB\u001b\u0011%\u0011yKVA\u0001\n\u0003\u0012\t\fC\u0005\u00034Z\u000b\t\u0011\"\u0011\u00036\"I!q\u0017,\u0002\u0002\u0013\u00053\u0011H\u0004\n\u00073R\u0013\u0011!E\u0001\u000772\u0011b!\u000b+\u0003\u0003E\ta!\u0018\t\ry\u0014G\u0011AB1\u0011%\u0011\u0019LYA\u0001\n\u000b\u0012)\fC\u0005\u0003R\n\f\t\u0011\"!\u0004.!I!1\u001b2\u0002\u0002\u0013\u000551\r\u0005\n\u00057\u0014\u0017\u0011!C\u0005\u0005;\u0014ac\u0011:pgN$5\rS3beR\u0014W-\u0019;TK:$WM\u001d\u0006\u0003U.\fqa\u00197vgR,'O\u0003\u0002m[\u0006)\u0001/Z6l_*\u0011an\\\u0001\u0007CB\f7\r[3\u000b\u0003A\f1a\u001c:h'\r\u0001!\u000f\u001f\t\u0003gZl\u0011\u0001\u001e\u0006\u0002k\u0006)1oY1mC&\u0011q\u000f\u001e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005edX\"\u0001>\u000b\u0005m\\\u0017!B1di>\u0014\u0018BA?{\u0005\u0015\t5\r^8s\u0003\u0019a\u0014N\\5u}\r\u0001ACAA\u0002!\r\t)\u0001A\u0007\u0002SV\u0011\u0011\u0011\u0002\t\u0005\u0003\u000b\tY!C\u0002\u0002\u000e%\u0014qa\u00117vgR,'/\u0001\u0005dYV\u001cH/\u001a:!\u0003A1XM\u001d2pg\u0016DU-\u0019:uE\u0016\fG/\u0006\u0002\u0002\u0016A\u00191/a\u0006\n\u0007\u0005eAOA\u0004C_>dW-\u00198\u0002#Y,'OY8tK\"+\u0017M\u001d;cK\u0006$\b%A\u0007dYV\u001cH/\u001a:M_\u001e<WM]\u000b\u0003\u0003C\u0001B!a\t\u0002(9\u0019\u0011Q\u0005\u0002\u000e\u0003\u0001IA!!\u000b\u0002\f\ti1\t\\;ti\u0016\u0014Hj\\4hKJ\fab\u00197vgR,'\u000fT8hO\u0016\u0014\b%\u0001\nbGRLg/\u001a7z\u001b>t\u0017\u000e^8sS:<\u0017AF1di&4X\r\\=N_:LGo\u001c:j]\u001e|F%Z9\u0015\t\u0005M\u0012\u0011\b\t\u0004g\u0006U\u0012bAA\u001ci\n!QK\\5u\u0011%\tY$CA\u0001\u0002\u0004\t)\"A\u0002yIE\n1#Y2uSZ,G._'p]&$xN]5oO\u0002\nq#[:FqR,'O\\1m\u00072,8\u000f^3s\u001b\u0016l'-\u001a:\u0016\u0005\u0005\r\u0003cB:\u0002F\u0005%\u0013QC\u0005\u0004\u0003\u000f\"(!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t)!a\u0013\n\u0007\u00055\u0013N\u0001\u0004NK6\u0014WM]\u0001\u0019SN,\u0005\u0010^3s]\u0006d7\t\\;ti\u0016\u0014X*Z7cKJ\u0004\u0013aD2s_N\u001cHiY*fiRLgnZ:\u0016\u0005\u0005U\u0003\u0003BA,\u0003;rA!a\t\u0002Z%!\u00111LA\u0006\u0003!\u0019X\r\u001e;j]\u001e\u001c\u0018\u0002BA0\u0003C\u0012ad\u0011:pgN$5MR1jYV\u0014X\rR3uK\u000e$xN]*fiRLgnZ:\n\u0007\u0005\r\u0014NA\bDYV\u001cH/\u001a:TKR$\u0018N\\4t\u0003A\u0019'o\\:t\t\u000e\u001cV\r\u001e;j]\u001e\u001c\b%\u0001\fde>\u001c8\u000fR2GC&dWO]3EKR,7\r^8s+\t\tY\u0007\u0005\u0004\u0002n\u0005M\u0014qO\u0007\u0003\u0003_R1!!\u001dl\u0003\u0019\u0011X-\\8uK&!\u0011QOA8\u0005]1\u0015-\u001b7ve\u0016$U\r^3di>\u0014(+Z4jgR\u0014\u0018\u0010E\u0002z\u0003sJ1!a\u001f{\u0005\u001d\tE\r\u001a:fgN\fqc\u0019:pgN$5MR1jYV\u0014X\rR3uK\u000e$xN\u001d\u0011\u0002\u0015M,\u0017/^3oG\u0016t%/\u0006\u0002\u0002\u0004B\u00191/!\"\n\u0007\u0005\u001dEO\u0001\u0003M_:<\u0017AD:fcV,gnY3Oe~#S-\u001d\u000b\u0005\u0003g\ti\tC\u0005\u0002<I\t\t\u00111\u0001\u0002\u0004\u0006Y1/Z9vK:\u001cWM\u0014:!\u00035qW\r\u001f;IK\u0006\u0014HOQ3biR\u0011\u0011Q\u0013\t\u0005\u0003/\u000biJ\u0004\u0003\u0002\u0006\u0005e\u0015bAANS\u000612\t\\;ti\u0016\u0014\b*Z1si\n,\u0017\r^*f]\u0012,'/\u0003\u0003\u0002 \u0006\u0005&!\u0003%fCJ$(-Z1u\u0015\r\tY*[\u0001\u0011I\u0006$\u0018mQ3oi\u0016\u00148o\u0015;bi\u0016,\"!a*\u0011\t\u0005\u0015\u0011\u0011V\u0005\u0004\u0003WK'\u0001G\"s_N\u001cHi\u0019%fCJ$(-Z1uS:<7\u000b^1uK\u0006!B-\u0019;b\u0007\u0016tG/\u001a:t'R\fG/Z0%KF$B!a\r\u00022\"I\u00111\b\f\u0002\u0002\u0003\u0007\u0011qU\u0001\u0012I\u0006$\u0018mQ3oi\u0016\u00148o\u0015;bi\u0016\u0004\u0013!\u00045fCJ$(-Z1u)\u0006\u001c8.\u0006\u0002\u0002:B\u0019\u00110a/\n\u0007\u0005u&PA\u0006DC:\u001cW\r\u001c7bE2,\u0017A\u00045fCJ$(-Z1u)\u0006\u001c8\u000eI\u0001\taJ,7\u000b^1siR\u0011\u00111G\u0001\ta>\u001cHo\u0015;pa\u0006\t\u0002.Z1si\n,\u0017\r\u001e*fG\u0016Lg/\u001a:\u0015\t\u0005-\u0017\u0011\u001b\t\u0004s\u00065\u0017bAAhu\nq\u0011i\u0019;peN+G.Z2uS>t\u0007bBAj9\u0001\u0007\u0011qO\u0001\bC\u0012$'/Z:t\u0003\u001d\u0011XmY3jm\u0016,\"!!7\u0011\t\u0005m\u0017\u0011\u001d\b\u0004s\u0006u\u0017bAApu\u0006)\u0011i\u0019;pe&!\u00111]As\u0005\u001d\u0011VmY3jm\u0016T1!a8{\u0003\u001d!wN]7b]R\fa!Y2uSZ,\u0017!D5oiJ|7\u000f]3di&tw-\u0001\u0003j]&$H\u0003BA\u001a\u0003cDq!a=\"\u0001\u0004\t)0\u0001\u0005t]\u0006\u00048\u000f[8u!\u0011\t9Pa\u0002\u000f\t\u0005e(1\u0001\b\u0005\u0003w\u0014\tA\u0004\u0003\u0002~\u0006}X\"A7\n\u00051l\u0017B\u00016l\u0013\r\u0011)![\u0001\r\u00072,8\u000f^3s\u000bZ,g\u000e^\u0005\u0005\u0005\u0013\u0011YAA\nDkJ\u0014XM\u001c;DYV\u001cH/\u001a:Ti\u0006$XMC\u0002\u0003\u0006%\f\u0011\"\u00193e\u001b\u0016l'-\u001a:\u0015\t\u0005M\"\u0011\u0003\u0005\b\u0005'\u0011\u0003\u0019AA%\u0003\u0005i\u0017\u0001\u0004:f[>4X-T3nE\u0016\u0014H\u0003BA\u001a\u00053AqAa\u0005$\u0001\u0004\tI%A\u0005iK\u0006\u0014HOY3bi\u0006a\u0001.Z1si\n,\u0017\r\u001e*taR!\u00111\u0007B\u0011\u0011\u001d\u0011\u0019#\na\u0001\u0005K\tAA\u001a:p[B!\u0011Q\u0001B\u0014\u0013\r\u0011I#\u001b\u0002\u000e+:L\u0017/^3BI\u0012\u0014Xm]:\u0002+Q\u0014\u0018nZ4fe\u001aK'o\u001d;IK\u0006\u0014HOY3biR!\u00111\u0007B\u0018\u0011\u001d\u0011\u0019C\na\u0001\u0005K\tAe]3mM&\u001b(+Z:q_:\u001c\u0018N\u00197f\r>\u00148I]8tg\u0012\u001b\u0007*Z1si\n,\u0017\r\u001e\u000b\u0003\u0003+\tQEY3d_6,\u0017i\u0019;jm\u0016LeMU3ta>t7/\u001b2mK\u001a{'\u000fS3beR\u0014W-\u0019;)\u0007\u0001\u0011I\u0004\u0005\u0003\u0003<\t\u0005SB\u0001B\u001f\u0015\r\u0011yd[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\"\u0005{\u00111\"\u00138uKJt\u0017\r\\!qS\u000612I]8tg\u0012\u001b\u0007*Z1si\n,\u0017\r^*f]\u0012,'\u000fE\u0002\u0002\u0006)\u001a\"A\u000b:\u0015\u0005\t\u001d#!E%ogB,7\r^5p]\u000e{W.\\1oIN!AF\u001dB)!\rI(1K\u0005\u0004\u0005+R(!\t(p'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8WKJLg-[2bi&|gNT3fI\u0016$'\u0001\u0004*fa>\u0014Ho\u0015;biV\u001c8CB\u0017s\u00057\u0012\t\u0007E\u0002t\u0005;J1Aa\u0018u\u0005\u001d\u0001&o\u001c3vGR\u00042a\u001dB2\u0013\r\u0011)\u0007\u001e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005S\u00022Aa\u001b.\u001b\u0005Q\u0013\u0001B2paf\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B:!\u0011\u0011)Ha \u000e\u0005\t]$\u0002\u0002B=\u0005w\nA\u0001\\1oO*\u0011!QP\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0002\n]$AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003\bB\u00191O!#\n\u0007\t-EOA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u0012\n]\u0005cA:\u0003\u0014&\u0019!Q\u0013;\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002<I\n\t\u00111\u0001\u0003\b\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u001eB1!q\u0014BS\u0005#k!A!)\u000b\u0007\t\rF/\u0001\u0006d_2dWm\u0019;j_:LAAa*\u0003\"\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)B!,\t\u0013\u0005mB'!AA\u0002\tE\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t\u001d\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tM\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0016\tm\u0006\"CA\u001eo\u0005\u0005\t\u0019\u0001BI\u00031\u0011V\r]8siN#\u0018\r^;t!\r\u0011Y'O\n\u0006s\t\r'\u0011\r\t\u0007\u0005\u000b\u0014YM!\u001b\u000e\u0005\t\u001d'b\u0001Bei\u00069!/\u001e8uS6,\u0017\u0002\u0002Bg\u0005\u000f\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c81)\t\u0011y,A\u0003baBd\u00170A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U!q\u001b\u0005\n\u00053l\u0014\u0011!a\u0001\u0005S\n1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t}\u0007\u0003\u0002B;\u0005CLAAa9\u0003x\t1qJ\u00196fGR\u0014Ab\u0015;biV\u001c(+\u001a9peR\u001cBa\u0010:\u0003R%\u0012q\b\u0011\u0002\u0016\u001b>t\u0017\u000e^8sS:<7\u000b^1uKJ+\u0007o\u001c:u'\u0011\u0001%Oa<\u0011\u0007\t-t(K\u0002A\u0003Z\u0013\u0001#T8oSR|'/\u001b8h\u0003\u000e$\u0018N^3\u0014\u0011\u0005\u0013(q\u001fB.\u0005C\u00022Aa\u001bA\u0003\u0015\u0019H/\u0019;f\u0003\u0019\u0019H/\u0019;fAQ!!q`B\u0001!\r\u0011Y'\u0011\u0005\b\u0005s$\u0005\u0019AAT)\u0011\u0011yp!\u0002\t\u0013\teX\t%AA\u0002\u0005\u001d\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0007\u0017QC!a*\u0004\u000e-\u00121q\u0002\t\u0005\u0007#\u0019I\"\u0004\u0002\u0004\u0014)!1QCB\f\u0003%)hn\u00195fG.,GMC\u0002\u0003@QLAaa\u0007\u0004\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0015\t\tE5q\u0004\u0005\n\u0003wI\u0015\u0011!a\u0001\u0005\u000f#B!!\u0006\u0004$!I\u00111H&\u0002\u0002\u0003\u0007!\u0011\u0013\u000b\u0005\u0003+\u00199\u0003C\u0005\u0002<9\u000b\t\u00111\u0001\u0003\u0012\n\tRj\u001c8ji>\u0014\u0018N\\4E_Jl\u0017M\u001c;\u0014\u0011Y\u0013(q\u001fB.\u0005C\"\"aa\f\u0011\u0007\t-d\u000b\u0006\u0003\u0003\u0012\u000eM\u0002\"CA\u001e7\u0006\u0005\t\u0019\u0001BD)\u0011\t)ba\u000e\t\u0013\u0005mR,!AA\u0002\tEE\u0003BA\u000b\u0007wA\u0011\"a\u000fa\u0003\u0003\u0005\rA!%\u0002!5{g.\u001b;pe&tw-Q2uSZ,\u0007c\u0001B6!N)\u0001ka\u0011\u0003bAA!QYB#\u0003O\u0013y0\u0003\u0003\u0004H\t\u001d'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u00111q\b\u000b\u0005\u0005\u007f\u001ci\u0005C\u0004\u0003zN\u0003\r!a*\u0015\t\rE3q\u000b\t\u0006g\u000eM\u0013qU\u0005\u0004\u0007+\"(AB(qi&|g\u000eC\u0005\u0003ZR\u000b\t\u00111\u0001\u0003\u0000\u0006\tRj\u001c8ji>\u0014\u0018N\\4E_Jl\u0017M\u001c;\u0011\u0007\t-$mE\u0003c\u0007?\u0012\t\u0007\u0005\u0004\u0003F\n-7q\u0006\u000b\u0003\u00077\"B!!\u0006\u0004f!I!\u0011\u001c4\u0002\u0002\u0003\u00071q\u0006\u0015\u0004U\te\u0002fA\u0015\u0003:\u0001")
@InternalApi
public class CrossDcHeartbeatSender
implements Actor {
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Cluster.ClusterLogger clusterLogger;
    private boolean activelyMonitoring;
    private final Function1<Member, Object> isExternalClusterMember;
    private final ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private long sequenceNr;
    private CrossDcHeartbeatingState dataCentersState;
    private final Cancellable heartbeatTask;
    private final ActorContext context;
    private final ActorRef self;

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    private Cluster.ClusterLogger clusterLogger() {
        return this.clusterLogger;
    }

    public boolean activelyMonitoring() {
        return this.activelyMonitoring;
    }

    public void activelyMonitoring_$eq(boolean x$1) {
        this.activelyMonitoring = x$1;
    }

    public Function1<Member, Object> isExternalClusterMember() {
        return this.isExternalClusterMember;
    }

    public ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings() {
        return this.crossDcSettings;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    public long sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(long x$1) {
        this.sequenceNr = x$1;
    }

    public ClusterHeartbeatSender.Heartbeat nextHeartBeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1L);
        return new ClusterHeartbeatSender.Heartbeat(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public CrossDcHeartbeatingState dataCentersState() {
        return this.dataCentersState;
    }

    public void dataCentersState_$eq(CrossDcHeartbeatingState x$1) {
        this.dataCentersState = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
        if (this.verboseHeartbeat()) {
            this.clusterLogger().logDebug("Initialized cross-dc heartbeat sender as DORMANT in DC: [{}]", this.cluster().selfDataCenter());
            return;
        }
    }

    public void postStop() {
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)a -> {
            CrossDcHeartbeatSender.$anonfun$postStop$1(this, a);
            return BoxedUnit.UNIT;
        });
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.dormant().orElse(this.introspecting());
    }

    public PartialFunction<Object, BoxedUnit> dormant() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                    this.$outer.init(currentClusterState);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    return (B1)BoxedUnit.UNIT;
                }
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return true;
                }
                return ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(A1)) {
                    this.$outer.heartbeat();
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterHeartbeatSender.HeartbeatRsp) {
                    ClusterHeartbeatSender.HeartbeatRsp heartbeatRsp = (ClusterHeartbeatSender.HeartbeatRsp)A1;
                    UniqueAddress from = heartbeatRsp.from();
                    this.$outer.heartbeatRsp(from);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                    Member m = memberRemoved.member();
                    this.$outer.removeMember(m);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)A1;
                    this.$outer.addMember(memberEvent.member());
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat) {
                    ClusterHeartbeatSender.ExpectedFirstHeartbeat expectedFirstHeartbeat = (ClusterHeartbeatSender.ExpectedFirstHeartbeat)A1;
                    UniqueAddress from = expectedFirstHeartbeat.from();
                    this.$outer.triggerFirstHeartbeat(from);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ClusterHeartbeatSender.HeartbeatRsp) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return true;
                }
                return object instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> introspecting() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossDcHeartbeatSender $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ReportStatus) {
                    this.$outer.sender().$bang((Object)(this.$outer.activelyMonitoring() ? new MonitoringActive(this.$outer.dataCentersState()) : new MonitoringDormant()), this.$outer.self());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                return object instanceof ReportStatus;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet<Member> nodes2 = snapshot.members();
        int nrOfMonitoredNodes = this.crossDcSettings().NrOfMonitoringActors();
        this.dataCentersState_$eq(CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), nrOfMonitoredNodes, nodes2));
        this.becomeActiveIfResponsibleForHeartbeat();
    }

    public void addMember(Member m) {
        if (CrossDcHeartbeatingState$.MODULE$.atLeastInUpState(m)) {
            this.dataCentersState_$eq(this.dataCentersState().addMember(m));
            if (this.verboseHeartbeat()) {
                String string = m.dataCenter();
                String string2 = this.cluster().selfDataCenter();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.clusterLogger().logDebug("Register member {} for cross DC heartbeat (will only heartbeat if oldest)", m);
                }
            }
            this.becomeActiveIfResponsibleForHeartbeat();
            return;
        }
    }

    public void removeMember(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
        if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
            this.context().stop(this.self());
            return;
        }
        this.dataCentersState_$eq(this.dataCentersState().removeMember(m));
        this.becomeActiveIfResponsibleForHeartbeat();
    }

    public void heartbeat() {
        ClusterHeartbeatSender.Heartbeat nextHB = this.nextHeartBeat();
        this.dataCentersState().activeReceivers().foreach((Function1 & Serializable & scala.Serializable)to -> {
            CrossDcHeartbeatSender.$anonfun$heartbeat$1(this, nextHB, to);
            return BoxedUnit.UNIT;
        });
    }

    public void heartbeatRsp(UniqueAddress from) {
        if (this.verboseHeartbeat()) {
            this.clusterLogger().logDebug("(Cross) Heartbeat response from [{}]", from.address());
        }
        this.dataCentersState_$eq(this.dataCentersState().heartbeatRsp(from));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        if (this.dataCentersState().activeReceivers().contains((Object)from) && !this.crossDcFailureDetector().isMonitoring((Object)from.address())) {
            if (this.verboseHeartbeat()) {
                this.clusterLogger().logDebug("Trigger extra expected (cross) heartbeat from [{}]", from.address());
            }
            this.crossDcFailureDetector().heartbeat((Object)from.address());
            return;
        }
    }

    private boolean selfIsResponsibleForCrossDcHeartbeat() {
        int activeDcs = this.dataCentersState().dataCenters().size();
        if (activeDcs > 1) {
            return this.dataCentersState().shouldActivelyMonitorNodes(this.cluster().selfDataCenter(), this.cluster().selfUniqueAddress());
        }
        return false;
    }

    private void becomeActiveIfResponsibleForHeartbeat() {
        if (!this.activelyMonitoring() && this.selfIsResponsibleForCrossDcHeartbeat()) {
            this.clusterLogger().logInfo("Cross DC heartbeat becoming ACTIVE on this node (for DC: {}), monitoring other DCs oldest nodes", (Object)this.cluster().selfDataCenter());
            this.activelyMonitoring_$eq(true);
            this.context().become(this.active().orElse(this.introspecting()));
            return;
        }
        if (!this.activelyMonitoring()) {
            if (this.verboseHeartbeat()) {
                this.clusterLogger().logInfo("Remaining DORMANT; others in {} handle heartbeating other DCs", (Object)this.cluster().selfDataCenter());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$isExternalClusterMember$1(CrossDcHeartbeatSender $this, Member member) {
        String string = member.dataCenter();
        String string2 = $this.cluster().selfDataCenter();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$postStop$1(CrossDcHeartbeatSender $this, UniqueAddress a) {
        $this.crossDcFailureDetector().remove((Object)a.address());
    }

    public static final /* synthetic */ void $anonfun$heartbeat$1(CrossDcHeartbeatSender $this, ClusterHeartbeatSender.Heartbeat nextHB$1, UniqueAddress to) {
        BoxedUnit boxedUnit;
        if ($this.crossDcFailureDetector().isMonitoring((Object)to.address())) {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("(Cross) Heartbeat to [{}]", to.address());
            }
            boxedUnit = BoxedUnit.UNIT;
        } else {
            if ($this.verboseHeartbeat()) {
                $this.clusterLogger().logDebug("First (Cross) Heartbeat to [{}]", to.address());
            }
            boxedUnit = $this.cluster().scheduler().scheduleOnce($this.crossDcSettings().HeartbeatExpectedResponseAfter(), $this.self(), (Object)new ClusterHeartbeatSender.ExpectedFirstHeartbeat(to), (ExecutionContext)$this.context().dispatcher(), $this.self());
        }
        ActorSelection$.MODULE$.toScala($this.heartbeatReceiver(to.address())).$bang((Object)nextHB$1, $this.self());
    }

    public CrossDcHeartbeatSender() {
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.clusterLogger = new Cluster.ClusterLogger(this.cluster(), Logging$.MODULE$.withMarker(this.context().system(), (Object)new ActorWithLogClass((Actor)this, ClusterLogClass$.MODULE$.ClusterHeartbeat()), LogSource$.MODULE$.fromActorWithLoggerClass()));
        this.activelyMonitoring = false;
        this.isExternalClusterMember = (Function1 & Serializable & scala.Serializable)member -> BoxesRunTime.boxToBoolean((boolean)CrossDcHeartbeatSender.$anonfun$isExternalClusterMember$1(this, member));
        this.crossDcSettings = this.cluster().settings().MultiDataCenter().CrossDcFailureDetectorSettings();
        this.crossDcFailureDetector = this.cluster().crossDcFailureDetector();
        this.sequenceNr = 0L;
        this.dataCentersState = CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), this.crossDcSettings().NrOfMonitoringActors(), (SortedSet<Member>)SortedSet$.MODULE$.empty(Member$.MODULE$.ordering()));
        this.heartbeatTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.crossDcSettings().HeartbeatInterval()), this.crossDcSettings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
    }

    public static interface InspectionCommand
    extends NoSerializationVerificationNeeded {
    }

    public static final class MonitoringActive
    implements MonitoringStateReport,
    Product,
    scala.Serializable {
        private final CrossDcHeartbeatingState state;

        public CrossDcHeartbeatingState state() {
            return this.state;
        }

        public MonitoringActive copy(CrossDcHeartbeatingState state) {
            return new MonitoringActive(state);
        }

        public CrossDcHeartbeatingState copy$default$1() {
            return this.state();
        }

        public String productPrefix() {
            return "MonitoringActive";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.state();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringActive;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MonitoringActive)) return false;
            boolean bl = true;
            if (!bl) return false;
            MonitoringActive monitoringActive = (MonitoringActive)x$1;
            CrossDcHeartbeatingState crossDcHeartbeatingState = this.state();
            CrossDcHeartbeatingState crossDcHeartbeatingState2 = monitoringActive.state();
            if (crossDcHeartbeatingState != null) {
                if (!((Object)crossDcHeartbeatingState).equals(crossDcHeartbeatingState2)) return false;
                return true;
            }
            if (crossDcHeartbeatingState2 == null) return true;
            return false;
        }

        public MonitoringActive(CrossDcHeartbeatingState state) {
            this.state = state;
            Product.$init$((Product)this);
        }
    }

    public static final class MonitoringDormant
    implements MonitoringStateReport,
    Product,
    scala.Serializable {
        public MonitoringDormant copy() {
            return new MonitoringDormant();
        }

        public String productPrefix() {
            return "MonitoringDormant";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MonitoringDormant;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            return object instanceof MonitoringDormant;
        }

        public MonitoringDormant() {
            Product.$init$((Product)this);
        }
    }

    public static interface MonitoringStateReport
    extends StatusReport {
    }

    public static final class ReportStatus
    implements Product,
    scala.Serializable {
        public ReportStatus copy() {
            return new ReportStatus();
        }

        public String productPrefix() {
            return "ReportStatus";
        }

        public int productArity() {
            return 0;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReportStatus;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            Object object = x$1;
            return object instanceof ReportStatus;
        }

        public ReportStatus() {
            Product.$init$((Product)this);
        }
    }

    public static interface StatusReport
    extends NoSerializationVerificationNeeded {
    }
}

