/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterSettings;
import org.apache.pekko.cluster.ConfigValidation;
import org.apache.pekko.cluster.Invalid;
import org.apache.pekko.cluster.JoinConfigCompatChecker;
import org.apache.pekko.cluster.Valid$;
import org.apache.pekko.util.ccompat.package;
import org.apache.pekko.util.ccompat.package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class JoinConfigCompatChecker$ {
    public static JoinConfigCompatChecker$ MODULE$;

    static {
        new JoinConfigCompatChecker$();
    }

    public ConfigValidation exists(Seq<String> requiredKeys, Config toCheck) {
        Set allKeys = (Set)((SetLike)package.JavaConverters$.MODULE$.asScalaSetConverter(toCheck.entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.getKey(), Set$.MODULE$.canBuildFrom());
        Seq result = (Seq)requiredKeys.collect((PartialFunction)new scala.Serializable(allKeys){
            public static final long serialVersionUID = 0L;
            private final Set allKeys$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (!this.allKeys$1.contains(A1)) {
                    return (B1)new StringBuilder(11).append(A1).append(" is missing").toString();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                return !this.allKeys$1.contains((Object)string);
            }
            {
                this.allKeys$1 = allKeys$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (result.isEmpty()) {
            return Valid$.MODULE$;
        }
        return new Invalid((Seq<String>)((Seq)result.to(package$.MODULE$.genericCompanionToCBF((GenericCompanion)Seq$.MODULE$))));
    }

    public ConfigValidation fullMatch(Seq<String> requiredKeys, Config toCheck, Config actualConfig) {
        return (ConfigValidation)this.exists(requiredKeys, toCheck).$plus$plus(this.checkEquality(requiredKeys, toCheck, actualConfig));
    }

    @InternalApi
    public ConfigValidation checkEquality(Seq<String> keys, Config toCheck, Config actualConfig) {
        Seq incompatibleKeys = (Seq)((TraversableLike)keys.withFilter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)toCheck.hasPath(key))).map((Function1 & Serializable & scala.Serializable)key -> {
            ConfigValue value = toCheck.getValue(key);
            return new Tuple2(key, (Object)value);
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JoinConfigCompatChecker$.$anonfun$checkEquality$3(actualConfig, x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                return new StringBuilder(16).append(key).append(" is incompatible").toString();
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        if (incompatibleKeys.isEmpty()) {
            return Valid$.MODULE$;
        }
        return new Invalid((Seq<String>)((Seq)incompatibleKeys.to(package$.MODULE$.genericCompanionToCBF((GenericCompanion)Seq$.MODULE$))));
    }

    @InternalApi
    public Config filterWithKeys(Seq<String> requiredKeys, Config config) {
        Seq filtered = (Seq)requiredKeys.withFilter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)config.hasPath(key))).map((Function1 & Serializable & scala.Serializable)key -> new Tuple2(key, (Object)config.getValue(key)), Seq$.MODULE$.canBuildFrom());
        return ConfigFactory.parseMap((java.util.Map)((java.util.Map)package.JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)filtered.toMap(Predef$.MODULE$.$conforms())).asJava()));
    }

    @InternalApi
    public Seq<String> removeSensitiveKeys(Seq<String> requiredKeys, ClusterSettings clusterSettings) {
        return (Seq)requiredKeys.filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)JoinConfigCompatChecker$.$anonfun$removeSensitiveKeys$1(clusterSettings, key)));
    }

    @InternalApi
    public Seq<String> removeSensitiveKeys(Config config, ClusterSettings clusterSettings) {
        Seq existingKeys = (Seq)((TraversableLike)((SetLike)package.JavaConverters$.MODULE$.asScalaSetConverter(config.entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.getKey(), Set$.MODULE$.canBuildFrom())).to(package$.MODULE$.genericCompanionToCBF((GenericCompanion)Seq$.MODULE$));
        return this.removeSensitiveKeys((Seq<String>)existingKeys, clusterSettings);
    }

    @InternalApi
    public JoinConfigCompatChecker load(ExtendedActorSystem system, ClusterSettings clusterSettings) {
        scala.collection.immutable.Set checkers = (scala.collection.immutable.Set)clusterSettings.ConfigCompatCheckers().map((Function1 & Serializable & scala.Serializable)fqcn -> (JoinConfigCompatChecker)system.dynamicAccess().createInstanceFor(fqcn, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(JoinConfigCompatChecker.class)).get(), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        return new JoinConfigCompatChecker(checkers){
            private final Seq<String> requiredKeys;
            private final scala.collection.immutable.Set checkers$1;

            public Seq<String> requiredKeys() {
                return this.requiredKeys;
            }

            public ConfigValidation check(Config toValidate, Config clusterConfig) {
                return (ConfigValidation)this.checkers$1.foldLeft((Object)Valid$.MODULE$, (Function2 & Serializable & scala.Serializable)(acc, checker) -> acc.$plus$plus(checker.check(toValidate, clusterConfig)));
            }
            {
                this.checkers$1 = checkers$1;
                String string = "pekko.version";
                this.requiredKeys = (Seq)((SeqLike)((TraversableLike)checkers$1.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.requiredKeys(), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).to(package$.MODULE$.genericCompanionToCBF((GenericCompanion)Seq$.MODULE$))).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$check$1(com.typesafe.config.Config com.typesafe.config.Config org.apache.pekko.cluster.ConfigValidation org.apache.pekko.cluster.JoinConfigCompatChecker ), $anonfun$requiredKeys$1(org.apache.pekko.cluster.JoinConfigCompatChecker )}, serializedLambda);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkCompat$1(String key, ConfigValue value, Config actualConfig$1) {
        if (!actualConfig$1.hasPath(key)) return false;
        ConfigValue configValue = actualConfig$1.getValue(key);
        ConfigValue configValue2 = value;
        if (configValue != null) {
            if (!configValue.equals(configValue2)) return false;
            return true;
        }
        if (configValue2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$checkEquality$3(Config actualConfig$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            ConfigValue value;
            String key = (String)tuple2._1();
            return !JoinConfigCompatChecker$.checkCompat$1(key, value = (ConfigValue)tuple2._2(), actualConfig$1);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$removeSensitiveKeys$1(ClusterSettings clusterSettings$1, String key) {
        return !clusterSettings$1.SensitiveConfigPaths().exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)key.startsWith(s)));
    }

    private JoinConfigCompatChecker$() {
        MODULE$ = this;
    }
}

