/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Deploy;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.NoScopeGiven$;
import org.apache.pekko.actor.Scope;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterScope$;
import org.apache.pekko.cluster.routing.ClusterRouterGroup;
import org.apache.pekko.cluster.routing.ClusterRouterGroup$;
import org.apache.pekko.cluster.routing.ClusterRouterGroupSettings$;
import org.apache.pekko.cluster.routing.ClusterRouterPool;
import org.apache.pekko.cluster.routing.ClusterRouterPool$;
import org.apache.pekko.cluster.routing.ClusterRouterPoolSettings$;
import org.apache.pekko.remote.RemoteDeployer;
import org.apache.pekko.remote.routing.RemoteRouterConfig;
import org.apache.pekko.routing.Group;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.RouterConfig;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

@InternalApi
public class ClusterDeployer
extends RemoteDeployer {
    public ClusterDeployer(ActorSystem.Settings _settings, DynamicAccess _pm) {
        super(_settings, _pm);
    }

    public Option<Deploy> parseConfig(String path, Config config) {
        Config config2;
        if (config.hasPath("cluster.enabled") && config.getBoolean("cluster.enabled") && !config.hasPath("nr-of-instances")) {
            int maxTotalNrOfInstances = config.withFallback((ConfigMergeable)this.default()).getInt("cluster.max-total-nr-of-instances");
            config2 = ConfigFactory.parseString((String)new StringBuilder(16).append("nr-of-instances=").append(maxTotalNrOfInstances).toString()).withFallback((ConfigMergeable)config);
        } else {
            config2 = config;
        }
        Config config22 = config2;
        Option option = super.parseConfig(path, config22);
        if (option instanceof Some) {
            Some some = (Some)option;
            Deploy deploy = (Deploy)some.value();
            Some d = some;
            if (deploy.config().getBoolean("cluster.enabled")) {
                Scope scope = deploy.scope();
                NoScopeGiven$ noScopeGiven$ = NoScopeGiven$.MODULE$;
                if (scope == null ? noScopeGiven$ != null : !scope.equals(noScopeGiven$)) {
                    throw new ConfigurationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cluster deployment can't be combined with scope [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{deploy.scope()})));
                }
                if (deploy.routerConfig() instanceof RemoteRouterConfig) {
                    throw new ConfigurationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cluster deployment can't be combined with [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{deploy.routerConfig()})));
                }
                RouterConfig routerConfig = deploy.routerConfig();
                if (routerConfig instanceof Pool) {
                    Pool r = (Pool)routerConfig;
                    ClusterRouterPool clusterRouterPool = ClusterRouterPool$.MODULE$.apply(r, ClusterRouterPoolSettings$.MODULE$.fromConfig(deploy.config()));
                    String string = deploy.copy$default$1();
                    Config config3 = deploy.copy$default$2();
                    String string2 = deploy.copy$default$5();
                    String string3 = deploy.copy$default$6();
                    return Some$.MODULE$.apply((Object)deploy.copy(string, config3, (RouterConfig)clusterRouterPool, (Scope)ClusterScope$.MODULE$, string2, string3));
                }
                if (routerConfig instanceof Group) {
                    Group r = (Group)routerConfig;
                    ClusterRouterGroup clusterRouterGroup = ClusterRouterGroup$.MODULE$.apply(r, ClusterRouterGroupSettings$.MODULE$.fromConfig(deploy.config()));
                    String string = deploy.copy$default$1();
                    Config config4 = deploy.copy$default$2();
                    String string4 = deploy.copy$default$5();
                    String string5 = deploy.copy$default$6();
                    return Some$.MODULE$.apply((Object)deploy.copy(string, config4, (RouterConfig)clusterRouterGroup, (Scope)ClusterScope$.MODULE$, string4, string5));
                }
                RouterConfig other = routerConfig;
                throw new IllegalArgumentException(new StringBuilder(56).append("Cluster aware router can only wrap Pool or Group, got [").append(other.getClass().getName()).append("]").toString());
            }
            return d;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }
}

