/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$;
import org.apache.pekko.cluster.ClusterEvent$ClusterShuttingDown$;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsEvents$;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsSnapshot$;
import org.apache.pekko.cluster.Gossip$;
import org.apache.pekko.cluster.InternalClusterAction;
import org.apache.pekko.cluster.InternalClusterAction$PublishChanges$;
import org.apache.pekko.cluster.InternalClusterAction$PublishEvent$;
import org.apache.pekko.cluster.InternalClusterAction$SendCurrentClusterState$;
import org.apache.pekko.cluster.InternalClusterAction$Subscribe$;
import org.apache.pekko.cluster.InternalClusterAction$Unsubscribe$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MembershipState;
import org.apache.pekko.cluster.MembershipState$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.event.EventStream;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class ClusterDomainEventPublisher
implements Actor,
RequiresMessageQueue<UnboundedMessageQueueSemantics> {
    private ActorContext context;
    private ActorRef self;
    private final Cluster cluster;
    private final UniqueAddress selfUniqueAddress;
    private final MembershipState emptyMembershipState;
    private MembershipState membershipState;

    public ClusterDomainEventPublisher() {
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.selfUniqueAddress = this.cluster().selfUniqueAddress();
        this.emptyMembershipState = MembershipState$.MODULE$.apply(Gossip$.MODULE$.empty(), this.cluster().selfUniqueAddress(), this.cluster().settings().SelfDataCenter(), this.cluster().settings().MultiDataCenter().CrossDcConnections());
        this.membershipState = this.emptyMembershipState();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public MembershipState emptyMembershipState() {
        return this.emptyMembershipState;
    }

    public MembershipState membershipState() {
        return this.membershipState;
    }

    public void membershipState_$eq(MembershipState x$1) {
        this.membershipState = x$1;
    }

    public String selfDc() {
        return this.cluster().settings().SelfDataCenter();
    }

    public void preRestart(Throwable reason, Option<Object> message) {
    }

    public void postStop() {
        this.publish(ClusterEvent$ClusterShuttingDown$.MODULE$);
        this.publishChanges(this.emptyMembershipState());
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ ClusterDomainEventPublisher $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof InternalClusterAction.PublishChanges) {
                    MembershipState membershipState;
                    InternalClusterAction.PublishChanges publishChanges = InternalClusterAction$PublishChanges$.MODULE$.unapply((InternalClusterAction.PublishChanges)object);
                    MembershipState newState = membershipState = publishChanges._1();
                    return true;
                }
                if (object instanceof ClusterEvent.CurrentInternalStats) {
                    ClusterEvent.CurrentInternalStats currentStats = (ClusterEvent.CurrentInternalStats)object;
                    return true;
                }
                if (object instanceof InternalClusterAction.SendCurrentClusterState) {
                    ActorRef actorRef;
                    InternalClusterAction.SendCurrentClusterState sendCurrentClusterState = InternalClusterAction$SendCurrentClusterState$.MODULE$.unapply((InternalClusterAction.SendCurrentClusterState)object);
                    ActorRef receiver = actorRef = sendCurrentClusterState._1();
                    return true;
                }
                if (object instanceof InternalClusterAction.Subscribe) {
                    InternalClusterAction.Subscribe subscribe = InternalClusterAction$Subscribe$.MODULE$.unapply((InternalClusterAction.Subscribe)object);
                    ActorRef actorRef = subscribe._1();
                    ClusterEvent.SubscriptionInitialStateMode subscriptionInitialStateMode = subscribe._2();
                    Set<Class<?>> set = subscribe._3();
                    ActorRef subscriber = actorRef;
                    ClusterEvent.SubscriptionInitialStateMode initMode = subscriptionInitialStateMode;
                    Set<Class<?>> to = set;
                    return true;
                }
                if (object instanceof InternalClusterAction.Unsubscribe) {
                    InternalClusterAction.Unsubscribe unsubscribe = InternalClusterAction$Unsubscribe$.MODULE$.unapply((InternalClusterAction.Unsubscribe)object);
                    ActorRef actorRef = unsubscribe._1();
                    Option<Class<?>> option = unsubscribe._2();
                    ActorRef subscriber = actorRef;
                    Option<Class<?>> to = option;
                    return true;
                }
                if (object instanceof InternalClusterAction.PublishEvent) {
                    ClusterEvent.ClusterDomainEvent clusterDomainEvent;
                    InternalClusterAction.PublishEvent publishEvent = InternalClusterAction$PublishEvent$.MODULE$.unapply((InternalClusterAction.PublishEvent)object);
                    ClusterEvent.ClusterDomainEvent event = clusterDomainEvent = publishEvent._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof InternalClusterAction.PublishChanges) {
                    MembershipState membershipState;
                    InternalClusterAction.PublishChanges publishChanges = InternalClusterAction$PublishChanges$.MODULE$.unapply((InternalClusterAction.PublishChanges)object);
                    MembershipState newState = membershipState = publishChanges._1();
                    this.$outer.publishChanges(newState);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.CurrentInternalStats) {
                    ClusterEvent.CurrentInternalStats currentStats = (ClusterEvent.CurrentInternalStats)object;
                    this.$outer.publishInternalStats(currentStats);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.SendCurrentClusterState) {
                    ActorRef actorRef;
                    InternalClusterAction.SendCurrentClusterState sendCurrentClusterState = InternalClusterAction$SendCurrentClusterState$.MODULE$.unapply((InternalClusterAction.SendCurrentClusterState)object);
                    ActorRef receiver = actorRef = sendCurrentClusterState._1();
                    this.$outer.sendCurrentClusterState(receiver);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.Subscribe) {
                    InternalClusterAction.Subscribe subscribe = InternalClusterAction$Subscribe$.MODULE$.unapply((InternalClusterAction.Subscribe)object);
                    ActorRef actorRef = subscribe._1();
                    ClusterEvent.SubscriptionInitialStateMode subscriptionInitialStateMode = subscribe._2();
                    Set<Class<?>> set = subscribe._3();
                    ActorRef subscriber = actorRef;
                    ClusterEvent.SubscriptionInitialStateMode initMode = subscriptionInitialStateMode;
                    Set<Class<?>> to = set;
                    this.$outer.subscribe(subscriber, initMode, to);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.Unsubscribe) {
                    InternalClusterAction.Unsubscribe unsubscribe = InternalClusterAction$Unsubscribe$.MODULE$.unapply((InternalClusterAction.Unsubscribe)object);
                    ActorRef actorRef = unsubscribe._1();
                    Option<Class<?>> option = unsubscribe._2();
                    ActorRef subscriber = actorRef;
                    Option<Class<?>> to = option;
                    this.$outer.unsubscribe(subscriber, to);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.PublishEvent) {
                    ClusterEvent.ClusterDomainEvent clusterDomainEvent;
                    InternalClusterAction.PublishEvent publishEvent = InternalClusterAction$PublishEvent$.MODULE$.unapply((InternalClusterAction.PublishEvent)object);
                    ClusterEvent.ClusterDomainEvent event = clusterDomainEvent = publishEvent._1();
                    this.$outer.publish(event);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public EventStream eventStream() {
        return this.context().system().eventStream();
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        Set set;
        Set unreachable = (Set)this.membershipState().dcReachabilityNoOutsideNodes().allUnreachableOrTerminated().collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ ClusterDomainEventPublisher $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(UniqueAddress x) {
                UniqueAddress uniqueAddress;
                UniqueAddress node;
                UniqueAddress uniqueAddress2 = node = (uniqueAddress = x);
                UniqueAddress uniqueAddress3 = this.$outer.selfUniqueAddress();
                return uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3);
            }

            public final Object applyOrElse(UniqueAddress x, Function1 function1) {
                UniqueAddress uniqueAddress;
                UniqueAddress node;
                UniqueAddress uniqueAddress2 = node = (uniqueAddress = x);
                UniqueAddress uniqueAddress3 = this.$outer.selfUniqueAddress();
                if (uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3)) {
                    return this.$outer.membershipState().latestGossip().member(node);
                }
                return function1.apply((Object)x);
            }
        });
        if (!this.membershipState().latestGossip().isMultiDc()) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            MembershipState membershipState = this.membershipState();
            set = (Set)this.membershipState().latestGossip().allDataCenters().filterNot((Function1 & Serializable)otherDc -> ClusterEvent$.MODULE$.isDataCenterReachable(membershipState, (String)otherDc));
        }
        Set unreachableDataCenters = set;
        ClusterEvent.CurrentClusterState state = new ClusterEvent.CurrentClusterState(this.membershipState().latestGossip().members(), (Set<Member>)unreachable, (Set<Address>)((Set)this.membershipState().latestGossip().seenBy().map((Function1 & Serializable)_$7 -> _$7.address())), (Option<Address>)this.membershipState().leader().map((Function1 & Serializable)_$8 -> _$8.address()), (Map<String, Option<Address>>)this.membershipState().latestGossip().allRoles().iterator().map((Function1 & Serializable)r -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(r);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.membershipState().roleLeader((String)r).map((Function1 & Serializable)_$9 -> _$9.address()));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Set<String>)unreachableDataCenters, (Set<UniqueAddress>)this.membershipState().latestGossip().tombstones().keySet());
        receiver.$bang((Object)state, this.self());
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initMode, Set<Class<?>> to) {
        ClusterEvent.SubscriptionInitialStateMode subscriptionInitialStateMode = initMode;
        if (ClusterEvent$InitialStateAsEvents$.MODULE$.equals(subscriptionInitialStateMode)) {
            ClusterEvent$.MODULE$.publishDiff(this.emptyMembershipState(), this.membershipState(), (Function1<Object, BoxedUnit>)(JProcedure1 & Serializable)event -> this.pub$1(subscriber, to, event));
        } else if (ClusterEvent$InitialStateAsSnapshot$.MODULE$.equals(subscriptionInitialStateMode)) {
            this.sendCurrentClusterState(subscriber);
        } else {
            throw new MatchError((Object)subscriptionInitialStateMode);
        }
        to.foreach((Function1 & Serializable)_$11 -> this.eventStream().subscribe(subscriber, _$11));
    }

    public void unsubscribe(ActorRef subscriber, Option<Class<?>> to) {
        Option<Class<?>> option = to;
        if (None$.MODULE$.equals(option)) {
            this.eventStream().unsubscribe(subscriber);
            return;
        }
        if (option instanceof Some) {
            Class c = (Class)((Some)option).value();
            this.eventStream().unsubscribe(subscriber, c);
            return;
        }
        throw new MatchError(option);
    }

    public void publishChanges(MembershipState newState) {
        MembershipState oldState = this.membershipState();
        this.membershipState_$eq(newState);
        ClusterEvent$.MODULE$.publishDiff(oldState, newState, (Function1<Object, BoxedUnit>)(JProcedure1 & Serializable)event -> this.publish(event));
    }

    public void publishInternalStats(ClusterEvent.CurrentInternalStats currentStats) {
        this.publish(currentStats);
    }

    public void publish(Object event) {
        this.eventStream().publish(event);
    }

    public void clearState() {
        this.membershipState_$eq(this.emptyMembershipState());
    }

    private final void pub$1(ActorRef subscriber$1, Set to$1, Object event) {
        if (to$1.exists((Function1 & Serializable)_$10 -> _$10.isAssignableFrom(event.getClass()))) {
            subscriber$1.$bang(event, this.self());
            return;
        }
    }
}

