/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$ClusterShuttingDown$;
import org.apache.pekko.cluster.ClusterEvent$CurrentClusterState$;
import org.apache.pekko.cluster.ClusterEvent$CurrentInternalStats$;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsEvents$;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsSnapshot$;
import org.apache.pekko.cluster.ClusterEvent$LeaderChanged$;
import org.apache.pekko.cluster.ClusterEvent$MemberDowned$;
import org.apache.pekko.cluster.ClusterEvent$MemberExited$;
import org.apache.pekko.cluster.ClusterEvent$MemberJoined$;
import org.apache.pekko.cluster.ClusterEvent$MemberLeft$;
import org.apache.pekko.cluster.ClusterEvent$MemberPreparingForShutdown$;
import org.apache.pekko.cluster.ClusterEvent$MemberReadyForShutdown$;
import org.apache.pekko.cluster.ClusterEvent$MemberRemoved$;
import org.apache.pekko.cluster.ClusterEvent$MemberTombstonesChanged$;
import org.apache.pekko.cluster.ClusterEvent$MemberUp$;
import org.apache.pekko.cluster.ClusterEvent$MemberWeaklyUp$;
import org.apache.pekko.cluster.ClusterEvent$ReachabilityChanged$;
import org.apache.pekko.cluster.ClusterEvent$ReachableDataCenter$;
import org.apache.pekko.cluster.ClusterEvent$ReachableMember$;
import org.apache.pekko.cluster.ClusterEvent$RoleLeaderChanged$;
import org.apache.pekko.cluster.ClusterEvent$SeenChanged$;
import org.apache.pekko.cluster.ClusterEvent$UnreachableDataCenter$;
import org.apache.pekko.cluster.ClusterEvent$UnreachableMember$;
import org.apache.pekko.cluster.Gossip;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.MemberStatus$Exiting$;
import org.apache.pekko.cluster.MemberStatus$Joining$;
import org.apache.pekko.cluster.MemberStatus$Leaving$;
import org.apache.pekko.cluster.MemberStatus$PreparingForShutdown$;
import org.apache.pekko.cluster.MemberStatus$ReadyForShutdown$;
import org.apache.pekko.cluster.MemberStatus$Removed$;
import org.apache.pekko.cluster.MemberStatus$Up$;
import org.apache.pekko.cluster.MemberStatus$WeaklyUp$;
import org.apache.pekko.cluster.MembershipState;
import org.apache.pekko.cluster.Reachability;
import org.apache.pekko.cluster.UniqueAddress;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.VectorBuilder;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ClusterEvent$
implements Serializable {
    public static final ClusterEvent$InitialStateAsSnapshot$ InitialStateAsSnapshot;
    public static final ClusterEvent$InitialStateAsEvents$ InitialStateAsEvents;
    public static final ClusterEvent$CurrentClusterState$ CurrentClusterState;
    public static final ClusterEvent$MemberJoined$ MemberJoined;
    public static final ClusterEvent$MemberWeaklyUp$ MemberWeaklyUp;
    public static final ClusterEvent$MemberUp$ MemberUp;
    public static final ClusterEvent$MemberLeft$ MemberLeft;
    public static final ClusterEvent$MemberPreparingForShutdown$ MemberPreparingForShutdown;
    public static final ClusterEvent$MemberReadyForShutdown$ MemberReadyForShutdown;
    public static final ClusterEvent$MemberExited$ MemberExited;
    public static final ClusterEvent$MemberDowned$ MemberDowned;
    public static final ClusterEvent$MemberRemoved$ MemberRemoved;
    public static final ClusterEvent$LeaderChanged$ LeaderChanged;
    public static final ClusterEvent$RoleLeaderChanged$ RoleLeaderChanged;
    public static final ClusterEvent$ClusterShuttingDown$ ClusterShuttingDown;
    public static final ClusterEvent$UnreachableMember$ UnreachableMember;
    public static final ClusterEvent$ReachableMember$ ReachableMember;
    public static final ClusterEvent$UnreachableDataCenter$ UnreachableDataCenter;
    public static final ClusterEvent$ReachableDataCenter$ ReachableDataCenter;
    public static final ClusterEvent$SeenChanged$ SeenChanged;
    public static final ClusterEvent$ReachabilityChanged$ ReachabilityChanged;
    public static final ClusterEvent$CurrentInternalStats$ CurrentInternalStats;
    public static final ClusterEvent$MemberTombstonesChanged$ MemberTombstonesChanged;
    public static final ClusterEvent$ MODULE$;

    private ClusterEvent$() {
    }

    static {
        MODULE$ = new ClusterEvent$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClusterEvent$.class);
    }

    public ClusterEvent$InitialStateAsSnapshot$ initialStateAsSnapshot() {
        return ClusterEvent$InitialStateAsSnapshot$.MODULE$;
    }

    public ClusterEvent$InitialStateAsEvents$ initialStateAsEvents() {
        return ClusterEvent$InitialStateAsEvents$.MODULE$;
    }

    public ClusterEvent$ClusterShuttingDown$ getClusterShuttingDownInstance() {
        return ClusterEvent$ClusterShuttingDown$.MODULE$;
    }

    @InternalApi
    public Seq<ClusterEvent.UnreachableMember> diffUnreachable(MembershipState oldState, MembershipState newState) {
        if (newState == oldState) {
            return package$.MODULE$.Nil();
        }
        Gossip newGossip = newState.latestGossip();
        scala.collection.immutable.Set<UniqueAddress> oldUnreachableNodes = oldState.dcReachabilityNoOutsideNodes().allUnreachableOrTerminated();
        return (Seq)newState.dcReachabilityNoOutsideNodes().allUnreachableOrTerminated().iterator().collect((PartialFunction)new Serializable(newState, newGossip, oldUnreachableNodes, this){
            private final MembershipState newState$1;
            private final Gossip newGossip$1;
            private final scala.collection.immutable.Set oldUnreachableNodes$1;
            {
                this.newState$1 = newState$6;
                this.newGossip$1 = newGossip$3;
                this.oldUnreachableNodes$1 = oldUnreachableNodes$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(UniqueAddress x) {
                UniqueAddress uniqueAddress = x;
                UniqueAddress node = uniqueAddress;
                if (!this.oldUnreachableNodes$1.contains((Object)node)) {
                    UniqueAddress uniqueAddress2 = node;
                    UniqueAddress uniqueAddress3 = this.newState$1.selfUniqueAddress();
                    if (uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(UniqueAddress x, Function1 function1) {
                UniqueAddress uniqueAddress = x;
                UniqueAddress node = uniqueAddress;
                if (!this.oldUnreachableNodes$1.contains((Object)node)) {
                    UniqueAddress uniqueAddress2 = node;
                    UniqueAddress uniqueAddress3 = this.newState$1.selfUniqueAddress();
                    if (uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3)) {
                        return ClusterEvent$UnreachableMember$.MODULE$.apply(this.newGossip$1.member(node));
                    }
                }
                return function1.apply((Object)x);
            }
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
    }

    @InternalApi
    public Seq<ClusterEvent.ReachableMember> diffReachable(MembershipState oldState, MembershipState newState) {
        if (newState == oldState) {
            return package$.MODULE$.Nil();
        }
        Gossip newGossip = newState.latestGossip();
        return (Seq)oldState.dcReachabilityNoOutsideNodes().allUnreachable().iterator().collect((PartialFunction)new Serializable(newState, newGossip, this){
            private final MembershipState newState$2;
            private final Gossip newGossip$2;
            {
                this.newState$2 = newState$7;
                this.newGossip$2 = newGossip$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(UniqueAddress x) {
                UniqueAddress uniqueAddress = x;
                UniqueAddress node = uniqueAddress;
                if (this.newGossip$2.hasMember(node) && this.newState$2.dcReachabilityNoOutsideNodes().isReachable(node)) {
                    UniqueAddress uniqueAddress2 = node;
                    UniqueAddress uniqueAddress3 = this.newState$2.selfUniqueAddress();
                    if (uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(UniqueAddress x, Function1 function1) {
                UniqueAddress uniqueAddress = x;
                UniqueAddress node = uniqueAddress;
                if (this.newGossip$2.hasMember(node) && this.newState$2.dcReachabilityNoOutsideNodes().isReachable(node)) {
                    UniqueAddress uniqueAddress2 = node;
                    UniqueAddress uniqueAddress3 = this.newState$2.selfUniqueAddress();
                    if (uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3)) {
                        return ClusterEvent$ReachableMember$.MODULE$.apply(this.newGossip$2.member(node));
                    }
                }
                return function1.apply((Object)x);
            }
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
    }

    @InternalApi
    public boolean isDataCenterReachable(MembershipState state, String otherDc) {
        SortedSet unrelatedDcNodes = (SortedSet)state.latestGossip().members().collect((PartialFunction)new Serializable(state, otherDc){
            private final MembershipState state$2;
            private final String otherDc$1;
            {
                this.state$2 = state$3;
                this.otherDc$1 = otherDc$2;
            }

            public final boolean isDefinedAt(Member x) {
                Member member;
                Member m = member = x;
                String string = m.dataCenter();
                String string2 = this.otherDc$1;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String string3 = m.dataCenter();
                    String string4 = this.state$2.selfDc();
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Member x, Function1 function1) {
                Member member;
                Member m = member = x;
                String string = m.dataCenter();
                String string2 = this.otherDc$1;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String string3 = m.dataCenter();
                    String string4 = this.state$2.selfDc();
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        return m.uniqueAddress();
                    }
                }
                return function1.apply((Object)x);
            }
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Reachability reachabilityForOtherDc = state.dcReachabilityWithoutObservationsWithin().remove((Iterable<UniqueAddress>)unrelatedDcNodes);
        return reachabilityForOtherDc.allUnreachable().isEmpty();
    }

    @InternalApi
    public Seq<ClusterEvent.UnreachableDataCenter> diffUnreachableDataCenter(MembershipState oldState, MembershipState newState) {
        if (newState == oldState) {
            return package$.MODULE$.Nil();
        }
        scala.collection.immutable.Set otherDcs = (scala.collection.immutable.Set)((SetOps)oldState.latestGossip().allDataCenters().union(newState.latestGossip().allDataCenters())).$minus((Object)newState.selfDc());
        scala.collection.immutable.Set oldUnreachableDcs = (scala.collection.immutable.Set)otherDcs.filterNot((Function1 & Serializable)otherDc -> this.isDataCenterReachable(oldState, (String)otherDc));
        scala.collection.immutable.Set currentUnreachableDcs = (scala.collection.immutable.Set)otherDcs.filterNot((Function1 & Serializable)otherDc -> this.isDataCenterReachable(newState, (String)otherDc));
        return (Seq)currentUnreachableDcs.diff((Set)oldUnreachableDcs).iterator().map((Function1 & Serializable)dataCenter -> ClusterEvent$UnreachableDataCenter$.MODULE$.apply((String)dataCenter)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
    }

    @InternalApi
    public Seq<ClusterEvent.ReachableDataCenter> diffReachableDataCenter(MembershipState oldState, MembershipState newState) {
        if (newState == oldState) {
            return package$.MODULE$.Nil();
        }
        scala.collection.immutable.Set otherDcs = (scala.collection.immutable.Set)((SetOps)oldState.latestGossip().allDataCenters().union(newState.latestGossip().allDataCenters())).$minus((Object)newState.selfDc());
        scala.collection.immutable.Set oldUnreachableDcs = (scala.collection.immutable.Set)otherDcs.filterNot((Function1 & Serializable)otherDc -> this.isDataCenterReachable(oldState, (String)otherDc));
        scala.collection.immutable.Set currentUnreachableDcs = (scala.collection.immutable.Set)otherDcs.filterNot((Function1 & Serializable)otherDc -> this.isDataCenterReachable(newState, (String)otherDc));
        return (Seq)oldUnreachableDcs.diff((Set)currentUnreachableDcs).iterator().map((Function1 & Serializable)dataCenter -> ClusterEvent$ReachableDataCenter$.MODULE$.apply((String)dataCenter)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$));
    }

    @InternalApi
    public Seq<ClusterEvent.MemberEvent> diffMemberEvents(MembershipState oldState, MembershipState newState) {
        Nil$ nil$;
        if (newState == oldState) {
            nil$ = package$.MODULE$.Nil();
        } else {
            Gossip oldGossip = oldState.latestGossip();
            Gossip newGossip = newState.latestGossip();
            SortedSet newMembers = (SortedSet)newGossip.members().diff(oldGossip.members());
            Map membersGroupedByAddress = ((IterableOps)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SortedSet[]{newGossip.members(), oldGossip.members()}))).flatten(Predef$.MODULE$.$conforms())).groupBy((Function1 & Serializable)_$3 -> _$3.uniqueAddress());
            scala.collection.immutable.Iterable changedMembers = (scala.collection.immutable.Iterable)membersGroupedByAddress.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    List list;
                    Tuple2 tuple2 = x;
                    if (tuple2 != null && (list = (List)tuple2._2()) instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        List list2 = colon2.next$access$1();
                        Member newMember = (Member)colon2.head();
                        if (list2 instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list2;
                            List list3 = colon3.next$access$1();
                            Member oldMember = (Member)colon3.head();
                            Nil$ nil$ = package$.MODULE$.Nil();
                            List list4 = list3;
                            if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                                MemberStatus memberStatus = newMember.status();
                                MemberStatus memberStatus2 = oldMember.status();
                                if ((memberStatus != null ? !memberStatus.equals(memberStatus2) : memberStatus2 != null) || newMember.upNumber() != oldMember.upNumber()) {
                                    return true;
                                }
                            }
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    List list;
                    Tuple2 tuple2 = x;
                    if (tuple2 != null && (list = (List)tuple2._2()) instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        List list2 = colon2.next$access$1();
                        Member newMember = (Member)colon2.head();
                        if (list2 instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list2;
                            List list3 = colon3.next$access$1();
                            Member oldMember = (Member)colon3.head();
                            Nil$ nil$ = package$.MODULE$.Nil();
                            List list4 = list3;
                            if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                                MemberStatus memberStatus = newMember.status();
                                MemberStatus memberStatus2 = oldMember.status();
                                if ((memberStatus != null ? !memberStatus.equals(memberStatus2) : memberStatus2 != null) || newMember.upNumber() != oldMember.upNumber()) {
                                    return newMember;
                                }
                            }
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            scala.collection.immutable.Set memberEvents = (scala.collection.immutable.Set)((SortedSet)newMembers.$plus$plus((IterableOnce)changedMembers)).unsorted().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Member x) {
                    Member member;
                    Member m = member = x;
                    MemberStatus memberStatus = m.status();
                    MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
                    if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Joining$) : memberStatus$Joining$ != null)) {
                        return true;
                    }
                    Member m2 = member;
                    MemberStatus memberStatus2 = m2.status();
                    MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
                    if (!(memberStatus2 != null ? !memberStatus2.equals(memberStatus$WeaklyUp$) : memberStatus$WeaklyUp$ != null)) {
                        return true;
                    }
                    Member m3 = member;
                    MemberStatus memberStatus3 = m3.status();
                    MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                    if (!(memberStatus3 != null ? !memberStatus3.equals(memberStatus$Up$) : memberStatus$Up$ != null)) {
                        return true;
                    }
                    Member m4 = member;
                    MemberStatus memberStatus4 = m4.status();
                    MemberStatus$Leaving$ memberStatus$Leaving$ = MemberStatus$Leaving$.MODULE$;
                    if (!(memberStatus4 != null ? !memberStatus4.equals(memberStatus$Leaving$) : memberStatus$Leaving$ != null)) {
                        return true;
                    }
                    Member m5 = member;
                    MemberStatus memberStatus5 = m5.status();
                    MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                    if (!(memberStatus5 != null ? !memberStatus5.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null)) {
                        return true;
                    }
                    Member m6 = member;
                    MemberStatus memberStatus6 = m6.status();
                    MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                    if (!(memberStatus6 != null ? !memberStatus6.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
                        return true;
                    }
                    Member m7 = member;
                    MemberStatus memberStatus7 = m7.status();
                    MemberStatus$PreparingForShutdown$ memberStatus$PreparingForShutdown$ = MemberStatus$PreparingForShutdown$.MODULE$;
                    if (!(memberStatus7 != null ? !memberStatus7.equals(memberStatus$PreparingForShutdown$) : memberStatus$PreparingForShutdown$ != null)) {
                        return true;
                    }
                    Member m8 = member;
                    MemberStatus memberStatus8 = m8.status();
                    MemberStatus$ReadyForShutdown$ memberStatus$ReadyForShutdown$ = MemberStatus$ReadyForShutdown$.MODULE$;
                    return !(memberStatus8 != null ? !memberStatus8.equals(memberStatus$ReadyForShutdown$) : memberStatus$ReadyForShutdown$ != null);
                }

                public final Object applyOrElse(Member x, Function1 function1) {
                    Member member;
                    Member m = member = x;
                    MemberStatus memberStatus = m.status();
                    MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
                    if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Joining$) : memberStatus$Joining$ != null)) {
                        return ClusterEvent$MemberJoined$.MODULE$.apply(m);
                    }
                    Member m2 = member;
                    MemberStatus memberStatus2 = m2.status();
                    MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
                    if (!(memberStatus2 != null ? !memberStatus2.equals(memberStatus$WeaklyUp$) : memberStatus$WeaklyUp$ != null)) {
                        return ClusterEvent$MemberWeaklyUp$.MODULE$.apply(m2);
                    }
                    Member m3 = member;
                    MemberStatus memberStatus3 = m3.status();
                    MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                    if (!(memberStatus3 != null ? !memberStatus3.equals(memberStatus$Up$) : memberStatus$Up$ != null)) {
                        return ClusterEvent$MemberUp$.MODULE$.apply(m3);
                    }
                    Member m4 = member;
                    MemberStatus memberStatus4 = m4.status();
                    MemberStatus$Leaving$ memberStatus$Leaving$ = MemberStatus$Leaving$.MODULE$;
                    if (!(memberStatus4 != null ? !memberStatus4.equals(memberStatus$Leaving$) : memberStatus$Leaving$ != null)) {
                        return ClusterEvent$MemberLeft$.MODULE$.apply(m4);
                    }
                    Member m5 = member;
                    MemberStatus memberStatus5 = m5.status();
                    MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                    if (!(memberStatus5 != null ? !memberStatus5.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null)) {
                        return ClusterEvent$MemberExited$.MODULE$.apply(m5);
                    }
                    Member m6 = member;
                    MemberStatus memberStatus6 = m6.status();
                    MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                    if (!(memberStatus6 != null ? !memberStatus6.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
                        return ClusterEvent$MemberDowned$.MODULE$.apply(m6);
                    }
                    Member m7 = member;
                    MemberStatus memberStatus7 = m7.status();
                    MemberStatus$PreparingForShutdown$ memberStatus$PreparingForShutdown$ = MemberStatus$PreparingForShutdown$.MODULE$;
                    if (!(memberStatus7 != null ? !memberStatus7.equals(memberStatus$PreparingForShutdown$) : memberStatus$PreparingForShutdown$ != null)) {
                        return ClusterEvent$MemberPreparingForShutdown$.MODULE$.apply(m7);
                    }
                    Member m8 = member;
                    MemberStatus memberStatus8 = m8.status();
                    MemberStatus$ReadyForShutdown$ memberStatus$ReadyForShutdown$ = MemberStatus$ReadyForShutdown$.MODULE$;
                    if (!(memberStatus8 != null ? !memberStatus8.equals(memberStatus$ReadyForShutdown$) : memberStatus$ReadyForShutdown$ != null)) {
                        return ClusterEvent$MemberReadyForShutdown$.MODULE$.apply(m8);
                    }
                    return function1.apply((Object)x);
                }
            });
            SortedSet removedMembers = (SortedSet)oldGossip.members().diff(newGossip.members());
            scala.collection.immutable.Set removedEvents = (scala.collection.immutable.Set)removedMembers.unsorted().map((Function1 & Serializable)m -> ClusterEvent$MemberRemoved$.MODULE$.apply(m.copy(MemberStatus$Removed$.MODULE$), m.status()));
            nil$ = ((VectorBuilder)new VectorBuilder().$plus$plus$eq((IterableOnce)removedEvents).$plus$plus$eq((IterableOnce)memberEvents)).result();
        }
        return (Seq)nil$;
    }

    @InternalApi
    public Seq<ClusterEvent.LeaderChanged> diffLeader(MembershipState oldState, MembershipState newState) {
        Option<UniqueAddress> newLeader;
        Option<UniqueAddress> option = newLeader = newState.leader();
        Option<UniqueAddress> option2 = oldState.leader();
        if (option == null ? option2 != null : !option.equals(option2)) {
            return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterEvent.LeaderChanged[]{ClusterEvent$LeaderChanged$.MODULE$.apply((Option<Address>)newLeader.map((Function1 & Serializable)_$4 -> _$4.address()))}));
        }
        return package$.MODULE$.Nil();
    }

    @InternalApi
    public scala.collection.immutable.Set<ClusterEvent.RoleLeaderChanged> diffRolesLeader(MembershipState oldState, MembershipState newState) {
        return (scala.collection.immutable.Set)((IterableOps)oldState.latestGossip().allRoles().union(newState.latestGossip().allRoles()).map((Function1 & Serializable)role -> {
            Option<UniqueAddress> newLeader = newState.roleLeader((String)role);
            return Tuple2$.MODULE$.apply(role, newLeader);
        })).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Option newLeader;
                String role = (String)tuple2._1();
                Option option = newLeader = (Option)tuple2._2();
                Option<UniqueAddress> option2 = oldState.roleLeader(role);
                return option == null ? option2 != null : !option.equals(option2);
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String role = (String)tuple2._1();
                Option newLeader = (Option)tuple2._2();
                return ClusterEvent$RoleLeaderChanged$.MODULE$.apply(role, (Option<Address>)newLeader.map((Function1 & Serializable)_$5 -> _$5.address()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @InternalApi
    public Seq<ClusterEvent.SeenChanged> diffSeen(MembershipState oldState, MembershipState newState) {
        block5: {
            scala.collection.immutable.Set<UniqueAddress> newSeenBy;
            boolean newConvergence;
            block4: {
                if (oldState == newState) {
                    return package$.MODULE$.Nil();
                }
                newConvergence = newState.convergence((scala.collection.immutable.Set<UniqueAddress>)Predef$.MODULE$.Set().empty());
                newSeenBy = newState.latestGossip().seenBy();
                if (newConvergence != oldState.convergence((scala.collection.immutable.Set<UniqueAddress>)Predef$.MODULE$.Set().empty())) break block4;
                scala.collection.immutable.Set<UniqueAddress> set = newSeenBy;
                scala.collection.immutable.Set<UniqueAddress> set2 = oldState.latestGossip().seenBy();
                if (!(set == null ? set2 != null : !set.equals(set2))) break block5;
            }
            return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterEvent.SeenChanged[]{ClusterEvent$SeenChanged$.MODULE$.apply(newConvergence, (scala.collection.immutable.Set<Address>)((scala.collection.immutable.Set)newSeenBy.map((Function1 & Serializable)_$6 -> _$6.address())))}));
        }
        return package$.MODULE$.Nil();
    }

    @InternalApi
    public Seq<ClusterEvent.ReachabilityChanged> diffReachability(MembershipState oldState, MembershipState newState) {
        if (newState.overview().reachability() == oldState.overview().reachability()) {
            return package$.MODULE$.Nil();
        }
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClusterEvent.ReachabilityChanged[]{ClusterEvent$ReachabilityChanged$.MODULE$.apply(newState.overview().reachability())}));
    }

    @InternalApi
    public Seq<ClusterEvent.MemberTombstonesChanged> diffTombstones(MembershipState oldState, MembershipState newState) {
        Map<UniqueAddress, Object> map = newState.latestGossip().tombstones();
        Map<UniqueAddress, Object> map2 = oldState.latestGossip().tombstones();
        if (!(map != null ? !map.equals(map2) : map2 != null)) {
            return package$.MODULE$.Nil();
        }
        ClusterEvent.MemberTombstonesChanged memberTombstonesChanged = ClusterEvent$MemberTombstonesChanged$.MODULE$.apply((scala.collection.immutable.Set<UniqueAddress>)newState.latestGossip().tombstones().keySet());
        return package$.MODULE$.Nil().$colon$colon((Object)memberTombstonesChanged);
    }

    @InternalApi
    public void publishDiff(MembershipState oldState, MembershipState newState, Function1<Object, BoxedUnit> pub) {
        this.diffTombstones(oldState, newState).foreach(pub);
        this.diffMemberEvents(oldState, newState).foreach(pub);
        this.diffUnreachable(oldState, newState).foreach(pub);
        this.diffReachable(oldState, newState).foreach(pub);
        this.diffUnreachableDataCenter(oldState, newState).foreach(pub);
        this.diffReachableDataCenter(oldState, newState).foreach(pub);
        this.diffLeader(oldState, newState).foreach(pub);
        this.diffRolesLeader(oldState, newState).foreach(pub);
        this.diffSeen(oldState, newState).foreach(pub);
        this.diffReachability(oldState, newState).foreach(pub);
    }
}

