/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.util.Set;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterEvent$;
import org.apache.pekko.cluster.ClusterEvent$ClusterShuttingDown$;
import org.apache.pekko.cluster.ClusterEvent$CurrentClusterState$;
import org.apache.pekko.cluster.ClusterEvent$CurrentInternalStats$;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsEvents$;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsSnapshot$;
import org.apache.pekko.cluster.ClusterEvent$LeaderChanged$;
import org.apache.pekko.cluster.ClusterEvent$MemberDowned$;
import org.apache.pekko.cluster.ClusterEvent$MemberExited$;
import org.apache.pekko.cluster.ClusterEvent$MemberJoined$;
import org.apache.pekko.cluster.ClusterEvent$MemberLeft$;
import org.apache.pekko.cluster.ClusterEvent$MemberPreparingForShutdown$;
import org.apache.pekko.cluster.ClusterEvent$MemberReadyForShutdown$;
import org.apache.pekko.cluster.ClusterEvent$MemberRemoved$;
import org.apache.pekko.cluster.ClusterEvent$MemberTombstonesChanged$;
import org.apache.pekko.cluster.ClusterEvent$MemberUp$;
import org.apache.pekko.cluster.ClusterEvent$MemberWeaklyUp$;
import org.apache.pekko.cluster.ClusterEvent$ReachabilityChanged$;
import org.apache.pekko.cluster.ClusterEvent$ReachableDataCenter$;
import org.apache.pekko.cluster.ClusterEvent$ReachableMember$;
import org.apache.pekko.cluster.ClusterEvent$RoleLeaderChanged$;
import org.apache.pekko.cluster.ClusterEvent$SeenChanged$;
import org.apache.pekko.cluster.ClusterEvent$UnreachableDataCenter$;
import org.apache.pekko.cluster.ClusterEvent$UnreachableMember$;
import org.apache.pekko.cluster.GossipStats;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.MemberStatus$Exiting$;
import org.apache.pekko.cluster.MemberStatus$Joining$;
import org.apache.pekko.cluster.MemberStatus$Leaving$;
import org.apache.pekko.cluster.MemberStatus$PreparingForShutdown$;
import org.apache.pekko.cluster.MemberStatus$ReadyForShutdown$;
import org.apache.pekko.cluster.MemberStatus$Removed$;
import org.apache.pekko.cluster.MemberStatus$Up$;
import org.apache.pekko.cluster.MemberStatus$WeaklyUp$;
import org.apache.pekko.cluster.MembershipState;
import org.apache.pekko.cluster.Reachability;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.VectorClockStats;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Product5;
import scala.Tuple5;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedSet;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

public final class ClusterEvent {
    @InternalApi
    public static Seq<LeaderChanged> diffLeader(MembershipState membershipState, MembershipState membershipState2) {
        return ClusterEvent$.MODULE$.diffLeader(membershipState, membershipState2);
    }

    @InternalApi
    public static Seq<MemberEvent> diffMemberEvents(MembershipState membershipState, MembershipState membershipState2) {
        return ClusterEvent$.MODULE$.diffMemberEvents(membershipState, membershipState2);
    }

    @InternalApi
    public static Seq<ReachabilityChanged> diffReachability(MembershipState membershipState, MembershipState membershipState2) {
        return ClusterEvent$.MODULE$.diffReachability(membershipState, membershipState2);
    }

    @InternalApi
    public static Seq<ReachableMember> diffReachable(MembershipState membershipState, MembershipState membershipState2) {
        return ClusterEvent$.MODULE$.diffReachable(membershipState, membershipState2);
    }

    @InternalApi
    public static Seq<ReachableDataCenter> diffReachableDataCenter(MembershipState membershipState, MembershipState membershipState2) {
        return ClusterEvent$.MODULE$.diffReachableDataCenter(membershipState, membershipState2);
    }

    @InternalApi
    public static scala.collection.immutable.Set<RoleLeaderChanged> diffRolesLeader(MembershipState membershipState, MembershipState membershipState2) {
        return ClusterEvent$.MODULE$.diffRolesLeader(membershipState, membershipState2);
    }

    @InternalApi
    public static Seq<SeenChanged> diffSeen(MembershipState membershipState, MembershipState membershipState2) {
        return ClusterEvent$.MODULE$.diffSeen(membershipState, membershipState2);
    }

    @InternalApi
    public static Seq<MemberTombstonesChanged> diffTombstones(MembershipState membershipState, MembershipState membershipState2) {
        return ClusterEvent$.MODULE$.diffTombstones(membershipState, membershipState2);
    }

    @InternalApi
    public static Seq<UnreachableMember> diffUnreachable(MembershipState membershipState, MembershipState membershipState2) {
        return ClusterEvent$.MODULE$.diffUnreachable(membershipState, membershipState2);
    }

    @InternalApi
    public static Seq<UnreachableDataCenter> diffUnreachableDataCenter(MembershipState membershipState, MembershipState membershipState2) {
        return ClusterEvent$.MODULE$.diffUnreachableDataCenter(membershipState, membershipState2);
    }

    public static ClusterEvent$ClusterShuttingDown$ getClusterShuttingDownInstance() {
        return ClusterEvent$.MODULE$.getClusterShuttingDownInstance();
    }

    public static ClusterEvent$InitialStateAsEvents$ initialStateAsEvents() {
        return ClusterEvent$.MODULE$.initialStateAsEvents();
    }

    public static ClusterEvent$InitialStateAsSnapshot$ initialStateAsSnapshot() {
        return ClusterEvent$.MODULE$.initialStateAsSnapshot();
    }

    @InternalApi
    public static boolean isDataCenterReachable(MembershipState membershipState, String string) {
        return ClusterEvent$.MODULE$.isDataCenterReachable(membershipState, string);
    }

    @InternalApi
    public static void publishDiff(MembershipState membershipState, MembershipState membershipState2, Function1<Object, BoxedUnit> function1) {
        ClusterEvent$.MODULE$.publishDiff(membershipState, membershipState2, function1);
    }

    @DoNotInherit
    public static interface ClusterDomainEvent
    extends DeadLetterSuppression {
    }

    public static final class CurrentClusterState
    implements Product5<SortedSet<Member>, scala.collection.immutable.Set<Member>, scala.collection.immutable.Set<Address>, Option<Address>, Map<String, Option<Address>>>,
    Serializable {
        private static final long serialVersionUID = 2L;
        private final SortedSet members;
        private final scala.collection.immutable.Set unreachable;
        private final scala.collection.immutable.Set seenBy;
        private final Option leader;
        private final Map roleLeaderMap;
        private final scala.collection.immutable.Set unreachableDataCenters;
        private final scala.collection.immutable.Set memberTombstones;

        public static CurrentClusterState apply(SortedSet<Member> sortedSet, scala.collection.immutable.Set<Member> set, scala.collection.immutable.Set<Address> set2, Option<Address> option, Map<String, Option<Address>> map) {
            return ClusterEvent$CurrentClusterState$.MODULE$.apply(sortedSet, set, set2, option, map);
        }

        public static Function1<SortedSet<Member>, Function1<scala.collection.immutable.Set<Member>, Function1<scala.collection.immutable.Set<Address>, Function1<Option<Address>, Function1<Map<String, Option<Address>>, CurrentClusterState>>>>> curried() {
            return ClusterEvent$CurrentClusterState$.MODULE$.curried();
        }

        public static Function1<Tuple5<SortedSet<Member>, scala.collection.immutable.Set<Member>, scala.collection.immutable.Set<Address>, Option<Address>, Map<String, Option<Address>>>, CurrentClusterState> tupled() {
            return ClusterEvent$CurrentClusterState$.MODULE$.tupled();
        }

        public static Option<Tuple5<SortedSet<Member>, scala.collection.immutable.Set<Member>, scala.collection.immutable.Set<Address>, Option<Address>, Map<String, Option<Address>>>> unapply(CurrentClusterState currentClusterState) {
            return ClusterEvent$CurrentClusterState$.MODULE$.unapply(currentClusterState);
        }

        public static SortedSet<Member> $lessinit$greater$default$1() {
            return ClusterEvent$CurrentClusterState$.MODULE$.$lessinit$greater$default$1();
        }

        public static SortedSet<Member> apply$default$1() {
            return ClusterEvent$CurrentClusterState$.MODULE$.apply$default$1();
        }

        public static scala.collection.immutable.Set<Member> $lessinit$greater$default$2() {
            return ClusterEvent$CurrentClusterState$.MODULE$.$lessinit$greater$default$2();
        }

        public static scala.collection.immutable.Set<Member> apply$default$2() {
            return ClusterEvent$CurrentClusterState$.MODULE$.apply$default$2();
        }

        public static scala.collection.immutable.Set<Address> $lessinit$greater$default$3() {
            return ClusterEvent$CurrentClusterState$.MODULE$.$lessinit$greater$default$3();
        }

        public static scala.collection.immutable.Set<Address> apply$default$3() {
            return ClusterEvent$CurrentClusterState$.MODULE$.apply$default$3();
        }

        public static Option<Address> $lessinit$greater$default$4() {
            return ClusterEvent$CurrentClusterState$.MODULE$.$lessinit$greater$default$4();
        }

        public static Option<Address> apply$default$4() {
            return ClusterEvent$CurrentClusterState$.MODULE$.apply$default$4();
        }

        public static Map<String, Option<Address>> $lessinit$greater$default$5() {
            return ClusterEvent$CurrentClusterState$.MODULE$.$lessinit$greater$default$5();
        }

        public static Map<String, Option<Address>> apply$default$5() {
            return ClusterEvent$CurrentClusterState$.MODULE$.apply$default$5();
        }

        public CurrentClusterState(SortedSet<Member> members, scala.collection.immutable.Set<Member> unreachable, scala.collection.immutable.Set<Address> seenBy, Option<Address> leader, Map<String, Option<Address>> roleLeaderMap, scala.collection.immutable.Set<String> unreachableDataCenters, @InternalApi scala.collection.immutable.Set<UniqueAddress> memberTombstones) {
            this.members = members;
            this.unreachable = unreachable;
            this.seenBy = seenBy;
            this.leader = leader;
            this.roleLeaderMap = roleLeaderMap;
            this.unreachableDataCenters = unreachableDataCenters;
            this.memberTombstones = memberTombstones;
            Product5.$init$((Product5)this);
        }

        public SortedSet<Member> members() {
            return this.members;
        }

        public scala.collection.immutable.Set<Member> unreachable() {
            return this.unreachable;
        }

        public scala.collection.immutable.Set<Address> seenBy() {
            return this.seenBy;
        }

        public Option<Address> leader() {
            return this.leader;
        }

        public Map<String, Option<Address>> roleLeaderMap() {
            return this.roleLeaderMap;
        }

        public scala.collection.immutable.Set<String> unreachableDataCenters() {
            return this.unreachableDataCenters;
        }

        public scala.collection.immutable.Set<UniqueAddress> memberTombstones() {
            return this.memberTombstones;
        }

        public CurrentClusterState(SortedSet<Member> members, scala.collection.immutable.Set<Member> unreachable, scala.collection.immutable.Set<Address> seenBy, Option<Address> leader, Map<String, Option<Address>> roleLeaderMap, scala.collection.immutable.Set<String> unreachableDataCenters) {
            this(members, unreachable, seenBy, leader, roleLeaderMap, unreachableDataCenters, (scala.collection.immutable.Set<UniqueAddress>)Predef$.MODULE$.Set().empty());
        }

        public CurrentClusterState(SortedSet<Member> members, scala.collection.immutable.Set<Member> unreachable, scala.collection.immutable.Set<Address> seenBy, Option<Address> leader, Map<String, Option<Address>> roleLeaderMap) {
            this(members, unreachable, seenBy, leader, roleLeaderMap, (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<UniqueAddress>)Predef$.MODULE$.Set().empty());
        }

        public Iterable<Member> getMembers() {
            return package.JavaConverters$.MODULE$.SetHasAsJava(this.members()).asJava();
        }

        public Set<Member> getUnreachable() {
            return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.unreachable()).asJava();
        }

        public Set<String> getUnreachableDataCenters() {
            return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.unreachableDataCenters()).asJava();
        }

        public Set<Address> getSeenBy() {
            return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.seenBy()).asJava();
        }

        public Address getLeader() {
            return (Address)this.leader().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public Option<Address> roleLeader(String role) {
            return (Option)this.roleLeaderMap().getOrElse((Object)role, this::roleLeader$$anonfun$1);
        }

        public Address getRoleLeader(String role) {
            return (Address)this.roleLeaderMap().get((Object)role).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public scala.collection.immutable.Set<String> allRoles() {
            return this.roleLeaderMap().keySet();
        }

        public Set<String> getAllRoles() {
            return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.allRoles()).asJava();
        }

        public scala.collection.immutable.Set<String> allDataCenters() {
            return (scala.collection.immutable.Set)this.members().iterator().map((Function1 & Serializable)_$1 -> _$1.dataCenter()).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Set$.MODULE$));
        }

        public Set<String> getAllDataCenters() {
            return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.allDataCenters()).asJava();
        }

        public CurrentClusterState withUnreachableDataCenters(scala.collection.immutable.Set<String> unreachableDataCenters) {
            return new CurrentClusterState(this.members(), this.unreachable(), this.seenBy(), this.leader(), this.roleLeaderMap(), unreachableDataCenters, this.memberTombstones());
        }

        public CurrentClusterState withMemberTombstones(scala.collection.immutable.Set<UniqueAddress> memberTombstones) {
            return new CurrentClusterState(this.members(), this.unreachable(), this.seenBy(), this.leader(), this.roleLeaderMap(), this.unreachableDataCenters(), memberTombstones);
        }

        @InternalApi
        public boolean isMemberUp(Address address) {
            return this.members().exists((Function1 & Serializable)m -> {
                Address address = m.address();
                Address address2 = address;
                if (address == null) {
                    if (address2 != null) {
                        return false;
                    }
                } else if (!address.equals(address2)) return false;
                MemberStatus memberStatus = m.status();
                MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                if (memberStatus == null) {
                    if (memberStatus$Up$ == null) return true;
                    return false;
                } else {
                    if (!memberStatus.equals(memberStatus$Up$)) return false;
                    return true;
                }
            });
        }

        public CurrentClusterState copy(SortedSet<Member> members, scala.collection.immutable.Set<Member> unreachable, scala.collection.immutable.Set<Address> seenBy, Option<Address> leader, Map<String, Option<Address>> roleLeaderMap) {
            return new CurrentClusterState(members, unreachable, seenBy, leader, roleLeaderMap, this.unreachableDataCenters(), this.memberTombstones());
        }

        public SortedSet<Member> copy$default$1() {
            return this.members();
        }

        public scala.collection.immutable.Set<Member> copy$default$2() {
            return this.unreachable();
        }

        public scala.collection.immutable.Set<Address> copy$default$3() {
            return this.seenBy();
        }

        public Option<Address> copy$default$4() {
            return this.leader();
        }

        public Map<String, Option<Address>> copy$default$5() {
            return this.roleLeaderMap();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof CurrentClusterState)) return false;
            CurrentClusterState that = (CurrentClusterState)object;
            if (this == that) return true;
            SortedSet<Member> sortedSet = this.members();
            SortedSet<Member> sortedSet2 = that.members();
            if (sortedSet == null) {
                if (sortedSet2 != null) {
                    return false;
                }
            } else if (!sortedSet.equals(sortedSet2)) return false;
            scala.collection.immutable.Set<Member> set = this.unreachable();
            scala.collection.immutable.Set<Member> set2 = that.unreachable();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            scala.collection.immutable.Set<Address> set3 = this.seenBy();
            scala.collection.immutable.Set<Address> set4 = that.seenBy();
            if (set3 == null) {
                if (set4 != null) {
                    return false;
                }
            } else if (!set3.equals(set4)) return false;
            Option<Address> option = this.leader();
            Option<Address> option2 = that.leader();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Map<String, Option<Address>> map = this.roleLeaderMap();
            Map<String, Option<Address>> map2 = that.roleLeaderMap();
            if (map == null) {
                if (map2 == null) return true;
                return false;
            } else {
                if (!map.equals(map2)) return false;
                return true;
            }
        }

        public int hashCode() {
            Seq state = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.members(), this.unreachable(), this.seenBy(), this.leader(), this.roleLeaderMap()}));
            return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)_$2 -> _$2.hashCode())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
        }

        public String productPrefix() {
            return "CurrentClusterState";
        }

        public SortedSet<Member> _1() {
            return this.members();
        }

        public scala.collection.immutable.Set<Member> _2() {
            return this.unreachable();
        }

        public scala.collection.immutable.Set<Address> _3() {
            return this.seenBy();
        }

        public Option<Address> _4() {
            return this.leader();
        }

        public Map<String, Option<Address>> _5() {
            return this.roleLeaderMap();
        }

        public boolean canEqual(Object that) {
            return that instanceof CurrentClusterState;
        }

        public String toString() {
            return new StringBuilder(29).append("CurrentClusterState(").append(this.members()).append(", ").append(this.unreachable()).append(", ").append(this.seenBy()).append(", ").append(this.leader()).append(", ").append(this.roleLeaderMap()).append(")").toString();
        }

        private final Option roleLeader$$anonfun$1() {
            return None$.MODULE$;
        }
    }

    @InternalApi
    public static final class CurrentInternalStats
    implements ClusterDomainEvent,
    Product,
    Serializable {
        private final GossipStats gossipStats;
        private final VectorClockStats vclockStats;

        public static CurrentInternalStats apply(GossipStats gossipStats, VectorClockStats vectorClockStats) {
            return ClusterEvent$CurrentInternalStats$.MODULE$.apply(gossipStats, vectorClockStats);
        }

        public static CurrentInternalStats fromProduct(Product product) {
            return ClusterEvent$CurrentInternalStats$.MODULE$.fromProduct(product);
        }

        public static CurrentInternalStats unapply(CurrentInternalStats currentInternalStats) {
            return ClusterEvent$CurrentInternalStats$.MODULE$.unapply(currentInternalStats);
        }

        public CurrentInternalStats(GossipStats gossipStats, VectorClockStats vclockStats) {
            this.gossipStats = gossipStats;
            this.vclockStats = vclockStats;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CurrentInternalStats)) return false;
            CurrentInternalStats currentInternalStats = (CurrentInternalStats)object;
            GossipStats gossipStats = this.gossipStats();
            GossipStats gossipStats2 = currentInternalStats.gossipStats();
            if (gossipStats == null) {
                if (gossipStats2 != null) {
                    return false;
                }
            } else if (!((Object)gossipStats).equals(gossipStats2)) return false;
            VectorClockStats vectorClockStats = this.vclockStats();
            VectorClockStats vectorClockStats2 = currentInternalStats.vclockStats();
            if (vectorClockStats == null) {
                if (vectorClockStats2 == null) return true;
                return false;
            } else {
                if (!((Object)vectorClockStats).equals(vectorClockStats2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CurrentInternalStats;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CurrentInternalStats";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "gossipStats";
            }
            if (1 == n2) {
                return "vclockStats";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public GossipStats gossipStats() {
            return this.gossipStats;
        }

        public VectorClockStats vclockStats() {
            return this.vclockStats;
        }

        public CurrentInternalStats copy(GossipStats gossipStats, VectorClockStats vclockStats) {
            return new CurrentInternalStats(gossipStats, vclockStats);
        }

        public GossipStats copy$default$1() {
            return this.gossipStats();
        }

        public VectorClockStats copy$default$2() {
            return this.vclockStats();
        }

        public GossipStats _1() {
            return this.gossipStats();
        }

        public VectorClockStats _2() {
            return this.vclockStats();
        }
    }

    public static interface DataCenterReachabilityEvent
    extends ClusterDomainEvent {
    }

    public static final class LeaderChanged
    implements ClusterDomainEvent,
    Product,
    Serializable {
        private final Option leader;

        public static LeaderChanged apply(Option<Address> option) {
            return ClusterEvent$LeaderChanged$.MODULE$.apply(option);
        }

        public static LeaderChanged fromProduct(Product product) {
            return ClusterEvent$LeaderChanged$.MODULE$.fromProduct(product);
        }

        public static LeaderChanged unapply(LeaderChanged leaderChanged) {
            return ClusterEvent$LeaderChanged$.MODULE$.unapply(leaderChanged);
        }

        public LeaderChanged(Option<Address> leader) {
            this.leader = leader;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LeaderChanged)) return false;
            LeaderChanged leaderChanged = (LeaderChanged)object;
            Option<Address> option = this.leader();
            Option<Address> option2 = leaderChanged.leader();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LeaderChanged;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "LeaderChanged";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "leader";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Address> leader() {
            return this.leader;
        }

        public Address getLeader() {
            return (Address)this.leader().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public LeaderChanged copy(Option<Address> leader) {
            return new LeaderChanged(leader);
        }

        public Option<Address> copy$default$1() {
            return this.leader();
        }

        public Option<Address> _1() {
            return this.leader();
        }
    }

    public static final class MemberDowned
    implements MemberEvent,
    Product,
    Serializable {
        private final Member member;

        public static MemberDowned apply(Member member) {
            return ClusterEvent$MemberDowned$.MODULE$.apply(member);
        }

        public static MemberDowned fromProduct(Product product) {
            return ClusterEvent$MemberDowned$.MODULE$.fromProduct(product);
        }

        public static MemberDowned unapply(MemberDowned memberDowned) {
            return ClusterEvent$MemberDowned$.MODULE$.unapply(memberDowned);
        }

        public MemberDowned(Member member) {
            this.member = member;
            MemberStatus memberStatus = member.status();
            MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
            if (memberStatus == null ? memberStatus$Down$ != null : !memberStatus.equals(memberStatus$Down$)) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Expected Down status, got: ").append(member).toString());
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemberDowned)) return false;
            MemberDowned memberDowned = (MemberDowned)object;
            Member member = this.member();
            Member member2 = memberDowned.member();
            if (member != null) {
                if (!((Object)member).equals(member2)) return false;
                return true;
            }
            if (member2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemberDowned;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MemberDowned";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public MemberDowned copy(Member member) {
            return new MemberDowned(member);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public Member _1() {
            return this.member();
        }
    }

    public static interface MemberEvent
    extends ClusterDomainEvent {
        public Member member();
    }

    public static final class MemberExited
    implements MemberEvent,
    Product,
    Serializable {
        private final Member member;

        public static MemberExited apply(Member member) {
            return ClusterEvent$MemberExited$.MODULE$.apply(member);
        }

        public static MemberExited fromProduct(Product product) {
            return ClusterEvent$MemberExited$.MODULE$.fromProduct(product);
        }

        public static MemberExited unapply(MemberExited memberExited) {
            return ClusterEvent$MemberExited$.MODULE$.unapply(memberExited);
        }

        public MemberExited(Member member) {
            this.member = member;
            MemberStatus memberStatus = member.status();
            MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
            if (memberStatus == null ? memberStatus$Exiting$ != null : !memberStatus.equals(memberStatus$Exiting$)) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Expected Exiting status, got: ").append(member).toString());
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemberExited)) return false;
            MemberExited memberExited = (MemberExited)object;
            Member member = this.member();
            Member member2 = memberExited.member();
            if (member != null) {
                if (!((Object)member).equals(member2)) return false;
                return true;
            }
            if (member2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemberExited;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MemberExited";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public MemberExited copy(Member member) {
            return new MemberExited(member);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public Member _1() {
            return this.member();
        }
    }

    public static final class MemberJoined
    implements MemberEvent,
    Product,
    Serializable {
        private final Member member;

        public static MemberJoined apply(Member member) {
            return ClusterEvent$MemberJoined$.MODULE$.apply(member);
        }

        public static MemberJoined fromProduct(Product product) {
            return ClusterEvent$MemberJoined$.MODULE$.fromProduct(product);
        }

        public static MemberJoined unapply(MemberJoined memberJoined) {
            return ClusterEvent$MemberJoined$.MODULE$.unapply(memberJoined);
        }

        public MemberJoined(Member member) {
            this.member = member;
            MemberStatus memberStatus = member.status();
            MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
            if (memberStatus == null ? memberStatus$Joining$ != null : !memberStatus.equals(memberStatus$Joining$)) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Expected Joining status, got: ").append(member).toString());
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemberJoined)) return false;
            MemberJoined memberJoined = (MemberJoined)object;
            Member member = this.member();
            Member member2 = memberJoined.member();
            if (member != null) {
                if (!((Object)member).equals(member2)) return false;
                return true;
            }
            if (member2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemberJoined;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MemberJoined";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public MemberJoined copy(Member member) {
            return new MemberJoined(member);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public Member _1() {
            return this.member();
        }
    }

    public static final class MemberLeft
    implements MemberEvent,
    Product,
    Serializable {
        private final Member member;

        public static MemberLeft apply(Member member) {
            return ClusterEvent$MemberLeft$.MODULE$.apply(member);
        }

        public static MemberLeft fromProduct(Product product) {
            return ClusterEvent$MemberLeft$.MODULE$.fromProduct(product);
        }

        public static MemberLeft unapply(MemberLeft memberLeft) {
            return ClusterEvent$MemberLeft$.MODULE$.unapply(memberLeft);
        }

        public MemberLeft(Member member) {
            this.member = member;
            MemberStatus memberStatus = member.status();
            MemberStatus$Leaving$ memberStatus$Leaving$ = MemberStatus$Leaving$.MODULE$;
            if (memberStatus == null ? memberStatus$Leaving$ != null : !memberStatus.equals(memberStatus$Leaving$)) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Expected Leaving status, got: ").append(member).toString());
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemberLeft)) return false;
            MemberLeft memberLeft = (MemberLeft)object;
            Member member = this.member();
            Member member2 = memberLeft.member();
            if (member != null) {
                if (!((Object)member).equals(member2)) return false;
                return true;
            }
            if (member2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemberLeft;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MemberLeft";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public MemberLeft copy(Member member) {
            return new MemberLeft(member);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public Member _1() {
            return this.member();
        }
    }

    public static final class MemberPreparingForShutdown
    implements MemberEvent,
    Product,
    Serializable {
        private final Member member;

        public static MemberPreparingForShutdown apply(Member member) {
            return ClusterEvent$MemberPreparingForShutdown$.MODULE$.apply(member);
        }

        public static MemberPreparingForShutdown fromProduct(Product product) {
            return ClusterEvent$MemberPreparingForShutdown$.MODULE$.fromProduct(product);
        }

        public static MemberPreparingForShutdown unapply(MemberPreparingForShutdown memberPreparingForShutdown) {
            return ClusterEvent$MemberPreparingForShutdown$.MODULE$.unapply(memberPreparingForShutdown);
        }

        public MemberPreparingForShutdown(Member member) {
            this.member = member;
            MemberStatus memberStatus = member.status();
            MemberStatus$PreparingForShutdown$ memberStatus$PreparingForShutdown$ = MemberStatus$PreparingForShutdown$.MODULE$;
            if (memberStatus == null ? memberStatus$PreparingForShutdown$ != null : !memberStatus.equals(memberStatus$PreparingForShutdown$)) {
                throw new IllegalArgumentException(new StringBuilder(43).append("Expected PreparingForShutdown status, got: ").append(member).toString());
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemberPreparingForShutdown)) return false;
            MemberPreparingForShutdown memberPreparingForShutdown = (MemberPreparingForShutdown)object;
            Member member = this.member();
            Member member2 = memberPreparingForShutdown.member();
            if (member != null) {
                if (!((Object)member).equals(member2)) return false;
                return true;
            }
            if (member2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemberPreparingForShutdown;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MemberPreparingForShutdown";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public MemberPreparingForShutdown copy(Member member) {
            return new MemberPreparingForShutdown(member);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public Member _1() {
            return this.member();
        }
    }

    public static final class MemberReadyForShutdown
    implements MemberEvent,
    Product,
    Serializable {
        private final Member member;

        public static MemberReadyForShutdown apply(Member member) {
            return ClusterEvent$MemberReadyForShutdown$.MODULE$.apply(member);
        }

        public static MemberReadyForShutdown fromProduct(Product product) {
            return ClusterEvent$MemberReadyForShutdown$.MODULE$.fromProduct(product);
        }

        public static MemberReadyForShutdown unapply(MemberReadyForShutdown memberReadyForShutdown) {
            return ClusterEvent$MemberReadyForShutdown$.MODULE$.unapply(memberReadyForShutdown);
        }

        public MemberReadyForShutdown(Member member) {
            this.member = member;
            MemberStatus memberStatus = member.status();
            MemberStatus$ReadyForShutdown$ memberStatus$ReadyForShutdown$ = MemberStatus$ReadyForShutdown$.MODULE$;
            if (memberStatus == null ? memberStatus$ReadyForShutdown$ != null : !memberStatus.equals(memberStatus$ReadyForShutdown$)) {
                throw new IllegalArgumentException(new StringBuilder(39).append("Expected ReadyForShutdown status, got: ").append(member).toString());
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemberReadyForShutdown)) return false;
            MemberReadyForShutdown memberReadyForShutdown = (MemberReadyForShutdown)object;
            Member member = this.member();
            Member member2 = memberReadyForShutdown.member();
            if (member != null) {
                if (!((Object)member).equals(member2)) return false;
                return true;
            }
            if (member2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemberReadyForShutdown;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MemberReadyForShutdown";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public MemberReadyForShutdown copy(Member member) {
            return new MemberReadyForShutdown(member);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public Member _1() {
            return this.member();
        }
    }

    public static final class MemberRemoved
    implements MemberEvent,
    Product,
    Serializable {
        private final Member member;
        private final MemberStatus previousStatus;

        public static MemberRemoved apply(Member member, MemberStatus memberStatus) {
            return ClusterEvent$MemberRemoved$.MODULE$.apply(member, memberStatus);
        }

        public static MemberRemoved fromProduct(Product product) {
            return ClusterEvent$MemberRemoved$.MODULE$.fromProduct(product);
        }

        public static MemberRemoved unapply(MemberRemoved memberRemoved) {
            return ClusterEvent$MemberRemoved$.MODULE$.unapply(memberRemoved);
        }

        public MemberRemoved(Member member, MemberStatus previousStatus) {
            this.member = member;
            this.previousStatus = previousStatus;
            MemberStatus memberStatus = member.status();
            MemberStatus$Removed$ memberStatus$Removed$ = MemberStatus$Removed$.MODULE$;
            if (memberStatus == null ? memberStatus$Removed$ != null : !memberStatus.equals(memberStatus$Removed$)) {
                throw new IllegalArgumentException(new StringBuilder(30).append("Expected Removed status, got: ").append(member).toString());
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemberRemoved)) return false;
            MemberRemoved memberRemoved = (MemberRemoved)object;
            Member member = this.member();
            Member member2 = memberRemoved.member();
            if (member == null) {
                if (member2 != null) {
                    return false;
                }
            } else if (!((Object)member).equals(member2)) return false;
            MemberStatus memberStatus = this.previousStatus();
            MemberStatus memberStatus2 = memberRemoved.previousStatus();
            if (memberStatus == null) {
                if (memberStatus2 == null) return true;
                return false;
            } else {
                if (!memberStatus.equals(memberStatus2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemberRemoved;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MemberRemoved";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            if (1 == n2) {
                return "previousStatus";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public MemberStatus previousStatus() {
            return this.previousStatus;
        }

        public MemberRemoved copy(Member member, MemberStatus previousStatus) {
            return new MemberRemoved(member, previousStatus);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public MemberStatus copy$default$2() {
            return this.previousStatus();
        }

        public Member _1() {
            return this.member();
        }

        public MemberStatus _2() {
            return this.previousStatus();
        }
    }

    @InternalApi
    public static final class MemberTombstonesChanged
    implements ClusterDomainEvent,
    Product,
    Serializable {
        private final scala.collection.immutable.Set tombstones;

        public static MemberTombstonesChanged apply(scala.collection.immutable.Set<UniqueAddress> set) {
            return ClusterEvent$MemberTombstonesChanged$.MODULE$.apply(set);
        }

        public static MemberTombstonesChanged fromProduct(Product product) {
            return ClusterEvent$MemberTombstonesChanged$.MODULE$.fromProduct(product);
        }

        public static MemberTombstonesChanged unapply(MemberTombstonesChanged memberTombstonesChanged) {
            return ClusterEvent$MemberTombstonesChanged$.MODULE$.unapply(memberTombstonesChanged);
        }

        public MemberTombstonesChanged(scala.collection.immutable.Set<UniqueAddress> tombstones) {
            this.tombstones = tombstones;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemberTombstonesChanged)) return false;
            MemberTombstonesChanged memberTombstonesChanged = (MemberTombstonesChanged)object;
            scala.collection.immutable.Set<UniqueAddress> set = this.tombstones();
            scala.collection.immutable.Set<UniqueAddress> set2 = memberTombstonesChanged.tombstones();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemberTombstonesChanged;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MemberTombstonesChanged";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tombstones";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Set<UniqueAddress> tombstones() {
            return this.tombstones;
        }

        public MemberTombstonesChanged copy(scala.collection.immutable.Set<UniqueAddress> tombstones) {
            return new MemberTombstonesChanged(tombstones);
        }

        public scala.collection.immutable.Set<UniqueAddress> copy$default$1() {
            return this.tombstones();
        }

        public scala.collection.immutable.Set<UniqueAddress> _1() {
            return this.tombstones();
        }
    }

    public static final class MemberUp
    implements MemberEvent,
    Product,
    Serializable {
        private final Member member;

        public static MemberUp apply(Member member) {
            return ClusterEvent$MemberUp$.MODULE$.apply(member);
        }

        public static MemberUp fromProduct(Product product) {
            return ClusterEvent$MemberUp$.MODULE$.fromProduct(product);
        }

        public static MemberUp unapply(MemberUp memberUp) {
            return ClusterEvent$MemberUp$.MODULE$.unapply(memberUp);
        }

        public MemberUp(Member member) {
            this.member = member;
            MemberStatus memberStatus = member.status();
            MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
            if (memberStatus == null ? memberStatus$Up$ != null : !memberStatus.equals(memberStatus$Up$)) {
                throw new IllegalArgumentException(new StringBuilder(25).append("Expected Up status, got: ").append(member).toString());
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemberUp)) return false;
            MemberUp memberUp = (MemberUp)object;
            Member member = this.member();
            Member member2 = memberUp.member();
            if (member != null) {
                if (!((Object)member).equals(member2)) return false;
                return true;
            }
            if (member2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemberUp;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MemberUp";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public MemberUp copy(Member member) {
            return new MemberUp(member);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public Member _1() {
            return this.member();
        }
    }

    public static final class MemberWeaklyUp
    implements MemberEvent,
    Product,
    Serializable {
        private final Member member;

        public static MemberWeaklyUp apply(Member member) {
            return ClusterEvent$MemberWeaklyUp$.MODULE$.apply(member);
        }

        public static MemberWeaklyUp fromProduct(Product product) {
            return ClusterEvent$MemberWeaklyUp$.MODULE$.fromProduct(product);
        }

        public static MemberWeaklyUp unapply(MemberWeaklyUp memberWeaklyUp) {
            return ClusterEvent$MemberWeaklyUp$.MODULE$.unapply(memberWeaklyUp);
        }

        public MemberWeaklyUp(Member member) {
            this.member = member;
            MemberStatus memberStatus = member.status();
            MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
            if (memberStatus == null ? memberStatus$WeaklyUp$ != null : !memberStatus.equals(memberStatus$WeaklyUp$)) {
                throw new IllegalArgumentException(new StringBuilder(31).append("Expected WeaklyUp status, got: ").append(member).toString());
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MemberWeaklyUp)) return false;
            MemberWeaklyUp memberWeaklyUp = (MemberWeaklyUp)object;
            Member member = this.member();
            Member member2 = memberWeaklyUp.member();
            if (member != null) {
                if (!((Object)member).equals(member2)) return false;
                return true;
            }
            if (member2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MemberWeaklyUp;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MemberWeaklyUp";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public MemberWeaklyUp copy(Member member) {
            return new MemberWeaklyUp(member);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public Member _1() {
            return this.member();
        }
    }

    @InternalApi
    public static final class ReachabilityChanged
    implements ClusterDomainEvent,
    Product,
    Serializable {
        private final Reachability reachability;

        public static ReachabilityChanged apply(Reachability reachability) {
            return ClusterEvent$ReachabilityChanged$.MODULE$.apply(reachability);
        }

        public static ReachabilityChanged fromProduct(Product product) {
            return ClusterEvent$ReachabilityChanged$.MODULE$.fromProduct(product);
        }

        public static ReachabilityChanged unapply(ReachabilityChanged reachabilityChanged) {
            return ClusterEvent$ReachabilityChanged$.MODULE$.unapply(reachabilityChanged);
        }

        public ReachabilityChanged(Reachability reachability) {
            this.reachability = reachability;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReachabilityChanged)) return false;
            ReachabilityChanged reachabilityChanged = (ReachabilityChanged)object;
            Reachability reachability = this.reachability();
            Reachability reachability2 = reachabilityChanged.reachability();
            if (reachability != null) {
                if (!((Object)reachability).equals(reachability2)) return false;
                return true;
            }
            if (reachability2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReachabilityChanged;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ReachabilityChanged";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "reachability";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Reachability reachability() {
            return this.reachability;
        }

        public ReachabilityChanged copy(Reachability reachability) {
            return new ReachabilityChanged(reachability);
        }

        public Reachability copy$default$1() {
            return this.reachability();
        }

        public Reachability _1() {
            return this.reachability();
        }
    }

    public static interface ReachabilityEvent
    extends ClusterDomainEvent {
        public Member member();
    }

    public static final class ReachableDataCenter
    implements DataCenterReachabilityEvent,
    Product,
    Serializable {
        private final String dataCenter;

        public static ReachableDataCenter apply(String string) {
            return ClusterEvent$ReachableDataCenter$.MODULE$.apply(string);
        }

        public static ReachableDataCenter fromProduct(Product product) {
            return ClusterEvent$ReachableDataCenter$.MODULE$.fromProduct(product);
        }

        public static ReachableDataCenter unapply(ReachableDataCenter reachableDataCenter) {
            return ClusterEvent$ReachableDataCenter$.MODULE$.unapply(reachableDataCenter);
        }

        public ReachableDataCenter(String dataCenter) {
            this.dataCenter = dataCenter;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReachableDataCenter)) return false;
            ReachableDataCenter reachableDataCenter = (ReachableDataCenter)object;
            String string = this.dataCenter();
            String string2 = reachableDataCenter.dataCenter();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReachableDataCenter;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ReachableDataCenter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "dataCenter";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String dataCenter() {
            return this.dataCenter;
        }

        public ReachableDataCenter copy(String dataCenter) {
            return new ReachableDataCenter(dataCenter);
        }

        public String copy$default$1() {
            return this.dataCenter();
        }

        public String _1() {
            return this.dataCenter();
        }
    }

    public static final class ReachableMember
    implements ReachabilityEvent,
    Product,
    Serializable {
        private final Member member;

        public static ReachableMember apply(Member member) {
            return ClusterEvent$ReachableMember$.MODULE$.apply(member);
        }

        public static ReachableMember fromProduct(Product product) {
            return ClusterEvent$ReachableMember$.MODULE$.fromProduct(product);
        }

        public static ReachableMember unapply(ReachableMember reachableMember) {
            return ClusterEvent$ReachableMember$.MODULE$.unapply(reachableMember);
        }

        public ReachableMember(Member member) {
            this.member = member;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReachableMember)) return false;
            ReachableMember reachableMember = (ReachableMember)object;
            Member member = this.member();
            Member member2 = reachableMember.member();
            if (member != null) {
                if (!((Object)member).equals(member2)) return false;
                return true;
            }
            if (member2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReachableMember;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ReachableMember";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public ReachableMember copy(Member member) {
            return new ReachableMember(member);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public Member _1() {
            return this.member();
        }
    }

    public static final class RoleLeaderChanged
    implements ClusterDomainEvent,
    Product,
    Serializable {
        private final String role;
        private final Option leader;

        public static RoleLeaderChanged apply(String string, Option<Address> option) {
            return ClusterEvent$RoleLeaderChanged$.MODULE$.apply(string, option);
        }

        public static RoleLeaderChanged fromProduct(Product product) {
            return ClusterEvent$RoleLeaderChanged$.MODULE$.fromProduct(product);
        }

        public static RoleLeaderChanged unapply(RoleLeaderChanged roleLeaderChanged) {
            return ClusterEvent$RoleLeaderChanged$.MODULE$.unapply(roleLeaderChanged);
        }

        public RoleLeaderChanged(String role, Option<Address> leader) {
            this.role = role;
            this.leader = leader;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RoleLeaderChanged)) return false;
            RoleLeaderChanged roleLeaderChanged = (RoleLeaderChanged)object;
            String string = this.role();
            String string2 = roleLeaderChanged.role();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<Address> option = this.leader();
            Option<Address> option2 = roleLeaderChanged.leader();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RoleLeaderChanged;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RoleLeaderChanged";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "role";
            }
            if (1 == n2) {
                return "leader";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String role() {
            return this.role;
        }

        public Option<Address> leader() {
            return this.leader;
        }

        public Address getLeader() {
            return (Address)this.leader().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public RoleLeaderChanged copy(String role, Option<Address> leader) {
            return new RoleLeaderChanged(role, leader);
        }

        public String copy$default$1() {
            return this.role();
        }

        public Option<Address> copy$default$2() {
            return this.leader();
        }

        public String _1() {
            return this.role();
        }

        public Option<Address> _2() {
            return this.leader();
        }
    }

    @InternalApi
    public static final class SeenChanged
    implements ClusterDomainEvent,
    Product,
    Serializable {
        private final boolean convergence;
        private final scala.collection.immutable.Set seenBy;

        public static SeenChanged apply(boolean bl, scala.collection.immutable.Set<Address> set) {
            return ClusterEvent$SeenChanged$.MODULE$.apply(bl, set);
        }

        public static SeenChanged fromProduct(Product product) {
            return ClusterEvent$SeenChanged$.MODULE$.fromProduct(product);
        }

        public static SeenChanged unapply(SeenChanged seenChanged) {
            return ClusterEvent$SeenChanged$.MODULE$.unapply(seenChanged);
        }

        public SeenChanged(boolean convergence, scala.collection.immutable.Set<Address> seenBy) {
            this.convergence = convergence;
            this.seenBy = seenBy;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.convergence() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.seenBy()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SeenChanged)) return false;
            SeenChanged seenChanged = (SeenChanged)object;
            if (this.convergence() != seenChanged.convergence()) return false;
            scala.collection.immutable.Set<Address> set = this.seenBy();
            scala.collection.immutable.Set<Address> set2 = seenChanged.seenBy();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SeenChanged;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SeenChanged";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "convergence";
            }
            if (1 == n2) {
                return "seenBy";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean convergence() {
            return this.convergence;
        }

        public scala.collection.immutable.Set<Address> seenBy() {
            return this.seenBy;
        }

        public SeenChanged copy(boolean convergence, scala.collection.immutable.Set<Address> seenBy) {
            return new SeenChanged(convergence, seenBy);
        }

        public boolean copy$default$1() {
            return this.convergence();
        }

        public scala.collection.immutable.Set<Address> copy$default$2() {
            return this.seenBy();
        }

        public boolean _1() {
            return this.convergence();
        }

        public scala.collection.immutable.Set<Address> _2() {
            return this.seenBy();
        }
    }

    public static abstract class SubscriptionInitialStateMode {
    }

    public static final class UnreachableDataCenter
    implements DataCenterReachabilityEvent,
    Product,
    Serializable {
        private final String dataCenter;

        public static UnreachableDataCenter apply(String string) {
            return ClusterEvent$UnreachableDataCenter$.MODULE$.apply(string);
        }

        public static UnreachableDataCenter fromProduct(Product product) {
            return ClusterEvent$UnreachableDataCenter$.MODULE$.fromProduct(product);
        }

        public static UnreachableDataCenter unapply(UnreachableDataCenter unreachableDataCenter) {
            return ClusterEvent$UnreachableDataCenter$.MODULE$.unapply(unreachableDataCenter);
        }

        public UnreachableDataCenter(String dataCenter) {
            this.dataCenter = dataCenter;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnreachableDataCenter)) return false;
            UnreachableDataCenter unreachableDataCenter = (UnreachableDataCenter)object;
            String string = this.dataCenter();
            String string2 = unreachableDataCenter.dataCenter();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UnreachableDataCenter;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnreachableDataCenter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "dataCenter";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String dataCenter() {
            return this.dataCenter;
        }

        public UnreachableDataCenter copy(String dataCenter) {
            return new UnreachableDataCenter(dataCenter);
        }

        public String copy$default$1() {
            return this.dataCenter();
        }

        public String _1() {
            return this.dataCenter();
        }
    }

    public static final class UnreachableMember
    implements ReachabilityEvent,
    Product,
    Serializable {
        private final Member member;

        public static UnreachableMember apply(Member member) {
            return ClusterEvent$UnreachableMember$.MODULE$.apply(member);
        }

        public static UnreachableMember fromProduct(Product product) {
            return ClusterEvent$UnreachableMember$.MODULE$.fromProduct(product);
        }

        public static UnreachableMember unapply(UnreachableMember unreachableMember) {
            return ClusterEvent$UnreachableMember$.MODULE$.unapply(unreachableMember);
        }

        public UnreachableMember(Member member) {
            this.member = member;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnreachableMember)) return false;
            UnreachableMember unreachableMember = (UnreachableMember)object;
            Member member = this.member();
            Member member2 = unreachableMember.member();
            if (member != null) {
                if (!((Object)member).equals(member2)) return false;
                return true;
            }
            if (member2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UnreachableMember;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnreachableMember";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "member";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Member member() {
            return this.member;
        }

        public UnreachableMember copy(Member member) {
            return new UnreachableMember(member);
        }

        public Member copy$default$1() {
            return this.member();
        }

        public Member _1() {
            return this.member();
        }
    }
}

