/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.AddressFromURIString$;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.ClusterNodeMBean;
import org.apache.pekko.cluster.ClusterReadView;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.event.LoggingAdapter;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.LambdaDeserialize;

public class ClusterJmx {
    public final Cluster org$apache$pekko$cluster$ClusterJmx$$cluster;
    private final LoggingAdapter log;
    private final MBeanServer mBeanServer;
    private final ObjectName clusterMBeanName;

    public ClusterJmx(Cluster cluster, LoggingAdapter log) {
        this.org$apache$pekko$cluster$ClusterJmx$$cluster = cluster;
        this.log = log;
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.clusterMBeanName = cluster.settings().JmxMultiMbeansInSameEnabled() ? new ObjectName(new StringBuilder(24).append("pekko:type=Cluster,port=").append(cluster.selfUniqueAddress().address().port().getOrElse(ClusterJmx::$init$$$anonfun$1)).toString()) : new ObjectName("pekko:type=Cluster");
    }

    public ClusterReadView org$apache$pekko$cluster$ClusterJmx$$clusterView() {
        return this.org$apache$pekko$cluster$ClusterJmx$$cluster.readView();
    }

    public void createMBean() {
        block3: {
            ClusterNodeMBean mbean = new ClusterNodeMBean(this){
                private final /* synthetic */ ClusterJmx $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(ClusterNodeMBean.class);
                }

                public String getClusterStatus() {
                    String members = ((IterableOnceOps)((IterableOps)this.$outer.org$apache$pekko$cluster$ClusterJmx$$clusterView().members().toSeq().sorted(Member$.MODULE$.ordering())).map(ClusterJmx::org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$_$$anonfun$1)).mkString(",\n    ");
                    String unreachable = ((IterableOnceOps)((IterableOps)this.$outer.org$apache$pekko$cluster$ClusterJmx$$clusterView().reachability().observersGroupedByUnreachable().toSeq().sortBy(ClusterJmx::org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$_$$anonfun$2, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map(ClusterJmx::org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$_$$anonfun$3)).mkString(",\n    ");
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(108).append("{\n        |  \"members\": [").append(members.isEmpty() ? "" : new StringBuilder(8).append("\n    ").append(members).append("\n  ").toString()).append("],\n        |  \"self-address\": \"").append(this.$outer.org$apache$pekko$cluster$ClusterJmx$$clusterView().selfAddress()).append("\",\n        |  \"unreachable\": [").append(unreachable.isEmpty() ? "" : new StringBuilder(8).append("\n    ").append(unreachable).append("\n  ").toString()).append("]\n        |}\n        |").toString()));
                }

                public String getMembers() {
                    return ((IterableOnceOps)this.$outer.org$apache$pekko$cluster$ClusterJmx$$clusterView().members().toSeq().map(ClusterJmx::org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getMembers$$anonfun$1)).mkString(",");
                }

                public String getUnreachable() {
                    return ((IterableOnceOps)this.$outer.org$apache$pekko$cluster$ClusterJmx$$clusterView().unreachableMembers().map(ClusterJmx::org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getUnreachable$$anonfun$1)).mkString(",");
                }

                public String getMemberStatus() {
                    return this.$outer.org$apache$pekko$cluster$ClusterJmx$$clusterView().status().toString();
                }

                public String getLeader() {
                    return (String)this.$outer.org$apache$pekko$cluster$ClusterJmx$$clusterView().leader().fold(ClusterJmx::org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getLeader$$anonfun$1, ClusterJmx::org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getLeader$$anonfun$2);
                }

                public boolean isSingleton() {
                    return this.$outer.org$apache$pekko$cluster$ClusterJmx$$clusterView().isSingletonCluster();
                }

                public boolean isAvailable() {
                    return this.$outer.org$apache$pekko$cluster$ClusterJmx$$clusterView().isAvailable();
                }

                public void join(String address) {
                    this.$outer.org$apache$pekko$cluster$ClusterJmx$$cluster.join(AddressFromURIString$.MODULE$.apply(address));
                }

                public void leave(String address) {
                    this.$outer.org$apache$pekko$cluster$ClusterJmx$$cluster.leave(AddressFromURIString$.MODULE$.apply(address));
                }

                public void down(String address) {
                    this.$outer.org$apache$pekko$cluster$ClusterJmx$$cluster.down(AddressFromURIString$.MODULE$.apply(address));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$_$$anonfun$1(org.apache.pekko.cluster.Member ), org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$_$$anonfun$2(scala.Tuple2 ), org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$_$$anonfun$3(scala.Tuple2 ), org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getMembers$$anonfun$1(org.apache.pekko.cluster.Member ), org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getUnreachable$$anonfun$1(org.apache.pekko.cluster.Member ), org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getLeader$$anonfun$1(), org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getLeader$$anonfun$2(org.apache.pekko.actor.Address )}, serializedLambda);
                }
            };
            try {
                this.mBeanServer.registerMBean(mbean, this.clusterMBeanName);
                this.org$apache$pekko$cluster$ClusterJmx$$cluster.ClusterLogger().logInfo("Registered cluster JMX MBean [{}]", this.clusterMBeanName);
            }
            catch (InstanceAlreadyExistsException e) {
                if (this.org$apache$pekko$cluster$ClusterJmx$$cluster.settings().JmxMultiMbeansInSameEnabled()) {
                    this.log.error((Throwable)e, new StringBuilder(47).append("Failed to register Cluster JMX MBean with name=").append(this.clusterMBeanName).toString());
                    break block3;
                }
                this.log.warning(new StringBuilder(194).append("Could not register Cluster JMX MBean with name=").append(this.clusterMBeanName).append(" as it is already registered. ").append("If you are running multiple clusters in the same JVM, set 'pekko.cluster.jmx.multi-mbeans-in-same-jvm = on' in config").toString());
            }
        }
    }

    public void unregisterMBean() {
        block3: {
            try {
                this.mBeanServer.unregisterMBean(this.clusterMBeanName);
            }
            catch (InstanceNotFoundException e) {
                if (this.org$apache$pekko$cluster$ClusterJmx$$cluster.settings().JmxMultiMbeansInSameEnabled()) {
                    this.log.error((Throwable)e, new StringBuilder(49).append("Failed to unregister Cluster JMX MBean with name=").append(this.clusterMBeanName).toString());
                    break block3;
                }
                this.log.warning(new StringBuilder(188).append("Could not unregister Cluster JMX MBean with name=").append(this.clusterMBeanName).append(" as it was not found. ").append("If you are running multiple clusters in the same JVM, set 'pekko.cluster.jmx.multi-mbeans-in-same-jvm = on' in config").toString());
            }
        }
    }

    private static final Object $init$$$anonfun$1() {
        return "";
    }

    public static final /* synthetic */ String org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$_$$anonfun$1(Member m) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(166).append("{\n              |      \"address\": \"").append(m.address()).append("\",\n              |      \"roles\": [").append(m.roles().isEmpty() ? "" : ((List)m.roles().toList().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)_$1 -> new StringBuilder(2).append("\"").append((String)_$1).append("\"").toString()).mkString("\n        ", ",\n        ", "\n      ")).append("],\n              |      \"status\": \"").append(m.status()).append("\",\n              |      \"app-version\": \"").append(m.appVersion()).append("\"\n              |    }").toString()));
    }

    public static final /* synthetic */ UniqueAddress org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$_$$anonfun$2(Tuple2 _$2) {
        return (UniqueAddress)_$2._1();
    }

    public static final /* synthetic */ String org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$_$$anonfun$3(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            UniqueAddress subject = (UniqueAddress)tuple2._1();
            Set observers = (Set)tuple2._2();
            Seq observerAddresses = (Seq)((IterableOps)observers.toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)_$3 -> new StringBuilder(2).append("\"").append(_$3.address()).append("\"").toString());
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(94).append("{\n              |      \"node\": \"").append(subject.address()).append("\",\n              |      \"observed-by\": [").append(observerAddresses.isEmpty() ? "" : observerAddresses.mkString("\n        ", ",\n        ", "\n      ")).append("]\n              |    }").toString()));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Address org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getMembers$$anonfun$1(Member _$4) {
        return _$4.address();
    }

    public static final /* synthetic */ Address org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getUnreachable$$anonfun$1(Member _$5) {
        return _$5.address();
    }

    public static final String org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getLeader$$anonfun$1() {
        return "";
    }

    public static final /* synthetic */ String org$apache$pekko$cluster$ClusterJmx$$anon$1$$_$getLeader$$anonfun$2(Address _$6) {
        return _$6.toString();
    }
}

