/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.PoisonPill$;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$ClusterShuttingDown$;
import org.apache.pekko.cluster.ClusterEvent$CurrentClusterState$;
import org.apache.pekko.cluster.ClusterEvent$CurrentInternalStats$;
import org.apache.pekko.cluster.ClusterEvent$LeaderChanged$;
import org.apache.pekko.cluster.ClusterEvent$MemberRemoved$;
import org.apache.pekko.cluster.ClusterEvent$MemberTombstonesChanged$;
import org.apache.pekko.cluster.ClusterEvent$ReachabilityChanged$;
import org.apache.pekko.cluster.ClusterEvent$ReachableMember$;
import org.apache.pekko.cluster.ClusterEvent$RoleLeaderChanged$;
import org.apache.pekko.cluster.ClusterEvent$SeenChanged$;
import org.apache.pekko.cluster.ClusterEvent$UnreachableMember$;
import org.apache.pekko.cluster.ClusterReadView$;
import org.apache.pekko.cluster.ClusterReadView$State$;
import org.apache.pekko.cluster.GossipStats$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.MemberStatus$Removed$;
import org.apache.pekko.cluster.Reachability;
import org.apache.pekko.cluster.Reachability$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.VectorClockStats$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public class ClusterReadView
implements Closeable {
    public final Cluster org$apache$pekko$cluster$ClusterReadView$$cluster;
    public final AtomicReference<State> org$apache$pekko$cluster$ClusterReadView$$_state;
    private final Address selfAddress;
    private final ActorRef eventBusListener;

    public ClusterReadView(Cluster cluster) {
        this.org$apache$pekko$cluster$ClusterReadView$$cluster = cluster;
        this.org$apache$pekko$cluster$ClusterReadView$$_state = new AtomicReference<State>(ClusterReadView$State$.MODULE$.apply(ClusterEvent$CurrentClusterState$.MODULE$.apply(ClusterEvent$CurrentClusterState$.MODULE$.apply$default$1(), ClusterEvent$CurrentClusterState$.MODULE$.apply$default$2(), ClusterEvent$CurrentClusterState$.MODULE$.apply$default$3(), ClusterEvent$CurrentClusterState$.MODULE$.apply$default$4(), ClusterEvent$CurrentClusterState$.MODULE$.apply$default$5()), Reachability$.MODULE$.empty(), Member$.MODULE$.apply(cluster.selfUniqueAddress(), cluster.selfRoles(), cluster.settings().AppVersion()).copy(MemberStatus$Removed$.MODULE$), ClusterEvent$CurrentInternalStats$.MODULE$.apply(GossipStats$.MODULE$.apply(GossipStats$.MODULE$.$lessinit$greater$default$1(), GossipStats$.MODULE$.$lessinit$greater$default$2(), GossipStats$.MODULE$.$lessinit$greater$default$3(), GossipStats$.MODULE$.$lessinit$greater$default$4(), GossipStats$.MODULE$.$lessinit$greater$default$5()), VectorClockStats$.MODULE$.apply(VectorClockStats$.MODULE$.$lessinit$greater$default$1(), VectorClockStats$.MODULE$.$lessinit$greater$default$2()))));
        this.selfAddress = cluster.selfAddress();
        this.eventBusListener = cluster.system().systemActorOf(Props$.MODULE$.apply(this::$init$$$anonfun$1, ClassTag$.MODULE$.apply(Actor.class)).withDispatcher(cluster.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "clusterEventBusListener");
    }

    public Address selfAddress() {
        return this.selfAddress;
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.org$apache$pekko$cluster$ClusterReadView$$_state.get().clusterState();
    }

    public Member self() {
        return this.org$apache$pekko$cluster$ClusterReadView$$_state.get().selfMember();
    }

    public boolean isTerminated() {
        return this.org$apache$pekko$cluster$ClusterReadView$$cluster.isTerminated();
    }

    public SortedSet<Member> members() {
        return this.org$apache$pekko$cluster$ClusterReadView$$_state.get().clusterState().members();
    }

    public Set<Member> unreachableMembers() {
        return this.org$apache$pekko$cluster$ClusterReadView$$_state.get().clusterState().unreachable();
    }

    public MemberStatus status() {
        return this.self().status();
    }

    public boolean isLeader() {
        return this.leader().contains((Object)this.selfAddress());
    }

    public Option<Address> leader() {
        return this.org$apache$pekko$cluster$ClusterReadView$$_state.get().clusterState().leader();
    }

    public boolean isSingletonCluster() {
        return this.members().size() == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable() {
        Member myself = this.self();
        if (this.unreachableMembers().contains((Object)myself)) return false;
        MemberStatus memberStatus = myself.status();
        MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
        if (memberStatus == null) {
            if (memberStatus$Down$ == null) return false;
        } else if (memberStatus.equals(memberStatus$Down$)) return false;
        MemberStatus memberStatus2 = myself.status();
        MemberStatus$Removed$ memberStatus$Removed$ = MemberStatus$Removed$.MODULE$;
        if (memberStatus2 == null) {
            if (memberStatus$Removed$ == null) return false;
            return true;
        } else if (memberStatus2.equals(memberStatus$Removed$)) return false;
        return true;
    }

    public Reachability reachability() {
        return this.org$apache$pekko$cluster$ClusterReadView$$_state.get().reachability();
    }

    public Set<Address> seenBy() {
        return this.org$apache$pekko$cluster$ClusterReadView$$_state.get().clusterState().seenBy();
    }

    public ClusterEvent.CurrentInternalStats latestStats() {
        return this.org$apache$pekko$cluster$ClusterReadView$$_state.get().latestStats();
    }

    public void org$apache$pekko$cluster$ClusterReadView$$logInfoVerbose(ClusterEvent.ClusterDomainEvent event) {
        if (this.org$apache$pekko$cluster$ClusterReadView$$cluster.settings().LogInfoVerbose()) {
            ClusterEvent.ClusterDomainEvent clusterDomainEvent = event;
            if (clusterDomainEvent instanceof ClusterEvent.SeenChanged || clusterDomainEvent instanceof ClusterEvent.CurrentInternalStats) {
                return;
            }
            if (clusterDomainEvent instanceof ClusterEvent.UnreachableMember) {
                ClusterEvent.CurrentClusterState s = this.state();
                this.org$apache$pekko$cluster$ClusterReadView$$cluster.ClusterLogger().logInfo("event {}, {} unreachable members [{}]", event, (Object)BoxesRunTime.boxToInteger((int)s.unreachable().size()), (Object)s.unreachable().mkString(", "));
                return;
            }
            if (clusterDomainEvent instanceof ClusterEvent.ReachableMember) {
                ClusterEvent.CurrentClusterState s = this.state();
                this.org$apache$pekko$cluster$ClusterReadView$$cluster.ClusterLogger().logInfo("event {}, {} unreachable members [{}]", event, (Object)BoxesRunTime.boxToInteger((int)s.unreachable().size()), (Object)s.unreachable().mkString(", "));
                return;
            }
            if (clusterDomainEvent instanceof ClusterEvent.MemberUp) {
                ClusterEvent.CurrentClusterState s = this.state();
                this.org$apache$pekko$cluster$ClusterReadView$$cluster.ClusterLogger().logInfo("event {}, {} members [{}]", event, (Object)BoxesRunTime.boxToInteger((int)s.members().size()), (Object)s.members().mkString(", "));
                return;
            }
            if (clusterDomainEvent instanceof ClusterEvent.MemberRemoved && !this.org$apache$pekko$cluster$ClusterReadView$$cluster.isTerminated()) {
                ClusterEvent.CurrentClusterState s = this.state();
                this.org$apache$pekko$cluster$ClusterReadView$$cluster.ClusterLogger().logInfo("event {}, {} members [{}]", event, (Object)BoxesRunTime.boxToInteger((int)s.members().size()), (Object)s.members().mkString(", "));
                return;
            }
            if (clusterDomainEvent instanceof ClusterEvent.MemberTombstonesChanged) {
                Set<UniqueAddress> set;
                ClusterEvent.MemberTombstonesChanged memberTombstonesChanged = ClusterEvent$MemberTombstonesChanged$.MODULE$.unapply((ClusterEvent.MemberTombstonesChanged)clusterDomainEvent);
                Set<UniqueAddress> tombstones = set = memberTombstonesChanged._1();
                this.org$apache$pekko$cluster$ClusterReadView$$cluster.ClusterLogger().logInfo("event MemberTombstonesChanged({})", BoxesRunTime.boxToInteger((int)tombstones.size()));
                return;
            }
            this.org$apache$pekko$cluster$ClusterReadView$$cluster.ClusterLogger().logInfo("event {}", event);
            return;
        }
    }

    @Override
    public void close() {
        if (!this.eventBusListener.isTerminated()) {
            this.eventBusListener.$bang((Object)PoisonPill$.MODULE$, this.eventBusListener.$bang$default$2((Object)PoisonPill$.MODULE$));
            return;
        }
    }

    public static final Member org$apache$pekko$cluster$ClusterReadView$$anon$2$$_$_$$anonfun$2(State oldState$1) {
        return oldState$1.selfMember();
    }

    private final Actor $init$$$anonfun$1() {
        return new Actor(this){
            private ActorContext context;
            private ActorRef self;
            private final /* synthetic */ ClusterReadView $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Actor.$init$((Actor)this);
                Statics.releaseFence();
            }

            public ActorContext context() {
                return this.context;
            }

            public final ActorRef self() {
                return this.self;
            }

            public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
                this.context = x$0;
            }

            public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
                this.self = x$0;
            }

            public void preStart() {
                this.$outer.org$apache$pekko$cluster$ClusterReadView$$cluster.subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.ClusterDomainEvent.class}));
            }

            public void postStop() {
                this.org$apache$pekko$cluster$ClusterReadView$$anon$1$$selfRemoved();
            }

            public void org$apache$pekko$cluster$ClusterReadView$$anon$1$$selfRemoved() {
                State oldState = this.$outer.org$apache$pekko$cluster$ClusterReadView$$_state.get();
                State newState = oldState.copy(ClusterEvent$CurrentClusterState$.MODULE$.apply(ClusterEvent$CurrentClusterState$.MODULE$.apply$default$1(), ClusterEvent$CurrentClusterState$.MODULE$.apply$default$2(), ClusterEvent$CurrentClusterState$.MODULE$.apply$default$3(), ClusterEvent$CurrentClusterState$.MODULE$.apply$default$4(), ClusterEvent$CurrentClusterState$.MODULE$.apply$default$5()), Reachability$.MODULE$.empty(), oldState.selfMember().copy(MemberStatus$Removed$.MODULE$), oldState.copy$default$4());
                this.$outer.org$apache$pekko$cluster$ClusterReadView$$_state.set(newState);
            }

            public PartialFunction receive() {
                return new Serializable(this){
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Object x) {
                        Object object = x;
                        if (object instanceof ClusterEvent.ClusterDomainEvent) {
                            ClusterEvent.ClusterDomainEvent e = (ClusterEvent.ClusterDomainEvent)object;
                            return true;
                        }
                        if (object instanceof ClusterEvent.CurrentClusterState) {
                            ClusterEvent.CurrentClusterState s = (ClusterEvent.CurrentClusterState)object;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        Object object = x;
                        if (object instanceof ClusterEvent.ClusterDomainEvent) {
                            ClusterEvent.ClusterDomainEvent e = (ClusterEvent.ClusterDomainEvent)object;
                            State oldState = this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.get();
                            ClusterEvent.CurrentClusterState oldClusterState = oldState.clusterState();
                            ClusterEvent.ClusterDomainEvent clusterDomainEvent = e;
                            if (clusterDomainEvent instanceof ClusterEvent.SeenChanged) {
                                Set<Address> set;
                                ClusterEvent.SeenChanged seenChanged = ClusterEvent$SeenChanged$.MODULE$.unapply((ClusterEvent.SeenChanged)clusterDomainEvent);
                                boolean bl = seenChanged._1();
                                Set<Address> seenBy = set = seenChanged._2();
                                this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldClusterState.copy(oldClusterState.copy$default$1(), oldClusterState.copy$default$2(), seenBy, oldClusterState.copy$default$4(), oldClusterState.copy$default$5()), oldState.copy$default$2(), oldState.copy$default$3(), oldState.copy$default$4()));
                            } else if (clusterDomainEvent instanceof ClusterEvent.ReachabilityChanged) {
                                Reachability reachability;
                                ClusterEvent.ReachabilityChanged reachabilityChanged = ClusterEvent$ReachabilityChanged$.MODULE$.unapply((ClusterEvent.ReachabilityChanged)clusterDomainEvent);
                                Reachability reachability2 = reachability = reachabilityChanged._1();
                                this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldState.copy$default$1(), reachability2, oldState.copy$default$3(), oldState.copy$default$4()));
                            } else if (clusterDomainEvent instanceof ClusterEvent.MemberRemoved) {
                                ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)clusterDomainEvent);
                                Member member = memberRemoved._1();
                                MemberStatus memberStatus = memberRemoved._2();
                                Member member2 = member;
                                Address address = member2.address();
                                Address address2 = this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().selfAddress();
                                if (!(address != null ? !address.equals(address2) : address2 != null)) {
                                    this.$outer.org$apache$pekko$cluster$ClusterReadView$$anon$1$$selfRemoved();
                                } else {
                                    Member member3 = member;
                                    this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldClusterState.copy((SortedSet<Member>)((SortedSet)oldClusterState.members().$minus((Object)member3)), (Set<Member>)((Set)oldClusterState.unreachable().$minus((Object)member3)), oldClusterState.copy$default$3(), oldClusterState.copy$default$4(), oldClusterState.copy$default$5()), oldState.copy$default$2(), oldState.copy$default$3(), oldState.copy$default$4()));
                                }
                            } else if (clusterDomainEvent instanceof ClusterEvent.UnreachableMember) {
                                Member member;
                                ClusterEvent.UnreachableMember unreachableMember = ClusterEvent$UnreachableMember$.MODULE$.unapply((ClusterEvent.UnreachableMember)clusterDomainEvent);
                                Member member4 = member = unreachableMember._1();
                                Set set = (Set)oldClusterState.unreachable().$minus((Object)member4).$plus((Object)member4);
                                SortedSet<Member> sortedSet = oldClusterState.copy$default$1();
                                Set<Address> set2 = oldClusterState.copy$default$3();
                                Option<Address> option = oldClusterState.copy$default$4();
                                Map<String, Option<Address>> map = oldClusterState.copy$default$5();
                                this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldClusterState.copy(sortedSet, (Set<Member>)set, set2, option, map), oldState.copy$default$2(), oldState.copy$default$3(), oldState.copy$default$4()));
                            } else if (clusterDomainEvent instanceof ClusterEvent.ReachableMember) {
                                Member member;
                                ClusterEvent.ReachableMember reachableMember = ClusterEvent$ReachableMember$.MODULE$.unapply((ClusterEvent.ReachableMember)clusterDomainEvent);
                                Member member5 = member = reachableMember._1();
                                Set set = (Set)oldClusterState.unreachable().$minus((Object)member5);
                                SortedSet<Member> sortedSet = oldClusterState.copy$default$1();
                                Set<Address> set3 = oldClusterState.copy$default$3();
                                Option<Address> option = oldClusterState.copy$default$4();
                                Map<String, Option<Address>> map = oldClusterState.copy$default$5();
                                this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldClusterState.copy(sortedSet, (Set<Member>)set, set3, option, map), oldState.copy$default$2(), oldState.copy$default$3(), oldState.copy$default$4()));
                            } else if (clusterDomainEvent instanceof ClusterEvent.MemberEvent) {
                                ClusterEvent.MemberEvent event = (ClusterEvent.MemberEvent)clusterDomainEvent;
                                Member member = event.member();
                                Set newUnreachable = oldClusterState.unreachable().contains((Object)member) ? (Set)oldClusterState.unreachable().$minus((Object)member).$plus((Object)member) : oldClusterState.unreachable();
                                Address address = member.address();
                                Address address3 = this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().selfAddress();
                                Member newSelfMember = !(address != null ? !address.equals(address3) : address3 != null) ? member : oldState.selfMember();
                                ClusterEvent.CurrentClusterState currentClusterState = oldClusterState.copy((SortedSet<Member>)((SortedSet)oldClusterState.members().$minus((Object)member).$plus((Object)member)), (Set<Member>)newUnreachable, oldClusterState.copy$default$3(), oldClusterState.copy$default$4(), oldClusterState.copy$default$5());
                                Reachability reachability = oldState.copy$default$2();
                                ClusterEvent.CurrentInternalStats currentInternalStats = oldState.copy$default$4();
                                this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(currentClusterState, reachability, newSelfMember, currentInternalStats));
                            } else if (clusterDomainEvent instanceof ClusterEvent.LeaderChanged) {
                                Option<Address> option;
                                ClusterEvent.LeaderChanged leaderChanged = ClusterEvent$LeaderChanged$.MODULE$.unapply((ClusterEvent.LeaderChanged)clusterDomainEvent);
                                Option<Address> leader = option = leaderChanged._1();
                                this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldClusterState.copy(oldClusterState.copy$default$1(), oldClusterState.copy$default$2(), oldClusterState.copy$default$3(), leader, oldClusterState.copy$default$5()), oldState.copy$default$2(), oldState.copy$default$3(), oldState.copy$default$4()));
                            } else if (clusterDomainEvent instanceof ClusterEvent.RoleLeaderChanged) {
                                ClusterEvent.RoleLeaderChanged roleLeaderChanged = ClusterEvent$RoleLeaderChanged$.MODULE$.unapply((ClusterEvent.RoleLeaderChanged)clusterDomainEvent);
                                String string = roleLeaderChanged._1();
                                Option<Address> option = roleLeaderChanged._2();
                                String role = string;
                                Option<Address> leader = option;
                                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)role);
                                Map map = (Map)oldClusterState.roleLeaderMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, leader));
                                SortedSet<Member> sortedSet = oldClusterState.copy$default$1();
                                Set<Member> set = oldClusterState.copy$default$2();
                                Set<Address> set4 = oldClusterState.copy$default$3();
                                Option<Address> option2 = oldClusterState.copy$default$4();
                                this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldClusterState.copy(sortedSet, set, set4, option2, (Map<String, Option<Address>>)map), oldState.copy$default$2(), oldState.copy$default$3(), oldState.copy$default$4()));
                            } else if (clusterDomainEvent instanceof ClusterEvent.CurrentInternalStats) {
                                ClusterEvent.CurrentInternalStats stats = (ClusterEvent.CurrentInternalStats)clusterDomainEvent;
                                this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldState.copy$default$1(), oldState.copy$default$2(), oldState.copy$default$3(), stats));
                            } else if (!ClusterEvent$ClusterShuttingDown$.MODULE$.equals(clusterDomainEvent)) {
                                if (clusterDomainEvent instanceof ClusterEvent.ReachableDataCenter) {
                                    ClusterEvent.ReachableDataCenter r = (ClusterEvent.ReachableDataCenter)clusterDomainEvent;
                                    this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldClusterState.withUnreachableDataCenters((Set<String>)((Set)oldClusterState.unreachableDataCenters().$minus((Object)r.dataCenter()))), oldState.copy$default$2(), oldState.copy$default$3(), oldState.copy$default$4()));
                                } else if (clusterDomainEvent instanceof ClusterEvent.UnreachableDataCenter) {
                                    ClusterEvent.UnreachableDataCenter r = (ClusterEvent.UnreachableDataCenter)clusterDomainEvent;
                                    this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldClusterState.withUnreachableDataCenters((Set<String>)((Set)oldClusterState.unreachableDataCenters().$plus((Object)r.dataCenter()))), oldState.copy$default$2(), oldState.copy$default$3(), oldState.copy$default$4()));
                                } else if (clusterDomainEvent instanceof ClusterEvent.MemberTombstonesChanged) {
                                    Set<UniqueAddress> set;
                                    ClusterEvent.MemberTombstonesChanged memberTombstonesChanged = ClusterEvent$MemberTombstonesChanged$.MODULE$.unapply((ClusterEvent.MemberTombstonesChanged)clusterDomainEvent);
                                    Set<UniqueAddress> tombstones = set = memberTombstonesChanged._1();
                                    this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(oldClusterState.withMemberTombstones(tombstones), oldState.copy$default$2(), oldState.copy$default$3(), oldState.copy$default$4()));
                                } else {
                                    ClusterEvent.ClusterDomainEvent unexpected = clusterDomainEvent;
                                    throw new IllegalArgumentException(new StringBuilder(30).append("Unexpected cluster event type ").append(unexpected.getClass()).toString());
                                }
                            }
                            this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$logInfoVerbose(e);
                            return BoxedUnit.UNIT;
                        }
                        if (object instanceof ClusterEvent.CurrentClusterState) {
                            ClusterEvent.CurrentClusterState s = (ClusterEvent.CurrentClusterState)object;
                            State oldState = this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.get();
                            Member newSelfMember = (Member)s.members().find((Function1 & Serializable)_$1 -> {
                                UniqueAddress uniqueAddress = _$1.uniqueAddress();
                                UniqueAddress uniqueAddress2 = this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$cluster.selfUniqueAddress();
                                return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
                            }).getOrElse(() -> ClusterReadView.org$apache$pekko$cluster$ClusterReadView$$anon$2$$_$_$$anonfun$2(oldState));
                            this.$outer.org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer().org$apache$pekko$cluster$ClusterReadView$$_state.set(oldState.copy(s, oldState.copy$default$2(), newSelfMember, oldState.copy$default$4()));
                            return BoxedUnit.UNIT;
                        }
                        return function1.apply(x);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$1(org.apache.pekko.cluster.Member ), org$apache$pekko$cluster$ClusterReadView$$anon$2$$_$_$$anonfun$2(org.apache.pekko.cluster.ClusterReadView$State )}, serializedLambda);
                    }
                };
            }

            public final /* synthetic */ ClusterReadView org$apache$pekko$cluster$ClusterReadView$_$_$$anon$$$outer() {
                return this.$outer;
            }
        };
    }

    public static final class State
    implements Product,
    Serializable {
        private final ClusterEvent.CurrentClusterState clusterState;
        private final Reachability reachability;
        private final Member selfMember;
        private final ClusterEvent.CurrentInternalStats latestStats;

        public static State apply(ClusterEvent.CurrentClusterState currentClusterState, Reachability reachability, Member member, ClusterEvent.CurrentInternalStats currentInternalStats) {
            return ClusterReadView$State$.MODULE$.apply(currentClusterState, reachability, member, currentInternalStats);
        }

        public static State fromProduct(Product product) {
            return ClusterReadView$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return ClusterReadView$State$.MODULE$.unapply(state);
        }

        public State(ClusterEvent.CurrentClusterState clusterState, Reachability reachability, Member selfMember, ClusterEvent.CurrentInternalStats latestStats) {
            this.clusterState = clusterState;
            this.reachability = reachability;
            this.selfMember = selfMember;
            this.latestStats = latestStats;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            ClusterEvent.CurrentClusterState currentClusterState = this.clusterState();
            ClusterEvent.CurrentClusterState currentClusterState2 = state.clusterState();
            if (currentClusterState == null) {
                if (currentClusterState2 != null) {
                    return false;
                }
            } else if (!((Object)currentClusterState).equals(currentClusterState2)) return false;
            Reachability reachability = this.reachability();
            Reachability reachability2 = state.reachability();
            if (reachability == null) {
                if (reachability2 != null) {
                    return false;
                }
            } else if (!((Object)reachability).equals(reachability2)) return false;
            Member member = this.selfMember();
            Member member2 = state.selfMember();
            if (member == null) {
                if (member2 != null) {
                    return false;
                }
            } else if (!((Object)member).equals(member2)) return false;
            ClusterEvent.CurrentInternalStats currentInternalStats = this.latestStats();
            ClusterEvent.CurrentInternalStats currentInternalStats2 = state.latestStats();
            if (currentInternalStats == null) {
                if (currentInternalStats2 == null) return true;
                return false;
            } else {
                if (!((Object)currentInternalStats).equals(currentInternalStats2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "clusterState";
                }
                case 1: {
                    return "reachability";
                }
                case 2: {
                    return "selfMember";
                }
                case 3: {
                    return "latestStats";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ClusterEvent.CurrentClusterState clusterState() {
            return this.clusterState;
        }

        public Reachability reachability() {
            return this.reachability;
        }

        public Member selfMember() {
            return this.selfMember;
        }

        public ClusterEvent.CurrentInternalStats latestStats() {
            return this.latestStats;
        }

        public State copy(ClusterEvent.CurrentClusterState clusterState, Reachability reachability, Member selfMember, ClusterEvent.CurrentInternalStats latestStats) {
            return new State(clusterState, reachability, selfMember, latestStats);
        }

        public ClusterEvent.CurrentClusterState copy$default$1() {
            return this.clusterState();
        }

        public Reachability copy$default$2() {
            return this.reachability();
        }

        public Member copy$default$3() {
            return this.selfMember();
        }

        public ClusterEvent.CurrentInternalStats copy$default$4() {
            return this.latestStats();
        }

        public ClusterEvent.CurrentClusterState _1() {
            return this.clusterState();
        }

        public Reachability _2() {
            return this.reachability();
        }

        public Member _3() {
            return this.selfMember();
        }

        public ClusterEvent.CurrentInternalStats _4() {
            return this.latestStats();
        }
    }
}

