/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.TimerSchedulerImpl;
import org.apache.pekko.actor.Timers;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$MemberJoined$;
import org.apache.pekko.cluster.ClusterEvent$MemberRemoved$;
import org.apache.pekko.cluster.ClusterEvent$MemberTombstonesChanged$;
import org.apache.pekko.cluster.ClusterEvent$MemberUp$;
import org.apache.pekko.cluster.ClusterEvent$MemberWeaklyUp$;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterRemoteWatcher$;
import org.apache.pekko.cluster.ClusterRemoteWatcher$DelayedQuarantine$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification$;
import org.apache.pekko.dispatch.sysmsg.SystemMessage;
import org.apache.pekko.event.ActorWithLogClass$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.remote.RemoteWatcher;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class ClusterRemoteWatcher
extends RemoteWatcher
implements Timers,
Actor {
    private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;
    private final boolean arteryEnabled;
    private final Cluster cluster;
    private final LoggingAdapter log;
    private final Set<String> watchPathAllowList;
    private Set<UniqueAddress> pendingDelayedQuarantine;
    private Set clusterNodes;
    private Set memberTombstones;

    public static Props props(FailureDetectorRegistry<Address> failureDetectorRegistry, RemoteSettings remoteSettings) {
        return ClusterRemoteWatcher$.MODULE$.props(failureDetectorRegistry, remoteSettings);
    }

    public ClusterRemoteWatcher(FailureDetectorRegistry<Address> failureDetector, FiniteDuration heartbeatInterval, FiniteDuration unreachableReaperInterval, FiniteDuration heartbeatExpectedResponseAfter) {
        super(failureDetector, heartbeatInterval, unreachableReaperInterval, heartbeatExpectedResponseAfter);
        Timers.$init$((Timers)this);
        this.arteryEnabled = ((RARP)RARP$.MODULE$.apply(this.context().system())).provider().remoteSettings().Artery().Enabled();
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.log = Logging$.MODULE$.apply(this.context().system(), (Object)ActorWithLogClass$.MODULE$.apply((Actor)this, ClusterLogClass$.MODULE$.ClusterCore()), LogSource$.MODULE$.fromActorWithLoggerClass());
        this.watchPathAllowList = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/system/sharding/"}));
        this.pendingDelayedQuarantine = Predef$.MODULE$.Set().empty();
        this.clusterNodes = Predef$.MODULE$.Set().empty();
        this.memberTombstones = Predef$.MODULE$.Set().empty();
        Statics.releaseFence();
    }

    public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
        return this.org$apache$pekko$actor$Timers$$_timers;
    }

    public void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$0) {
        this.org$apache$pekko$actor$Timers$$_timers = x$0;
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
        Actor.aroundReceive$((Actor)this, (PartialFunction)receive, (Object)msg);
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public Set<Address> clusterNodes() {
        return this.clusterNodes;
    }

    public void clusterNodes_$eq(Set<Address> x$1) {
        this.clusterNodes = x$1;
    }

    public Set<UniqueAddress> memberTombstones() {
        return this.memberTombstones;
    }

    public void memberTombstones_$eq(Set<UniqueAddress> x$1) {
        this.memberTombstones = x$1;
    }

    public void preStart() {
        Actor.preStart$((Actor)this);
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.MemberTombstonesChanged.class}));
    }

    public void postStop() {
        super.postStop();
        this.cluster().unsubscribe(this.self());
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.receiveClusterEvent().orElse(super.receive());
    }

    public PartialFunction<Object, BoxedUnit> receiveClusterEvent() {
        return new Serializable(this){
            private final /* synthetic */ ClusterRemoteWatcher $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState state = (ClusterEvent.CurrentClusterState)object;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberJoined) {
                    Member member;
                    ClusterEvent.MemberJoined memberJoined = ClusterEvent$MemberJoined$.MODULE$.unapply((ClusterEvent.MemberJoined)object);
                    Member m = member = memberJoined._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    Member member;
                    ClusterEvent.MemberUp memberUp = ClusterEvent$MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member m = member = memberUp._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberWeaklyUp) {
                    Member member;
                    ClusterEvent.MemberWeaklyUp memberWeaklyUp = ClusterEvent$MemberWeaklyUp$.MODULE$.unapply((ClusterEvent.MemberWeaklyUp)object);
                    Member m = member = memberWeaklyUp._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    MemberStatus previousStatus = memberStatus;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberTombstonesChanged) {
                    Set<UniqueAddress> set;
                    ClusterEvent.MemberTombstonesChanged memberTombstonesChanged = ClusterEvent$MemberTombstonesChanged$.MODULE$.unapply((ClusterEvent.MemberTombstonesChanged)object);
                    Set<UniqueAddress> tombstones = set = memberTombstonesChanged._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return true;
                }
                if (object instanceof DelayedQuarantine) {
                    DelayedQuarantine delayedQuarantine = ClusterRemoteWatcher$DelayedQuarantine$.MODULE$.unapply((DelayedQuarantine)object);
                    Member member = delayedQuarantine._1();
                    MemberStatus memberStatus = delayedQuarantine._2();
                    Member m = member;
                    MemberStatus previousStatus = memberStatus;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState state = (ClusterEvent.CurrentClusterState)object;
                    this.$outer.clusterNodes_$eq((Set<Address>)((Set)state.members().collect((PartialFunction)new Serializable(this){
                        private final /* synthetic */ $anon$1 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Member x) {
                            Member member;
                            Member m = member = x;
                            Address address = m.address();
                            Address address2 = this.$outer.org$apache$pekko$cluster$ClusterRemoteWatcher$_$$anon$$$outer().cluster().selfAddress();
                            return address == null ? address2 != null : !address.equals(address2);
                        }

                        public final Object applyOrElse(Member x, Function1 function1) {
                            Member member;
                            Member m = member = x;
                            Address address = m.address();
                            Address address2 = this.$outer.org$apache$pekko$cluster$ClusterRemoteWatcher$_$$anon$$$outer().cluster().selfAddress();
                            if (address == null ? address2 != null : !address.equals(address2)) {
                                return m.address();
                            }
                            return function1.apply((Object)x);
                        }
                    }, Address$.MODULE$.addressOrdering())));
                    this.$outer.clusterNodes().foreach((Function1)(JProcedure1 & Serializable)address -> this.$outer.takeOverResponsibility((Address)address));
                    this.$outer.unreachable_$eq((Set)this.$outer.unreachable().diff(this.$outer.clusterNodes()));
                    this.$outer.memberTombstones_$eq(state.memberTombstones());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberJoined) {
                    Member member;
                    ClusterEvent.MemberJoined memberJoined = ClusterEvent$MemberJoined$.MODULE$.unapply((ClusterEvent.MemberJoined)object);
                    Member m = member = memberJoined._1();
                    this.$outer.org$apache$pekko$cluster$ClusterRemoteWatcher$$memberJoined(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    Member member;
                    ClusterEvent.MemberUp memberUp = ClusterEvent$MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member m = member = memberUp._1();
                    this.$outer.memberUp(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberWeaklyUp) {
                    Member member;
                    ClusterEvent.MemberWeaklyUp memberWeaklyUp = ClusterEvent$MemberWeaklyUp$.MODULE$.unapply((ClusterEvent.MemberWeaklyUp)object);
                    Member m = member = memberWeaklyUp._1();
                    this.$outer.memberUp(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    MemberStatus previousStatus = memberStatus;
                    this.$outer.memberRemoved(m, previousStatus);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberTombstonesChanged) {
                    Set<UniqueAddress> set;
                    ClusterEvent.MemberTombstonesChanged memberTombstonesChanged = ClusterEvent$MemberTombstonesChanged$.MODULE$.unapply((ClusterEvent.MemberTombstonesChanged)object);
                    Set<UniqueAddress> tombstones = set = memberTombstonesChanged._1();
                    this.$outer.memberTombstones_$eq(tombstones);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    return BoxedUnit.UNIT;
                }
                if (object instanceof DelayedQuarantine) {
                    DelayedQuarantine delayedQuarantine = ClusterRemoteWatcher$DelayedQuarantine$.MODULE$.unapply((DelayedQuarantine)object);
                    Member member = delayedQuarantine._1();
                    MemberStatus memberStatus = delayedQuarantine._2();
                    Member m = member;
                    MemberStatus previousStatus = memberStatus;
                    this.$outer.delayedQuarantine(m, previousStatus);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            public final /* synthetic */ ClusterRemoteWatcher org$apache$pekko$cluster$ClusterRemoteWatcher$_$$anon$$$outer() {
                return this.$outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(org.apache.pekko.actor.Address )}, serializedLambda);
            }
        };
    }

    public void org$apache$pekko$cluster$ClusterRemoteWatcher$$memberJoined(Member m) {
        Address address = m.address();
        Address address2 = this.cluster().selfAddress();
        if (address == null ? address2 != null : !address.equals(address2)) {
            this.quarantineOldIncarnation(m);
            return;
        }
    }

    public void memberUp(Member m) {
        Address address = m.address();
        Address address2 = this.cluster().selfAddress();
        if (address == null ? address2 != null : !address.equals(address2)) {
            this.quarantineOldIncarnation(m);
            this.clusterNodes_$eq((Set<Address>)((Set)this.clusterNodes().$plus((Object)m.address())));
            this.takeOverResponsibility(m.address());
            this.unreachable_$eq((Set)this.unreachable().$minus((Object)m.address()));
            return;
        }
    }

    public void memberRemoved(Member m, MemberStatus previousStatus) {
        Address address = m.address();
        Address address2 = this.cluster().selfAddress();
        if (address == null ? address2 != null : !address.equals(address2)) {
            this.clusterNodes_$eq((Set<Address>)((Set)this.clusterNodes().$minus((Object)m.address())));
            MemberStatus memberStatus = previousStatus;
            MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
            if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
                this.quarantine(m.address(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)m.uniqueAddress().longUid())), new StringBuilder(42).append("Cluster member removed, previous status [").append(previousStatus).append("]").toString(), false);
            } else if (this.arteryEnabled) {
                this.pendingDelayedQuarantine = (Set)this.pendingDelayedQuarantine.$plus((Object)m.uniqueAddress());
                this.context().system().scheduler().scheduleOnce(this.cluster().settings().QuarantineRemovedNodeAfter(), this.self(), (Object)ClusterRemoteWatcher$DelayedQuarantine$.MODULE$.apply(m, previousStatus), (ExecutionContext)this.context().dispatcher(), this.self());
            }
            this.publishAddressTerminated(m.address());
            return;
        }
    }

    public void quarantineOldIncarnation(Member newIncarnation) {
        if (this.pendingDelayedQuarantine.nonEmpty()) {
            this.pendingDelayedQuarantine.find((Function1 & Serializable)_$1 -> {
                Address address = _$1.address();
                Address address2 = newIncarnation.address();
                return !(address != null ? !address.equals(address2) : address2 != null);
            }).foreach((Function1)(JProcedure1 & Serializable)oldIncarnation -> {
                this.pendingDelayedQuarantine = (Set)this.pendingDelayedQuarantine.$minus(oldIncarnation);
                this.quarantine(oldIncarnation.address(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)oldIncarnation.longUid())), "Cluster member removed, new incarnation joined", true);
            });
            return;
        }
    }

    public void delayedQuarantine(Member m, MemberStatus previousStatus) {
        if (this.pendingDelayedQuarantine.apply((Object)m.uniqueAddress())) {
            this.pendingDelayedQuarantine = (Set)this.pendingDelayedQuarantine.$minus((Object)m.uniqueAddress());
            this.quarantine(m.address(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)m.uniqueAddress().longUid())), new StringBuilder(42).append("Cluster member removed, previous status [").append(previousStatus).append("]").toString(), true);
            return;
        }
    }

    public void addWatch(InternalActorRef watchee, InternalActorRef watcher) {
        Address watcheeNode = watchee.path().address();
        if (!this.clusterNodes().contains((Object)watcheeNode) && this.memberTombstones().exists((Function1 & Serializable)_$2 -> {
            Address address = _$2.address();
            Address address2 = watcheeNode;
            return !(address != null ? !address.equals(address2) : address2 != null);
        })) {
            this.log().debug("Death watch for [{}] triggered immediately because member was removed from cluster", (Object)watchee);
            watcher.sendSystemMessage((SystemMessage)DeathWatchNotification$.MODULE$.apply((ActorRef)watchee, false, true));
            return;
        }
        super.addWatch(watchee, watcher);
    }

    public void watchNode(InternalActorRef watchee) {
        if (!this.clusterNodes().apply((Object)watchee.path().address())) {
            super.watchNode(watchee);
            return;
        }
    }

    public boolean shouldWatch(InternalActorRef watchee) {
        return this.clusterNodes().apply((Object)watchee.path().address()) || super.shouldWatch(watchee) || this.isWatchOutsideClusterAllowed(watchee);
    }

    private boolean isWatchOutsideClusterAllowed(InternalActorRef watchee) {
        String pathPrefix;
        String string = this.context().system().name();
        String string2 = watchee.path().address().system();
        return !(string != null ? !string.equals(string2) : string2 != null) && this.watchPathAllowList.contains((Object)(pathPrefix = ((IterableOnceOps)watchee.path().elements().take(2)).mkString("/", "/", "/")));
    }

    public void takeOverResponsibility(Address address) {
        if (this.watchingNodes().apply((Object)address)) {
            this.log().debug("Cluster is taking over responsibility of node: [{}]", (Object)address);
            this.unwatchNode(address);
            return;
        }
    }

    public static final class DelayedQuarantine
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Member m;
        private final MemberStatus previousStatus;

        public static DelayedQuarantine apply(Member member, MemberStatus memberStatus) {
            return ClusterRemoteWatcher$DelayedQuarantine$.MODULE$.apply(member, memberStatus);
        }

        public static DelayedQuarantine fromProduct(Product product) {
            return ClusterRemoteWatcher$DelayedQuarantine$.MODULE$.fromProduct(product);
        }

        public static DelayedQuarantine unapply(DelayedQuarantine delayedQuarantine) {
            return ClusterRemoteWatcher$DelayedQuarantine$.MODULE$.unapply(delayedQuarantine);
        }

        public DelayedQuarantine(Member m, MemberStatus previousStatus) {
            this.m = m;
            this.previousStatus = previousStatus;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DelayedQuarantine)) return false;
            DelayedQuarantine delayedQuarantine = (DelayedQuarantine)object;
            Member member = this.m();
            Member member2 = delayedQuarantine.m();
            if (member == null) {
                if (member2 != null) {
                    return false;
                }
            } else if (!((Object)member).equals(member2)) return false;
            MemberStatus memberStatus = this.previousStatus();
            MemberStatus memberStatus2 = delayedQuarantine.previousStatus();
            if (memberStatus == null) {
                if (memberStatus2 == null) return true;
                return false;
            } else {
                if (!memberStatus.equals(memberStatus2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DelayedQuarantine;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DelayedQuarantine";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "m";
            }
            if (1 == n2) {
                return "previousStatus";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Member m() {
            return this.m;
        }

        public MemberStatus previousStatus() {
            return this.previousStatus;
        }

        public DelayedQuarantine copy(Member m, MemberStatus previousStatus) {
            return new DelayedQuarantine(m, previousStatus);
        }

        public Member copy$default$1() {
            return this.m();
        }

        public MemberStatus copy$default$2() {
            return this.previousStatus();
        }

        public Member _1() {
            return this.m();
        }

        public MemberStatus _2() {
            return this.previousStatus();
        }
    }
}

