/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterUserAction$JoinTo$;
import org.apache.pekko.cluster.InternalClusterAction;
import org.apache.pekko.cluster.InternalClusterAction$IncompatibleConfig$;
import org.apache.pekko.cluster.InternalClusterAction$InitJoinAck$;
import org.apache.pekko.cluster.InternalClusterAction$InitJoinNack$;
import org.apache.pekko.cluster.InternalClusterAction$JoinSeedNode$;
import org.apache.pekko.cluster.InternalClusterAction$UncheckedConfig$;
import org.apache.pekko.cluster.JoinConfigCompatChecker;
import org.apache.pekko.cluster.SeedNodeProcess;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;

@InternalApi
public final class FirstSeedNodeProcess
extends SeedNodeProcess {
    public final IndexedSeq<Address> org$apache$pekko$cluster$FirstSeedNodeProcess$$seedNodes;
    private final Deadline timeout;
    private Set remainingSeedNodes;
    private final Cancellable retryTask;

    public FirstSeedNodeProcess(IndexedSeq<Address> seedNodes, JoinConfigCompatChecker joinConfigCompatChecker) {
        block3: {
            block2: {
                this.org$apache$pekko$cluster$FirstSeedNodeProcess$$seedNodes = seedNodes;
                super(joinConfigCompatChecker);
                if (seedNodes.size() <= 1) break block2;
                Object object = seedNodes.head();
                Address address = this.selfAddress();
                if (!(object == null ? address != null : !object.equals(address))) break block3;
            }
            throw new IllegalArgumentException("Join seed node should not be done");
        }
        this.timeout = Deadline$.MODULE$.now().$plus(this.cluster().settings().SeedNodeTimeout());
        this.remainingSeedNodes = (Set)seedNodes.toSet().$minus((Object)this.selfAddress());
        this.retryTask = this.cluster().scheduler().scheduleWithFixedDelay(new package.DurationInt(package$.MODULE$.DurationInt(1)).second(), new package.DurationInt(package$.MODULE$.DurationInt(1)).second(), this.self(), (Object)InternalClusterAction$JoinSeedNode$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.self().$bang((Object)InternalClusterAction$JoinSeedNode$.MODULE$, this.self());
    }

    public Deadline timeout() {
        return this.timeout;
    }

    public Set<Address> remainingSeedNodes() {
        return this.remainingSeedNodes;
    }

    public void remainingSeedNodes_$eq(Set<Address> x$1) {
        this.remainingSeedNodes = x$1;
    }

    public Cancellable retryTask() {
        return this.retryTask;
    }

    @Override
    public void postStop() {
        this.retryTask().cancel();
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ FirstSeedNodeProcess $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (InternalClusterAction$JoinSeedNode$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof InternalClusterAction.InitJoinAck) {
                    InternalClusterAction.InitJoinAck initJoinAck = InternalClusterAction$InitJoinAck$.MODULE$.unapply((InternalClusterAction.InitJoinAck)object);
                    Address address = initJoinAck._1();
                    InternalClusterAction.ConfigCheck configCheck = initJoinAck._2();
                    Address address2 = address;
                    if (configCheck instanceof InternalClusterAction.CompatibleConfig) {
                        InternalClusterAction.CompatibleConfig compatible = (InternalClusterAction.CompatibleConfig)configCheck;
                        return true;
                    }
                    Address address3 = address;
                    if (InternalClusterAction$UncheckedConfig$.MODULE$.equals(configCheck)) {
                        return true;
                    }
                    Address address4 = address;
                    if (InternalClusterAction$IncompatibleConfig$.MODULE$.equals(configCheck)) {
                        return true;
                    }
                }
                if (object instanceof InternalClusterAction.InitJoinNack) {
                    Address address;
                    InternalClusterAction.InitJoinNack initJoinNack = InternalClusterAction$InitJoinNack$.MODULE$.unapply((InternalClusterAction.InitJoinNack)object);
                    Address address5 = address = initJoinNack._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (InternalClusterAction$JoinSeedNode$.MODULE$.equals(object)) {
                    if (this.$outer.timeout().hasTimeLeft()) {
                        this.$outer.receiveJoinSeedNode(this.$outer.remainingSeedNodes());
                        return BoxedUnit.UNIT;
                    }
                    if (this.$outer.cluster().ClusterLogger().isDebugEnabled()) {
                        this.$outer.cluster().ClusterLogger().logDebug("Couldn't join other seed nodes, will join myself. seed-nodes=[{}]", this.$outer.org$apache$pekko$cluster$FirstSeedNodeProcess$$seedNodes.mkString(", "));
                    }
                    this.$outer.context().parent().$bang((Object)ClusterUserAction$JoinTo$.MODULE$.apply(this.$outer.selfAddress()), this.$outer.self());
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.InitJoinAck) {
                    InternalClusterAction.InitJoinAck initJoinAck = InternalClusterAction$InitJoinAck$.MODULE$.unapply((InternalClusterAction.InitJoinAck)object);
                    Address address = initJoinAck._1();
                    InternalClusterAction.ConfigCheck configCheck = initJoinAck._2();
                    Address address2 = address;
                    if (configCheck instanceof InternalClusterAction.CompatibleConfig) {
                        InternalClusterAction.CompatibleConfig compatible = (InternalClusterAction.CompatibleConfig)configCheck;
                        this.$outer.receiveInitJoinAckCompatibleConfig(address2, this.$outer.sender(), compatible, (Option<PartialFunction<Object, BoxedUnit>>)None$.MODULE$);
                        return BoxedUnit.UNIT;
                    }
                    Address address3 = address;
                    if (InternalClusterAction$UncheckedConfig$.MODULE$.equals(configCheck)) {
                        this.$outer.receiveInitJoinAckUncheckedConfig(address3, this.$outer.sender(), (Option<PartialFunction<Object, BoxedUnit>>)None$.MODULE$);
                        return BoxedUnit.UNIT;
                    }
                    Address address4 = address;
                    if (InternalClusterAction$IncompatibleConfig$.MODULE$.equals(configCheck)) {
                        this.$outer.receiveInitJoinAckIncompatibleConfig(address4, this.$outer.sender(), (Option<PartialFunction<Object, BoxedUnit>>)None$.MODULE$);
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof InternalClusterAction.InitJoinNack) {
                    Address address;
                    InternalClusterAction.InitJoinNack initJoinNack = InternalClusterAction$InitJoinNack$.MODULE$.unapply((InternalClusterAction.InitJoinNack)object);
                    Address address5 = address = initJoinNack._1();
                    this.$outer.cluster().ClusterLogger().logInfo("Received InitJoinNack message from [{}] to [{}]", this.$outer.sender(), (Object)this.$outer.selfAddress());
                    this.$outer.remainingSeedNodes_$eq((Set<Address>)((Set)this.$outer.remainingSeedNodes().$minus((Object)address5)));
                    if (this.$outer.remainingSeedNodes().isEmpty()) {
                        this.$outer.context().parent().$bang((Object)ClusterUserAction$JoinTo$.MODULE$.apply(this.$outer.selfAddress()), this.$outer.self());
                        this.$outer.context().stop(this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }
}

