/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Gossip;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MembershipState;
import org.apache.pekko.cluster.UniqueAddress;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.BuildFrom$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SetOps;
import scala.collection.SortedSetOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.Vector;
import scala.math.Ordering$;
import scala.math.package$;
import scala.util.Random$;

@InternalApi
public class GossipTargetSelector {
    private final double reduceGossipDifferentViewProbability;
    private final double crossDcGossipProbability;

    public GossipTargetSelector(double reduceGossipDifferentViewProbability, double crossDcGossipProbability) {
        this.reduceGossipDifferentViewProbability = reduceGossipDifferentViewProbability;
        this.crossDcGossipProbability = crossDcGossipProbability;
    }

    public final Option<UniqueAddress> gossipTarget(MembershipState state) {
        return this.selectRandomNode((IndexedSeq<UniqueAddress>)this.gossipTargets(state));
    }

    public final Vector<UniqueAddress> gossipTargets(MembershipState state) {
        if (state.latestGossip().isMultiDc()) {
            return this.multiDcGossipTargets(state);
        }
        return this.localDcGossipTargets(state);
    }

    public Vector<UniqueAddress> randomNodesForFullGossip(MembershipState state, int n) {
        if (state.latestGossip().isMultiDc() && ((SetOps)state.ageSortedTopOldestMembersPerDc().apply((Object)state.selfDc())).contains((Object)state.selfMember())) {
            Vector randomLocalNodes = (Vector)Random$.MODULE$.shuffle((IterableOnce)state.members().toVector().collect((PartialFunction)new Serializable(state){
                private final MembershipState state$1;
                {
                    this.state$1 = state$9;
                }

                public final boolean isDefinedAt(Member x) {
                    Member member;
                    Member m = member = x;
                    String string = m.dataCenter();
                    String string2 = this.state$1.selfDc();
                    return !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(m.uniqueAddress());
                }

                public final Object applyOrElse(Member x, Function1 function1) {
                    Member member;
                    Member m = member = x;
                    String string = m.dataCenter();
                    String string2 = this.state$1.selfDc();
                    if (!(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(m.uniqueAddress())) {
                        return m.uniqueAddress();
                    }
                    return function1.apply((Object)x);
                }
            }), BuildFrom$.MODULE$.buildFromIterableOps());
            List otherDcs = (List)Random$.MODULE$.shuffle((IterableOnce)state.ageSortedTopOldestMembersPerDc().keySet().$minus((Object)state.selfDc()).toList(), BuildFrom$.MODULE$.buildFromIterableOps());
            Option option = GossipTargetSelector.selectOtherDcNode$1(state, otherDcs);
            if (option instanceof Some) {
                UniqueAddress node = (UniqueAddress)((Some)option).value();
                return (Vector)randomLocalNodes.take(n - 1).$colon$plus((Object)node);
            }
            if (None$.MODULE$.equals(option)) {
                return randomLocalNodes.take(n);
            }
            throw new MatchError((Object)option);
        }
        Vector selectedNodes = (Vector)state.members().toVector().collect((PartialFunction)new Serializable(state){
            private final MembershipState state$4;
            {
                this.state$4 = state$11;
            }

            public final boolean isDefinedAt(Member x) {
                Member member;
                Member m = member = x;
                String string = m.dataCenter();
                String string2 = this.state$4.selfDc();
                return !(string != null ? !string.equals(string2) : string2 != null) && this.state$4.validNodeForGossip(m.uniqueAddress());
            }

            public final Object applyOrElse(Member x, Function1 function1) {
                Member member;
                Member m = member = x;
                String string = m.dataCenter();
                String string2 = this.state$4.selfDc();
                if (!(string != null ? !string.equals(string2) : string2 != null) && this.state$4.validNodeForGossip(m.uniqueAddress())) {
                    return m.uniqueAddress();
                }
                return function1.apply((Object)x);
            }
        });
        if (selectedNodes.size() <= n) {
            return selectedNodes;
        }
        return ((Vector)Random$.MODULE$.shuffle((IterableOnce)selectedNodes, BuildFrom$.MODULE$.buildFromIterableOps())).take(n);
    }

    public Vector<UniqueAddress> localDcGossipTargets(MembershipState state) {
        Vector firstSelection;
        Gossip latestGossip = state.latestGossip();
        Vector vector = firstSelection = this.preferNodesWithDifferentView(state) ? (Vector)latestGossip.members().iterator().collect((PartialFunction)new Serializable(state, latestGossip){
            private final MembershipState state$5;
            private final Gossip latestGossip$1;
            {
                this.state$5 = state$12;
                this.latestGossip$1 = latestGossip$2;
            }

            public final boolean isDefinedAt(Member x) {
                Member member;
                Member m = member = x;
                String string = m.dataCenter();
                String string2 = this.state$5.selfDc();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (!this.latestGossip$1.seenByNode(m.uniqueAddress()) && this.state$5.validNodeForGossip(m.uniqueAddress())) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Member x, Function1 function1) {
                Member member;
                Member m = member = x;
                String string = m.dataCenter();
                String string2 = this.state$5.selfDc();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (!this.latestGossip$1.seenByNode(m.uniqueAddress()) && this.state$5.validNodeForGossip(m.uniqueAddress())) {
                        return m.uniqueAddress();
                    }
                }
                return function1.apply((Object)x);
            }
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)scala.package$.MODULE$.Vector())) : scala.package$.MODULE$.Vector().empty();
        if (firstSelection.isEmpty()) {
            return (Vector)latestGossip.members().toVector().collect((PartialFunction)new Serializable(state){
                private final MembershipState state$6;
                {
                    this.state$6 = state$13;
                }

                public final boolean isDefinedAt(Member x) {
                    Member member;
                    Member m = member = x;
                    String string = m.dataCenter();
                    String string2 = this.state$6.selfDc();
                    return !(string != null ? !string.equals(string2) : string2 != null) && this.state$6.validNodeForGossip(m.uniqueAddress());
                }

                public final Object applyOrElse(Member x, Function1 function1) {
                    Member member;
                    Member m = member = x;
                    String string = m.dataCenter();
                    String string2 = this.state$6.selfDc();
                    if (!(string != null ? !string.equals(string2) : string2 != null) && this.state$6.validNodeForGossip(m.uniqueAddress())) {
                        return m.uniqueAddress();
                    }
                    return function1.apply((Object)x);
                }
            });
        }
        return firstSelection;
    }

    public Vector<UniqueAddress> multiDcGossipTargets(MembershipState state) {
        if (this.selectDcLocalNodes(state)) {
            return this.localDcGossipTargets(state);
        }
        Map<String, SortedSet<Member>> nodesPerDc = state.ageSortedTopOldestMembersPerDc();
        if (!((SetOps)nodesPerDc.apply((Object)state.selfDc())).contains((Object)state.selfMember())) {
            return this.localDcGossipTargets(state);
        }
        List<String> otherDcsInRandomOrder = this.dcsInRandomOrder((List<String>)nodesPerDc.$minus((Object)state.selfDc()).keys().toList());
        Vector nodes = GossipTargetSelector.findFirstDcWithValidNodes$1(state, nodesPerDc, otherDcsInRandomOrder);
        if (nodes.nonEmpty()) {
            return nodes;
        }
        return this.localDcGossipTargets(state);
    }

    public double adjustedGossipDifferentViewProbability(int clusterSize) {
        double low = this.reduceGossipDifferentViewProbability;
        double high = low * (double)3;
        if ((double)clusterSize <= low) {
            return this.reduceGossipDifferentViewProbability;
        }
        double minP = this.reduceGossipDifferentViewProbability / (double)10;
        if ((double)clusterSize >= high) {
            return minP;
        }
        double k = (minP - this.reduceGossipDifferentViewProbability) / (high - low);
        return this.reduceGossipDifferentViewProbability + ((double)clusterSize - low) * k;
    }

    public boolean selectDcLocalNodes(MembershipState state) {
        int localMembers = state.dcMembers().size();
        double probability = localMembers > 4 ? this.crossDcGossipProbability : package$.MODULE$.max((double)(5 - localMembers) * 0.25, this.crossDcGossipProbability);
        return ThreadLocalRandom.current().nextDouble() > probability;
    }

    public boolean preferNodesWithDifferentView(MembershipState state) {
        return ThreadLocalRandom.current().nextDouble() < this.adjustedGossipDifferentViewProbability(state.latestGossip().members().size());
    }

    public List<String> dcsInRandomOrder(List<String> dcs) {
        return (List)Random$.MODULE$.shuffle(dcs, BuildFrom$.MODULE$.buildFromIterableOps());
    }

    public Option<UniqueAddress> selectRandomNode(IndexedSeq<UniqueAddress> nodes) {
        if (nodes.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(nodes.apply(ThreadLocalRandom.current().nextInt(nodes.size())));
    }

    private static final Option selectOtherDcNode$1(MembershipState state$2, List randomizedDcs) {
        List list;
        block3: {
            Option option;
            while (true) {
                list = randomizedDcs;
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    return None$.MODULE$;
                }
                if (!(list instanceof .colon.colon)) break block3;
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                String dc = (String)colon2.head();
                List tail = list3;
                option = ((IterableOnceOps)state$2.ageSortedTopOldestMembersPerDc().apply((Object)dc)).collectFirst((PartialFunction)new Serializable(state$2){
                    private final MembershipState state$3;
                    {
                        this.state$3 = state$10;
                    }

                    public final boolean isDefinedAt(Member x) {
                        Member member = x;
                        Member m = member;
                        return this.state$3.validNodeForGossip(m.uniqueAddress());
                    }

                    public final Object applyOrElse(Member x, Function1 function1) {
                        Member member = x;
                        Member m = member;
                        if (this.state$3.validNodeForGossip(m.uniqueAddress())) {
                            return m.uniqueAddress();
                        }
                        return function1.apply((Object)x);
                    }
                });
                if (option instanceof Some) {
                    UniqueAddress addr = (UniqueAddress)((Some)option).value();
                    return Some$.MODULE$.apply((Object)addr);
                }
                if (!None$.MODULE$.equals(option)) break;
                randomizedDcs = tail;
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)list);
    }

    private static final Vector findFirstDcWithValidNodes$1(MembershipState state$7, Map nodesPerDc$1, List left) {
        List list;
        while ((list = left) instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            String dc = (String)colon2.head();
            List tail = list2;
            SortedSet validNodes = (SortedSet)((SortedSetOps)nodesPerDc$1.apply((Object)dc)).collect((PartialFunction)new Serializable(state$7){
                private final MembershipState state$8;
                {
                    this.state$8 = state$14;
                }

                public final boolean isDefinedAt(Member x) {
                    Member member = x;
                    Member member2 = member;
                    return this.state$8.validNodeForGossip(member2.uniqueAddress());
                }

                public final Object applyOrElse(Member x, Function1 function1) {
                    Member member = x;
                    Member member2 = member;
                    if (this.state$8.validNodeForGossip(member2.uniqueAddress())) {
                        return member2.uniqueAddress();
                    }
                    return function1.apply((Object)x);
                }
            }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            if (validNodes.nonEmpty()) {
                return validNodes.toVector();
            }
            left = tail;
        }
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List list3 = list;
        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
            return scala.package$.MODULE$.Vector().empty();
        }
        throw new MatchError((Object)list);
    }
}

