/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterSettings;
import org.apache.pekko.cluster.ConfigValidation;
import org.apache.pekko.cluster.Invalid$;
import org.apache.pekko.cluster.JoinConfigCompatChecker;
import org.apache.pekko.cluster.Valid$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;

public final class JoinConfigCompatChecker$
implements Serializable {
    public static final JoinConfigCompatChecker$ MODULE$ = new JoinConfigCompatChecker$();

    private JoinConfigCompatChecker$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JoinConfigCompatChecker$.class);
    }

    public ConfigValidation exists(Seq<String> requiredKeys, Config toCheck) {
        Set allKeys = (Set)package.JavaConverters$.MODULE$.SetHasAsScala(toCheck.entrySet()).asScala().map((Function1 & Serializable)_$1 -> (String)_$1.getKey());
        Seq result = (Seq)requiredKeys.collect((PartialFunction)new Serializable(allKeys){
            private final Set allKeys$1;
            {
                this.allKeys$1 = allKeys$2;
            }

            public final boolean isDefinedAt(String x) {
                String string = x;
                String requiredKey = string;
                return !this.allKeys$1.contains((Object)requiredKey);
            }

            public final Object applyOrElse(String x, Function1 function1) {
                String string = x;
                String requiredKey = string;
                if (!this.allKeys$1.contains((Object)requiredKey)) {
                    return new StringBuilder(11).append(requiredKey).append(" is missing").toString();
                }
                return function1.apply((Object)x);
            }
        });
        return result.isEmpty() ? Valid$.MODULE$ : Invalid$.MODULE$.apply((Seq<String>)((Seq)result.to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$))));
    }

    public ConfigValidation fullMatch(Seq<String> requiredKeys, Config toCheck, Config actualConfig) {
        return this.exists(requiredKeys, toCheck).$plus$plus(this.checkEquality(requiredKeys, toCheck, actualConfig));
    }

    @InternalApi
    public ConfigValidation checkEquality(Seq<String> keys, Config toCheck, Config actualConfig) {
        Seq incompatibleKeys = (Seq)((IterableOps)keys.withFilter((Function1 & Serializable)key -> toCheck.hasPath(key)).map((Function1 & Serializable)key -> {
            ConfigValue value = toCheck.getValue(key);
            return Tuple2$.MODULE$.apply(key, (Object)value);
        })).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ConfigValue value;
                String key = (String)tuple2._1();
                return !this.checkCompat$1(actualConfig, key, value = (ConfigValue)tuple2._2());
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                ConfigValue value = (ConfigValue)tuple2._2();
                return new StringBuilder(16).append(key).append(" is incompatible").toString();
            }
            throw new MatchError((Object)tuple2);
        });
        return incompatibleKeys.isEmpty() ? Valid$.MODULE$ : Invalid$.MODULE$.apply((Seq<String>)((Seq)incompatibleKeys.to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$))));
    }

    @InternalApi
    public Config filterWithKeys(Seq<String> requiredKeys, Config config) {
        Seq filtered = (Seq)requiredKeys.withFilter((Function1 & Serializable)key -> config.hasPath(key)).map((Function1 & Serializable)key -> Tuple2$.MODULE$.apply(key, (Object)config.getValue(key)));
        return ConfigFactory.parseMap((java.util.Map)package.JavaConverters$.MODULE$.MapHasAsJava((Map)filtered.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
    }

    @InternalApi
    public Seq<String> removeSensitiveKeys(Seq<String> requiredKeys, ClusterSettings clusterSettings) {
        return (Seq)requiredKeys.filter((Function1 & Serializable)key -> !clusterSettings.SensitiveConfigPaths().exists((Function1 & Serializable)s -> key.startsWith((String)s)));
    }

    @InternalApi
    public Seq<String> removeSensitiveKeys(Config config, ClusterSettings clusterSettings) {
        Seq existingKeys = (Seq)((IterableOnceOps)package.JavaConverters$.MODULE$.SetHasAsScala(config.entrySet()).asScala().map((Function1 & Serializable)_$2 -> (String)_$2.getKey())).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$));
        return this.removeSensitiveKeys((Seq<String>)existingKeys, clusterSettings);
    }

    @InternalApi
    public JoinConfigCompatChecker load(ExtendedActorSystem system, ClusterSettings clusterSettings) {
        scala.collection.immutable.Set checkers = (scala.collection.immutable.Set)clusterSettings.ConfigCompatCheckers().map((Function1 & Serializable)fqcn -> (JoinConfigCompatChecker)system.dynamicAccess().createInstanceFor(fqcn, (Seq)Seq$.MODULE$.empty(), ClassTag$.MODULE$.apply(JoinConfigCompatChecker.class)).get());
        return new JoinConfigCompatChecker(checkers, this){
            private final scala.collection.immutable.Set checkers$2;
            private final Seq requiredKeys;
            {
                this.checkers$2 = checkers$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.requiredKeys = (Seq)((SeqOps)((IterableOnceOps)checkers$1.flatMap(JoinConfigCompatChecker$::org$apache$pekko$cluster$JoinConfigCompatChecker$$anon$2$$_$$lessinit$greater$$anonfun$1)).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Seq$.MODULE$))).$plus$colon((Object)"pekko.version");
            }

            public Seq requiredKeys() {
                return this.requiredKeys;
            }

            public ConfigValidation check(Config toValidate, Config clusterConfig) {
                return (ConfigValidation)this.checkers$2.foldLeft((Object)Valid$.MODULE$, (arg_0, arg_1) -> JoinConfigCompatChecker$.org$apache$pekko$cluster$JoinConfigCompatChecker$$anon$2$$_$check$$anonfun$1(toValidate, clusterConfig, arg_0, arg_1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$cluster$JoinConfigCompatChecker$$anon$2$$_$$lessinit$greater$$anonfun$1(org.apache.pekko.cluster.JoinConfigCompatChecker ), org$apache$pekko$cluster$JoinConfigCompatChecker$$anon$2$$_$check$$anonfun$1(com.typesafe.config.Config com.typesafe.config.Config org.apache.pekko.cluster.ConfigValidation org.apache.pekko.cluster.JoinConfigCompatChecker )}, serializedLambda);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkCompat$1(Config actualConfig$1, String key, ConfigValue value) {
        if (!actualConfig$1.hasPath(key)) return false;
        ConfigValue configValue = actualConfig$1.getValue(key);
        ConfigValue configValue2 = value;
        if (configValue != null) {
            if (!configValue.equals(configValue2)) return false;
            return true;
        }
        if (configValue2 == null) return true;
        return false;
    }

    public static final /* synthetic */ IterableOnce org$apache$pekko$cluster$JoinConfigCompatChecker$$anon$2$$_$$lessinit$greater$$anonfun$1(JoinConfigCompatChecker _$3) {
        return _$3.requiredKeys();
    }

    public static final /* synthetic */ ConfigValidation org$apache$pekko$cluster$JoinConfigCompatChecker$$anon$2$$_$check$$anonfun$1(Config toValidate$1, Config clusterConfig$1, ConfigValidation acc, JoinConfigCompatChecker checker) {
        return acc.$plus$plus(checker.check(toValidate$1, clusterConfig$1));
    }
}

