/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterSettings$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.MemberStatus$Exiting$;
import org.apache.pekko.cluster.MemberStatus$Joining$;
import org.apache.pekko.cluster.MemberStatus$Leaving$;
import org.apache.pekko.cluster.MemberStatus$PreparingForShutdown$;
import org.apache.pekko.cluster.MemberStatus$ReadyForShutdown$;
import org.apache.pekko.cluster.MemberStatus$Removed$;
import org.apache.pekko.cluster.MemberStatus$Up$;
import org.apache.pekko.cluster.MemberStatus$WeaklyUp$;
import org.apache.pekko.cluster.MembershipState$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.util.Version;
import org.apache.pekko.util.Version$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Member$
implements Serializable {
    private static final Set none;
    private static final Ordering addressOrdering;
    private static final Ordering leaderStatusOrdering;
    private static final Ordering ordering;
    private static final Ordering ageOrdering;
    public static final Member$ MODULE$;

    private Member$() {
    }

    static {
        MODULE$ = new Member$();
        none = Predef$.MODULE$.Set().empty();
        addressOrdering = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable)(a, b) -> {
            if (a == b) {
                return false;
            }
            Option option = a.host();
            Option option2 = b.host();
            if (option == null ? option2 != null : !option.equals(option2)) {
                return ((String)a.host().getOrElse(this::$init$$$anonfun$1$$anonfun$1)).compareTo((String)b.host().getOrElse(this::$init$$$anonfun$1$$anonfun$2)) < 0;
            }
            Option option3 = a.port();
            Option option4 = b.port();
            if (option3 == null ? option4 != null : !option3.equals(option4)) {
                return BoxesRunTime.unboxToInt((Object)a.port().getOrElse(this::$init$$$anonfun$1$$anonfun$3)) < BoxesRunTime.unboxToInt((Object)b.port().getOrElse(this::$init$$$anonfun$1$$anonfun$4));
            }
            return false;
        });
        leaderStatusOrdering = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable)(a, b) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)a.status(), (Object)b.status());
            if (tuple2 != null) {
                MemberStatus memberStatus = (MemberStatus)tuple2._1();
                MemberStatus memberStatus2 = (MemberStatus)tuple2._2();
                MemberStatus as = memberStatus;
                MemberStatus bs = memberStatus2;
                MemberStatus memberStatus3 = as;
                MemberStatus memberStatus4 = bs;
                if (!(memberStatus3 != null ? !memberStatus3.equals(memberStatus4) : memberStatus4 != null)) {
                    return this.ordering().compare(a, b) <= 0;
                }
                if (MemberStatus$Down$.MODULE$.equals(memberStatus)) {
                    return false;
                }
                if (MemberStatus$Down$.MODULE$.equals(memberStatus2)) {
                    return true;
                }
                if (MemberStatus$Exiting$.MODULE$.equals(memberStatus)) {
                    return false;
                }
                if (MemberStatus$Exiting$.MODULE$.equals(memberStatus2)) {
                    return true;
                }
                if (MemberStatus$Joining$.MODULE$.equals(memberStatus)) {
                    return false;
                }
                if (MemberStatus$Joining$.MODULE$.equals(memberStatus2)) {
                    return true;
                }
                if (MemberStatus$WeaklyUp$.MODULE$.equals(memberStatus)) {
                    return false;
                }
                if (MemberStatus$WeaklyUp$.MODULE$.equals(memberStatus2)) {
                    return true;
                }
            }
            return this.ordering().compare(a, b) <= 0;
        });
        ordering = new Ordering<Member>(){
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }

            public int compare(Member a, Member b) {
                return a.uniqueAddress().compare(b.uniqueAddress());
            }
        };
        ageOrdering = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable)(a, b) -> a.isOlderThan((Member)b));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Member$.class);
    }

    public Set<Member> none() {
        return none;
    }

    @InternalApi
    public Member apply(UniqueAddress uniqueAddress, Set<String> roles, Version appVersion) {
        return new Member(uniqueAddress, Integer.MAX_VALUE, MemberStatus$Joining$.MODULE$, roles, appVersion);
    }

    public Member removed(UniqueAddress node) {
        return new Member(node, Integer.MAX_VALUE, MemberStatus$Removed$.MODULE$, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(4).append(ClusterSettings$.MODULE$.DcRolePrefix()).append("-N/A").toString()}))), Version$.MODULE$.Zero());
    }

    public Ordering<Address> addressOrdering() {
        return addressOrdering;
    }

    public Ordering<Member> leaderStatusOrdering() {
        return leaderStatusOrdering;
    }

    public Ordering<Member> ordering() {
        return ordering;
    }

    public Ordering<Member> ageOrdering() {
        return ageOrdering;
    }

    public Set<Member> pickHighestPriority(Set<Member> a, Set<Member> b) {
        return this.pickHighestPriority(a, b, (Map<UniqueAddress, Object>)Predef$.MODULE$.Map().empty());
    }

    @InternalApi
    public Set<Member> pickHighestPriority(Set<Member> a, Set<Member> b, Map<UniqueAddress, Object> tombstones) {
        Map groupedByAddress = ((IterableOps)a.toSeq().$plus$plus((IterableOnce)b.toSeq())).groupBy((Function1 & Serializable)_$2 -> _$2.uniqueAddress());
        return (Set)groupedByAddress.foldLeft(this.none(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                Set acc = (Set)tuple2._1();
                if (tuple22 != null) {
                    Seq members = (Seq)tuple22._2();
                    if (members.size() == 2) {
                        return (Set)acc.$plus(members.reduceLeft((Function2 & Serializable)(m1, m2) -> this.highestPriorityOf((Member)m1, (Member)m2)));
                    }
                    Member m = (Member)members.head();
                    if (tombstones.contains((Object)m.uniqueAddress()) || MembershipState$.MODULE$.removeUnreachableWithMemberStatus().apply((Object)m.status())) {
                        return acc;
                    }
                    return (Set)acc.$plus((Object)m);
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Member highestPriorityOf(Member m1, Member m2) {
        MemberStatus memberStatus = m1.status();
        MemberStatus memberStatus2 = m2.status();
        if (!(memberStatus != null ? !memberStatus.equals(memberStatus2) : memberStatus2 != null)) {
            if (m1.isOlderThan(m2)) {
                return m1;
            }
            return m2;
        }
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)m1.status(), (Object)m2.status());
        if (tuple2 != null) {
            MemberStatus memberStatus3 = (MemberStatus)tuple2._1();
            MemberStatus memberStatus4 = (MemberStatus)tuple2._2();
            if (MemberStatus$Removed$.MODULE$.equals(memberStatus3)) {
                return m1;
            }
            if (MemberStatus$Removed$.MODULE$.equals(memberStatus4)) {
                return m2;
            }
            if (MemberStatus$ReadyForShutdown$.MODULE$.equals(memberStatus3)) {
                return m1;
            }
            if (MemberStatus$ReadyForShutdown$.MODULE$.equals(memberStatus4)) {
                return m2;
            }
            if (MemberStatus$Down$.MODULE$.equals(memberStatus3)) {
                return m1;
            }
            if (MemberStatus$Down$.MODULE$.equals(memberStatus4)) {
                return m2;
            }
            if (MemberStatus$Exiting$.MODULE$.equals(memberStatus3)) {
                return m1;
            }
            if (MemberStatus$Exiting$.MODULE$.equals(memberStatus4)) {
                return m2;
            }
            if (MemberStatus$Leaving$.MODULE$.equals(memberStatus3)) {
                return m1;
            }
            if (MemberStatus$Leaving$.MODULE$.equals(memberStatus4)) {
                return m2;
            }
            if (MemberStatus$Joining$.MODULE$.equals(memberStatus3)) {
                return m2;
            }
            if (MemberStatus$Joining$.MODULE$.equals(memberStatus4)) {
                return m1;
            }
            if (MemberStatus$WeaklyUp$.MODULE$.equals(memberStatus3)) {
                return m2;
            }
            if (MemberStatus$WeaklyUp$.MODULE$.equals(memberStatus4)) {
                return m1;
            }
            if (MemberStatus$PreparingForShutdown$.MODULE$.equals(memberStatus3)) {
                return m1;
            }
            if (MemberStatus$PreparingForShutdown$.MODULE$.equals(memberStatus4)) {
                return m2;
            }
            if (MemberStatus$Up$.MODULE$.equals(memberStatus3) && MemberStatus$Up$.MODULE$.equals(memberStatus4)) {
                return m1;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private final String $init$$$anonfun$1$$anonfun$1() {
        return "";
    }

    private final String $init$$$anonfun$1$$anonfun$2() {
        return "";
    }

    private final int $init$$$anonfun$1$$anonfun$3() {
        return 0;
    }

    private final int $init$$$anonfun$1$$anonfun$4() {
        return 0;
    }
}

