/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.util.Set;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterSettings$;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$;
import org.apache.pekko.cluster.MemberStatus$Up$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.util.Version;
import org.apache.pekko.util.Version$;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;

public class Member
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Member.class.getDeclaredField("dataCenter$lzy1"));
    private final UniqueAddress uniqueAddress;
    private final int upNumber;
    private final MemberStatus status;
    private final scala.collection.immutable.Set roles;
    private final Version appVersion;
    private volatile Object dataCenter$lzy1;

    public static Ordering<Address> addressOrdering() {
        return Member$.MODULE$.addressOrdering();
    }

    public static Ordering<Member> ageOrdering() {
        return Member$.MODULE$.ageOrdering();
    }

    @InternalApi
    public static Member apply(UniqueAddress uniqueAddress, scala.collection.immutable.Set<String> set, Version version) {
        return Member$.MODULE$.apply(uniqueAddress, set, version);
    }

    public static Member highestPriorityOf(Member member, Member member2) {
        return Member$.MODULE$.highestPriorityOf(member, member2);
    }

    public static Ordering<Member> leaderStatusOrdering() {
        return Member$.MODULE$.leaderStatusOrdering();
    }

    public static scala.collection.immutable.Set<Member> none() {
        return Member$.MODULE$.none();
    }

    public static Ordering<Member> ordering() {
        return Member$.MODULE$.ordering();
    }

    public static scala.collection.immutable.Set<Member> pickHighestPriority(scala.collection.immutable.Set<Member> set, scala.collection.immutable.Set<Member> set2) {
        return Member$.MODULE$.pickHighestPriority(set, set2);
    }

    @InternalApi
    public static scala.collection.immutable.Set<Member> pickHighestPriority(scala.collection.immutable.Set<Member> set, scala.collection.immutable.Set<Member> set2, Map<UniqueAddress, Object> map) {
        return Member$.MODULE$.pickHighestPriority(set, set2, map);
    }

    public static Member removed(UniqueAddress uniqueAddress) {
        return Member$.MODULE$.removed(uniqueAddress);
    }

    public Member(UniqueAddress uniqueAddress, int upNumber, MemberStatus status, scala.collection.immutable.Set<String> roles, Version appVersion) {
        this.uniqueAddress = uniqueAddress;
        this.upNumber = upNumber;
        this.status = status;
        this.roles = roles;
        this.appVersion = appVersion;
    }

    public UniqueAddress uniqueAddress() {
        return this.uniqueAddress;
    }

    public int upNumber() {
        return this.upNumber;
    }

    public MemberStatus status() {
        return this.status;
    }

    public scala.collection.immutable.Set<String> roles() {
        return this.roles;
    }

    public Version appVersion() {
        return this.appVersion;
    }

    public String dataCenter() {
        Object object = this.dataCenter$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.dataCenter$lzyINIT1();
    }

    private Object dataCenter$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.dataCenter$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ((String)this.roles().find((Function1 & Serializable)_$1 -> _$1.startsWith(ClusterSettings$.MODULE$.DcRolePrefix())).getOrElse(Member::dataCenter$lzyINIT1$$anonfun$2)).substring(ClusterSettings$.MODULE$.DcRolePrefix().length());
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dataCenter$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Address address() {
        return this.uniqueAddress().address();
    }

    public int hashCode() {
        return Statics.anyHash((Object)this.uniqueAddress());
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof Member) {
            Member m = (Member)object;
            UniqueAddress uniqueAddress = this.uniqueAddress();
            UniqueAddress uniqueAddress2 = m.uniqueAddress();
            return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
        }
        return false;
    }

    public String toString() {
        String string = this.dataCenter();
        String string2 = ClusterSettings$.MODULE$.DefaultDataCenter();
        Version version = this.appVersion();
        Version version2 = Version$.MODULE$.Zero();
        return new StringBuilder(10).append("Member(").append(this.address()).append(", ").append(this.status()).append(!(string != null ? !string.equals(string2) : string2 != null) ? "" : new StringBuilder(2).append(", ").append(this.dataCenter()).toString()).append(!(version != null ? !version.equals(version2) : version2 != null) ? "" : new StringBuilder(2).append(", ").append(this.appVersion()).toString()).append(")").toString();
    }

    public boolean hasRole(String role) {
        return this.roles().contains((Object)role);
    }

    public Set<String> getRoles() {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.roles()).asJava();
    }

    public boolean isOlderThan(Member other) throws IllegalArgumentException {
        String string = this.dataCenter();
        String string2 = other.dataCenter();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new IllegalArgumentException(new StringBuilder(77).append("Comparing members of different data centers with isOlderThan is not allowed. ").append(new StringBuilder(9).append("[").append(this).append("] vs. [").append(other).append("]").toString()).toString());
        }
        if (this.upNumber() == other.upNumber()) {
            return Member$.MODULE$.addressOrdering().compare((Object)this.address(), (Object)other.address()) < 0;
        }
        return this.upNumber() < other.upNumber();
    }

    public Member copy(MemberStatus status) {
        MemberStatus oldStatus = this.status();
        MemberStatus memberStatus = status;
        MemberStatus memberStatus2 = oldStatus;
        if (!(memberStatus != null ? !memberStatus.equals(memberStatus2) : memberStatus2 != null)) {
            return this;
        }
        Predef$.MODULE$.require(((SetOps)MemberStatus$.MODULE$.allowedTransitions().apply((Object)oldStatus)).apply((Object)status), () -> this.copy$$anonfun$1(status));
        return new Member(this.uniqueAddress(), this.upNumber(), status, this.roles(), this.appVersion());
    }

    public Member copyUp(int upNumber) {
        return new Member(this.uniqueAddress(), upNumber, this.status(), this.roles(), this.appVersion()).copy(MemberStatus$Up$.MODULE$);
    }

    private static final String dataCenter$lzyINIT1$$anonfun$2() {
        throw new IllegalStateException("DataCenter undefined, should not be possible");
    }

    private final Object copy$$anonfun$1(MemberStatus status$1) {
        return new StringBuilder(40).append("Invalid member status transition [ ").append(this).append(" -> ").append(status$1).append("]").toString();
    }
}

