/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$MemberRemoved$;
import org.apache.pekko.cluster.ClusterEvent$MemberUp$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Removed$;
import org.apache.pekko.cluster.MemberStatus$Up$;
import org.apache.pekko.cluster.UniqueAddress;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@InternalApi
public class OnMemberStatusChangedListener
implements Actor {
    private ActorContext context;
    private ActorRef self;
    private final Runnable callback;
    private final MemberStatus status;
    private final Cluster cluster;
    private final Class<? extends Serializable> to;

    public OnMemberStatusChangedListener(Runnable callback, MemberStatus status) {
        Class clazz;
        this.callback = callback;
        this.status = status;
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        MemberStatus memberStatus = status;
        if (MemberStatus$Up$.MODULE$.equals(memberStatus)) {
            clazz = ClusterEvent.MemberUp.class;
        } else if (MemberStatus$Removed$.MODULE$.equals(memberStatus)) {
            clazz = ClusterEvent.MemberRemoved.class;
        } else {
            MemberStatus other = memberStatus;
            throw new IllegalArgumentException(new StringBuilder(63).append("Expected Up or Removed in OnMemberStatusChangedListener, got [").append(other).append("]").toString());
        }
        this.to = clazz;
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public void preStart() {
        this.cluster.subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{this.to}));
    }

    public void postStop() {
        MemberStatus memberStatus = this.status;
        MemberStatus$Removed$ memberStatus$Removed$ = MemberStatus$Removed$.MODULE$;
        if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Removed$) : memberStatus$Removed$ != null)) {
            this.org$apache$pekko$cluster$OnMemberStatusChangedListener$$done();
        }
        this.cluster.unsubscribe(this.self());
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ OnMemberStatusChangedListener $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState state = (ClusterEvent.CurrentClusterState)object;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    Member member;
                    ClusterEvent.MemberUp memberUp = ClusterEvent$MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member member2 = member = memberUp._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member member3 = member;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState state = (ClusterEvent.CurrentClusterState)object;
                    if (state.members().exists((Function1 & Serializable)m -> this.$outer.org$apache$pekko$cluster$OnMemberStatusChangedListener$$isTriggered((Member)m))) {
                        this.$outer.org$apache$pekko$cluster$OnMemberStatusChangedListener$$done();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    ClusterEvent.MemberUp memberUp = ClusterEvent$MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member member = memberUp._1();
                    Member member2 = member;
                    if (this.$outer.org$apache$pekko$cluster$OnMemberStatusChangedListener$$isTriggered(member2)) {
                        this.$outer.org$apache$pekko$cluster$OnMemberStatusChangedListener$$done();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member member3 = member;
                    if (this.$outer.org$apache$pekko$cluster$OnMemberStatusChangedListener$$isTriggered(member3)) {
                        this.$outer.org$apache$pekko$cluster$OnMemberStatusChangedListener$$done();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$6(org.apache.pekko.cluster.Member )}, serializedLambda);
            }
        };
    }

    public void org$apache$pekko$cluster$OnMemberStatusChangedListener$$done() {
        block6: {
            try {
                try {
                    this.callback.run();
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable e = throwable3 = (Throwable)option.get();
                        this.cluster.ClusterLogger().logError(e, "[{}] callback failed with [{}]", (Object)new StringBuilder(2).append("On").append(this.to.getSimpleName()).toString(), (Object)e.getMessage());
                        break block6;
                    }
                    throw throwable;
                }
            }
            finally {
                this.context().stop(this.self());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$pekko$cluster$OnMemberStatusChangedListener$$isTriggered(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster.selfUniqueAddress();
        if (uniqueAddress == null) {
            if (uniqueAddress2 != null) {
                return false;
            }
        } else if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
        MemberStatus memberStatus = m.status();
        MemberStatus memberStatus2 = this.status;
        if (memberStatus == null) {
            if (memberStatus2 == null) return true;
            return false;
        } else {
            if (!memberStatus.equals(memberStatus2)) return false;
            return true;
        }
    }
}

