/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterLogMarker$;
import org.apache.pekko.cluster.ClusterUserAction$JoinTo$;
import org.apache.pekko.cluster.ConfigValidation;
import org.apache.pekko.cluster.InternalClusterAction;
import org.apache.pekko.cluster.InternalClusterAction$InitJoin$;
import org.apache.pekko.cluster.Invalid;
import org.apache.pekko.cluster.JoinConfigCompatChecker;
import org.apache.pekko.cluster.JoinConfigCompatChecker$;
import org.apache.pekko.cluster.Valid$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public abstract class SeedNodeProcess
implements Actor {
    private ActorContext context;
    private ActorRef self;
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final Cluster cluster;
    private final Address selfAddress;
    private final String JoinToIncompatibleConfigUnenforced;
    private final String ValidatedIncompatibleConfig;
    private final String NodeShutdownWarning;

    public SeedNodeProcess(JoinConfigCompatChecker joinConfigCompatChecker) {
        this.joinConfigCompatChecker = joinConfigCompatChecker;
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.selfAddress = this.cluster().selfAddress();
        this.JoinToIncompatibleConfigUnenforced = "Join will be performed because compatibility check is configured to not be enforced.";
        this.ValidatedIncompatibleConfig = "Cluster validated this node config, but sent back incompatible settings";
        this.NodeShutdownWarning = "It's recommended to perform a full cluster shutdown in order to deploy this new version. If a cluster shutdown isn't an option, you may want to disable this protection by setting 'pekko.cluster.configuration-compatibility-check.enforce-on-join = off'. Note that disabling it will allow the formation of a cluster with nodes having incompatible configuration settings. This node will be shutdown!";
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public Address selfAddress() {
        return this.selfAddress;
    }

    private void stopOrBecome(Option<PartialFunction<Object, BoxedUnit>> behavior) {
        Option<PartialFunction<Object, BoxedUnit>> option = behavior;
        if (option instanceof Some) {
            PartialFunction done = (PartialFunction)((Some)option).value();
            this.context().become(done);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.context().stop(this.self());
            return;
        }
        throw new MatchError(option);
    }

    public final void receiveJoinSeedNode(Set<Address> seedNodes) {
        Seq<String> requiredNonSensitiveKeys = JoinConfigCompatChecker$.MODULE$.removeSensitiveKeys(this.joinConfigCompatChecker.requiredKeys(), this.cluster().settings());
        Config configToValidate = JoinConfigCompatChecker$.MODULE$.filterWithKeys(requiredNonSensitiveKeys, this.context().system().settings().config());
        seedNodes.foreach((Function1)(JProcedure1 & Serializable)a -> ActorSelection$.MODULE$.toScala(this.context().actorSelection(this.context().parent().path().toStringWithAddress(a))).$bang((Object)InternalClusterAction$InitJoin$.MODULE$.apply(configToValidate), this.self()));
    }

    public final void receiveInitJoinAckIncompatibleConfig(Address joinTo, ActorRef origin, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        if (this.cluster().settings().ByPassConfigCompatCheck()) {
            this.logInitJoinAckReceived(origin);
            this.cluster().ClusterLogger().logWarning("Joining cluster with incompatible configurations. {}", this.JoinToIncompatibleConfigUnenforced);
            this.context().parent().$bang((Object)ClusterUserAction$JoinTo$.MODULE$.apply(joinTo), this.self());
            this.stopOrBecome(behavior);
            return;
        }
        this.cluster().ClusterLogger().logError(ClusterLogMarker$.MODULE$.joinFailed(), new StringBuilder(72).append("Couldn't join seed nodes because of incompatible cluster configuration. ").append(this.NodeShutdownWarning).toString());
        this.context().stop(this.self());
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system())).run((CoordinatedShutdown.Reason)CoordinatedShutdown.IncompatibleConfigurationDetectedReason$.MODULE$);
    }

    public final void receiveInitJoinAckCompatibleConfig(Address joinTo, ActorRef origin, InternalClusterAction.CompatibleConfig configCheck, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        this.logInitJoinAckReceived(origin);
        ConfigValidation configValidation = this.joinConfigCompatChecker.check(configCheck.clusterConfig(), this.context().system().settings().config());
        if (Valid$.MODULE$.equals(configValidation)) {
            this.context().parent().$bang((Object)ClusterUserAction$JoinTo$.MODULE$.apply(joinTo), this.self());
            this.stopOrBecome(behavior);
            return;
        }
        if (configValidation instanceof Invalid) {
            Invalid invalid;
            Invalid checked = invalid = (Invalid)configValidation;
            if (this.cluster().settings().ByPassConfigCompatCheck()) {
                this.logWarningInvalidConfigIfBypassConfigCheck(checked);
                this.context().parent().$bang((Object)ClusterUserAction$JoinTo$.MODULE$.apply(joinTo), this.self());
                this.stopOrBecome(behavior);
                return;
            }
            Invalid checked2 = invalid;
            this.logErrorInvalidConfig(checked2);
            this.context().stop(this.self());
            ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system())).run((CoordinatedShutdown.Reason)CoordinatedShutdown.IncompatibleConfigurationDetectedReason$.MODULE$);
            return;
        }
        throw new MatchError((Object)configValidation);
    }

    public final void receiveInitJoinAckUncheckedConfig(Address joinTo, ActorRef origin, Option<PartialFunction<Object, BoxedUnit>> behavior) {
        this.logInitJoinAckReceived(origin);
        this.cluster().ClusterLogger().logWarning("Joining a cluster without configuration compatibility check feature.");
        this.context().parent().$bang((Object)ClusterUserAction$JoinTo$.MODULE$.apply(joinTo), this.self());
        this.stopOrBecome(behavior);
    }

    private void logInitJoinAckReceived(ActorRef from) {
        this.cluster().ClusterLogger().logInfo("Received InitJoinAck message from [{}] to [{}]", from, (Object)this.selfAddress());
    }

    private void logWarningInvalidConfigIfBypassConfigCheck(Invalid invalid) {
        this.cluster().ClusterLogger().logWarning("{}: {}. {}.", (Object)this.ValidatedIncompatibleConfig, (Object)invalid.errorMessages().mkString(", "), (Object)this.JoinToIncompatibleConfigUnenforced);
    }

    private void logErrorInvalidConfig(Invalid validation) {
        this.cluster().ClusterLogger().logError("{}: {}. {}", (Object)this.ValidatedIncompatibleConfig, (Object)validation.errorMessages().mkString(", "), (Object)this.NodeShutdownWarning);
    }
}

