/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.routing;

import java.io.Serializable;
import org.apache.pekko.actor.ActorInitializationException$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$ReachableMember$;
import org.apache.pekko.cluster.ClusterEvent$UnreachableMember$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Up$;
import org.apache.pekko.cluster.MemberStatus$WeaklyUp$;
import org.apache.pekko.cluster.routing.ClusterRouterActor$;
import org.apache.pekko.cluster.routing.ClusterRouterSettingsBase;
import org.apache.pekko.routing.ActorRefRoutee;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.ActorSelectionRoutee;
import org.apache.pekko.routing.ActorSelectionRoutee$;
import org.apache.pekko.routing.Group;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.RouterActor;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public interface ClusterRouterActor {
    public static void $init$(ClusterRouterActor $this) {
        if (!(((RouterActor)$this).cell().routerConfig() instanceof Pool) && !(((RouterActor)$this).cell().routerConfig() instanceof Group)) {
            throw ActorInitializationException$.MODULE$.apply(new StringBuilder(67).append("Cluster router actor can only be used with Pool or Group, not with ").append(((RouterActor)$this).cell().routerConfig().getClass()).toString());
        }
        $this.nodes_$eq((SortedSet<Address>)((SortedSet)$this.cluster().readView().members().collect((PartialFunction)new Serializable($this){
            private final /* synthetic */ ClusterRouterActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Member x) {
                Member member = x;
                Member m = member;
                return this.$outer.isAvailable(m);
            }

            public final Object applyOrElse(Member x, Function1 function1) {
                Member member = x;
                Member m = member;
                if (this.$outer.isAvailable(m)) {
                    return m.address();
                }
                return function1.apply((Object)x);
            }
        }, Member$.MODULE$.addressOrdering())));
    }

    public ClusterRouterSettingsBase settings();

    public static Cluster cluster$(ClusterRouterActor $this) {
        return $this.cluster();
    }

    default public Cluster cluster() {
        return (Cluster)Cluster$.MODULE$.apply(((RouterActor)this).context().system());
    }

    public static void preStart$(ClusterRouterActor $this) {
        $this.preStart();
    }

    default public void preStart() {
        this.cluster().subscribe(((RouterActor)this).self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
    }

    public static void postStop$(ClusterRouterActor $this) {
        $this.postStop();
    }

    default public void postStop() {
        this.cluster().unsubscribe(((RouterActor)this).self());
    }

    public SortedSet<Address> nodes();

    public void nodes_$eq(SortedSet<Address> var1);

    public static boolean isAvailable$(ClusterRouterActor $this, Member m) {
        return $this.isAvailable(m);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isAvailable(Member m) {
        MemberStatus memberStatus = m.status();
        MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
        if (memberStatus == null ? memberStatus$Up$ != null : !memberStatus.equals(memberStatus$Up$)) {
            MemberStatus memberStatus2 = m.status();
            MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
            if (memberStatus2 == null) {
                if (memberStatus$WeaklyUp$ != null) {
                    return false;
                }
            } else if (!memberStatus2.equals(memberStatus$WeaklyUp$)) return false;
        }
        if (!this.satisfiesRoles(m.roles())) return false;
        if (this.settings().allowLocalRoutees()) return true;
        Address address = m.address();
        Address address2 = this.cluster().selfAddress();
        if (address == null) {
            if (address2 == null) return false;
            return true;
        } else if (address.equals(address2)) return false;
        return true;
    }

    private boolean satisfiesRoles(Set<String> memberRoles) {
        return this.settings().useRoles().subsetOf(memberRoles);
    }

    public static SortedSet availableNodes$(ClusterRouterActor $this) {
        return $this.availableNodes();
    }

    default public SortedSet<Address> availableNodes() {
        if (this.nodes().isEmpty() && this.settings().allowLocalRoutees() && this.satisfiesRoles(this.cluster().selfRoles())) {
            return (SortedSet)SortedSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Address[]{this.cluster().selfAddress()}), Member$.MODULE$.addressOrdering());
        }
        return this.nodes();
    }

    public static Address fullAddress$(ClusterRouterActor $this, Routee routee) {
        return $this.fullAddress(routee);
    }

    default public Address fullAddress(Routee routee) {
        Address address;
        Address address2;
        Routee routee2 = routee;
        if (routee2 instanceof ActorRefRoutee) {
            ActorRef actorRef;
            ActorRefRoutee actorRefRoutee = ActorRefRoutee$.MODULE$.unapply((ActorRefRoutee)routee2);
            ActorRef ref = actorRef = actorRefRoutee._1();
            address2 = ref.path().address();
        } else if (routee2 instanceof ActorSelectionRoutee) {
            ActorSelection actorSelection;
            ActorSelectionRoutee actorSelectionRoutee = ActorSelectionRoutee$.MODULE$.unapply((ActorSelectionRoutee)routee2);
            ActorSelection sel = actorSelection = actorSelectionRoutee._1();
            address2 = sel.anchor().path().address();
        } else {
            Routee unknown = routee2;
            throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported routee type: ").append(unknown.getClass()).toString());
        }
        Address address3 = address = address2;
        if (address3 != null) {
            Address address4 = Address$.MODULE$.unapply(address3);
            String string = address4._1();
            String string2 = address4._2();
            Option option = address4._3();
            Option option2 = address4._4();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return this.cluster().selfAddress();
            }
        }
        Address a = address3;
        return a;
    }

    public void addRoutees();

    public static void addMember$(ClusterRouterActor $this, Member member) {
        $this.addMember(member);
    }

    default public void addMember(Member member) {
        this.nodes_$eq((SortedSet<Address>)((SortedSet)this.nodes().$plus((Object)member.address())));
        this.addRoutees();
    }

    public static void removeMember$(ClusterRouterActor $this, Member member) {
        $this.removeMember(member);
    }

    default public void removeMember(Member member) {
        Address address = member.address();
        this.nodes_$eq((SortedSet<Address>)((SortedSet)this.nodes().$minus((Object)address)));
        IndexedSeq affectedRoutees = (IndexedSeq)((RouterActor)this).cell().router().routees().filter((Function1 & Serializable)_$3 -> {
            Address address = this.fullAddress((Routee)_$3);
            Address address2 = address;
            return !(address != null ? !address.equals(address2) : address2 != null);
        });
        ((RouterActor)this).cell().removeRoutees((Iterable)affectedRoutees, true);
        this.addRoutees();
    }

    public static PartialFunction clusterReceive$(ClusterRouterActor $this) {
        return $this.clusterReceive();
    }

    default public PartialFunction<Object, BoxedUnit> clusterReceive() {
        return new Serializable(this){
            private final /* synthetic */ ClusterRouterActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState s = (ClusterEvent.CurrentClusterState)object;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)object;
                    ClusterEvent.MemberEvent m = memberEvent;
                    if (this.$outer.isAvailable(m.member())) {
                        return true;
                    }
                    ClusterEvent.MemberEvent other = memberEvent;
                    return true;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    Member member;
                    ClusterEvent.UnreachableMember unreachableMember = ClusterEvent$UnreachableMember$.MODULE$.unapply((ClusterEvent.UnreachableMember)object);
                    Member m = member = unreachableMember._1();
                    return true;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    Member member;
                    ClusterEvent.ReachableMember reachableMember = ClusterEvent$ReachableMember$.MODULE$.unapply((ClusterEvent.ReachableMember)object);
                    Member m = member = reachableMember._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState s = (ClusterEvent.CurrentClusterState)object;
                    this.$outer.nodes_$eq((SortedSet<Address>)((SortedSet)s.members().collect((PartialFunction)new Serializable(this){
                        private final /* synthetic */ $anon$3 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Member x) {
                            Member member;
                            Member m = member = x;
                            return this.$outer.org$apache$pekko$cluster$routing$ClusterRouterActor$_$$anon$$$outer().isAvailable(m);
                        }

                        public final Object applyOrElse(Member x, Function1 function1) {
                            Member member;
                            Member m = member = x;
                            if (this.$outer.org$apache$pekko$cluster$routing$ClusterRouterActor$_$$anon$$$outer().isAvailable(m)) {
                                return m.address();
                            }
                            return function1.apply((Object)x);
                        }
                    }, Member$.MODULE$.addressOrdering())));
                    this.$outer.addRoutees();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent memberEvent = (ClusterEvent.MemberEvent)object;
                    ClusterEvent.MemberEvent m = memberEvent;
                    if (this.$outer.isAvailable(m.member())) {
                        this.$outer.addMember(m.member());
                        return BoxedUnit.UNIT;
                    }
                    ClusterEvent.MemberEvent other = memberEvent;
                    this.$outer.removeMember(other.member());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    Member member;
                    ClusterEvent.UnreachableMember unreachableMember = ClusterEvent$UnreachableMember$.MODULE$.unapply((ClusterEvent.UnreachableMember)object);
                    Member m = member = unreachableMember._1();
                    this.$outer.removeMember(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    ClusterEvent.ReachableMember reachableMember = ClusterEvent$ReachableMember$.MODULE$.unapply((ClusterEvent.ReachableMember)object);
                    Member member = reachableMember._1();
                    Member m = member;
                    if (this.$outer.isAvailable(m)) {
                        this.$outer.addMember(m);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            public final /* synthetic */ ClusterRouterActor org$apache$pekko$cluster$routing$ClusterRouterActor$_$$anon$$$outer() {
                return this.$outer;
            }
        };
    }
}

