/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.routing;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Set;
import org.apache.pekko.actor.RelativeActorPath$;
import org.apache.pekko.cluster.routing.ClusterRouterGroupSettings$;
import org.apache.pekko.cluster.routing.ClusterRouterSettingsBase;
import org.apache.pekko.japi.Util$;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class ClusterRouterGroupSettings
implements Product,
Serializable,
ClusterRouterSettingsBase {
    private static final long serialVersionUID = 1L;
    private final int totalInstances;
    private final Seq routeesPaths;
    private final boolean allowLocalRoutees;
    private final scala.collection.immutable.Set useRoles;

    public static ClusterRouterGroupSettings apply(int n, Seq<String> seq, boolean bl, Option<String> option) {
        return ClusterRouterGroupSettings$.MODULE$.apply(n, seq, bl, option);
    }

    public static ClusterRouterGroupSettings apply(int n, Seq<String> seq, boolean bl, Seq<String> seq2) {
        return ClusterRouterGroupSettings$.MODULE$.apply(n, seq, bl, seq2);
    }

    public static ClusterRouterGroupSettings apply(int n, Seq<String> seq, boolean bl, scala.collection.immutable.Set<String> set) {
        return ClusterRouterGroupSettings$.MODULE$.apply(n, seq, bl, set);
    }

    public static ClusterRouterGroupSettings apply(int n, Seq<String> seq, boolean bl, String ... stringArray) {
        return ClusterRouterGroupSettings$.MODULE$.apply(n, seq, bl, stringArray);
    }

    public static ClusterRouterGroupSettings fromConfig(Config config) {
        return ClusterRouterGroupSettings$.MODULE$.fromConfig(config);
    }

    public static Option<Tuple4<Object, Seq<String>, Object, scala.collection.immutable.Set<String>>> unapply(ClusterRouterGroupSettings clusterRouterGroupSettings) {
        return ClusterRouterGroupSettings$.MODULE$.unapply(clusterRouterGroupSettings);
    }

    public ClusterRouterGroupSettings(int totalInstances, Seq<String> routeesPaths, boolean allowLocalRoutees, scala.collection.immutable.Set<String> useRoles) {
        block5: {
            block4: {
                this.totalInstances = totalInstances;
                this.routeesPaths = routeesPaths;
                this.allowLocalRoutees = allowLocalRoutees;
                this.useRoles = useRoles;
                ClusterRouterSettingsBase.$init$(this);
                if (totalInstances <= 0) {
                    throw new IllegalArgumentException("totalInstances of cluster router must be > 0");
                }
                if (routeesPaths == null || routeesPaths.isEmpty()) break block4;
                Object object = routeesPaths.head();
                String string = "";
                if (object != null ? !object.equals(string) : string != null) break block5;
            }
            throw new IllegalArgumentException("routeesPaths must be defined");
        }
        routeesPaths.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Option option;
            String string = x$1;
            if (string != null && !(option = RelativeActorPath$.MODULE$.unapply(string)).isEmpty()) {
                Seq seq = (Seq)option.get();
                return;
            }
            String p = string;
            throw new IllegalArgumentException(new StringBuilder(69).append("routeesPaths [").append(p).append("] is not a valid actor path without address information").toString());
        });
    }

    @Override
    public int totalInstances() {
        return this.totalInstances;
    }

    public Seq<String> routeesPaths() {
        return this.routeesPaths;
    }

    @Override
    public boolean allowLocalRoutees() {
        return this.allowLocalRoutees;
    }

    @Override
    public scala.collection.immutable.Set<String> useRoles() {
        return this.useRoles;
    }

    public int hashCode() {
        int seed = HashCode$.MODULE$.SEED();
        seed = HashCode$.MODULE$.hash(seed, this.totalInstances());
        seed = HashCode$.MODULE$.hash(seed, this.routeesPaths());
        seed = HashCode$.MODULE$.hash(seed, this.allowLocalRoutees());
        seed = HashCode$.MODULE$.hash(seed, this.useRoles());
        return seed;
    }

    public boolean canEqual(Object that) {
        return that instanceof ClusterRouterGroupSettings;
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.totalInstances());
            }
            case 1: {
                return this.routeesPaths();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.allowLocalRoutees());
            }
            case 3: {
                return this.useRoles();
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ClusterRouterGroupSettings) {
            ClusterRouterGroupSettings that = (ClusterRouterGroupSettings)object;
            return BoxesRunTime.boxToInteger((int)this.totalInstances()).equals(BoxesRunTime.boxToInteger((int)that.totalInstances())) && this.routeesPaths().equals(that.routeesPaths()) && this.allowLocalRoutees() == that.allowLocalRoutees() && this.useRoles().equals(that.useRoles());
        }
        return false;
    }

    public String toString() {
        return new StringBuilder(31).append("ClusterRouterGroupSettings(").append(this.totalInstances()).append(",").append(this.routeesPaths()).append(",").append(this.allowLocalRoutees()).append(",").append(this.useRoles()).append(")").toString();
    }

    public Option<String> useRole() {
        return this.useRoles().headOption();
    }

    public ClusterRouterGroupSettings(int totalInstances, Seq<String> routeesPaths, boolean allowLocalRoutees, Option<String> useRole) {
        this(totalInstances, routeesPaths, allowLocalRoutees, (scala.collection.immutable.Set<String>)Option$.MODULE$.option2Iterable(useRole).toSet());
    }

    public ClusterRouterGroupSettings(int totalInstances, Iterable<String> routeesPaths, boolean allowLocalRoutees, String useRole) {
        this(totalInstances, (Seq<String>)Util$.MODULE$.immutableSeq(routeesPaths), allowLocalRoutees, (scala.collection.immutable.Set<String>)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)useRole)).toSet());
    }

    public ClusterRouterGroupSettings(int totalInstances, Iterable<String> routeesPaths, boolean allowLocalRoutees, Set<String> useRoles) {
        this(totalInstances, (Seq<String>)Util$.MODULE$.immutableSeq(routeesPaths), allowLocalRoutees, (scala.collection.immutable.Set<String>)package.JavaConverters$.MODULE$.SetHasAsScala(useRoles).asScala().toSet());
    }

    public ClusterRouterGroupSettings copy(int totalInstances, Seq<String> routeesPaths, boolean allowLocalRoutees, Option<String> useRole) {
        return new ClusterRouterGroupSettings(totalInstances, routeesPaths, allowLocalRoutees, useRole);
    }

    public int copy$default$1() {
        return this.totalInstances();
    }

    public Seq<String> copy$default$2() {
        return this.routeesPaths();
    }

    public boolean copy$default$3() {
        return this.allowLocalRoutees();
    }

    public Option<String> copy$default$4() {
        return this.useRole();
    }

    public ClusterRouterGroupSettings withUseRoles(scala.collection.immutable.Set<String> useRoles) {
        return new ClusterRouterGroupSettings(this.totalInstances(), this.routeesPaths(), this.allowLocalRoutees(), useRoles);
    }

    public ClusterRouterGroupSettings withUseRoles(Seq<String> useRoles) {
        return new ClusterRouterGroupSettings(this.totalInstances(), this.routeesPaths(), this.allowLocalRoutees(), (scala.collection.immutable.Set<String>)useRoles.toSet());
    }

    public ClusterRouterGroupSettings withUseRoles(String ... useRoles) {
        return this.withUseRoles((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])useRoles));
    }

    public ClusterRouterGroupSettings withUseRoles(Set<String> useRoles) {
        return new ClusterRouterGroupSettings(this.totalInstances(), this.routeesPaths(), this.allowLocalRoutees(), (scala.collection.immutable.Set<String>)package.JavaConverters$.MODULE$.SetHasAsScala(useRoles).asScala().toSet());
    }
}

