/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.routing;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Set;
import org.apache.pekko.cluster.routing.ClusterRouterPoolSettings$;
import org.apache.pekko.cluster.routing.ClusterRouterSettingsBase;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.ccompat.package;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ClusterRouterPoolSettings
implements Product,
Serializable,
ClusterRouterSettingsBase {
    private static final long serialVersionUID = 1L;
    private final int totalInstances;
    private final int maxInstancesPerNode;
    private final boolean allowLocalRoutees;
    private final scala.collection.immutable.Set useRoles;

    public static ClusterRouterPoolSettings apply(int n, int n2, boolean bl, Option<String> option) {
        return ClusterRouterPoolSettings$.MODULE$.apply(n, n2, bl, option);
    }

    public static ClusterRouterPoolSettings apply(int n, int n2, boolean bl, Seq<String> seq) {
        return ClusterRouterPoolSettings$.MODULE$.apply(n, n2, bl, seq);
    }

    public static ClusterRouterPoolSettings apply(int n, int n2, boolean bl, scala.collection.immutable.Set<String> set) {
        return ClusterRouterPoolSettings$.MODULE$.apply(n, n2, bl, set);
    }

    public static ClusterRouterPoolSettings apply(int n, int n2, boolean bl, String ... stringArray) {
        return ClusterRouterPoolSettings$.MODULE$.apply(n, n2, bl, stringArray);
    }

    public static ClusterRouterPoolSettings fromConfig(Config config) {
        return ClusterRouterPoolSettings$.MODULE$.fromConfig(config);
    }

    public static Option<Tuple4<Object, Object, Object, scala.collection.immutable.Set<String>>> unapply(ClusterRouterPoolSettings clusterRouterPoolSettings) {
        return ClusterRouterPoolSettings$.MODULE$.unapply(clusterRouterPoolSettings);
    }

    public ClusterRouterPoolSettings(int totalInstances, int maxInstancesPerNode, boolean allowLocalRoutees, scala.collection.immutable.Set<String> useRoles) {
        this.totalInstances = totalInstances;
        this.maxInstancesPerNode = maxInstancesPerNode;
        this.allowLocalRoutees = allowLocalRoutees;
        this.useRoles = useRoles;
        ClusterRouterSettingsBase.$init$(this);
        if (maxInstancesPerNode <= 0) {
            throw new IllegalArgumentException("maxInstancesPerNode of cluster pool router must be > 0");
        }
    }

    @Override
    public int totalInstances() {
        return this.totalInstances;
    }

    public int maxInstancesPerNode() {
        return this.maxInstancesPerNode;
    }

    @Override
    public boolean allowLocalRoutees() {
        return this.allowLocalRoutees;
    }

    @Override
    public scala.collection.immutable.Set<String> useRoles() {
        return this.useRoles;
    }

    public int hashCode() {
        int seed = HashCode$.MODULE$.SEED();
        seed = HashCode$.MODULE$.hash(seed, this.totalInstances());
        seed = HashCode$.MODULE$.hash(seed, this.maxInstancesPerNode());
        seed = HashCode$.MODULE$.hash(seed, this.allowLocalRoutees());
        seed = HashCode$.MODULE$.hash(seed, this.useRoles());
        return seed;
    }

    public boolean canEqual(Object that) {
        return that instanceof ClusterRouterPoolSettings;
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.totalInstances());
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.maxInstancesPerNode());
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.allowLocalRoutees());
            }
            case 3: {
                return this.useRoles();
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ClusterRouterPoolSettings) {
            ClusterRouterPoolSettings that = (ClusterRouterPoolSettings)object;
            return BoxesRunTime.boxToInteger((int)this.totalInstances()).equals(BoxesRunTime.boxToInteger((int)that.totalInstances())) && BoxesRunTime.boxToInteger((int)this.maxInstancesPerNode()).equals(BoxesRunTime.boxToInteger((int)that.maxInstancesPerNode())) && this.allowLocalRoutees() == that.allowLocalRoutees() && this.useRoles().equals(that.useRoles());
        }
        return false;
    }

    public String toString() {
        return new StringBuilder(30).append("ClusterRouterPoolSettings(").append(this.totalInstances()).append(",").append(this.maxInstancesPerNode()).append(",").append(this.allowLocalRoutees()).append(",").append(this.useRoles()).append(")").toString();
    }

    public Option<String> useRole() {
        return this.useRoles().headOption();
    }

    public ClusterRouterPoolSettings(int totalInstances, int maxInstancesPerNode, boolean allowLocalRoutees, Option<String> useRole) {
        this(totalInstances, maxInstancesPerNode, allowLocalRoutees, (scala.collection.immutable.Set<String>)Option$.MODULE$.option2Iterable(useRole).toSet());
    }

    public ClusterRouterPoolSettings(int totalInstances, int maxInstancesPerNode, boolean allowLocalRoutees, String useRole) {
        this(totalInstances, maxInstancesPerNode, allowLocalRoutees, (scala.collection.immutable.Set<String>)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)useRole)).toSet());
    }

    public ClusterRouterPoolSettings(int totalInstances, int maxInstancesPerNode, boolean allowLocalRoutees, Set<String> useRoles) {
        this(totalInstances, maxInstancesPerNode, allowLocalRoutees, (scala.collection.immutable.Set<String>)package.JavaConverters$.MODULE$.SetHasAsScala(useRoles).asScala().toSet());
    }

    public ClusterRouterPoolSettings copy(int totalInstances, int maxInstancesPerNode, boolean allowLocalRoutees, Option<String> useRole) {
        return new ClusterRouterPoolSettings(totalInstances, maxInstancesPerNode, allowLocalRoutees, useRole);
    }

    public int copy$default$1() {
        return this.totalInstances();
    }

    public int copy$default$2() {
        return this.maxInstancesPerNode();
    }

    public boolean copy$default$3() {
        return this.allowLocalRoutees();
    }

    public Option<String> copy$default$4() {
        return this.useRole();
    }

    public ClusterRouterPoolSettings withUseRoles(scala.collection.immutable.Set<String> useRoles) {
        return new ClusterRouterPoolSettings(this.totalInstances(), this.maxInstancesPerNode(), this.allowLocalRoutees(), useRoles);
    }

    public ClusterRouterPoolSettings withUseRoles(Seq<String> useRoles) {
        return new ClusterRouterPoolSettings(this.totalInstances(), this.maxInstancesPerNode(), this.allowLocalRoutees(), (scala.collection.immutable.Set<String>)useRoles.toSet());
    }

    public ClusterRouterPoolSettings withUseRoles(String ... useRoles) {
        return this.withUseRoles((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])useRoles));
    }

    public ClusterRouterPoolSettings withUseRoles(Set<String> useRoles) {
        return new ClusterRouterPoolSettings(this.totalInstances(), this.maxInstancesPerNode(), this.allowLocalRoutees(), (scala.collection.immutable.Set<String>)package.JavaConverters$.MODULE$.SetHasAsScala(useRoles).asScala().toSet());
    }
}

