/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sbr;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.sbr.DowningStrategy;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownAll$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownIndirectlyConnected$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownReachable$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownUnreachable$;
import scala.Option;
import scala.collection.immutable.SortedSet;

@InternalApi
public final class KeepMajority
extends DowningStrategy {
    private final Option role;

    public KeepMajority(String selfDc, Option<String> role, UniqueAddress selfUniqueAddress) {
        this.role = role;
        super(selfDc, selfUniqueAddress);
    }

    private String selfDc$accessor() {
        return super.selfDc();
    }

    @Override
    public Option<String> role() {
        return this.role;
    }

    @Override
    public DowningStrategy.Decision decide() {
        int unreachableSize;
        if (this.hasIndirectlyConnected()) {
            return DowningStrategy$DownIndirectlyConnected$.MODULE$;
        }
        SortedSet<Member> ms = this.membersWithRole();
        if (ms.isEmpty()) {
            return DowningStrategy$DownAll$.MODULE$;
        }
        int reachableSize = this.reachableMembersWithRole().size();
        DowningStrategy.Decision decision = this.majorityDecision(reachableSize, unreachableSize = this.unreachableMembersWithRole().size(), (Member)ms.head());
        if (DowningStrategy$DownUnreachable$.MODULE$.equals(decision)) {
            DowningStrategy.Decision decision2 = this.majorityDecisionWhenIncludingMembershipChangesEdgeCase();
            return (DowningStrategy.Decision)(DowningStrategy$DownUnreachable$.MODULE$.equals(decision2) ? DowningStrategy$DownUnreachable$.MODULE$ : DowningStrategy$DownAll$.MODULE$);
        }
        DowningStrategy.Decision decision3 = decision;
        return decision3;
    }

    private DowningStrategy.Decision majorityDecision(int thisSide, int otherSide, Member lowest) {
        if (thisSide == otherSide) {
            return (DowningStrategy.Decision)(this.unreachable(lowest) ? DowningStrategy$DownReachable$.MODULE$ : DowningStrategy$DownUnreachable$.MODULE$);
        }
        return (DowningStrategy.Decision)(thisSide > otherSide ? DowningStrategy$DownUnreachable$.MODULE$ : DowningStrategy$DownReachable$.MODULE$);
    }

    private DowningStrategy.Decision majorityDecisionWhenIncludingMembershipChangesEdgeCase() {
        SortedSet<Member> ms = this.membersWithRole(false, true);
        if (ms.isEmpty()) {
            return DowningStrategy$DownAll$.MODULE$;
        }
        int thisSideReachableSize = this.reachableMembersWithRole(false, true).size();
        int otherSideUnreachableSize = this.unreachableMembersWithRole(true, false).size();
        return this.majorityDecision(thisSideReachableSize, otherSideUnreachableSize, (Member)ms.head());
    }
}

