/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sbr;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.sbr.DowningStrategy;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownAll$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownIndirectlyConnected$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownReachable$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownUnreachable$;
import scala.Option;
import scala.collection.immutable.SortedSet;
import scala.math.Ordering;

@InternalApi
public final class KeepOldest
extends DowningStrategy {
    private final boolean downIfAlone;
    private final Option role;

    public KeepOldest(String selfDc, boolean downIfAlone, Option<String> role, UniqueAddress selfUniqueAddress) {
        this.downIfAlone = downIfAlone;
        this.role = role;
        super(selfDc, selfUniqueAddress);
    }

    private String selfDc$accessor() {
        return super.selfDc();
    }

    public boolean downIfAlone() {
        return this.downIfAlone;
    }

    @Override
    public Option<String> role() {
        return this.role;
    }

    @Override
    public Ordering<Member> ordering() {
        return Member$.MODULE$.ageOrdering();
    }

    @Override
    public DowningStrategy.Decision decide() {
        int unreachableCount;
        int reachableCount;
        if (this.hasIndirectlyConnected()) {
            return DowningStrategy$DownIndirectlyConnected$.MODULE$;
        }
        SortedSet<Member> ms = this.membersWithRole();
        if (ms.isEmpty()) {
            return DowningStrategy$DownAll$.MODULE$;
        }
        Member oldest = (Member)ms.head();
        boolean oldestIsReachable = !this.unreachable(oldest);
        DowningStrategy.Decision decision = this.oldestDecision(oldestIsReachable, reachableCount = this.reachableMembersWithRole().size(), unreachableCount = this.unreachableMembersWithRole().size());
        if (DowningStrategy$DownUnreachable$.MODULE$.equals(decision)) {
            DowningStrategy.Decision decision2 = this.oldestDecisionWhenIncludingMembershipChangesEdgeCase();
            return (DowningStrategy.Decision)(DowningStrategy$DownUnreachable$.MODULE$.equals(decision2) ? DowningStrategy$DownUnreachable$.MODULE$ : DowningStrategy$DownAll$.MODULE$);
        }
        DowningStrategy.Decision decision3 = decision;
        return decision3;
    }

    private DowningStrategy.Decision oldestDecision(boolean oldestIsOnThisSide, int thisSide, int otherSide) {
        if (oldestIsOnThisSide) {
            return (DowningStrategy.Decision)(this.downIfAlone() && thisSide == 1 && otherSide >= 2 ? DowningStrategy$DownReachable$.MODULE$ : DowningStrategy$DownUnreachable$.MODULE$);
        }
        return (DowningStrategy.Decision)(this.downIfAlone() && otherSide == 1 && thisSide >= 2 ? DowningStrategy$DownUnreachable$.MODULE$ : DowningStrategy$DownReachable$.MODULE$);
    }

    private DowningStrategy.Decision oldestDecisionWhenIncludingMembershipChangesEdgeCase() {
        SortedSet<Member> ms = this.membersWithRole(false, true);
        if (ms.isEmpty()) {
            return DowningStrategy$DownAll$.MODULE$;
        }
        Member oldest = (Member)ms.head();
        boolean oldestIsReachable = !this.unreachable(oldest);
        boolean includingPossiblyUp = this.downIfAlone();
        int reachableCount = this.reachableMembersWithRole(includingPossiblyUp, true).size();
        int unreachableCount = this.unreachableMembersWithRole(includingPossiblyUp, true).size();
        return this.oldestDecision(oldestIsReachable, reachableCount, unreachableCount);
    }
}

