/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sbr;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsEvents$;
import org.apache.pekko.cluster.ClusterLogMarker$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.sbr.DowningStrategy;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$AcquireLeaseResult$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$ReachabilityChangedStats$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$ReleaseLeaseCondition$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$ReleaseLeaseResult$;
import org.apache.pekko.cluster.sbr.SplitBrainResolverBase;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.remote.artery.ThisActorSystemQuarantinedEvent;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public final class SplitBrainResolver
extends SplitBrainResolverBase
implements Actor {
    private final Cluster cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());

    public static Props props(FiniteDuration finiteDuration, DowningStrategy downingStrategy) {
        return SplitBrainResolver$.MODULE$.props(finiteDuration, downingStrategy);
    }

    public SplitBrainResolver(FiniteDuration stableAfter, DowningStrategy strategy) {
        super(stableAfter, strategy);
        FiniteDuration finiteDuration = this.downAllWhenUnstable();
        FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
        this.log().info(new StringBuilder(118).append("SBR started. Config: strategy [{}], stable-after [{}], down-all-when-unstable [{}], selfUniqueAddress [{}], selfDc [").append(this.selfDc()).append("].").toString(), (Object)Logging$.MODULE$.simpleName(strategy.getClass()), (Object)stableAfter.toCoarsest(), (Object)(!(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null) ? "off" : this.downAllWhenUnstable().toCoarsest()), (Object)new StringBuilder(1).append(this.selfUniqueAddress().address()).append("#").append(this.selfUniqueAddress().longUid()).toString());
    }

    @Override
    public UniqueAddress selfUniqueAddress() {
        return this.cluster.selfUniqueAddress();
    }

    @Override
    public String selfDc() {
        return this.cluster.selfDataCenter();
    }

    @Override
    public void preStart() {
        this.cluster.subscribe(this.self(), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsEvents$.MODULE$, (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.ClusterDomainEvent.class}));
        this.context().system().eventStream().subscribe(this.self(), ThisActorSystemQuarantinedEvent.class);
        Actor.preStart$((Actor)this);
    }

    @Override
    public void postStop() {
        this.cluster.unsubscribe(this.self());
        this.context().system().eventStream().unsubscribe(this.self(), ThisActorSystemQuarantinedEvent.class);
        super.postStop();
    }

    @Override
    public void down(UniqueAddress node, DowningStrategy.Decision decision) {
        this.log().info(ClusterLogMarker$.MODULE$.sbrDowningNode(node, decision), "SBR is downing [{}]", (Object)node);
        this.cluster.down(node.address());
    }

    public static final class AcquireLeaseResult
    implements Product,
    Serializable {
        private final boolean holdingLease;

        public static AcquireLeaseResult apply(boolean bl) {
            return SplitBrainResolver$AcquireLeaseResult$.MODULE$.apply(bl);
        }

        public static AcquireLeaseResult fromProduct(Product product) {
            return SplitBrainResolver$AcquireLeaseResult$.MODULE$.fromProduct(product);
        }

        public static AcquireLeaseResult unapply(AcquireLeaseResult acquireLeaseResult) {
            return SplitBrainResolver$AcquireLeaseResult$.MODULE$.unapply(acquireLeaseResult);
        }

        public AcquireLeaseResult(boolean holdingLease) {
            this.holdingLease = holdingLease;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.holdingLease() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AcquireLeaseResult)) return false;
            AcquireLeaseResult acquireLeaseResult = (AcquireLeaseResult)object;
            if (this.holdingLease() != acquireLeaseResult.holdingLease()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AcquireLeaseResult;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "AcquireLeaseResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "holdingLease";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean holdingLease() {
            return this.holdingLease;
        }

        public AcquireLeaseResult copy(boolean holdingLease) {
            return new AcquireLeaseResult(holdingLease);
        }

        public boolean copy$default$1() {
            return this.holdingLease();
        }

        public boolean _1() {
            return this.holdingLease();
        }
    }

    public static final class ReachabilityChangedStats
    implements Product,
    Serializable {
        private final long firstChangeTimestamp;
        private final long latestChangeTimestamp;
        private final long changeCount;

        public static ReachabilityChangedStats apply(long l, long l2, long l3) {
            return SplitBrainResolver$ReachabilityChangedStats$.MODULE$.apply(l, l2, l3);
        }

        public static ReachabilityChangedStats fromProduct(Product product) {
            return SplitBrainResolver$ReachabilityChangedStats$.MODULE$.fromProduct(product);
        }

        public static ReachabilityChangedStats unapply(ReachabilityChangedStats reachabilityChangedStats) {
            return SplitBrainResolver$ReachabilityChangedStats$.MODULE$.unapply(reachabilityChangedStats);
        }

        public ReachabilityChangedStats(long firstChangeTimestamp, long latestChangeTimestamp, long changeCount) {
            this.firstChangeTimestamp = firstChangeTimestamp;
            this.latestChangeTimestamp = latestChangeTimestamp;
            this.changeCount = changeCount;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.firstChangeTimestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.latestChangeTimestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.changeCount()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReachabilityChangedStats)) return false;
            ReachabilityChangedStats reachabilityChangedStats = (ReachabilityChangedStats)object;
            if (this.firstChangeTimestamp() != reachabilityChangedStats.firstChangeTimestamp()) return false;
            if (this.latestChangeTimestamp() != reachabilityChangedStats.latestChangeTimestamp()) return false;
            if (this.changeCount() != reachabilityChangedStats.changeCount()) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ReachabilityChangedStats;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ReachabilityChangedStats";
        }

        public Object productElement(int n) {
            long l;
            int n2 = n;
            switch (n2) {
                case 0: {
                    l = this._1();
                    break;
                }
                case 1: {
                    l = this._2();
                    break;
                }
                case 2: {
                    l = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return BoxesRunTime.boxToLong((long)l);
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "firstChangeTimestamp";
                }
                case 1: {
                    return "latestChangeTimestamp";
                }
                case 2: {
                    return "changeCount";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long firstChangeTimestamp() {
            return this.firstChangeTimestamp;
        }

        public long latestChangeTimestamp() {
            return this.latestChangeTimestamp;
        }

        public long changeCount() {
            return this.changeCount;
        }

        public boolean isEmpty() {
            return this.changeCount() == 0L;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "reachability unchanged";
            }
            long now = System.nanoTime();
            return new StringBuilder(43).append("reachability changed ").append(this.changeCount()).append(" times since ").append(new package.DurationLong(package$.MODULE$.DurationLong(now - this.firstChangeTimestamp())).nanos().toMillis()).append(" ms ago, ").append(new StringBuilder(25).append("latest change was ").append(new package.DurationLong(package$.MODULE$.DurationLong(now - this.latestChangeTimestamp())).nanos().toMillis()).append(" ms ago").toString()).toString();
        }

        public ReachabilityChangedStats copy(long firstChangeTimestamp, long latestChangeTimestamp, long changeCount) {
            return new ReachabilityChangedStats(firstChangeTimestamp, latestChangeTimestamp, changeCount);
        }

        public long copy$default$1() {
            return this.firstChangeTimestamp();
        }

        public long copy$default$2() {
            return this.latestChangeTimestamp();
        }

        public long copy$default$3() {
            return this.changeCount();
        }

        public long _1() {
            return this.firstChangeTimestamp();
        }

        public long _2() {
            return this.latestChangeTimestamp();
        }

        public long _3() {
            return this.changeCount();
        }
    }

    public static interface ReleaseLeaseCondition {
        public static int ordinal(ReleaseLeaseCondition releaseLeaseCondition) {
            return SplitBrainResolver$ReleaseLeaseCondition$.MODULE$.ordinal(releaseLeaseCondition);
        }
    }

    public static final class ReleaseLeaseResult
    implements Product,
    Serializable {
        private final boolean released;

        public static ReleaseLeaseResult apply(boolean bl) {
            return SplitBrainResolver$ReleaseLeaseResult$.MODULE$.apply(bl);
        }

        public static ReleaseLeaseResult fromProduct(Product product) {
            return SplitBrainResolver$ReleaseLeaseResult$.MODULE$.fromProduct(product);
        }

        public static ReleaseLeaseResult unapply(ReleaseLeaseResult releaseLeaseResult) {
            return SplitBrainResolver$ReleaseLeaseResult$.MODULE$.unapply(releaseLeaseResult);
        }

        public ReleaseLeaseResult(boolean released) {
            this.released = released;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.released() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReleaseLeaseResult)) return false;
            ReleaseLeaseResult releaseLeaseResult = (ReleaseLeaseResult)object;
            if (this.released() != releaseLeaseResult.released()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReleaseLeaseResult;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ReleaseLeaseResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "released";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean released() {
            return this.released;
        }

        public ReleaseLeaseResult copy(boolean released) {
            return new ReleaseLeaseResult(released);
        }

        public boolean copy$default$1() {
            return this.released();
        }

        public boolean _1() {
            return this.released();
        }
    }
}

