/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sbr;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sbr.KeepOldestSettings;
import org.apache.pekko.cluster.sbr.KeepOldestSettings$;
import org.apache.pekko.cluster.sbr.LeaseMajoritySettings;
import org.apache.pekko.cluster.sbr.LeaseMajoritySettings$;
import org.apache.pekko.cluster.sbr.SplitBrainResolverSettings$;
import org.apache.pekko.cluster.sbr.StaticQuorumSettings;
import org.apache.pekko.cluster.sbr.StaticQuorumSettings$;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@InternalApi
public final class SplitBrainResolverSettings {
    private final Config cc;
    private final FiniteDuration DowningStableAfter;
    private final String DowningStrategy;
    private final FiniteDuration DownAllWhenUnstable;

    public static String DownAllName() {
        return SplitBrainResolverSettings$.MODULE$.DownAllName();
    }

    public static String KeepMajorityName() {
        return SplitBrainResolverSettings$.MODULE$.KeepMajorityName();
    }

    public static String KeepOldestName() {
        return SplitBrainResolverSettings$.MODULE$.KeepOldestName();
    }

    public static String LeaseMajorityName() {
        return SplitBrainResolverSettings$.MODULE$.LeaseMajorityName();
    }

    public static String StaticQuorumName() {
        return SplitBrainResolverSettings$.MODULE$.StaticQuorumName();
    }

    public static Set<String> allStrategyNames() {
        return SplitBrainResolverSettings$.MODULE$.allStrategyNames();
    }

    public SplitBrainResolverSettings(Config config) {
        FiniteDuration finiteDuration;
        String string;
        this.cc = config.getConfig("pekko.cluster.split-brain-resolver");
        String key = "stable-after";
        FiniteDuration finiteDuration2 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)FiniteDuration$.MODULE$.apply(this.cc.getDuration(key).toMillis(), TimeUnit.MILLISECONDS));
        this.DowningStableAfter = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration2, (Function1 & Serializable)_$1 -> _$1.$greater$eq((Object)Duration$.MODULE$.Zero()), () -> SplitBrainResolverSettings.$init$$$anonfun$2(key));
        String strategyName = string = this.cc.getString("active-strategy").toLowerCase(Locale.ROOT);
        if (!SplitBrainResolverSettings$.MODULE$.allStrategyNames().apply((Object)strategyName)) {
            String unknown = string;
            throw new ConfigurationException(new StringBuilder(45).append("Unknown downing strategy [").append(unknown).append("]. Select one of [").append(SplitBrainResolverSettings$.MODULE$.allStrategyNames().mkString(",")).append("]").toString());
        }
        this.DowningStrategy = strategyName;
        String key2 = "down-all-when-unstable";
        String string2 = Helpers$.MODULE$.toRootLowerCase(this.cc.getString("down-all-when-unstable"));
        if ("on".equals(string2)) {
            finiteDuration = new package.DurationInt(package$.MODULE$.DurationInt(4)).seconds().max(this.DowningStableAfter().$times(3L).$div(4L));
        } else if ("off".equals(string2)) {
            finiteDuration = Duration$.MODULE$.Zero();
        } else {
            FiniteDuration finiteDuration3 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)FiniteDuration$.MODULE$.apply(this.cc.getDuration(key2).toMillis(), TimeUnit.MILLISECONDS));
            finiteDuration = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration3, (Function1 & Serializable)_$2 -> _$2.$greater((Object)Duration$.MODULE$.Zero()), () -> SplitBrainResolverSettings.$init$$$anonfun$4(key2));
        }
        this.DownAllWhenUnstable = finiteDuration;
    }

    public FiniteDuration DowningStableAfter() {
        return this.DowningStableAfter;
    }

    public String DowningStrategy() {
        return this.DowningStrategy;
    }

    public FiniteDuration DownAllWhenUnstable() {
        return this.DownAllWhenUnstable;
    }

    public Option<String> keepMajorityRole() {
        return this.role(this.strategyConfig("keep-majority"));
    }

    public StaticQuorumSettings staticQuorumSettings() {
        Config c = this.strategyConfig("static-quorum");
        Integer n = (Integer)Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)c.getInt("quorum-size")));
        int size = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension((Object)n, (Function1)(JFunction1.mcZI.sp & Serializable)_$3 -> _$3 >= 1, SplitBrainResolverSettings::$anonfun$2));
        return StaticQuorumSettings$.MODULE$.apply(size, this.role(c));
    }

    public KeepOldestSettings keepOldestSettings() {
        Config c = this.strategyConfig("keep-oldest");
        boolean downIfAlone = c.getBoolean("down-if-alone");
        return KeepOldestSettings$.MODULE$.apply(downIfAlone, this.role(c));
    }

    public LeaseMajoritySettings leaseMajoritySettings() {
        None$ none$;
        String leaseImplementation;
        Config c = this.strategyConfig("lease-majority");
        String string = leaseImplementation = c.getString("lease-implementation");
        String string2 = "";
        Predef$.MODULE$.require(string == null ? string2 != null : !string.equals(string2), SplitBrainResolverSettings::leaseMajoritySettings$$anonfun$1);
        FiniteDuration acquireLeaseDelayForMinority = FiniteDuration$.MODULE$.apply(c.getDuration("acquire-lease-delay-for-minority").toMillis(), TimeUnit.MILLISECONDS);
        String string3 = c.getString("lease-name").trim();
        if ("".equals(string3)) {
            none$ = None$.MODULE$;
        } else {
            String name = string3;
            none$ = Some$.MODULE$.apply((Object)name);
        }
        None$ leaseName = none$;
        FiniteDuration releaseAfter = FiniteDuration$.MODULE$.apply(c.getDuration("release-after").toMillis(), TimeUnit.MILLISECONDS);
        return LeaseMajoritySettings$.MODULE$.apply(leaseImplementation, acquireLeaseDelayForMinority, releaseAfter, this.role(c), (Option<String>)leaseName);
    }

    private Config strategyConfig(String strategyName) {
        return this.cc.getConfig(strategyName);
    }

    private Option<String> role(Config c) {
        String string = c.getString("role");
        if ("".equals(string)) {
            return None$.MODULE$;
        }
        String r = string;
        return Some$.MODULE$.apply((Object)r);
    }

    private static final Object $init$$$anonfun$2(String key$1) {
        return new StringBuilder(6).append(key$1).append(" >= 0s").toString();
    }

    private static final Object $init$$$anonfun$4(String key$2) {
        return new StringBuilder(26).append(key$2).append(" > 0s, or 'off' to disable").toString();
    }

    private static final Object $anonfun$2() {
        return new StringBuilder(73).append("pekko.cluster.split-brain-resolver.").append("static-quorum").append(".quorum-size must be >= 1").toString();
    }

    private static final Object leaseMajoritySettings$$anonfun$1() {
        return new StringBuilder(86).append("pekko.cluster.split-brain-resolver.").append("lease-majority").append(".lease-implementation must be defined").toString();
    }
}

