/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefProvider;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.RootActorPath;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.Cluster$ClusterLogger$;
import org.apache.pekko.cluster.ClusterActorRefProvider;
import org.apache.pekko.cluster.ClusterDaemon;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$InitialStateAsSnapshot$;
import org.apache.pekko.cluster.ClusterJmx;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterReadView;
import org.apache.pekko.cluster.ClusterSettings;
import org.apache.pekko.cluster.ClusterSettings$;
import org.apache.pekko.cluster.ClusterUserAction;
import org.apache.pekko.cluster.ClusterUserAction$Down$;
import org.apache.pekko.cluster.ClusterUserAction$JoinTo$;
import org.apache.pekko.cluster.ClusterUserAction$Leave$;
import org.apache.pekko.cluster.ClusterUserAction$PrepareForShutdown$;
import org.apache.pekko.cluster.DowningProvider;
import org.apache.pekko.cluster.DowningProvider$;
import org.apache.pekko.cluster.InternalClusterAction;
import org.apache.pekko.cluster.InternalClusterAction$AddOnMemberRemovedListener$;
import org.apache.pekko.cluster.InternalClusterAction$AddOnMemberUpListener$;
import org.apache.pekko.cluster.InternalClusterAction$GetClusterCoreRef$;
import org.apache.pekko.cluster.InternalClusterAction$JoinSeedNodes$;
import org.apache.pekko.cluster.InternalClusterAction$SendCurrentClusterState$;
import org.apache.pekko.cluster.InternalClusterAction$Subscribe$;
import org.apache.pekko.cluster.InternalClusterAction$Unsubscribe$;
import org.apache.pekko.cluster.JoinConfigCompatChecker;
import org.apache.pekko.cluster.JoinConfigCompatChecker$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.UniqueAddress$;
import org.apache.pekko.dispatch.MonitorableThreadFactory;
import org.apache.pekko.event.LogMarker;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.japi.Util$;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.remote.AddressUidExtension;
import org.apache.pekko.remote.AddressUidExtension$;
import org.apache.pekko.remote.DefaultFailureDetectorRegistry;
import org.apache.pekko.remote.FailureDetectorLoader$;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public class Cluster
implements Extension {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Cluster.class.getDeclaredField("ClusterLogger$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Cluster.class.getDeclaredField("downingProvider$lzy1"));
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    public final MarkerLoggingAdapter org$apache$pekko$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry failureDetector;
    private final FailureDetectorRegistry crossDcFailureDetector;
    private volatile Object downingProvider$lzy1;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile Object ClusterLogger$lzy1;

    public static Extension apply(ActorSystem actorSystem) {
        return Cluster$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Cluster$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Cluster createExtension(ExtendedActorSystem extendedActorSystem) {
        return Cluster$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Cluster get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    public static Cluster get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Cluster$.MODULE$.get(classicActorSystemProvider);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Cluster$.MODULE$.get(classicActorSystemProvider);
    }

    public static boolean isAssertInvariantsEnabled() {
        return Cluster$.MODULE$.isAssertInvariantsEnabled();
    }

    public static ExtensionId<? extends Extension> lookup() {
        return Cluster$.MODULE$.lookup();
    }

    public Cluster(ExtendedActorSystem system) {
        Scheduler scheduler;
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        JoinConfigCompatChecker joinConfigCompatChecker = JoinConfigCompatChecker$.MODULE$.load(system, this.settings());
        ActorRefProvider actorRefProvider = system.provider();
        if (!(actorRefProvider instanceof ClusterActorRefProvider)) {
            ActorRefProvider other = actorRefProvider;
            throw new ConfigurationException(new StringBuilder(108).append("ActorSystem [").append(system).append("] needs to have 'pekko.actor.provider' set to 'cluster' in the configuration, currently uses [").append(other.getClass().getName()).append("]").toString());
        }
        ClusterActorRefProvider c = (ClusterActorRefProvider)actorRefProvider;
        this.selfUniqueAddress = UniqueAddress$.MODULE$.apply(c.transport().defaultAddress(), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)system)).longAddressUid());
        this._isTerminated = new AtomicBoolean(false);
        this.org$apache$pekko$cluster$Cluster$$log = Logging$.MODULE$.withMarker((ActorSystem)system, ClusterLogClass$.MODULE$.ClusterCore(), LogSource$.MODULE$.fromAnyClass());
        this.clusterJmx = None$.MODULE$;
        this.ClusterLogger().logInfo("Starting up, Pekko version [{}] ...", (Object)system.settings().ConfigVersion());
        Function0 & Serializable createFailureDetector = (Function0 & Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().FailureDetectorImplementationClass(), this.settings().FailureDetectorConfig(), (ActorSystem)system);
        this.failureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector);
        Function0 & Serializable createFailureDetector2 = (Function0 & Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().ImplementationClass(), this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().config(), (ActorSystem)system);
        this.crossDcFailureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector2);
        package.DurationInt durationInt = new package.DurationInt(package$.MODULE$.DurationInt(1));
        if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
            ThreadFactory threadFactory;
            this.ClusterLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'pekko.scheduler.tick-duration' [{} ms] <=  'pekko.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), (Object)BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
            Config cfg = ConfigFactory.parseString((String)new StringBuilder(32).append("pekko.scheduler.tick-duration=").append(this.settings().SchedulerTickDuration().toMillis()).append("ms").toString()).withFallback((ConfigMergeable)system.settings().config());
            ThreadFactory threadFactory2 = system.threadFactory();
            if (threadFactory2 instanceof MonitorableThreadFactory) {
                MonitorableThreadFactory tf = (MonitorableThreadFactory)threadFactory2;
                threadFactory = tf.withName(new StringBuilder(18).append(tf.name()).append("-cluster-scheduler").toString());
            } else {
                ThreadFactory tf;
                threadFactory = tf = threadFactory2;
            }
            ThreadFactory threadFactory3 = threadFactory;
            Object[] objectArray = new Tuple2[3];
            Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(Config.class);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)cfg);
            Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class);
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)this.org$apache$pekko$cluster$Cluster$$log);
            Class clazz3 = (Class)Predef$.MODULE$.ArrowAssoc(ThreadFactory.class);
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz3, (Object)threadFactory3);
            scheduler = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), ClassTag$.MODULE$.apply(Scheduler.class)).get();
        } else {
            Scheduler systemScheduler = system.scheduler();
            scheduler = new Scheduler(systemScheduler){
                private final Scheduler systemScheduler$1;
                {
                    this.systemScheduler$1 = systemScheduler$2;
                }

                public void close() {
                }

                public double maxFrequency() {
                    return this.systemScheduler$1.maxFrequency();
                }

                public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.schedule(initialDelay, interval, runnable, executor);
                }

                public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.scheduleOnce(delay, runnable, executor);
                }
            };
        }
        this.scheduler = scheduler;
        this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{joinConfigCompatChecker})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
        Timeout timeout = system.settings().CreationTimeout();
        this.clusterCore = this.liftedTree1$1(timeout, system);
        this.readView = new ClusterReadView(this);
        system.registerOnTermination((Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        if (this.settings().JmxEnabled()) {
            ClusterJmx jmx = new ClusterJmx(this, (LoggingAdapter)this.org$apache$pekko$cluster$Cluster$$log);
            jmx.createMBean();
            this.clusterJmx = Some$.MODULE$.apply((Object)jmx);
        }
        this.ClusterLogger().logInfo("Started up successfully");
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public String selfDataCenter() {
        return this.settings().SelfDataCenter();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return package.JavaConverters$.MODULE$.SetHasAsJava(this.selfRoles()).asJava();
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    public DowningProvider downingProvider() {
        Object object = this.downingProvider$lzy1;
        if (object instanceof DowningProvider) {
            return (DowningProvider)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DowningProvider)this.downingProvider$lzyINIT1();
    }

    private Object downingProvider$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.downingProvider$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DowningProvider downingProvider = null;
                    try {
                        this.checkAutoDownUsage();
                        downingProvider = DowningProvider$.MODULE$.load(this.settings().DowningProviderClassName(), (ActorSystem)this.system());
                        object2 = downingProvider == null ? LazyVals.NullValue$.MODULE$ : downingProvider;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.downingProvider$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return downingProvider;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private void checkAutoDownUsage() {
        block3: {
            block2: {
                String string = this.settings().DowningProviderClassName();
                String string2 = "org.apache.pekko.cluster.AutoDowning";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                if (!this.settings().config().hasPath("auto-down-unreachable-after")) break block3;
                String string3 = this.settings().config().getString("auto-down-unreachable-after");
                String string4 = "off";
                if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block3;
            }
            this.ClusterLogger().logWarning("auto-down has been removed in Akka 2.6.0. See https://pekko.apache.org/docs/pekko/current/typed/cluster.html#downing for alternatives.");
            return;
        }
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated.get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public Member selfMember() {
        return this.readView().self();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        this.subscribe(subscriber, (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsSnapshot$.MODULE$, to);
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        Predef$.MODULE$.require(to.length() > 0, Cluster::subscribe$$anonfun$1);
        Predef$.MODULE$.require(to.forall((Function1 & Serializable)x$0 -> ClusterEvent.ClusterDomainEvent.class.isAssignableFrom((Class<?>)x$0)), () -> Cluster.subscribe$$anonfun$3(to));
        InternalClusterAction.Subscribe subscribe = InternalClusterAction$Subscribe$.MODULE$.apply(subscriber, initialStateMode, to.toSet());
        this.clusterCore().$bang((Object)subscribe, this.clusterCore().$bang$default$2((Object)subscribe));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])to));
    }

    public void unsubscribe(ActorRef subscriber) {
        InternalClusterAction.Unsubscribe unsubscribe = InternalClusterAction$Unsubscribe$.MODULE$.apply(subscriber, (Option<Class<?>>)None$.MODULE$);
        this.clusterCore().$bang((Object)unsubscribe, this.clusterCore().$bang$default$2((Object)unsubscribe));
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        InternalClusterAction.Unsubscribe unsubscribe = InternalClusterAction$Unsubscribe$.MODULE$.apply(subscriber, (Option<Class<?>>)Some$.MODULE$.apply(to));
        this.clusterCore().$bang((Object)unsubscribe, this.clusterCore().$bang$default$2((Object)unsubscribe));
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        InternalClusterAction.SendCurrentClusterState sendCurrentClusterState = InternalClusterAction$SendCurrentClusterState$.MODULE$.apply(receiver);
        this.clusterCore().$bang((Object)sendCurrentClusterState, this.clusterCore().$bang$default$2((Object)sendCurrentClusterState));
    }

    public void join(Address address) {
        address.checkHostCharacters();
        ClusterUserAction.JoinTo joinTo = ClusterUserAction$JoinTo$.MODULE$.apply(this.fillLocal(address));
        this.clusterCore().$bang((Object)joinTo, this.clusterCore().$bang$default$2((Object)joinTo));
    }

    public void prepareForFullClusterShutdown() {
        ClusterUserAction$PrepareForShutdown$ clusterUserAction$PrepareForShutdown$ = ClusterUserAction$PrepareForShutdown$.MODULE$;
        this.clusterCore().$bang((Object)clusterUserAction$PrepareForShutdown$, this.clusterCore().$bang$default$2((Object)clusterUserAction$PrepareForShutdown$));
    }

    private Address fillLocal(Address address) {
        if (address.hasLocalScope()) {
            String string = address.system();
            String string2 = this.selfAddress().system();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return this.selfAddress();
            }
        }
        return address;
    }

    public void joinSeedNodes(Seq<Address> seedNodes) {
        seedNodes.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.checkHostCharacters());
        InternalClusterAction.JoinSeedNodes joinSeedNodes = InternalClusterAction$JoinSeedNodes$.MODULE$.apply((IndexedSeq<Address>)((IndexedSeq)seedNodes.toVector().map((Function1 & Serializable)address -> this.fillLocal((Address)address))));
        this.clusterCore().$bang((Object)joinSeedNodes, this.clusterCore().$bang$default$2((Object)joinSeedNodes));
    }

    public void joinSeedNodes(List<Address> seedNodes) {
        this.joinSeedNodes((Seq<Address>)Util$.MODULE$.immutableSeq(seedNodes));
    }

    public void leave(Address address) {
        ClusterUserAction.Leave leave = ClusterUserAction$Leave$.MODULE$.apply(this.fillLocal(address));
        this.clusterCore().$bang((Object)leave, this.clusterCore().$bang$default$2((Object)leave));
    }

    public void down(Address address) {
        ClusterUserAction.Down down = ClusterUserAction$Down$.MODULE$.apply(this.fillLocal(address));
        this.clusterCore().$bang((Object)down, this.clusterCore().$bang$default$2((Object)down));
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(code){
            private final Function0 code$1;
            {
                this.code$1 = code$3;
            }

            public void run() {
                this.code$1.apply();
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        InternalClusterAction.AddOnMemberUpListener addOnMemberUpListener = InternalClusterAction$AddOnMemberUpListener$.MODULE$.apply(callback);
        this.clusterDaemons.$bang((Object)addOnMemberUpListener, this.clusterDaemons.$bang$default$2((Object)addOnMemberUpListener));
    }

    public <T> void registerOnMemberRemoved(Function0<T> code) {
        this.registerOnMemberRemoved(new Runnable(code){
            private final Function0 code$2;
            {
                this.code$2 = code$4;
            }

            public void run() {
                this.code$2.apply();
            }
        });
    }

    public void registerOnMemberRemoved(Runnable callback) {
        if (this._isTerminated.get()) {
            callback.run();
            return;
        }
        InternalClusterAction.AddOnMemberRemovedListener addOnMemberRemovedListener = InternalClusterAction$AddOnMemberRemovedListener$.MODULE$.apply(callback);
        this.clusterDaemons.$bang((Object)addOnMemberRemovedListener, this.clusterDaemons.$bang$default$2((Object)addOnMemberRemovedListener));
    }

    public ActorPath remotePathOf(ActorRef actorRef) {
        ActorPath path = actorRef.path();
        if (path.address().host().isDefined()) {
            return path;
        }
        RootActorPath rootActorPath = path.root();
        return rootActorPath.copy(this.selfAddress(), rootActorPath.copy$default$2()).$div((Iterable)path.elements()).withUid(path.uid());
    }

    @InternalApi
    public void shutdown() {
        if (this._isTerminated.compareAndSet(false, true)) {
            this.ClusterLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons);
            if (this.readView() != null) {
                this.readView().close();
            }
            this.closeScheduler();
            this.clusterJmx.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.unregisterMBean());
            this.ClusterLogger().logInfo("Successfully shut down");
            return;
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Closeable x = (Closeable)scheduler;
            x.close();
            return;
        }
    }

    public final Cluster$ClusterLogger$ ClusterLogger() {
        Object object = this.ClusterLogger$lzy1;
        if (object instanceof Cluster$ClusterLogger$) {
            return (Cluster$ClusterLogger$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Cluster$ClusterLogger$)this.ClusterLogger$lzyINIT1();
    }

    private Object ClusterLogger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ClusterLogger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Cluster$ClusterLogger$ cluster$ClusterLogger$ = null;
                    try {
                        cluster$ClusterLogger$ = new Cluster$ClusterLogger$(this);
                        object2 = cluster$ClusterLogger$ == null ? LazyVals.NullValue$.MODULE$ : cluster$ClusterLogger$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ClusterLogger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cluster$ClusterLogger$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final ActorRef liftedTree1$1(Timeout timeout$1, ExtendedActorSystem system$3) {
        ActorRef actorRef;
        try {
            ActorRef actorRef2 = org.apache.pekko.pattern.package$.MODULE$.ask(this.clusterDaemons);
            InternalClusterAction$GetClusterCoreRef$ internalClusterAction$GetClusterCoreRef$ = InternalClusterAction$GetClusterCoreRef$.MODULE$;
            actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(actorRef2, (Object)internalClusterAction$GetClusterCoreRef$, timeout$1, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef2, (Object)internalClusterAction$GetClusterCoreRef$)).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.org$apache$pekko$cluster$Cluster$$log.error(e, "Failed to startup Cluster. You can try to increase 'pekko.actor.creation-timeout'.");
                this.shutdown();
                actorRef = system$3.deadLetters();
            }
            throw throwable;
        }
        return actorRef;
    }

    private final void $init$$$anonfun$1() {
        this.shutdown();
    }

    private static final Object subscribe$$anonfun$1() {
        return "at least one `ClusterDomainEvent` class is required";
    }

    private static final Object subscribe$$anonfun$3(Seq to$1) {
        return new StringBuilder(93).append("subscribe to `org.apache.pekko.cluster.ClusterEvent.ClusterDomainEvent` or subclasses, was [").append(((IterableOnceOps)to$1.map((Function1 & Serializable)_$1 -> _$1.getName())).mkString(", ")).append("]").toString();
    }

    public class ClusterLogger {
        private final MarkerLoggingAdapter log;
        private final /* synthetic */ Cluster $outer;

        public ClusterLogger(Cluster $outer, MarkerLoggingAdapter log) {
            this.log = log;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void logDebug(String message) {
            if (this.$outer.settings().LogInfo() && this.log.isDebugEnabled()) {
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), message);
                return;
            }
        }

        public void logDebug(String template, Object arg1) {
            if (this.$outer.settings().LogInfo() && this.log.isDebugEnabled()) {
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logDebug(String template, Object arg1, Object arg2) {
            if (this.$outer.settings().LogInfo() && this.log.isDebugEnabled()) {
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logDebug(String template, Object arg1, Object arg2, Object arg3) {
            if (this.$outer.settings().LogInfo() && this.log.isDebugEnabled()) {
                this.logAtLevel(Logging$.MODULE$.DebugLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
                return;
            }
        }

        public void logInfo(String message) {
            if (this.$outer.settings().LogInfo() && this.log.isInfoEnabled()) {
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), message);
                return;
            }
        }

        public void logInfo(LogMarker marker, String message) {
            if (this.$outer.settings().LogInfo() && this.log.isInfoEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), message);
                return;
            }
        }

        public void logInfo(String template, Object arg1) {
            if (this.$outer.settings().LogInfo() && this.log.isInfoEnabled()) {
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logInfo(LogMarker marker, String template, Object arg1) {
            if (this.$outer.settings().LogInfo() && this.log.isInfoEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logInfo(String template, Object arg1, Object arg2) {
            if (this.$outer.settings().LogInfo() && this.log.isInfoEnabled()) {
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logInfo(LogMarker marker, String template, Object arg1, Object arg2) {
            if (this.$outer.settings().LogInfo() && this.log.isInfoEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logInfo(String template, Object arg1, Object arg2, Object arg3) {
            if (this.$outer.settings().LogInfo() && this.log.isInfoEnabled()) {
                this.logAtLevel(Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
                return;
            }
        }

        public void logInfo(LogMarker marker, String template, Object arg1, Object arg2, Object arg3) {
            if (this.$outer.settings().LogInfo() && this.log.isInfoEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.InfoLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
                return;
            }
        }

        public void logWarning(String message) {
            if (this.log.isWarningEnabled()) {
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), message);
                return;
            }
        }

        public void logWarning(String template, Object arg1) {
            if (this.log.isWarningEnabled()) {
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logWarning(LogMarker marker, String template, Object arg1) {
            if (this.log.isWarningEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logWarning(String template, Object arg1, Object arg2) {
            if (this.log.isWarningEnabled()) {
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logWarning(LogMarker marker, String template, Object arg1, Object arg2) {
            if (this.log.isWarningEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logWarning(String template, Object arg1, Object arg2, Object arg3) {
            if (this.log.isWarningEnabled()) {
                this.logAtLevel(Logging$.MODULE$.WarningLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
                return;
            }
        }

        public void logError(String message) {
            if (this.log.isErrorEnabled()) {
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), message);
                return;
            }
        }

        public void logError(LogMarker marker, String message) {
            if (this.log.isErrorEnabled(marker)) {
                this.logAtLevel(marker, Logging$.MODULE$.ErrorLevel(), message);
                return;
            }
        }

        public void logError(String template, Object arg1) {
            if (this.log.isErrorEnabled()) {
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
                return;
            }
        }

        public void logError(String template, Object arg1, Object arg2) {
            if (this.log.isErrorEnabled()) {
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
                return;
            }
        }

        public void logError(String template, Object arg1, Object arg2, Object arg3) {
            if (this.log.isErrorEnabled()) {
                this.logAtLevel(Logging$.MODULE$.ErrorLevel(), this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
                return;
            }
        }

        public void logError(Throwable cause, String message) {
            String string = this.$outer.settings().SelfDataCenter();
            String string2 = ClusterSettings$.MODULE$.DefaultDataCenter();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log.error(cause, "Cluster Node [{}] - {}", (Object)this.$outer.selfAddress(), (Object)message);
                return;
            }
            this.log.error(cause, "Cluster Node [{}] dc [{}] - {}", (Object)this.$outer.selfAddress(), (Object)this.$outer.settings().SelfDataCenter(), (Object)message);
        }

        public void logError(Throwable cause, String template, Object arg1) {
            this.logError(cause, this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1})));
        }

        public void logError(Throwable cause, String template, Object arg1, Object arg2) {
            this.logError(cause, this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2})));
        }

        public void logError(Throwable cause, String template, Object arg1, Object arg2, Object arg3) {
            this.logError(cause, this.log.format(template, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg1, arg2, arg3})));
        }

        private void logAtLevel(int logLevel, String message) {
            String string = this.$outer.settings().SelfDataCenter();
            String string2 = ClusterSettings$.MODULE$.DefaultDataCenter();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log.log(logLevel, "Cluster Node [{}] - {}", (Object)this.$outer.selfAddress(), (Object)message);
                return;
            }
            this.log.log(logLevel, "Cluster Node [{}] dc [{}] - {}", (Object)this.$outer.selfAddress(), (Object)this.$outer.settings().SelfDataCenter(), (Object)message);
        }

        private void logAtLevel(LogMarker marker, int logLevel, String message) {
            String string = this.$outer.settings().SelfDataCenter();
            String string2 = ClusterSettings$.MODULE$.DefaultDataCenter();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log.log(marker, logLevel, this.log.format("Cluster Node [{}] - {}", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.selfAddress(), message})));
                return;
            }
            this.log.log(marker, logLevel, this.log.format("Cluster Node [{}] dc [{}] - {}", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.selfAddress(), this.$outer.settings().SelfDataCenter(), message})));
        }

        public final /* synthetic */ Cluster org$apache$pekko$cluster$Cluster$ClusterLogger$$$outer() {
            return this.$outer;
        }
    }
}

