/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.RootActorPath$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterCoreDaemon$;
import org.apache.pekko.cluster.ClusterCoreDaemon$Ignored$;
import org.apache.pekko.cluster.ClusterCoreDaemon$Merge$;
import org.apache.pekko.cluster.ClusterCoreDaemon$Newer$;
import org.apache.pekko.cluster.ClusterCoreDaemon$Older$;
import org.apache.pekko.cluster.ClusterCoreDaemon$Same$;
import org.apache.pekko.cluster.ClusterEvent$CurrentInternalStats$;
import org.apache.pekko.cluster.ClusterHeartbeatSender;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterLogMarker$;
import org.apache.pekko.cluster.ClusterUserAction;
import org.apache.pekko.cluster.ClusterUserAction$Down$;
import org.apache.pekko.cluster.ClusterUserAction$JoinTo$;
import org.apache.pekko.cluster.ClusterUserAction$Leave$;
import org.apache.pekko.cluster.ClusterUserAction$PrepareForShutdown$;
import org.apache.pekko.cluster.ConfigValidation;
import org.apache.pekko.cluster.CrossDcHeartbeatSender;
import org.apache.pekko.cluster.FirstSeedNodeProcess;
import org.apache.pekko.cluster.Gossip;
import org.apache.pekko.cluster.Gossip$;
import org.apache.pekko.cluster.GossipEnvelope;
import org.apache.pekko.cluster.GossipEnvelope$;
import org.apache.pekko.cluster.GossipOverview;
import org.apache.pekko.cluster.GossipStats;
import org.apache.pekko.cluster.GossipStats$;
import org.apache.pekko.cluster.GossipStatus;
import org.apache.pekko.cluster.GossipStatus$;
import org.apache.pekko.cluster.GossipTargetSelector;
import org.apache.pekko.cluster.InternalClusterAction;
import org.apache.pekko.cluster.InternalClusterAction$CompatibleConfig$;
import org.apache.pekko.cluster.InternalClusterAction$ConfigCheckUnsupportedByJoiningNode$;
import org.apache.pekko.cluster.InternalClusterAction$ExitingCompleted$;
import org.apache.pekko.cluster.InternalClusterAction$ExitingConfirmed$;
import org.apache.pekko.cluster.InternalClusterAction$GossipSpeedupTick$;
import org.apache.pekko.cluster.InternalClusterAction$GossipTick$;
import org.apache.pekko.cluster.InternalClusterAction$IncompatibleConfig$;
import org.apache.pekko.cluster.InternalClusterAction$InitJoin$;
import org.apache.pekko.cluster.InternalClusterAction$InitJoinAck$;
import org.apache.pekko.cluster.InternalClusterAction$InitJoinNack$;
import org.apache.pekko.cluster.InternalClusterAction$Join$;
import org.apache.pekko.cluster.InternalClusterAction$JoinSeedNodes$;
import org.apache.pekko.cluster.InternalClusterAction$LeaderActionsTick$;
import org.apache.pekko.cluster.InternalClusterAction$PublishChanges$;
import org.apache.pekko.cluster.InternalClusterAction$PublishStatsTick$;
import org.apache.pekko.cluster.InternalClusterAction$ReapUnreachableTick$;
import org.apache.pekko.cluster.InternalClusterAction$SendGossipTo$;
import org.apache.pekko.cluster.InternalClusterAction$Welcome$;
import org.apache.pekko.cluster.Invalid;
import org.apache.pekko.cluster.Invalid$;
import org.apache.pekko.cluster.JoinConfigCompatChecker;
import org.apache.pekko.cluster.JoinConfigCompatChecker$;
import org.apache.pekko.cluster.JoinSeedNodeProcess;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.MemberStatus$Exiting$;
import org.apache.pekko.cluster.MemberStatus$Joining$;
import org.apache.pekko.cluster.MemberStatus$Leaving$;
import org.apache.pekko.cluster.MemberStatus$PreparingForShutdown$;
import org.apache.pekko.cluster.MemberStatus$ReadyForShutdown$;
import org.apache.pekko.cluster.MemberStatus$Removed$;
import org.apache.pekko.cluster.MemberStatus$Up$;
import org.apache.pekko.cluster.MemberStatus$WeaklyUp$;
import org.apache.pekko.cluster.MembershipState;
import org.apache.pekko.cluster.MembershipState$;
import org.apache.pekko.cluster.Reachability;
import org.apache.pekko.cluster.Reachability$Terminated$;
import org.apache.pekko.cluster.Reachability$Unreachable$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.UniqueAddress$;
import org.apache.pekko.cluster.Valid$;
import org.apache.pekko.cluster.VectorClock;
import org.apache.pekko.cluster.VectorClock$After$;
import org.apache.pekko.cluster.VectorClock$Before$;
import org.apache.pekko.cluster.VectorClock$Concurrent$;
import org.apache.pekko.cluster.VectorClock$Node$;
import org.apache.pekko.cluster.VectorClock$Same$;
import org.apache.pekko.cluster.VectorClockStats;
import org.apache.pekko.cluster.VectorClockStats$;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.event.ActorWithLogClass$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.remote.QuarantinedEvent;
import org.apache.pekko.remote.QuarantinedEvent$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.apache.pekko.util.Version;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.SetOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

@InternalApi
public class ClusterCoreDaemon
implements Actor,
RequiresMessageQueue<UnboundedMessageQueueSemantics> {
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(ClusterCoreDaemon.class.getDeclaredField("Merge$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(ClusterCoreDaemon.class.getDeclaredField("Same$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(ClusterCoreDaemon.class.getDeclaredField("Newer$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ClusterCoreDaemon.class.getDeclaredField("Older$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ClusterCoreDaemon.class.getDeclaredField("Ignored$lzy1"));
    private ActorContext context;
    private ActorRef self;
    public final ActorRef org$apache$pekko$cluster$ClusterCoreDaemon$$publisher;
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final Cluster cluster;
    private final String selfDc;
    private final Cluster.ClusterLogger gossipLogger;
    private final String vclockNode;
    private final GossipTargetSelector gossipTargetSelector;
    private MembershipState membershipState;
    private boolean isCurrentlyLeader;
    private final boolean statsEnabled;
    private GossipStats gossipStats;
    private IndexedSeq seedNodes;
    private Option seedNodeProcess;
    private int seedNodeProcessCounter;
    private Option joinSeedNodesDeadline;
    private int leaderActionCounter;
    private int selfDownCounter;
    private boolean preparingForShutdown;
    private boolean exitingTasksInProgress;
    private final Promise selfExiting;
    private final CoordinatedShutdown coordShutdown;
    private Set exitingConfirmed;
    private final Cancellable gossipTask;
    private final Cancellable failureDetectorReaperTask;
    private final Cancellable leaderActionsTask;
    private final Option publishStatsTask;
    private volatile Object Ignored$lzy1;
    private volatile Object Older$lzy1;
    private volatile Object Newer$lzy1;
    private volatile Object Same$lzy1;
    private volatile Object Merge$lzy1;

    public static int MaxGossipsBeforeShuttingDownMyself() {
        return ClusterCoreDaemon$.MODULE$.MaxGossipsBeforeShuttingDownMyself();
    }

    public static int MaxTicksBeforeShuttingDownMyself() {
        return ClusterCoreDaemon$.MODULE$.MaxTicksBeforeShuttingDownMyself();
    }

    public static int NumberOfGossipsBeforeShutdownWhenLeaderExits() {
        return ClusterCoreDaemon$.MODULE$.NumberOfGossipsBeforeShutdownWhenLeaderExits();
    }

    public ClusterCoreDaemon(ActorRef publisher, JoinConfigCompatChecker joinConfigCompatChecker) {
        None$ none$;
        this.org$apache$pekko$cluster$ClusterCoreDaemon$$publisher = publisher;
        this.joinConfigCompatChecker = joinConfigCompatChecker;
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.selfDc = this.cluster().selfDataCenter();
        this.gossipLogger = new Cluster.ClusterLogger(this.cluster(), Logging$.MODULE$.withMarker(this.context().system(), (Object)ActorWithLogClass$.MODULE$.apply((Actor)this, ClusterLogClass$.MODULE$.ClusterGossip()), LogSource$.MODULE$.fromActorWithLoggerClass()));
        this.vclockNode = VectorClock$Node$.MODULE$.apply(Gossip$.MODULE$.vclockName(this.selfUniqueAddress()));
        this.gossipTargetSelector = new GossipTargetSelector(Int$.MODULE$.int2double(this.cluster().settings().ReduceGossipDifferentViewProbability()), this.cluster().settings().MultiDataCenter().CrossDcGossipProbability());
        this.membershipState = MembershipState$.MODULE$.apply(Gossip$.MODULE$.empty(), this.cluster().selfUniqueAddress(), this.cluster().settings().SelfDataCenter(), this.cluster().settings().MultiDataCenter().CrossDcConnections());
        this.isCurrentlyLeader = false;
        this.statsEnabled = this.cluster().settings().PublishStatsInterval().isFinite();
        this.gossipStats = GossipStats$.MODULE$.apply(GossipStats$.MODULE$.$lessinit$greater$default$1(), GossipStats$.MODULE$.$lessinit$greater$default$2(), GossipStats$.MODULE$.$lessinit$greater$default$3(), GossipStats$.MODULE$.$lessinit$greater$default$4(), GossipStats$.MODULE$.$lessinit$greater$default$5());
        this.seedNodes = this.cluster().settings().SeedNodes();
        this.seedNodeProcess = None$.MODULE$;
        this.seedNodeProcessCounter = 0;
        this.joinSeedNodesDeadline = None$.MODULE$;
        this.leaderActionCounter = 0;
        this.selfDownCounter = 0;
        this.preparingForShutdown = false;
        this.exitingTasksInProgress = false;
        this.selfExiting = Promise$.MODULE$.apply();
        this.coordShutdown = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system());
        this.coordShutdown().addTask(CoordinatedShutdown$.MODULE$.PhaseClusterExiting(), "wait-exiting", (Function0 & Serializable)() -> {
            if (this.latestGossip().members().isEmpty()) {
                return Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            return this.selfExiting().future();
        });
        ActorSystem sys = this.context().system();
        this.coordShutdown().addTask(CoordinatedShutdown$.MODULE$.PhaseClusterExitingDone(), "exiting-completed", (Function0 & Serializable)() -> {
            block3: {
                block2: {
                    if (((Cluster)Cluster$.MODULE$.apply(sys)).isTerminated()) break block2;
                    MemberStatus memberStatus = ((Cluster)Cluster$.MODULE$.apply(sys)).selfMember().status();
                    MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                    if (memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null) break block3;
                }
                return Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            Timeout timeout = Timeout$.MODULE$.apply(this.coordShutdown().timeout(CoordinatedShutdown$.MODULE$.PhaseClusterExitingDone()));
            return AskableActorRef$.MODULE$.ask$extension(package$.MODULE$.ask(this.self()), (Object)InternalClusterAction$ExitingCompleted$.MODULE$, timeout, this.self()).mapTo(ClassTag$.MODULE$.apply(Done.class));
        });
        this.exitingConfirmed = Predef$.MODULE$.Set().empty();
        this.gossipTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().GossipInterval()), this.cluster().settings().GossipInterval(), this.self(), (Object)InternalClusterAction$GossipTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.failureDetectorReaperTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().UnreachableNodesReaperInterval()), this.cluster().settings().UnreachableNodesReaperInterval(), this.self(), (Object)InternalClusterAction$ReapUnreachableTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.leaderActionsTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().LeaderActionsInterval()), this.cluster().settings().LeaderActionsInterval(), this.self(), (Object)InternalClusterAction$LeaderActionsTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        Duration duration = this.cluster().settings().PublishStatsInterval();
        FiniteDuration finiteDuration = Duration$.MODULE$.Zero();
        Duration duration2 = duration;
        if (!(finiteDuration == null ? duration2 != null : !finiteDuration.equals(duration2)) || duration instanceof Duration.Infinite) {
            none$ = None$.MODULE$;
        } else if (duration instanceof FiniteDuration) {
            FiniteDuration d = (FiniteDuration)duration;
            none$ = Some$.MODULE$.apply((Object)this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(d), d, this.self(), (Object)InternalClusterAction$PublishStatsTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self()));
        } else {
            throw new MatchError((Object)duration);
        }
        this.publishStatsTask = none$;
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public String selfDc() {
        return this.selfDc;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.cluster().selfUniqueAddress();
    }

    public String vclockNode() {
        return this.vclockNode;
    }

    public GossipTargetSelector gossipTargetSelector() {
        return this.gossipTargetSelector;
    }

    public MembershipState membershipState() {
        return this.membershipState;
    }

    public void membershipState_$eq(MembershipState x$1) {
        this.membershipState = x$1;
    }

    public boolean isCurrentlyLeader() {
        return this.isCurrentlyLeader;
    }

    public void isCurrentlyLeader_$eq(boolean x$1) {
        this.isCurrentlyLeader = x$1;
    }

    public Gossip latestGossip() {
        return this.membershipState().latestGossip();
    }

    public boolean statsEnabled() {
        return this.statsEnabled;
    }

    public GossipStats gossipStats() {
        return this.gossipStats;
    }

    public void gossipStats_$eq(GossipStats x$1) {
        this.gossipStats = x$1;
    }

    public IndexedSeq<Address> seedNodes() {
        return this.seedNodes;
    }

    public void seedNodes_$eq(IndexedSeq<Address> x$1) {
        this.seedNodes = x$1;
    }

    public Option<ActorRef> seedNodeProcess() {
        return this.seedNodeProcess;
    }

    public void seedNodeProcess_$eq(Option<ActorRef> x$1) {
        this.seedNodeProcess = x$1;
    }

    public int seedNodeProcessCounter() {
        return this.seedNodeProcessCounter;
    }

    public void seedNodeProcessCounter_$eq(int x$1) {
        this.seedNodeProcessCounter = x$1;
    }

    public Option<Deadline> joinSeedNodesDeadline() {
        return this.joinSeedNodesDeadline;
    }

    public void joinSeedNodesDeadline_$eq(Option<Deadline> x$1) {
        this.joinSeedNodesDeadline = x$1;
    }

    public int leaderActionCounter() {
        return this.leaderActionCounter;
    }

    public void leaderActionCounter_$eq(int x$1) {
        this.leaderActionCounter = x$1;
    }

    public int selfDownCounter() {
        return this.selfDownCounter;
    }

    public void selfDownCounter_$eq(int x$1) {
        this.selfDownCounter = x$1;
    }

    public boolean preparingForShutdown() {
        return this.preparingForShutdown;
    }

    public void preparingForShutdown_$eq(boolean x$1) {
        this.preparingForShutdown = x$1;
    }

    public boolean exitingTasksInProgress() {
        return this.exitingTasksInProgress;
    }

    public void exitingTasksInProgress_$eq(boolean x$1) {
        this.exitingTasksInProgress = x$1;
    }

    public Promise<Done> selfExiting() {
        return this.selfExiting;
    }

    public CoordinatedShutdown coordShutdown() {
        return this.coordShutdown;
    }

    public Set<UniqueAddress> exitingConfirmed() {
        return this.exitingConfirmed;
    }

    public void exitingConfirmed_$eq(Set<UniqueAddress> x$1) {
        this.exitingConfirmed = x$1;
    }

    private ActorSelection clusterCore(Address address) {
        return this.context().actorSelection(RootActorPath$.MODULE$.apply(address, RootActorPath$.MODULE$.$lessinit$greater$default$2()).$div("system").$div("cluster").$div("core").$div("daemon"));
    }

    public Cancellable gossipTask() {
        return this.gossipTask;
    }

    public Cancellable failureDetectorReaperTask() {
        return this.failureDetectorReaperTask;
    }

    public Cancellable leaderActionsTask() {
        return this.leaderActionsTask;
    }

    public Option<Cancellable> publishStatsTask() {
        return this.publishStatsTask;
    }

    public void preStart() {
        BoxedUnit boxedUnit;
        this.subscribeQuarantinedEvent();
        Option<Props> option = this.cluster().downingProvider().downingActorProps();
        if (option instanceof Some) {
            Props props = (Props)((Some)option).value();
            String string = props.dispatcher();
            String string2 = "";
            Props propsWithDispatcher = !(string != null ? !string.equals(string2) : string2 != null) ? props.withDispatcher(this.context().props().dispatcher()) : props;
            boxedUnit = this.context().actorOf(propsWithDispatcher, "downingProvider");
        } else if (None$.MODULE$.equals(option)) {
            this.cluster().ClusterLogger().logInfo("No downing-provider-class configured, manual cluster downing required, see https://pekko.apache.org/docs/pekko/current/typed/cluster.html#downing");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        if (this.seedNodes().isEmpty()) {
            if (this.isClusterBootstrapAvailable()) {
                this.cluster().ClusterLogger().logInfo("No seed nodes found in configuration, relying on Cluster Bootstrap for joining");
                return;
            }
            this.cluster().ClusterLogger().logInfo("No seed-nodes configured, manual cluster join required, see https://pekko.apache.org/docs/pekko/current/typed/cluster.html#joining");
            return;
        }
        this.self().$bang((Object)InternalClusterAction$JoinSeedNodes$.MODULE$.apply(this.seedNodes()), this.self());
    }

    private void subscribeQuarantinedEvent() {
        this.context().system().eventStream().subscribe(this.self(), org.apache.pekko.remote.artery.QuarantinedEvent.class);
        this.context().system().eventStream().subscribe(this.self(), QuarantinedEvent.class);
    }

    private boolean isClusterBootstrapAvailable() {
        return this.context().system().settings().config().hasPath("pekko.management.cluster.bootstrap");
    }

    public void postStop() {
        this.context().system().eventStream().unsubscribe(this.self());
        this.gossipTask().cancel();
        this.failureDetectorReaperTask().cancel();
        this.leaderActionsTask().cancel();
        this.publishStatsTask().foreach((Function1 & Serializable)_$3 -> _$3.cancel());
        this.selfExiting().trySuccess((Object)Done$.MODULE$);
    }

    public PartialFunction<Object, BoxedUnit> uninitialized() {
        return new Serializable(this){
            private final /* synthetic */ ClusterCoreDaemon $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof InternalClusterAction.InitJoin) {
                    InternalClusterAction.InitJoin initJoin = InternalClusterAction$InitJoin$.MODULE$.unapply((InternalClusterAction.InitJoin)object);
                    Config config = initJoin._1();
                    return true;
                }
                if (object instanceof ClusterUserAction.JoinTo) {
                    Address address;
                    ClusterUserAction.JoinTo joinTo = ClusterUserAction$JoinTo$.MODULE$.unapply((ClusterUserAction.JoinTo)object);
                    Address address2 = address = joinTo._1();
                    return true;
                }
                if (object instanceof InternalClusterAction.JoinSeedNodes) {
                    IndexedSeq<Address> indexedSeq;
                    InternalClusterAction.JoinSeedNodes joinSeedNodes = InternalClusterAction$JoinSeedNodes$.MODULE$.unapply((InternalClusterAction.JoinSeedNodes)object);
                    IndexedSeq<Address> newSeedNodes = indexedSeq = joinSeedNodes._1();
                    return true;
                }
                if (object instanceof InternalClusterAction.SubscriptionMessage) {
                    InternalClusterAction.SubscriptionMessage msg = (InternalClusterAction.SubscriptionMessage)object;
                    return true;
                }
                if (object instanceof InternalClusterAction.Welcome) {
                    InternalClusterAction.Welcome welcome = InternalClusterAction$Welcome$.MODULE$.unapply((InternalClusterAction.Welcome)object);
                    UniqueAddress uniqueAddress = welcome._1();
                    Gossip gossip = welcome._2();
                    UniqueAddress from = uniqueAddress;
                    Gossip gossip2 = gossip;
                    return true;
                }
                return object instanceof InternalClusterAction.Tick;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof InternalClusterAction.InitJoin) {
                    InternalClusterAction.InitJoin initJoin = InternalClusterAction$InitJoin$.MODULE$.unapply((InternalClusterAction.InitJoin)object);
                    Config config = initJoin._1();
                    this.$outer.cluster().ClusterLogger().logInfo("Received InitJoin message from [{}], but this node is not initialized yet", this.$outer.sender());
                    this.$outer.sender().$bang((Object)InternalClusterAction$InitJoinNack$.MODULE$.apply(this.$outer.cluster().selfAddress()), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterUserAction.JoinTo) {
                    Address address;
                    ClusterUserAction.JoinTo joinTo = ClusterUserAction$JoinTo$.MODULE$.unapply((ClusterUserAction.JoinTo)object);
                    Address address2 = address = joinTo._1();
                    this.$outer.join(address2);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.JoinSeedNodes) {
                    IndexedSeq<Address> indexedSeq;
                    InternalClusterAction.JoinSeedNodes joinSeedNodes = InternalClusterAction$JoinSeedNodes$.MODULE$.unapply((InternalClusterAction.JoinSeedNodes)object);
                    IndexedSeq<Address> newSeedNodes = indexedSeq = joinSeedNodes._1();
                    this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$resetJoinSeedNodesDeadline();
                    this.$outer.joinSeedNodes(newSeedNodes);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.SubscriptionMessage) {
                    InternalClusterAction.SubscriptionMessage msg = (InternalClusterAction.SubscriptionMessage)object;
                    this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$publisher.forward((Object)msg, this.$outer.context());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.Welcome) {
                    InternalClusterAction.Welcome welcome = InternalClusterAction$Welcome$.MODULE$.unapply((InternalClusterAction.Welcome)object);
                    UniqueAddress uniqueAddress = welcome._1();
                    Gossip gossip = welcome._2();
                    UniqueAddress from = uniqueAddress;
                    Gossip gossip2 = gossip;
                    this.$outer.welcome(from.address(), from, gossip2);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.Tick) {
                    if (this.$outer.joinSeedNodesDeadline().exists(ClusterCoreDaemon::org$apache$pekko$cluster$ClusterCoreDaemon$$anon$4$$_$applyOrElse$$anonfun$3)) {
                        this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$joinSeedNodesWasUnsuccessful();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$cluster$ClusterCoreDaemon$$anon$4$$_$applyOrElse$$anonfun$3(scala.concurrent.duration.Deadline )}, serializedLambda);
            }
        }.orElse(this.receiveExitingCompleted());
    }

    public PartialFunction<Object, BoxedUnit> tryingToJoin(Address joinWith, Option<Deadline> deadline) {
        return new Serializable(joinWith, deadline, this){
            private final Address joinWith$1;
            private final Option deadline$1;
            private final /* synthetic */ ClusterCoreDaemon $outer;
            {
                this.joinWith$1 = joinWith$2;
                this.deadline$1 = deadline$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof InternalClusterAction.Welcome) {
                    InternalClusterAction.Welcome welcome = InternalClusterAction$Welcome$.MODULE$.unapply((InternalClusterAction.Welcome)object);
                    UniqueAddress uniqueAddress = welcome._1();
                    Gossip gossip = welcome._2();
                    UniqueAddress from = uniqueAddress;
                    Gossip gossip2 = gossip;
                    return true;
                }
                if (object instanceof InternalClusterAction.InitJoin) {
                    InternalClusterAction.InitJoin initJoin = InternalClusterAction$InitJoin$.MODULE$.unapply((InternalClusterAction.InitJoin)object);
                    Config config = initJoin._1();
                    return true;
                }
                if (object instanceof ClusterUserAction.JoinTo) {
                    Address address;
                    ClusterUserAction.JoinTo joinTo = ClusterUserAction$JoinTo$.MODULE$.unapply((ClusterUserAction.JoinTo)object);
                    Address address2 = address = joinTo._1();
                    return true;
                }
                if (object instanceof InternalClusterAction.JoinSeedNodes) {
                    IndexedSeq<Address> indexedSeq;
                    InternalClusterAction.JoinSeedNodes joinSeedNodes = InternalClusterAction$JoinSeedNodes$.MODULE$.unapply((InternalClusterAction.JoinSeedNodes)object);
                    IndexedSeq<Address> newSeedNodes = indexedSeq = joinSeedNodes._1();
                    return true;
                }
                if (object instanceof InternalClusterAction.SubscriptionMessage) {
                    InternalClusterAction.SubscriptionMessage msg = (InternalClusterAction.SubscriptionMessage)object;
                    return true;
                }
                return object instanceof InternalClusterAction.Tick;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof InternalClusterAction.Welcome) {
                    InternalClusterAction.Welcome welcome = InternalClusterAction$Welcome$.MODULE$.unapply((InternalClusterAction.Welcome)object);
                    UniqueAddress uniqueAddress = welcome._1();
                    Gossip gossip = welcome._2();
                    UniqueAddress from = uniqueAddress;
                    Gossip gossip2 = gossip;
                    this.$outer.welcome(this.joinWith$1, from, gossip2);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.InitJoin) {
                    InternalClusterAction.InitJoin initJoin = InternalClusterAction$InitJoin$.MODULE$.unapply((InternalClusterAction.InitJoin)object);
                    Config config = initJoin._1();
                    this.$outer.cluster().ClusterLogger().logInfo("Received InitJoin message from [{}], but this node is not a member yet", this.$outer.sender());
                    this.$outer.sender().$bang((Object)InternalClusterAction$InitJoinNack$.MODULE$.apply(this.$outer.cluster().selfAddress()), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterUserAction.JoinTo) {
                    Address address;
                    ClusterUserAction.JoinTo joinTo = ClusterUserAction$JoinTo$.MODULE$.unapply((ClusterUserAction.JoinTo)object);
                    Address address2 = address = joinTo._1();
                    this.$outer.becomeUninitialized();
                    this.$outer.join(address2);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.JoinSeedNodes) {
                    IndexedSeq<Address> indexedSeq;
                    InternalClusterAction.JoinSeedNodes joinSeedNodes = InternalClusterAction$JoinSeedNodes$.MODULE$.unapply((InternalClusterAction.JoinSeedNodes)object);
                    IndexedSeq<Address> newSeedNodes = indexedSeq = joinSeedNodes._1();
                    this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$resetJoinSeedNodesDeadline();
                    this.$outer.becomeUninitialized();
                    this.$outer.joinSeedNodes(newSeedNodes);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.SubscriptionMessage) {
                    InternalClusterAction.SubscriptionMessage msg = (InternalClusterAction.SubscriptionMessage)object;
                    this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$publisher.forward((Object)msg, this.$outer.context());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.Tick) {
                    if (this.$outer.joinSeedNodesDeadline().exists(ClusterCoreDaemon::org$apache$pekko$cluster$ClusterCoreDaemon$$anon$5$$_$applyOrElse$$anonfun$4)) {
                        this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$joinSeedNodesWasUnsuccessful();
                        return BoxedUnit.UNIT;
                    }
                    if (this.deadline$1.exists(ClusterCoreDaemon::org$apache$pekko$cluster$ClusterCoreDaemon$$anon$5$$_$applyOrElse$$anonfun$5)) {
                        this.$outer.becomeUninitialized();
                        if (this.$outer.seedNodes().nonEmpty()) {
                            this.$outer.joinSeedNodes(this.$outer.seedNodes());
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.join(this.joinWith$1);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$cluster$ClusterCoreDaemon$$anon$5$$_$applyOrElse$$anonfun$4(scala.concurrent.duration.Deadline ), org$apache$pekko$cluster$ClusterCoreDaemon$$anon$5$$_$applyOrElse$$anonfun$5(scala.concurrent.duration.Deadline )}, serializedLambda);
            }
        }.orElse(this.receiveExitingCompleted());
    }

    public void org$apache$pekko$cluster$ClusterCoreDaemon$$resetJoinSeedNodesDeadline() {
        None$ none$;
        Duration duration = this.cluster().settings().ShutdownAfterUnsuccessfulJoinSeedNodes();
        if (duration instanceof FiniteDuration) {
            FiniteDuration d = (FiniteDuration)duration;
            none$ = Some$.MODULE$.apply((Object)Deadline$.MODULE$.now().$plus(d));
        } else {
            none$ = None$.MODULE$;
        }
        this.joinSeedNodesDeadline_$eq((Option<Deadline>)none$);
    }

    public void org$apache$pekko$cluster$ClusterCoreDaemon$$joinSeedNodesWasUnsuccessful() {
        this.cluster().ClusterLogger().logWarning("Joining of seed-nodes [{}] was unsuccessful after configured shutdown-after-unsuccessful-join-seed-nodes [{}]. Running CoordinatedShutdown.", (Object)this.seedNodes().mkString(", "), (Object)this.cluster().settings().ShutdownAfterUnsuccessfulJoinSeedNodes());
        this.joinSeedNodesDeadline_$eq((Option<Deadline>)None$.MODULE$);
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system())).run((CoordinatedShutdown.Reason)CoordinatedShutdown.ClusterJoinUnsuccessfulReason$.MODULE$);
    }

    public void becomeUninitialized() {
        this.stopSeedNodeProcess();
        this.context().become(this.uninitialized());
    }

    public void becomeInitialized() {
        Props internalHeartbeatSenderProps = Props$.MODULE$.apply(ClusterCoreDaemon::$anonfun$1, ClassTag$.MODULE$.apply(ClusterHeartbeatSender.class)).withDispatcher(this.cluster().settings().UseDispatcher());
        this.context().actorOf(internalHeartbeatSenderProps, "heartbeatSender");
        Props externalHeartbeatProps = Props$.MODULE$.apply(ClusterCoreDaemon::$anonfun$2, ClassTag$.MODULE$.apply(CrossDcHeartbeatSender.class)).withDispatcher(this.cluster().settings().UseDispatcher());
        this.context().actorOf(externalHeartbeatProps, "crossDcHeartbeatSender");
        this.stopSeedNodeProcess();
        this.joinSeedNodesDeadline_$eq((Option<Deadline>)None$.MODULE$);
        this.context().become(this.initialized());
    }

    public PartialFunction<Object, BoxedUnit> initialized() {
        return new Serializable(this){
            private final /* synthetic */ ClusterCoreDaemon $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof GossipEnvelope) {
                    GossipEnvelope msg = (GossipEnvelope)object;
                    return true;
                }
                if (object instanceof GossipStatus) {
                    GossipStatus msg = (GossipStatus)object;
                    return true;
                }
                if (InternalClusterAction$GossipTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (InternalClusterAction$GossipSpeedupTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (InternalClusterAction$ReapUnreachableTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (InternalClusterAction$LeaderActionsTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (InternalClusterAction$PublishStatsTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof InternalClusterAction.InitJoin) {
                    Config config;
                    InternalClusterAction.InitJoin initJoin = InternalClusterAction$InitJoin$.MODULE$.unapply((InternalClusterAction.InitJoin)object);
                    Config joiningNodeConfig = config = initJoin._1();
                    return true;
                }
                if (object instanceof InternalClusterAction.Join) {
                    InternalClusterAction.Join join = InternalClusterAction$Join$.MODULE$.unapply((InternalClusterAction.Join)object);
                    UniqueAddress uniqueAddress = join._1();
                    Set<String> set = join._2();
                    Version version = join._3();
                    UniqueAddress node = uniqueAddress;
                    Set<String> roles = set;
                    Version appVersion = version;
                    return true;
                }
                if (object instanceof ClusterUserAction.Down) {
                    Address address;
                    ClusterUserAction.Down down = ClusterUserAction$Down$.MODULE$.unapply((ClusterUserAction.Down)object);
                    Address address2 = address = down._1();
                    return true;
                }
                if (object instanceof ClusterUserAction.Leave) {
                    Address address;
                    ClusterUserAction.Leave leave = ClusterUserAction$Leave$.MODULE$.unapply((ClusterUserAction.Leave)object);
                    Address address3 = address = leave._1();
                    return true;
                }
                if (ClusterUserAction$PrepareForShutdown$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof InternalClusterAction.SendGossipTo) {
                    Address address;
                    InternalClusterAction.SendGossipTo sendGossipTo = InternalClusterAction$SendGossipTo$.MODULE$.unapply((InternalClusterAction.SendGossipTo)object);
                    Address address4 = address = sendGossipTo._1();
                    return true;
                }
                if (object instanceof InternalClusterAction.SubscriptionMessage) {
                    InternalClusterAction.SubscriptionMessage msg = (InternalClusterAction.SubscriptionMessage)object;
                    return true;
                }
                if (object instanceof org.apache.pekko.remote.artery.QuarantinedEvent) {
                    org.apache.pekko.remote.UniqueAddress uniqueAddress;
                    org.apache.pekko.remote.artery.QuarantinedEvent quarantinedEvent = org.apache.pekko.remote.artery.QuarantinedEvent$.MODULE$.unapply((org.apache.pekko.remote.artery.QuarantinedEvent)object);
                    org.apache.pekko.remote.UniqueAddress ua = uniqueAddress = quarantinedEvent._1();
                    return true;
                }
                if (object instanceof QuarantinedEvent) {
                    QuarantinedEvent quarantinedEvent = QuarantinedEvent$.MODULE$.unapply((QuarantinedEvent)object);
                    Address address = quarantinedEvent._1();
                    long l = quarantinedEvent._2();
                    Address address5 = address;
                    long uid = l;
                    return true;
                }
                if (object instanceof ClusterUserAction.JoinTo) {
                    Address address;
                    ClusterUserAction.JoinTo joinTo = ClusterUserAction$JoinTo$.MODULE$.unapply((ClusterUserAction.JoinTo)object);
                    Address address6 = address = joinTo._1();
                    return true;
                }
                if (object instanceof InternalClusterAction.JoinSeedNodes) {
                    IndexedSeq<Address> indexedSeq;
                    InternalClusterAction.JoinSeedNodes joinSeedNodes = InternalClusterAction$JoinSeedNodes$.MODULE$.unapply((InternalClusterAction.JoinSeedNodes)object);
                    IndexedSeq<Address> nodes = indexedSeq = joinSeedNodes._1();
                    return true;
                }
                if (object instanceof InternalClusterAction.ExitingConfirmed) {
                    UniqueAddress uniqueAddress;
                    InternalClusterAction.ExitingConfirmed exitingConfirmed = InternalClusterAction$ExitingConfirmed$.MODULE$.unapply((InternalClusterAction.ExitingConfirmed)object);
                    UniqueAddress address = uniqueAddress = exitingConfirmed._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof GossipEnvelope) {
                    GossipEnvelope msg = (GossipEnvelope)object;
                    this.$outer.receiveGossip(msg);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof GossipStatus) {
                    GossipStatus msg = (GossipStatus)object;
                    this.$outer.receiveGossipStatus(msg);
                    return BoxedUnit.UNIT;
                }
                if (InternalClusterAction$GossipTick$.MODULE$.equals(object)) {
                    this.$outer.gossipTick();
                    return BoxedUnit.UNIT;
                }
                if (InternalClusterAction$GossipSpeedupTick$.MODULE$.equals(object)) {
                    this.$outer.gossipSpeedupTick();
                    return BoxedUnit.UNIT;
                }
                if (InternalClusterAction$ReapUnreachableTick$.MODULE$.equals(object)) {
                    this.$outer.reapUnreachableMembers();
                    return BoxedUnit.UNIT;
                }
                if (InternalClusterAction$LeaderActionsTick$.MODULE$.equals(object)) {
                    this.$outer.leaderActions();
                    return BoxedUnit.UNIT;
                }
                if (InternalClusterAction$PublishStatsTick$.MODULE$.equals(object)) {
                    this.$outer.publishInternalStats();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.InitJoin) {
                    Config config;
                    InternalClusterAction.InitJoin initJoin = InternalClusterAction$InitJoin$.MODULE$.unapply((InternalClusterAction.InitJoin)object);
                    Config joiningNodeConfig = config = initJoin._1();
                    this.$outer.cluster().ClusterLogger().logInfo("Received InitJoin message from [{}] to [{}]", this.$outer.sender(), (Object)this.$outer.cluster().selfAddress());
                    this.$outer.initJoin(joiningNodeConfig);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.Join) {
                    InternalClusterAction.Join join = InternalClusterAction$Join$.MODULE$.unapply((InternalClusterAction.Join)object);
                    UniqueAddress uniqueAddress = join._1();
                    Set<String> set = join._2();
                    Version version = join._3();
                    UniqueAddress node = uniqueAddress;
                    Set<String> roles = set;
                    Version appVersion = version;
                    this.$outer.joining(node, roles, appVersion);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterUserAction.Down) {
                    Address address;
                    ClusterUserAction.Down down = ClusterUserAction$Down$.MODULE$.unapply((ClusterUserAction.Down)object);
                    Address address2 = address = down._1();
                    this.$outer.downing(address2);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterUserAction.Leave) {
                    Address address;
                    ClusterUserAction.Leave leave = ClusterUserAction$Leave$.MODULE$.unapply((ClusterUserAction.Leave)object);
                    Address address3 = address = leave._1();
                    this.$outer.leaving(address3);
                    return BoxedUnit.UNIT;
                }
                if (ClusterUserAction$PrepareForShutdown$.MODULE$.equals(object)) {
                    this.$outer.startPrepareForShutdown();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.SendGossipTo) {
                    Address address;
                    InternalClusterAction.SendGossipTo sendGossipTo = InternalClusterAction$SendGossipTo$.MODULE$.unapply((InternalClusterAction.SendGossipTo)object);
                    Address address4 = address = sendGossipTo._1();
                    this.$outer.sendGossipTo(address4);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.SubscriptionMessage) {
                    InternalClusterAction.SubscriptionMessage msg = (InternalClusterAction.SubscriptionMessage)object;
                    this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$publisher.forward((Object)msg, this.$outer.context());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof org.apache.pekko.remote.artery.QuarantinedEvent) {
                    org.apache.pekko.remote.UniqueAddress uniqueAddress;
                    org.apache.pekko.remote.artery.QuarantinedEvent quarantinedEvent = org.apache.pekko.remote.artery.QuarantinedEvent$.MODULE$.unapply((org.apache.pekko.remote.artery.QuarantinedEvent)object);
                    org.apache.pekko.remote.UniqueAddress ua = uniqueAddress = quarantinedEvent._1();
                    this.$outer.quarantined(UniqueAddress$.MODULE$.apply(ua));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof QuarantinedEvent) {
                    QuarantinedEvent quarantinedEvent = QuarantinedEvent$.MODULE$.unapply((QuarantinedEvent)object);
                    Address address = quarantinedEvent._1();
                    long l = quarantinedEvent._2();
                    Address address5 = address;
                    long uid = l;
                    this.$outer.quarantined(UniqueAddress$.MODULE$.apply(address5, uid));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterUserAction.JoinTo) {
                    Address address;
                    ClusterUserAction.JoinTo joinTo = ClusterUserAction$JoinTo$.MODULE$.unapply((ClusterUserAction.JoinTo)object);
                    Address address6 = address = joinTo._1();
                    this.$outer.cluster().ClusterLogger().logInfo("Trying to join [{}] when already part of a cluster, ignoring", address6);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.JoinSeedNodes) {
                    IndexedSeq<Address> indexedSeq;
                    InternalClusterAction.JoinSeedNodes joinSeedNodes = InternalClusterAction$JoinSeedNodes$.MODULE$.unapply((InternalClusterAction.JoinSeedNodes)object);
                    IndexedSeq<Address> nodes = indexedSeq = joinSeedNodes._1();
                    this.$outer.cluster().ClusterLogger().logInfo("Trying to join seed nodes [{}] when already part of a cluster, ignoring", (Object)nodes.mkString(", "));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.ExitingConfirmed) {
                    UniqueAddress uniqueAddress;
                    InternalClusterAction.ExitingConfirmed exitingConfirmed = InternalClusterAction$ExitingConfirmed$.MODULE$.unapply((InternalClusterAction.ExitingConfirmed)object);
                    UniqueAddress address = uniqueAddress = exitingConfirmed._1();
                    this.$outer.receiveExitingConfirmed(address);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        }.orElse(this.receiveExitingCompleted());
    }

    public PartialFunction<Object, BoxedUnit> receiveExitingCompleted() {
        return new Serializable(this){
            private final /* synthetic */ ClusterCoreDaemon $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return InternalClusterAction$ExitingCompleted$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (InternalClusterAction$ExitingCompleted$.MODULE$.equals(object)) {
                    this.$outer.exitingCompleted();
                    this.$outer.sender().$bang((Object)Done$.MODULE$, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.uninitialized();
    }

    public void unhandled(Object message) {
        Object object = message;
        if (object instanceof InternalClusterAction.Tick) {
            return;
        }
        if (object instanceof GossipEnvelope) {
            return;
        }
        if (object instanceof GossipStatus) {
            return;
        }
        if (object instanceof InternalClusterAction.ExitingConfirmed) {
            return;
        }
        Object other = object;
        Actor.unhandled$((Actor)this, (Object)other);
    }

    public void initJoin(Config joiningNodeConfig) {
        Serializable serializable;
        String joiningNodeVersion = joiningNodeConfig.hasPath("pekko.version") ? joiningNodeConfig.getString("pekko.version") : "unknown";
        boolean configCheckUnsupportedByJoiningNode = joiningNodeConfig.isEmpty();
        MemberStatus selfStatus = this.latestGossip().member(this.selfUniqueAddress()).status();
        if (MembershipState$.MODULE$.removeUnreachableWithMemberStatus().contains((Object)selfStatus)) {
            this.cluster().ClusterLogger().logInfo("Sending InitJoinNack message from node [{}] to [{}] (version [{}])", this.cluster().selfAddress(), (Object)this.sender(), (Object)joiningNodeVersion);
            this.sender().$bang((Object)InternalClusterAction$InitJoinNack$.MODULE$.apply(this.cluster().selfAddress()), this.self());
            return;
        }
        this.cluster().ClusterLogger().logInfo("Sending InitJoinAck message from node [{}] to [{}] (version [{}])", this.cluster().selfAddress(), (Object)this.sender(), (Object)joiningNodeVersion);
        Seq<String> allowedConfigPaths = JoinConfigCompatChecker$.MODULE$.removeSensitiveKeys(this.context().system().settings().config(), this.cluster().settings());
        Config configWithoutSensitiveKeys = JoinConfigCompatChecker$.MODULE$.filterWithKeys(allowedConfigPaths, this.context().system().settings().config());
        ConfigValidation configValidation = this.joinConfigCompatChecker.check(joiningNodeConfig, configWithoutSensitiveKeys);
        if (Valid$.MODULE$.equals(configValidation)) {
            if (configCheckUnsupportedByJoiningNode) {
                serializable = InternalClusterAction$ConfigCheckUnsupportedByJoiningNode$.MODULE$;
            } else {
                Seq<String> nonSensitiveKeys = JoinConfigCompatChecker$.MODULE$.removeSensitiveKeys(joiningNodeConfig, this.cluster().settings());
                Config clusterConfig = JoinConfigCompatChecker$.MODULE$.filterWithKeys(nonSensitiveKeys, this.context().system().settings().config());
                serializable = InternalClusterAction$CompatibleConfig$.MODULE$.apply(clusterConfig);
            }
        } else if (configValidation instanceof Invalid) {
            Seq<String> seq;
            Invalid invalid = Invalid$.MODULE$.unapply((Invalid)configValidation);
            Seq<String> messages = seq = invalid._1();
            this.cluster().ClusterLogger().logWarning(new StringBuilder(57).append("Found incompatible settings when [{}] tried to join: {}. ").append(new StringBuilder(38).append("Self version [{}], Joining version [").append(joiningNodeVersion).append("].").toString()).toString(), this.sender().path().address(), (Object)messages.mkString(", "), (Object)this.context().system().settings().ConfigVersion());
            serializable = (Serializable)((Object)(configCheckUnsupportedByJoiningNode ? InternalClusterAction$ConfigCheckUnsupportedByJoiningNode$.MODULE$ : InternalClusterAction$IncompatibleConfig$.MODULE$));
        } else {
            throw new MatchError((Object)configValidation);
        }
        InternalClusterAction.ConfigCheck configCheckReply = serializable;
        this.sender().$bang((Object)InternalClusterAction$InitJoinAck$.MODULE$.apply(this.cluster().selfAddress(), configCheckReply), this.self());
    }

    public void joinSeedNodes(IndexedSeq<Address> newSeedNodes) {
        if (newSeedNodes.nonEmpty()) {
            None$ none$;
            this.stopSeedNodeProcess();
            this.seedNodes_$eq(newSeedNodes);
            IndexedSeq<Address> indexedSeq = newSeedNodes;
            SeqOps seqOps = IndexedSeq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Address[]{this.cluster().selfAddress()}));
            if (!(indexedSeq != null ? !indexedSeq.equals((Object)seqOps) : seqOps != null)) {
                this.self().$bang((Object)ClusterUserAction$JoinTo$.MODULE$.apply(this.cluster().selfAddress()), this.self());
                none$ = None$.MODULE$;
            } else {
                this.seedNodeProcessCounter_$eq(this.seedNodeProcessCounter() + 1);
                Object object = newSeedNodes.head();
                Address address = this.cluster().selfAddress();
                none$ = !(object != null ? !object.equals(address) : address != null) ? Some$.MODULE$.apply((Object)this.context().actorOf(Props$.MODULE$.apply(FirstSeedNodeProcess.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{newSeedNodes, this.joinConfigCompatChecker})).withDispatcher(this.cluster().settings().UseDispatcher()), new StringBuilder(21).append("firstSeedNodeProcess-").append(this.seedNodeProcessCounter()).toString())) : Some$.MODULE$.apply((Object)this.context().actorOf(Props$.MODULE$.apply(JoinSeedNodeProcess.class, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{newSeedNodes, this.joinConfigCompatChecker})).withDispatcher(this.cluster().settings().UseDispatcher()), new StringBuilder(20).append("joinSeedNodeProcess-").append(this.seedNodeProcessCounter()).toString()));
            }
            this.seedNodeProcess_$eq((Option<ActorRef>)none$);
            return;
        }
    }

    public void join(Address address) {
        None$ none$;
        String string = address.protocol();
        String string2 = this.cluster().selfAddress().protocol();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.cluster().ClusterLogger().logWarning("Trying to join member with wrong protocol, but was ignored, expected [{}] but was [{}]", (Object)this.cluster().selfAddress().protocol(), (Object)address.protocol());
            return;
        }
        String string3 = address.system();
        String string4 = this.cluster().selfAddress().system();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            this.cluster().ClusterLogger().logWarning("Trying to join member with wrong ActorSystem name, but was ignored, expected [{}] but was [{}]", (Object)this.cluster().selfAddress().system(), (Object)address.system());
            return;
        }
        Predef$.MODULE$.require(this.latestGossip().members().isEmpty(), ClusterCoreDaemon::join$$anonfun$1);
        this.stopSeedNodeProcess();
        Address address2 = address;
        Address address3 = this.cluster().selfAddress();
        if (!(address2 != null ? !address2.equals(address3) : address3 != null)) {
            this.becomeInitialized();
            this.joining(this.selfUniqueAddress(), this.cluster().selfRoles(), this.cluster().settings().AppVersion());
            return;
        }
        Duration duration = this.cluster().settings().RetryUnsuccessfulJoinAfter();
        if (duration instanceof FiniteDuration) {
            FiniteDuration d = (FiniteDuration)duration;
            none$ = Some$.MODULE$.apply((Object)Deadline$.MODULE$.now().$plus(d));
        } else {
            none$ = None$.MODULE$;
        }
        None$ joinDeadline = none$;
        this.context().become(this.tryingToJoin(address, (Option<Deadline>)joinDeadline));
        this.cluster().ClusterLogger().logDebug("Trying to join [{}]", address);
        ActorSelection$.MODULE$.toScala(this.clusterCore(address)).$bang((Object)InternalClusterAction$Join$.MODULE$.apply(this.selfUniqueAddress(), this.cluster().selfRoles(), this.cluster().settings().AppVersion()), this.self());
    }

    public void stopSeedNodeProcess() {
        Option<ActorRef> option = this.seedNodeProcess();
        if (option instanceof Some) {
            ActorRef s = (ActorRef)((Some)option).value();
            this.context().stop(s);
            this.seedNodeProcess_$eq((Option<ActorRef>)None$.MODULE$);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void joining(UniqueAddress joiningNode, Set<String> roles, Version appVersion) {
        if (!this.preparingForShutdown()) {
            MemberStatus selfStatus = this.latestGossip().member(this.selfUniqueAddress()).status();
            String string = joiningNode.address().protocol();
            String string2 = this.cluster().selfAddress().protocol();
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.cluster().ClusterLogger().logWarning("Member with wrong protocol tried to join, but was ignored, expected [{}] but was [{}]", (Object)this.cluster().selfAddress().protocol(), (Object)joiningNode.address().protocol());
                return;
            }
            String string3 = joiningNode.address().system();
            String string4 = this.cluster().selfAddress().system();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                this.cluster().ClusterLogger().logWarning("Member with wrong ActorSystem name tried to join, but was ignored, expected [{}] but was [{}]", (Object)this.cluster().selfAddress().system(), (Object)joiningNode.address().system());
                return;
            }
            if (MembershipState$.MODULE$.removeUnreachableWithMemberStatus().contains((Object)selfStatus)) {
                this.cluster().ClusterLogger().logInfo("Trying to join [{}] to [{}] member, ignoring. Use a member that is Up instead.", joiningNode, (Object)selfStatus);
                return;
            }
            SortedSet<Member> localMembers = this.latestGossip().members();
            Option option = localMembers.find((Function1 & Serializable)_$7 -> {
                Address address = _$7.address();
                Address address2 = joiningNode.address();
                return !(address != null ? !address.equals(address2) : address2 != null);
            });
            if (option instanceof Some) {
                Member member;
                Member m = member = (Member)((Some)option).value();
                UniqueAddress uniqueAddress = m.uniqueAddress();
                UniqueAddress uniqueAddress2 = joiningNode;
                if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                    this.cluster().ClusterLogger().logInfo("Existing member [{}] is joining again.", m);
                    UniqueAddress uniqueAddress3 = joiningNode;
                    UniqueAddress uniqueAddress4 = this.selfUniqueAddress();
                    if (uniqueAddress3 == null ? uniqueAddress4 != null : !((Object)uniqueAddress3).equals(uniqueAddress4)) {
                        this.sender().$bang((Object)InternalClusterAction$Welcome$.MODULE$.apply(this.selfUniqueAddress(), this.latestGossip()), this.self());
                        return;
                    }
                    return;
                }
                Member m2 = member;
                this.cluster().ClusterLogger().logInfo("New incarnation of existing member [{}] is trying to join. Existing will be removed from the cluster and then new member will be allowed to join.", m2);
                MemberStatus memberStatus = m2.status();
                MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                if (memberStatus == null ? memberStatus$Down$ != null : !memberStatus.equals(memberStatus$Down$)) {
                    Reachability newReachability = this.latestGossip().overview().reachability().terminated(this.selfUniqueAddress(), m2.uniqueAddress());
                    GossipOverview gossipOverview = this.latestGossip().overview();
                    GossipOverview newOverview = gossipOverview.copy(gossipOverview.copy$default$1(), newReachability);
                    Gossip gossip = this.latestGossip();
                    Gossip newGossip = gossip.copy(gossip.copy$default$1(), newOverview, gossip.copy$default$3(), gossip.copy$default$4());
                    this.updateLatestGossip(newGossip);
                    this.downing(m2.address());
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.cluster().failureDetector().remove((Object)joiningNode.address());
                this.cluster().crossDcFailureDetector().remove((Object)joiningNode.address());
                SortedSet newMembers = (SortedSet)localMembers.$plus((Object)Member$.MODULE$.apply(joiningNode, roles, appVersion)).$plus((Object)Member$.MODULE$.apply(this.selfUniqueAddress(), this.cluster().selfRoles(), this.cluster().settings().AppVersion()));
                Gossip gossip = this.latestGossip();
                Gossip newGossip = gossip.copy((SortedSet<Member>)newMembers, gossip.copy$default$2(), gossip.copy$default$3(), gossip.copy$default$4());
                this.updateLatestGossip(newGossip);
                UniqueAddress uniqueAddress = joiningNode;
                UniqueAddress uniqueAddress5 = this.selfUniqueAddress();
                if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress5) : uniqueAddress5 != null)) {
                    this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged(joiningNode, MemberStatus$Joining$.MODULE$), "Node [{}] is JOINING itself (with roles [{}], version [{}]) and forming new cluster", joiningNode.address(), roles.mkString(", "), appVersion);
                    if (localMembers.isEmpty()) {
                        this.leaderActions();
                    }
                } else {
                    this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged(joiningNode, MemberStatus$Joining$.MODULE$), "Node [{}] is JOINING, roles [{}], version [{}]", joiningNode.address(), roles.mkString(", "), appVersion);
                    this.sender().$bang((Object)InternalClusterAction$Welcome$.MODULE$.apply(this.selfUniqueAddress(), this.latestGossip()), this.self());
                }
                this.publishMembershipState();
                return;
            }
            throw new MatchError((Object)option);
        }
        this.cluster().ClusterLogger().logInfo("Ignoring join request from [{}] as preparing for shutdown", joiningNode);
    }

    public void welcome(Address joinWith, UniqueAddress from, Gossip gossip) {
        Predef$.MODULE$.require(this.latestGossip().members().isEmpty(), ClusterCoreDaemon::welcome$$anonfun$1);
        Address address = joinWith;
        Address address2 = from.address();
        if (address == null ? address2 != null : !address.equals(address2)) {
            this.cluster().ClusterLogger().logInfo("Ignoring welcome from [{}] when trying to join with [{}]", from.address(), (Object)joinWith);
            return;
        }
        MembershipState membershipState = this.membershipState();
        this.membershipState_$eq(membershipState.copy(gossip, membershipState.copy$default$2(), membershipState.copy$default$3(), membershipState.copy$default$4()).seen());
        this.cluster().ClusterLogger().logInfo("Welcome from [{}]", from.address());
        this.assertLatestGossip();
        this.publishMembershipState();
        UniqueAddress uniqueAddress = from;
        UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
        if (uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) {
            this.gossipTo(from, this.sender());
        }
        this.becomeInitialized();
    }

    public void startPrepareForShutdown() {
        if (!this.preparingForShutdown()) {
            this.preparingForShutdown_$eq(true);
            SortedSet changedMembers = (SortedSet)this.latestGossip().members().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Member x) {
                    Member member;
                    Member m = member = x;
                    return MembershipState$.MODULE$.allowedToPrepareToShutdown().apply((Object)m.status());
                }

                public final Object applyOrElse(Member x, Function1 function1) {
                    Member member;
                    Member m = member = x;
                    if (MembershipState$.MODULE$.allowedToPrepareToShutdown().apply((Object)m.status())) {
                        return m.copy(MemberStatus$PreparingForShutdown$.MODULE$);
                    }
                    return function1.apply((Object)x);
                }
            }, Member$.MODULE$.ordering());
            Gossip newGossip = this.latestGossip().update((SortedSet<Member>)changedMembers);
            this.updateLatestGossip(newGossip);
            changedMembers.foreach((Function1)(JProcedure1 & Serializable)member -> this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged(member.uniqueAddress(), MemberStatus$PreparingForShutdown$.MODULE$), "Preparing for shutdown [{}] as [{}]", (Object)member.address(), (Object)MemberStatus$PreparingForShutdown$.MODULE$));
            this.publishMembershipState();
            this.gossip();
            return;
        }
    }

    public void leaving(Address address) {
        this.latestGossip().members().find((Function1 & Serializable)_$8 -> {
            Address address = _$8.address();
            Address address2 = address;
            return !(address != null ? !address.equals(address2) : address2 != null);
        }).foreach((Function1)(JProcedure1 & Serializable)existingMember -> {
            block3: {
                block2: {
                    MemberStatus memberStatus = existingMember.status();
                    MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
                    if (!(memberStatus == null ? memberStatus$Joining$ != null : !memberStatus.equals(memberStatus$Joining$))) break block2;
                    MemberStatus memberStatus2 = existingMember.status();
                    MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
                    if (!(memberStatus2 == null ? memberStatus$WeaklyUp$ != null : !memberStatus2.equals(memberStatus$WeaklyUp$))) break block2;
                    MemberStatus memberStatus3 = existingMember.status();
                    MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                    if (!(memberStatus3 == null ? memberStatus$Up$ != null : !memberStatus3.equals(memberStatus$Up$))) break block2;
                    MemberStatus memberStatus4 = existingMember.status();
                    MemberStatus$PreparingForShutdown$ memberStatus$PreparingForShutdown$ = MemberStatus$PreparingForShutdown$.MODULE$;
                    if (!(memberStatus4 == null ? memberStatus$PreparingForShutdown$ != null : !memberStatus4.equals(memberStatus$PreparingForShutdown$))) break block2;
                    MemberStatus memberStatus5 = existingMember.status();
                    MemberStatus$ReadyForShutdown$ memberStatus$ReadyForShutdown$ = MemberStatus$ReadyForShutdown$.MODULE$;
                    if (memberStatus5 != null ? !memberStatus5.equals(memberStatus$ReadyForShutdown$) : memberStatus$ReadyForShutdown$ != null) break block3;
                }
                SortedSet newMembers = (SortedSet)this.latestGossip().members().$minus(existingMember).$plus((Object)existingMember.copy(MemberStatus$Leaving$.MODULE$));
                Gossip gossip = this.latestGossip();
                Gossip newGossip = gossip.copy((SortedSet<Member>)newMembers, gossip.copy$default$2(), gossip.copy$default$3(), gossip.copy$default$4());
                this.updateLatestGossip(newGossip);
                this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged(existingMember.uniqueAddress(), MemberStatus$Leaving$.MODULE$), "Marked address [{}] as [{}]", (Object)address, (Object)MemberStatus$Leaving$.MODULE$);
                this.publishMembershipState();
                this.gossip();
                return;
            }
        });
    }

    public void exitingCompleted() {
        this.cluster().ClusterLogger().logInfo("Exiting completed");
        this.exitingTasksInProgress_$eq(false);
        MemberStatus memberStatus = this.membershipState().selfMember().status();
        MemberStatus$Removed$ memberStatus$Removed$ = MemberStatus$Removed$.MODULE$;
        if (memberStatus == null ? memberStatus$Removed$ != null : !memberStatus.equals(memberStatus$Removed$)) {
            this.membershipState_$eq(this.membershipState().seen());
            this.assertLatestGossip();
            this.publishMembershipState();
            this.gossipRandomN(ClusterCoreDaemon$.MODULE$.NumberOfGossipsBeforeShutdownWhenLeaderExits());
            SortedSet membersExceptSelf = (SortedSet)this.latestGossip().members().filter((Function1 & Serializable)_$9 -> {
                UniqueAddress uniqueAddress = _$9.uniqueAddress();
                UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
                return uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2);
            });
            Option<UniqueAddress> option = this.membershipState().leaderOf((SortedSet<Member>)membersExceptSelf);
            if (option instanceof Some) {
                UniqueAddress node1 = (UniqueAddress)((Some)option).value();
                ActorSelection$.MODULE$.toScala(this.clusterCore(node1.address())).$bang((Object)InternalClusterAction$ExitingConfirmed$.MODULE$.apply(this.selfUniqueAddress()), this.self());
                Option<UniqueAddress> option2 = this.membershipState().leaderOf((SortedSet<Member>)((SortedSet)membersExceptSelf.filterNot((Function1 & Serializable)_$10 -> {
                    UniqueAddress uniqueAddress = _$10.uniqueAddress();
                    UniqueAddress uniqueAddress2 = node1;
                    return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
                })));
                if (option2 instanceof Some) {
                    UniqueAddress node2 = (UniqueAddress)((Some)option2).value();
                    ActorSelection$.MODULE$.toScala(this.clusterCore(node2.address())).$bang((Object)InternalClusterAction$ExitingConfirmed$.MODULE$.apply(this.selfUniqueAddress()), this.self());
                } else if (!None$.MODULE$.equals(option2)) {
                    throw new MatchError(option2);
                }
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
        }
        this.shutdown();
    }

    public void receiveExitingConfirmed(UniqueAddress node) {
        this.cluster().ClusterLogger().logInfo("Exiting confirmed [{}]", node.address());
        this.exitingConfirmed_$eq((Set<UniqueAddress>)((Set)this.exitingConfirmed().$plus((Object)node)));
    }

    public void cleanupExitingConfirmed() {
        if (this.exitingConfirmed().nonEmpty()) {
            this.exitingConfirmed_$eq((Set<UniqueAddress>)((Set)this.exitingConfirmed().filter((Function1 & Serializable)n -> this.latestGossip().members().exists((Function1 & Serializable)_$11 -> {
                UniqueAddress uniqueAddress = _$11.uniqueAddress();
                UniqueAddress uniqueAddress2 = n;
                return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
            }))));
            return;
        }
    }

    public void shutdown() {
        this.cluster().shutdown();
    }

    public void downing(Address address) {
        Gossip localGossip = this.latestGossip();
        SortedSet<Member> localMembers = localGossip.members();
        Reachability localReachability = this.membershipState().dcReachability();
        Option option = localMembers.find((Function1 & Serializable)_$12 -> {
            Address address = _$12.address();
            Address address2 = address;
            return !(address != null ? !address.equals(address2) : address2 != null);
        });
        if (option instanceof Some) {
            Member m = (Member)((Some)option).value();
            MemberStatus memberStatus = m.status();
            MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
            if (memberStatus == null ? memberStatus$Down$ != null : !memberStatus.equals(memberStatus$Down$)) {
                if (localReachability.isReachable(m.uniqueAddress())) {
                    this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged(m.uniqueAddress(), MemberStatus$Down$.MODULE$), "Marking node [{}] as [{}]", (Object)m.address(), (Object)MemberStatus$Down$.MODULE$);
                } else {
                    this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged(m.uniqueAddress(), MemberStatus$Down$.MODULE$), "Marking unreachable node [{}] as [{}]", (Object)m.address(), (Object)MemberStatus$Down$.MODULE$);
                }
                Gossip newGossip = localGossip.markAsDown(m);
                this.updateLatestGossip(newGossip);
                this.publishMembershipState();
                Address address2 = address;
                Address address3 = this.cluster().selfAddress();
                if (!(address2 != null ? !address2.equals(address3) : address3 != null)) {
                    this.gossipRandomN(ClusterCoreDaemon$.MODULE$.MaxGossipsBeforeShuttingDownMyself());
                    return;
                }
                this.gossipTo(m.uniqueAddress());
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.cluster().ClusterLogger().logInfo("Ignoring down of unknown node [{}]", address);
            return;
        }
        throw new MatchError((Object)option);
    }

    public void quarantined(UniqueAddress node) {
        Gossip localGossip = this.latestGossip();
        if (localGossip.hasMember(node)) {
            Reachability newReachability = this.latestGossip().overview().reachability().terminated(this.selfUniqueAddress(), node);
            GossipOverview newOverview = localGossip.overview().copy(localGossip.overview().copy$default$1(), newReachability);
            Gossip newGossip = localGossip.copy(localGossip.copy$default$1(), newOverview, localGossip.copy$default$3(), localGossip.copy$default$4());
            this.updateLatestGossip(newGossip);
            this.cluster().ClusterLogger().logWarning(ClusterLogMarker$.MODULE$.unreachable(node.address()), "Marking node as TERMINATED [{}], due to quarantine. Node roles [{}]. It must still be marked as down before it's removed.", (Object)node.address(), (Object)this.cluster().selfRoles().mkString(","));
            this.publishMembershipState();
            return;
        }
    }

    public void receiveGossipStatus(GossipStatus status) {
        Object object;
        boolean seenSame;
        UniqueAddress from = status.from();
        if (!this.latestGossip().hasMember(from)) {
            this.gossipLogger.logInfo("Ignoring received gossip status from unknown [{}]", from);
            return;
        }
        if (!this.latestGossip().isReachable(this.selfUniqueAddress(), from)) {
            this.gossipLogger.logInfo("Ignoring received gossip status from unreachable [{}] ", from);
            return;
        }
        byte[] localSeenDigest = this.latestGossip().seenDigest();
        Object object2 = Predef$.MODULE$.byteArrayOps(status.seenDigest());
        boolean bl = seenSame = ArrayOps$.MODULE$.isEmpty$extension(object2) || ArrayOps$.MODULE$.isEmpty$extension(object = Predef$.MODULE$.byteArrayOps(localSeenDigest)) ? true : Arrays.equals(status.seenDigest(), localSeenDigest);
        if (!seenSame) {
            this.gossipTo(from, this.sender());
            return;
        }
        VectorClock.Ordering ordering = status.version().compareTo(this.latestGossip().version());
        if (VectorClock$Same$.MODULE$.equals(ordering)) {
            return;
        }
        if (VectorClock$After$.MODULE$.equals(ordering)) {
            this.gossipStatusTo(from, this.sender());
            return;
        }
        this.gossipTo(from, this.sender());
    }

    public final ClusterCoreDaemon$Ignored$ Ignored() {
        Object object = this.Ignored$lzy1;
        if (object instanceof ClusterCoreDaemon$Ignored$) {
            return (ClusterCoreDaemon$Ignored$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClusterCoreDaemon$Ignored$)this.Ignored$lzyINIT1();
    }

    private Object Ignored$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Ignored$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClusterCoreDaemon$Ignored$ clusterCoreDaemon$Ignored$ = null;
                    try {
                        clusterCoreDaemon$Ignored$ = new ClusterCoreDaemon$Ignored$();
                        object2 = clusterCoreDaemon$Ignored$ == null ? LazyVals.NullValue$.MODULE$ : clusterCoreDaemon$Ignored$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Ignored$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clusterCoreDaemon$Ignored$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final ClusterCoreDaemon$Older$ Older() {
        Object object = this.Older$lzy1;
        if (object instanceof ClusterCoreDaemon$Older$) {
            return (ClusterCoreDaemon$Older$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClusterCoreDaemon$Older$)this.Older$lzyINIT1();
    }

    private Object Older$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Older$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClusterCoreDaemon$Older$ clusterCoreDaemon$Older$ = null;
                    try {
                        clusterCoreDaemon$Older$ = new ClusterCoreDaemon$Older$();
                        object2 = clusterCoreDaemon$Older$ == null ? LazyVals.NullValue$.MODULE$ : clusterCoreDaemon$Older$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Older$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clusterCoreDaemon$Older$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final ClusterCoreDaemon$Newer$ Newer() {
        Object object = this.Newer$lzy1;
        if (object instanceof ClusterCoreDaemon$Newer$) {
            return (ClusterCoreDaemon$Newer$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClusterCoreDaemon$Newer$)this.Newer$lzyINIT1();
    }

    private Object Newer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Newer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClusterCoreDaemon$Newer$ clusterCoreDaemon$Newer$ = null;
                    try {
                        clusterCoreDaemon$Newer$ = new ClusterCoreDaemon$Newer$();
                        object2 = clusterCoreDaemon$Newer$ == null ? LazyVals.NullValue$.MODULE$ : clusterCoreDaemon$Newer$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Newer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clusterCoreDaemon$Newer$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final ClusterCoreDaemon$Same$ Same() {
        Object object = this.Same$lzy1;
        if (object instanceof ClusterCoreDaemon$Same$) {
            return (ClusterCoreDaemon$Same$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClusterCoreDaemon$Same$)this.Same$lzyINIT1();
    }

    private Object Same$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Same$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClusterCoreDaemon$Same$ clusterCoreDaemon$Same$ = null;
                    try {
                        clusterCoreDaemon$Same$ = new ClusterCoreDaemon$Same$();
                        object2 = clusterCoreDaemon$Same$ == null ? LazyVals.NullValue$.MODULE$ : clusterCoreDaemon$Same$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Same$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clusterCoreDaemon$Same$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final ClusterCoreDaemon$Merge$ Merge() {
        Object object = this.Merge$lzy1;
        if (object instanceof ClusterCoreDaemon$Merge$) {
            return (ClusterCoreDaemon$Merge$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClusterCoreDaemon$Merge$)this.Merge$lzyINIT1();
    }

    private Object Merge$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Merge$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClusterCoreDaemon$Merge$ clusterCoreDaemon$Merge$ = null;
                    try {
                        clusterCoreDaemon$Merge$ = new ClusterCoreDaemon$Merge$();
                        object2 = clusterCoreDaemon$Merge$ == null ? LazyVals.NullValue$.MODULE$ : clusterCoreDaemon$Merge$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Merge$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clusterCoreDaemon$Merge$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ReceiveGossipType receiveGossip(GossipEnvelope envelope) {
        MemberStatus selfStatus;
        Tuple3 tuple3;
        Gossip gossip;
        UniqueAddress from = envelope.from();
        try {
            gossip = envelope.gossip();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                this.gossipLogger.logWarning("Invalid Gossip. This should only happen during a rolling upgrade. {}", t.getMessage());
                gossip = Gossip$.MODULE$.empty();
            }
            throw throwable;
        }
        Gossip remoteGossip = gossip;
        Gossip localGossip = this.latestGossip();
        if (remoteGossip == Gossip$.MODULE$.empty()) {
            this.gossipLogger.logDebug("Ignoring received gossip from [{}] to protect against overload", from);
            return this.Ignored();
        }
        UniqueAddress uniqueAddress = envelope.to();
        UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
        if (uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) {
            this.gossipLogger.logInfo("Ignoring received gossip intended for someone else, from [{}] to [{}]", from.address(), (Object)envelope.to());
            return this.Ignored();
        }
        if (!localGossip.hasMember(from)) {
            this.gossipLogger.logInfo("Ignoring received gossip from unknown [{}]", from);
            return this.Ignored();
        }
        if (!localGossip.isReachable(this.selfUniqueAddress(), from)) {
            this.gossipLogger.logInfo("Ignoring received gossip from unreachable [{}] ", from);
            return this.Ignored();
        }
        if (remoteGossip.members().forall((Function1 & Serializable)_$13 -> {
            UniqueAddress uniqueAddress = _$13.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
            return uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2);
        })) {
            this.gossipLogger.logInfo("Ignoring received gossip that does not contain myself, from [{}]", from);
            return this.Ignored();
        }
        VectorClock.Ordering comparison = remoteGossip.version().compareTo(localGossip.version());
        VectorClock.Ordering ordering = comparison;
        if (VectorClock$Same$.MODULE$.equals(ordering)) {
            boolean talkback = !this.exitingTasksInProgress() && !remoteGossip.seenByNode(this.selfUniqueAddress());
            tuple3 = Tuple3$.MODULE$.apply((Object)remoteGossip.mergeSeen(localGossip), (Object)BoxesRunTime.boxToBoolean((boolean)talkback), (Object)this.Same());
        } else if (VectorClock$Before$.MODULE$.equals(ordering)) {
            tuple3 = Tuple3$.MODULE$.apply((Object)localGossip, (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)this.Older());
        } else if (VectorClock$After$.MODULE$.equals(ordering)) {
            boolean talkback = !this.exitingTasksInProgress() && !remoteGossip.seenByNode(this.selfUniqueAddress());
            tuple3 = Tuple3$.MODULE$.apply((Object)remoteGossip, (Object)BoxesRunTime.boxToBoolean((boolean)talkback), (Object)this.Newer());
        } else {
            Gossip prunedLocalGossip = (Gossip)localGossip.members().foldLeft((Object)localGossip, (Function2 & Serializable)(g, m) -> {
                if (MembershipState$.MODULE$.removeUnreachableWithMemberStatus().apply((Object)m.status()) && !remoteGossip.members().contains(m)) {
                    this.gossipLogger.logDebug("Pruned conflicting local gossip: {}", m);
                    return g.prune(VectorClock$Node$.MODULE$.apply(Gossip$.MODULE$.vclockName(m.uniqueAddress())));
                }
                return g;
            });
            Gossip prunedRemoteGossip = (Gossip)remoteGossip.members().foldLeft((Object)remoteGossip, (Function2 & Serializable)(g, m) -> {
                if (MembershipState$.MODULE$.removeUnreachableWithMemberStatus().apply((Object)m.status()) && !localGossip.members().contains(m)) {
                    this.gossipLogger.logDebug("Pruned conflicting remote gossip: {}", m);
                    return g.prune(VectorClock$Node$.MODULE$.apply(Gossip$.MODULE$.vclockName(m.uniqueAddress())));
                }
                return g;
            });
            tuple3 = Tuple3$.MODULE$.apply((Object)prunedRemoteGossip.merge(prunedLocalGossip), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)this.Merge());
        }
        Tuple3 tuple32 = tuple3;
        Gossip winningGossip = (Gossip)tuple32._1();
        boolean talkback = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
        ReceiveGossipType gossipType = (ReceiveGossipType)tuple32._3();
        MembershipState membershipState = this.membershipState();
        this.membershipState_$eq(membershipState.copy(this.exitingTasksInProgress() ? winningGossip : winningGossip.seen(this.selfUniqueAddress()), membershipState.copy$default$2(), membershipState.copy$default$3(), membershipState.copy$default$4()));
        this.assertLatestGossip();
        this.latestGossip().members().foreach((Function1)(JProcedure1 & Serializable)node -> {
            if (!localGossip.members().apply(node)) {
                this.cluster().failureDetector().remove((Object)node.address());
                this.cluster().crossDcFailureDetector().remove((Object)node.address());
                return;
            }
        });
        this.gossipLogger.logDebug("Receiving gossip from [{}]", from);
        VectorClock.Ordering ordering2 = comparison;
        VectorClock$Concurrent$ vectorClock$Concurrent$ = VectorClock$Concurrent$.MODULE$;
        if (!(ordering2 != null ? !ordering2.equals(vectorClock$Concurrent$) : vectorClock$Concurrent$ != null) && this.cluster().settings().Debug().VerboseGossipLogging()) {
            this.gossipLogger.logDebug("Couldn't establish a causal relationship between \"remote\" gossip and \"local\" gossip - Remote[{}] - Local[{}] - merged them into [{}]", remoteGossip, localGossip, winningGossip);
        }
        if (this.statsEnabled()) {
            GossipStats gossipStats;
            ReceiveGossipType receiveGossipType = gossipType;
            if (this.Merge().equals(receiveGossipType)) {
                gossipStats = this.gossipStats().incrementMergeCount();
            } else if (this.Same().equals(receiveGossipType)) {
                gossipStats = this.gossipStats().incrementSameCount();
            } else if (this.Newer().equals(receiveGossipType)) {
                gossipStats = this.gossipStats().incrementNewerCount();
            } else if (this.Older().equals(receiveGossipType)) {
                gossipStats = this.gossipStats().incrementOlderCount();
            } else if (this.Ignored().equals(receiveGossipType)) {
                gossipStats = this.gossipStats();
            } else {
                throw new MatchError((Object)receiveGossipType);
            }
            this.gossipStats_$eq(gossipStats);
        }
        this.publishMembershipState();
        MemberStatus memberStatus = selfStatus = this.latestGossip().member(this.selfUniqueAddress()).status();
        MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
        if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null) && !this.exitingTasksInProgress()) {
            this.exitingTasksInProgress_$eq(true);
            if (this.coordShutdown().shutdownReason().isEmpty()) {
                this.cluster().ClusterLogger().logInfo("Exiting, starting coordinated shutdown");
            }
            this.selfExiting().trySuccess((Object)Done$.MODULE$);
            this.coordShutdown().run((CoordinatedShutdown.Reason)CoordinatedShutdown.ClusterLeavingReason$.MODULE$);
        }
        MemberStatus memberStatus2 = selfStatus;
        MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
        if (!(memberStatus2 != null ? !memberStatus2.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
            MemberStatus memberStatus3 = localGossip.member(this.selfUniqueAddress()).status();
            MemberStatus$Down$ memberStatus$Down$2 = MemberStatus$Down$.MODULE$;
            if (memberStatus3 == null ? memberStatus$Down$2 != null : !memberStatus3.equals(memberStatus$Down$2)) {
                this.cluster().ClusterLogger().logWarning("Received gossip where this member has been downed, from [{}]", from.address());
                this.shutdownSelfWhenDown();
            }
        }
        if (talkback) {
            this.gossipTo(from, this.sender());
        }
        return gossipType;
    }

    public void gossipTick() {
        this.gossip();
        if (this.isGossipSpeedupNeeded()) {
            this.cluster().scheduler().scheduleOnce(this.cluster().settings().GossipInterval().$div(3L), this.self(), (Object)InternalClusterAction$GossipSpeedupTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
            this.cluster().scheduler().scheduleOnce(this.cluster().settings().GossipInterval().$times(2L).$div(3L), this.self(), (Object)InternalClusterAction$GossipSpeedupTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
            return;
        }
    }

    public void gossipSpeedupTick() {
        if (this.isGossipSpeedupNeeded()) {
            this.gossip();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isGossipSpeedupNeeded() {
        if (this.latestGossip().isMultiDc()) {
            if (this.latestGossip().members().exists((Function1 & Serializable)m -> {
                MemberStatus memberStatus = m.status();
                MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                if (memberStatus == null) {
                    if (memberStatus$Down$ == null) return true;
                } else if (memberStatus.equals(memberStatus$Down$)) return true;
                String string = m.dataCenter();
                String string2 = this.cluster().selfDataCenter();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            })) return true;
            MembershipState membershipState = this.membershipState();
            if (this.latestGossip().overview().seen().count((Function1 & Serializable)node -> membershipState.isInSameDc((UniqueAddress)node)) >= this.latestGossip().members().count((Function1 & Serializable)_$14 -> {
                String string = _$14.dataCenter();
                String string2 = this.cluster().selfDataCenter();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }) / 2) return false;
            return true;
        }
        if (this.latestGossip().members().exists((Function1 & Serializable)m -> {
            MemberStatus memberStatus = m.status();
            MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
            return !(memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null);
        })) return true;
        if (this.latestGossip().overview().seen().size() >= this.latestGossip().members().size() / 2) return false;
        return true;
    }

    public void gossipRandomN(int n) {
        if (!this.isSingletonCluster() && n > 0) {
            this.gossipTargetSelector().randomNodesForFullGossip(this.membershipState(), n).foreach((Function1)(JProcedure1 & Serializable)node -> this.gossipTo((UniqueAddress)node));
            return;
        }
    }

    public void gossip() {
        if (!this.isSingletonCluster()) {
            Option<UniqueAddress> option = this.gossipTargetSelector().gossipTarget(this.membershipState());
            if (option instanceof Some) {
                UniqueAddress peer = (UniqueAddress)((Some)option).value();
                if (!this.membershipState().isInSameDc(peer) || this.latestGossip().seenByNode(peer)) {
                    this.gossipStatusTo(peer);
                    return;
                }
                this.gossipTo(peer);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                if (this.cluster().settings().Debug().VerboseGossipLogging()) {
                    this.gossipLogger.logDebug("will not gossip this round");
                    return;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public void leaderActions() {
        if (this.membershipState().isLeader(this.selfUniqueAddress())) {
            if (!this.isCurrentlyLeader()) {
                this.cluster().ClusterLogger().logInfo("is the new leader among reachable nodes (more leaders may exist)");
                this.isCurrentlyLeader_$eq(true);
            }
            int firstNotice = 20;
            int periodicNotice = 60;
            if (this.membershipState().convergence(this.exitingConfirmed())) {
                if (this.leaderActionCounter() >= firstNotice) {
                    this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.leaderRestored(), "Leader can perform its duties again");
                }
                this.leaderActionCounter_$eq(0);
                this.leaderActionsOnConvergence();
            } else {
                this.leaderActionCounter_$eq(this.leaderActionCounter() + 1);
                if (this.cluster().settings().AllowWeaklyUpMembers() && this.cluster().settings().LeaderActionsInterval().$times(Int$.MODULE$.int2long(this.leaderActionCounter())).$greater$eq((Object)this.cluster().settings().WeaklyUpAfter()) && !this.preparingForShutdown()) {
                    this.moveJoiningToWeaklyUp();
                }
                if (this.leaderActionCounter() == firstNotice || this.leaderActionCounter() % periodicNotice == 0) {
                    this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.leaderIncapacitated(), "Leader can currently not perform its duties, reachability status: [{}], member status: [{}]", (Object)this.membershipState().dcReachabilityExcludingDownedObservers(), (Object)this.latestGossip().members().collect((PartialFunction)new Serializable(this){
                        private final /* synthetic */ ClusterCoreDaemon $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Member x) {
                            Member member;
                            Member m = member = x;
                            String string = m.dataCenter();
                            String string2 = this.$outer.selfDc();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }

                        public final Object applyOrElse(Member x, Function1 function1) {
                            Member member;
                            Member m = member = x;
                            String string = m.dataCenter();
                            String string2 = this.$outer.selfDc();
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                return new StringBuilder(7).append(m.address()).append(" ").append(m.status()).append(" seen=").append(this.$outer.latestGossip().seenByNode(m.uniqueAddress())).toString();
                            }
                            return function1.apply((Object)x);
                        }
                    }, (Ordering)Ordering.String$.MODULE$).mkString(", "));
                }
            }
        } else if (this.isCurrentlyLeader()) {
            this.cluster().ClusterLogger().logInfo("is no longer leader");
            this.isCurrentlyLeader_$eq(false);
        }
        this.cleanupExitingConfirmed();
        this.checkForPrepareForShutdown();
        this.shutdownSelfWhenDown();
    }

    public void checkForPrepareForShutdown() {
        if (MembershipState$.MODULE$.allowedToPrepareToShutdown().apply((Object)this.latestGossip().member(this.selfUniqueAddress()).status()) && this.latestGossip().members().exists((Function1 & Serializable)m -> MembershipState$.MODULE$.prepareForShutdownStates().apply((Object)m.status()))) {
            this.cluster().ClusterLogger().logDebug("Detected full cluster shutdown");
            this.self().$bang((Object)ClusterUserAction$PrepareForShutdown$.MODULE$, this.self());
            return;
        }
    }

    public void shutdownSelfWhenDown() {
        MemberStatus memberStatus = this.latestGossip().member(this.selfUniqueAddress()).status();
        MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
        if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
            Set<UniqueAddress> unreachable = this.membershipState().dcReachability().allUnreachableOrTerminated();
            scala.collection.SortedSet downed = this.membershipState().dcMembers().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Member x) {
                    Member member;
                    Member m = member = x;
                    MemberStatus memberStatus = m.status();
                    MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                    return !(memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null);
                }

                public final Object applyOrElse(Member x, Function1 function1) {
                    Member member;
                    Member m = member = x;
                    MemberStatus memberStatus = m.status();
                    MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                    if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
                        return m.uniqueAddress();
                    }
                    return function1.apply((Object)x);
                }
            }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            if (this.selfDownCounter() >= ClusterCoreDaemon$.MODULE$.MaxTicksBeforeShuttingDownMyself() || downed.forall((Function1 & Serializable)node -> unreachable.apply(node) || this.latestGossip().seenByNode((UniqueAddress)node))) {
                this.cluster().ClusterLogger().logInfo("Node has been marked as DOWN. Shutting down myself");
                this.gossipRandomN(ClusterCoreDaemon$.MODULE$.MaxGossipsBeforeShuttingDownMyself());
                this.shutdown();
                return;
            }
            this.selfDownCounter_$eq(this.selfDownCounter() + 1);
            return;
        }
    }

    public boolean isMinNrOfMembersFulfilled() {
        return this.latestGossip().members().size() >= this.cluster().settings().MinNrOfMembers() && this.cluster().settings().MinNrOfMembersOfRole().forall((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String role = (String)tuple2._1();
                int threshold = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return this.latestGossip().members().count((Function1 & Serializable)_$15 -> _$15.hasRole(role)) >= threshold;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void leaderActionsOnConvergence() {
        Gossip gossip;
        Set removedUnreachable = (Set)((IterableOps)this.membershipState().dcReachability().allUnreachableOrTerminated().map((Function1 & Serializable)node -> {
            Member m = this.latestGossip().member((UniqueAddress)node);
            return Tuple2$.MODULE$.apply(node, (Object)m);
        })).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UniqueAddress node = (UniqueAddress)tuple2._1();
                Member m = (Member)tuple2._2();
                String string = m.dataCenter();
                String string2 = this.selfDc();
                return !(string != null ? !string.equals(string2) : string2 != null) && MembershipState$.MODULE$.removeUnreachableWithMemberStatus().apply((Object)m.status());
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UniqueAddress node = (UniqueAddress)tuple2._1();
                Member m = (Member)tuple2._2();
                return m;
            }
            throw new MatchError((Object)tuple2);
        });
        Set removedExitingConfirmed = (Set)this.exitingConfirmed().filter((Function1 & Serializable)n -> {
            Member member = this.latestGossip().member((UniqueAddress)n);
            String string = member.dataCenter();
            String string2 = this.selfDc();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            MemberStatus memberStatus = member.status();
            MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
            if (memberStatus == null) {
                if (memberStatus$Exiting$ == null) return true;
                return false;
            } else {
                if (!memberStatus.equals(memberStatus$Exiting$)) return false;
                return true;
            }
        });
        Set removedOtherDc = this.latestGossip().isMultiDc() ? (Set)this.latestGossip().members().filter((Function1 & Serializable)m -> {
            String string = m.dataCenter();
            String string2 = this.selfDc();
            return (string == null ? string2 != null : !string.equals(string2)) && MembershipState$.MODULE$.removeUnreachableWithMemberStatus().apply((Object)m.status());
        }) : Predef$.MODULE$.Set().empty();
        boolean enoughMembers = this.isMinNrOfMembersFulfilled();
        IntRef upNumber = IntRef.create((int)0);
        SortedSet changedMembers = (SortedSet)this.latestGossip().members().collect((PartialFunction)new Serializable(upNumber, enoughMembers, this){
            private final IntRef upNumber$1;
            private final boolean enoughMembers$2;
            private final /* synthetic */ ClusterCoreDaemon $outer;
            {
                this.upNumber$1 = upNumber$2;
                this.enoughMembers$2 = enoughMembers$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Member x) {
                Member member;
                Member m = member = x;
                String string = m.dataCenter();
                String string2 = this.$outer.selfDc();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (ClusterCoreDaemon.org$apache$pekko$cluster$ClusterCoreDaemon$$_$_$isJoiningToUp$1(this.enoughMembers$2, m) && !this.$outer.preparingForShutdown()) {
                        return true;
                    }
                }
                Member m2 = member;
                String string3 = m2.dataCenter();
                String string4 = this.$outer.selfDc();
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    MemberStatus memberStatus = m2.status();
                    MemberStatus$Leaving$ memberStatus$Leaving$ = MemberStatus$Leaving$.MODULE$;
                    if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Leaving$) : memberStatus$Leaving$ != null)) {
                        return true;
                    }
                }
                Member m3 = member;
                String string5 = m3.dataCenter();
                String string6 = this.$outer.selfDc();
                MemberStatus memberStatus = m3.status();
                MemberStatus$PreparingForShutdown$ memberStatus$PreparingForShutdown$ = MemberStatus$PreparingForShutdown$.MODULE$;
                return !(string5 != null ? !string5.equals(string6) : string6 != null) & !(memberStatus != null ? !memberStatus.equals(memberStatus$PreparingForShutdown$) : memberStatus$PreparingForShutdown$ != null);
            }

            public final Object applyOrElse(Member x, Function1 function1) {
                Member member;
                Member m = member = x;
                String string = m.dataCenter();
                String string2 = this.$outer.selfDc();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (ClusterCoreDaemon.org$apache$pekko$cluster$ClusterCoreDaemon$$_$_$isJoiningToUp$1(this.enoughMembers$2, m) && !this.$outer.preparingForShutdown()) {
                        int n;
                        Member youngest;
                        int n2;
                        this.upNumber$1.elem = this.upNumber$1.elem == 0 ? (n2 = 1 + ((youngest = this.$outer.membershipState().youngestMember()).upNumber() == Integer.MAX_VALUE ? 0 : youngest.upNumber())) : (n = this.upNumber$1.elem + 1);
                        return m.copyUp(this.upNumber$1.elem);
                    }
                }
                Member m2 = member;
                String string3 = m2.dataCenter();
                String string4 = this.$outer.selfDc();
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    MemberStatus memberStatus = m2.status();
                    MemberStatus$Leaving$ memberStatus$Leaving$ = MemberStatus$Leaving$.MODULE$;
                    if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Leaving$) : memberStatus$Leaving$ != null)) {
                        return m2.copy(MemberStatus$Exiting$.MODULE$);
                    }
                }
                Member m3 = member;
                String string5 = m3.dataCenter();
                String string6 = this.$outer.selfDc();
                MemberStatus memberStatus = m3.status();
                MemberStatus$PreparingForShutdown$ memberStatus$PreparingForShutdown$ = MemberStatus$PreparingForShutdown$.MODULE$;
                if (!(string5 != null ? !string5.equals(string6) : string6 != null) & !(memberStatus != null ? !memberStatus.equals(memberStatus$PreparingForShutdown$) : memberStatus$PreparingForShutdown$ != null)) {
                    return m3.copy(MemberStatus$ReadyForShutdown$.MODULE$);
                }
                return function1.apply((Object)x);
            }
        }, Member$.MODULE$.ordering());
        if (removedUnreachable.nonEmpty() || removedExitingConfirmed.nonEmpty() || changedMembers.nonEmpty() || removedOtherDc.nonEmpty()) {
            Set removed = (Set)((SetOps)removedUnreachable.map((Function1 & Serializable)_$16 -> _$16.uniqueAddress())).union((scala.collection.Set)removedExitingConfirmed).union((scala.collection.Set)removedOtherDc.map((Function1 & Serializable)_$17 -> _$17.uniqueAddress()));
            Gossip newGossip = this.latestGossip().update((SortedSet<Member>)changedMembers).removeAll((Iterable<UniqueAddress>)removed, System.currentTimeMillis());
            if (!this.exitingTasksInProgress()) {
                MemberStatus memberStatus = newGossip.member(this.selfUniqueAddress()).status();
                MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null)) {
                    this.exitingTasksInProgress_$eq(true);
                    if (this.coordShutdown().shutdownReason().isEmpty()) {
                        this.cluster().ClusterLogger().logInfo("Exiting (leader), starting coordinated shutdown");
                    }
                    this.selfExiting().trySuccess((Object)Done$.MODULE$);
                    this.coordShutdown().run((CoordinatedShutdown.Reason)CoordinatedShutdown.ClusterLeavingReason$.MODULE$);
                }
            }
            this.exitingConfirmed_$eq((Set<UniqueAddress>)((Set)this.exitingConfirmed().filterNot((Function1)removedExitingConfirmed)));
            changedMembers.foreach((Function1)(JProcedure1 & Serializable)m -> this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged(m.uniqueAddress(), m.status()), "Leader is moving node [{}] to [{}]", (Object)m.address(), (Object)m.status()));
            removedUnreachable.foreach((Function1)(JProcedure1 & Serializable)m -> {
                MemberStatus memberStatus = m.status();
                MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                String status = !(memberStatus != null ? !memberStatus.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null) ? "exiting" : "unreachable";
                this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged(m.uniqueAddress(), MemberStatus$Removed$.MODULE$), "Leader is removing {} node [{}]", (Object)status, (Object)m.address());
            });
            removedExitingConfirmed.foreach((Function1)(JProcedure1 & Serializable)n -> this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged((UniqueAddress)n, MemberStatus$Removed$.MODULE$), "Leader is removing confirmed Exiting node [{}]", (Object)n.address()));
            removedOtherDc.foreach((Function1)(JProcedure1 & Serializable)m -> this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged(m.uniqueAddress(), MemberStatus$Removed$.MODULE$), "Leader is removing {} node [{}] in DC [{}]", m.status(), m.address(), m.dataCenter()));
            gossip = newGossip;
        } else {
            gossip = this.latestGossip();
        }
        Gossip updatedGossip = gossip;
        Gossip pruned = updatedGossip.pruneTombstones(System.currentTimeMillis() - this.cluster().settings().PruneGossipTombstonesAfter().toMillis());
        if (pruned != this.latestGossip()) {
            this.updateLatestGossip(pruned);
            this.publishMembershipState();
            this.gossipExitingMembersToOldest((Set<Member>)((Set)changedMembers.filter((Function1 & Serializable)_$18 -> {
                MemberStatus memberStatus = _$18.status();
                MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                return !(memberStatus != null ? !memberStatus.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null);
            })));
            return;
        }
    }

    private void gossipExitingMembersToOldest(Set<Member> exitingMembers) {
        Set<Member> targets = this.membershipState().gossipTargetsForExitingMembers(exitingMembers);
        if (targets.nonEmpty()) {
            if (this.cluster().ClusterLogger().isDebugEnabled()) {
                this.gossipLogger.logDebug("Gossip exiting members [{}] to the two oldest (per role) [{}] (singleton optimization).", exitingMembers.mkString(", "), targets.mkString(", "));
            }
            targets.foreach((Function1)(JProcedure1 & Serializable)m -> this.gossipTo(m.uniqueAddress()));
            return;
        }
    }

    public void moveJoiningToWeaklyUp() {
        boolean enoughMembers;
        Gossip localGossip = this.latestGossip();
        SortedSet<Member> localMembers = localGossip.members();
        SortedSet changedMembers = (SortedSet)localMembers.collect((PartialFunction)new Serializable(enoughMembers = this.isMinNrOfMembersFulfilled(), this){
            private final boolean enoughMembers$5;
            private final /* synthetic */ ClusterCoreDaemon $outer;
            {
                this.enoughMembers$5 = enoughMembers$6;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Member x) {
                Member member = x;
                Member m = member;
                return this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$_$isJoiningToWeaklyUp$1(this.enoughMembers$5, m);
            }

            public final Object applyOrElse(Member x, Function1 function1) {
                Member member = x;
                Member m = member;
                if (this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$_$isJoiningToWeaklyUp$1(this.enoughMembers$5, m)) {
                    return m.copy(MemberStatus$WeaklyUp$.MODULE$);
                }
                return function1.apply((Object)x);
            }
        }, Member$.MODULE$.ordering());
        if (changedMembers.nonEmpty()) {
            Gossip newGossip = localGossip.update((SortedSet<Member>)changedMembers);
            this.updateLatestGossip(newGossip);
            changedMembers.foreach((Function1)(JProcedure1 & Serializable)m -> this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.memberChanged(m.uniqueAddress(), m.status()), "Leader is moving node [{}] to [{}]", (Object)m.address(), (Object)m.status()));
            this.publishMembershipState();
            return;
        }
    }

    public void reapUnreachableMembers() {
        if (!this.isSingletonCluster()) {
            Gossip localGossip = this.latestGossip();
            GossipOverview localOverview = localGossip.overview();
            SortedSet<Member> localMembers = localGossip.members();
            SortedSet newlyDetectedUnreachableMembers = (SortedSet)localMembers.filterNot((Function1 & Serializable)member -> {
                UniqueAddress uniqueAddress = member.uniqueAddress();
                UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
                if (uniqueAddress == null) {
                    if (uniqueAddress2 == null) return true;
                } else if (((Object)uniqueAddress).equals(uniqueAddress2)) return true;
                Reachability.ReachabilityStatus reachabilityStatus = localOverview.reachability().status(this.selfUniqueAddress(), member.uniqueAddress());
                Reachability$Unreachable$ reachability$Unreachable$ = Reachability$Unreachable$.MODULE$;
                if (reachabilityStatus == null) {
                    if (reachability$Unreachable$ == null) return true;
                } else if (reachabilityStatus.equals(reachability$Unreachable$)) return true;
                Reachability.ReachabilityStatus reachabilityStatus2 = localOverview.reachability().status(this.selfUniqueAddress(), member.uniqueAddress());
                Reachability$Terminated$ reachability$Terminated$ = Reachability$Terminated$.MODULE$;
                if (reachabilityStatus2 == null) {
                    if (reachability$Terminated$ == null) return true;
                } else if (reachabilityStatus2.equals(reachability$Terminated$)) return true;
                if (!this.org$apache$pekko$cluster$ClusterCoreDaemon$$_$isAvailable$1((Member)member)) return false;
                return true;
            });
            Set newlyDetectedReachableMembers = (Set)localOverview.reachability().allUnreachableFrom(this.selfUniqueAddress()).collect((PartialFunction)new Serializable(localGossip, this){
                private final Gossip localGossip$3;
                private final /* synthetic */ ClusterCoreDaemon $outer;
                {
                    this.localGossip$3 = localGossip$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(UniqueAddress x) {
                    UniqueAddress uniqueAddress;
                    UniqueAddress node;
                    UniqueAddress uniqueAddress2 = node = (uniqueAddress = x);
                    UniqueAddress uniqueAddress3 = this.$outer.selfUniqueAddress();
                    return (uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3)) && this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$_$isAvailable$1(this.localGossip$3.member(node));
                }

                public final Object applyOrElse(UniqueAddress x, Function1 function1) {
                    UniqueAddress uniqueAddress;
                    UniqueAddress node;
                    UniqueAddress uniqueAddress2 = node = (uniqueAddress = x);
                    UniqueAddress uniqueAddress3 = this.$outer.selfUniqueAddress();
                    if ((uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3)) && this.$outer.org$apache$pekko$cluster$ClusterCoreDaemon$$_$isAvailable$1(this.localGossip$3.member(node))) {
                        return this.localGossip$3.member(node);
                    }
                    return function1.apply((Object)x);
                }
            });
            if (newlyDetectedUnreachableMembers.nonEmpty() || newlyDetectedReachableMembers.nonEmpty()) {
                Reachability newReachability1 = (Reachability)newlyDetectedUnreachableMembers.foldLeft((Object)localOverview.reachability(), (Function2 & Serializable)(reachability, m) -> reachability.unreachable(this.selfUniqueAddress(), m.uniqueAddress()));
                Reachability newReachability2 = (Reachability)newlyDetectedReachableMembers.foldLeft((Object)newReachability1, (Function2 & Serializable)(reachability, m) -> reachability.reachable(this.selfUniqueAddress(), m.uniqueAddress()));
                if (newReachability2 != localOverview.reachability()) {
                    GossipOverview newOverview = localOverview.copy(localOverview.copy$default$1(), newReachability2);
                    Gossip newGossip = localGossip.copy(localGossip.copy$default$1(), newOverview, localGossip.copy$default$3(), localGossip.copy$default$4());
                    this.updateLatestGossip(newGossip);
                    Tuple2 tuple2 = newlyDetectedUnreachableMembers.partition((Function1 & Serializable)_$19 -> {
                        MemberStatus memberStatus = _$19.status();
                        MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                        return !(memberStatus != null ? !memberStatus.equals(memberStatus$Exiting$) : memberStatus$Exiting$ != null);
                    });
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SortedSet exiting = (SortedSet)tuple2._1();
                    SortedSet nonExiting = (SortedSet)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)exiting, (Object)nonExiting);
                    SortedSet exiting2 = (SortedSet)tuple22._1();
                    SortedSet nonExiting2 = (SortedSet)tuple22._2();
                    nonExiting2.foreach((Function1)(JProcedure1 & Serializable)node -> this.cluster().ClusterLogger().logWarning(ClusterLogMarker$.MODULE$.unreachable(node.address()), "Marking node as UNREACHABLE [{}].", node));
                    if (exiting2.nonEmpty()) {
                        this.cluster().ClusterLogger().logInfo("Marking exiting node(s) as UNREACHABLE [{}]. This is expected and they will be removed.", (Object)exiting2.mkString(", "));
                    }
                    newlyDetectedReachableMembers.foreach((Function1)(JProcedure1 & Serializable)node -> this.cluster().ClusterLogger().logInfo(ClusterLogMarker$.MODULE$.reachable(node.address()), "Marking node as REACHABLE [{}].", node));
                    this.publishMembershipState();
                    return;
                }
                return;
            }
            return;
        }
    }

    public boolean isSingletonCluster() {
        return this.latestGossip().isSingletonCluster();
    }

    public void sendGossipTo(Address address) {
        this.latestGossip().members().foreach((Function1)(JProcedure1 & Serializable)m -> {
            Address address = m.address();
            Address address2 = address;
            if (!(address != null ? !address.equals(address2) : address2 != null)) {
                this.gossipTo(m.uniqueAddress());
                return;
            }
        });
    }

    public void gossipTo(UniqueAddress node) {
        if (this.membershipState().validNodeForGossip(node)) {
            ActorSelection$.MODULE$.toScala(this.clusterCore(node.address())).$bang((Object)GossipEnvelope$.MODULE$.apply(this.selfUniqueAddress(), node, this.latestGossip()), this.self());
            return;
        }
    }

    public void gossipTo(UniqueAddress node, ActorRef destination) {
        if (this.membershipState().validNodeForGossip(node)) {
            destination.$bang((Object)GossipEnvelope$.MODULE$.apply(this.selfUniqueAddress(), node, this.latestGossip()), this.self());
            return;
        }
    }

    public void gossipStatusTo(UniqueAddress node, ActorRef destination) {
        if (this.membershipState().validNodeForGossip(node)) {
            destination.$bang((Object)GossipStatus$.MODULE$.apply(this.selfUniqueAddress(), this.latestGossip().version(), this.latestGossip().seenDigest()), this.self());
            return;
        }
    }

    public void gossipStatusTo(UniqueAddress node) {
        if (this.membershipState().validNodeForGossip(node)) {
            ActorSelection$.MODULE$.toScala(this.clusterCore(node.address())).$bang((Object)GossipStatus$.MODULE$.apply(this.selfUniqueAddress(), this.latestGossip().version(), this.latestGossip().seenDigest()), this.self());
            return;
        }
    }

    public void updateLatestGossip(Gossip gossip) {
        Gossip seenVersionedGossip;
        Gossip versionedGossip = gossip.$colon$plus(this.vclockNode());
        Gossip newGossip = this.exitingTasksInProgress() ? versionedGossip.clearSeen() : (seenVersionedGossip = versionedGossip.onlySeen(this.selfUniqueAddress()));
        MembershipState membershipState = this.membershipState();
        this.membershipState_$eq(membershipState.copy(newGossip, membershipState.copy$default$2(), membershipState.copy$default$3(), membershipState.copy$default$4()));
        this.assertLatestGossip();
    }

    public void assertLatestGossip() {
        if (Cluster$.MODULE$.isAssertInvariantsEnabled() && this.latestGossip().version().versions().size() > this.latestGossip().members().size()) {
            throw new IllegalStateException(new StringBuilder(46).append("Too many vector clock entries in gossip state ").append(this.latestGossip()).toString());
        }
    }

    public void publishMembershipState() {
        if (this.cluster().settings().Debug().VerboseGossipLogging()) {
            this.gossipLogger.logDebug("New gossip published [{}]", this.membershipState().latestGossip());
        }
        this.org$apache$pekko$cluster$ClusterCoreDaemon$$publisher.$bang((Object)InternalClusterAction$PublishChanges$.MODULE$.apply(this.membershipState()), this.self());
        Duration duration = this.cluster().settings().PublishStatsInterval();
        FiniteDuration finiteDuration = Duration$.MODULE$.Zero();
        if (!(duration != null ? !duration.equals(finiteDuration) : finiteDuration != null)) {
            this.publishInternalStats();
            return;
        }
    }

    public void publishInternalStats() {
        VectorClockStats vclockStats = VectorClockStats$.MODULE$.apply(this.latestGossip().version().versions().size(), this.latestGossip().members().count((Function1 & Serializable)m -> this.latestGossip().seenByNode(m.uniqueAddress())));
        this.org$apache$pekko$cluster$ClusterCoreDaemon$$publisher.$bang((Object)ClusterEvent$CurrentInternalStats$.MODULE$.apply(this.gossipStats(), vclockStats), this.self());
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$ClusterCoreDaemon$$anon$4$$_$applyOrElse$$anonfun$3(Deadline _$4) {
        return _$4.isOverdue();
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$ClusterCoreDaemon$$anon$5$$_$applyOrElse$$anonfun$4(Deadline _$5) {
        return _$5.isOverdue();
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$ClusterCoreDaemon$$anon$5$$_$applyOrElse$$anonfun$5(Deadline _$6) {
        return _$6.isOverdue();
    }

    private static final ClusterHeartbeatSender $anonfun$1() {
        return new ClusterHeartbeatSender();
    }

    private static final CrossDcHeartbeatSender $anonfun$2() {
        return new CrossDcHeartbeatSender();
    }

    private static final Object join$$anonfun$1() {
        return "Join can only be done from empty state";
    }

    private static final Object welcome$$anonfun$1() {
        return "Join can only be done from empty state";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean org$apache$pekko$cluster$ClusterCoreDaemon$$_$_$isJoiningToUp$1(boolean enoughMembers$1, Member m) {
        MemberStatus memberStatus = m.status();
        MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
        if (memberStatus == null ? memberStatus$Joining$ != null : !memberStatus.equals(memberStatus$Joining$)) {
            MemberStatus memberStatus2 = m.status();
            MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
            if (memberStatus2 == null) {
                if (memberStatus$WeaklyUp$ != null) {
                    return false;
                }
            } else if (!memberStatus2.equals(memberStatus$WeaklyUp$)) return false;
        }
        if (!enoughMembers$1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean org$apache$pekko$cluster$ClusterCoreDaemon$$_$isJoiningToWeaklyUp$1(boolean enoughMembers$3, Member m) {
        String string = m.dataCenter();
        String string2 = this.selfDc();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        MemberStatus memberStatus = m.status();
        MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
        if (memberStatus == null) {
            if (memberStatus$Joining$ != null) {
                return false;
            }
        } else if (!memberStatus.equals(memberStatus$Joining$)) return false;
        if (!enoughMembers$3) return false;
        if (!this.membershipState().dcReachabilityExcludingDownedObservers().isReachable(m.uniqueAddress())) return false;
        return true;
    }

    public final boolean org$apache$pekko$cluster$ClusterCoreDaemon$$_$isAvailable$1(Member member) {
        String string = member.dataCenter();
        String string2 = this.cluster().settings().SelfDataCenter();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.cluster().failureDetector().isAvailable((Object)member.address());
        }
        return this.cluster().crossDcFailureDetector().isAvailable((Object)member.address());
    }

    public interface ReceiveGossipType {
    }
}

