/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$MemberRemoved$;
import org.apache.pekko.cluster.ClusterEvent$ReachableMember$;
import org.apache.pekko.cluster.ClusterEvent$UnreachableMember$;
import org.apache.pekko.cluster.ClusterHeartbeatReceiver$;
import org.apache.pekko.cluster.ClusterHeartbeatSender$ExpectedFirstHeartbeat$;
import org.apache.pekko.cluster.ClusterHeartbeatSender$Heartbeat$;
import org.apache.pekko.cluster.ClusterHeartbeatSender$HeartbeatRsp$;
import org.apache.pekko.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import org.apache.pekko.cluster.ClusterHeartbeatSenderState;
import org.apache.pekko.cluster.ClusterHeartbeatSenderState$;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterLogMarker$;
import org.apache.pekko.cluster.ClusterMessage;
import org.apache.pekko.cluster.HeartbeatNodeRing$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.event.ActorWithLogClass$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.remote.HeartbeatMessage;
import scala.Function1;
import scala.Int$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class ClusterHeartbeatSender
implements Actor {
    private ActorContext context;
    private ActorRef self;
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Cluster.ClusterLogger clusterLogger;
    private final Function1 filterInternalClusterMembers;
    private int sequenceNr;
    private final FailureDetectorRegistry failureDetector;
    private ClusterHeartbeatSenderState state;
    private final Cancellable heartbeatTask;
    public long org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp;

    public ClusterHeartbeatSender() {
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.clusterLogger = new Cluster.ClusterLogger(this.cluster(), Logging$.MODULE$.withMarker(this.context().system(), (Object)ActorWithLogClass$.MODULE$.apply((Actor)this, ClusterLogClass$.MODULE$.ClusterHeartbeat()), LogSource$.MODULE$.fromActorWithLoggerClass()));
        this.filterInternalClusterMembers = (Function1 & Serializable)_$1 -> {
            String string = _$1.dataCenter();
            String string2 = this.cluster().selfDataCenter();
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        this.sequenceNr = 0;
        this.failureDetector = this.cluster().failureDetector();
        this.state = ClusterHeartbeatSenderState$.MODULE$.apply(HeartbeatNodeRing$.MODULE$.apply(this.cluster().selfUniqueAddress(), (Set<UniqueAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{this.cluster().selfUniqueAddress()}))), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.cluster().settings().MonitoredByNrOfMembers()), (Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.failureDetector());
        this.heartbeatTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()), this.cluster().settings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp = System.nanoTime() + this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().HeartbeatInterval()).toNanos();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    public Function1<Member, Object> filterInternalClusterMembers() {
        return this.filterInternalClusterMembers;
    }

    public int sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(int x$1) {
        this.sequenceNr = x$1;
    }

    public Heartbeat selfHeartbeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1);
        return ClusterHeartbeatSender$Heartbeat$.MODULE$.apply(this.cluster().selfAddress(), Int$.MODULE$.int2long(this.sequenceNr()), System.nanoTime());
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public ClusterHeartbeatSenderState state() {
        return this.state;
    }

    public void state_$eq(ClusterHeartbeatSenderState x$1) {
        this.state = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
    }

    public void postStop() {
        this.state().activeReceivers().foreach((Function1)(JProcedure1 & Serializable)a -> this.failureDetector().remove((Object)a.address()));
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.initializing();
    }

    public PartialFunction<Object, BoxedUnit> initializing() {
        return new Serializable(this){
            private final /* synthetic */ ClusterHeartbeatSender $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState s = (ClusterEvent.CurrentClusterState)object;
                    return true;
                }
                return ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState s = (ClusterEvent.CurrentClusterState)object;
                    this.$outer.init(s);
                    this.$outer.context().become(this.$outer.active());
                    return BoxedUnit.UNIT;
                }
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp = System.nanoTime();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private final /* synthetic */ ClusterHeartbeatSender $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof HeartbeatRsp) {
                    HeartbeatRsp response = (HeartbeatRsp)object;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent evt = (ClusterEvent.MemberEvent)object;
                    return true;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    Member member;
                    ClusterEvent.UnreachableMember unreachableMember = ClusterEvent$UnreachableMember$.MODULE$.unapply((ClusterEvent.UnreachableMember)object);
                    Member m = member = unreachableMember._1();
                    return true;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    Member member;
                    ClusterEvent.ReachableMember reachableMember = ClusterEvent$ReachableMember$.MODULE$.unapply((ClusterEvent.ReachableMember)object);
                    Member m = member = reachableMember._1();
                    return true;
                }
                if (object instanceof ExpectedFirstHeartbeat) {
                    UniqueAddress uniqueAddress;
                    ExpectedFirstHeartbeat expectedFirstHeartbeat = ClusterHeartbeatSender$ExpectedFirstHeartbeat$.MODULE$.unapply((ExpectedFirstHeartbeat)object);
                    UniqueAddress from = uniqueAddress = expectedFirstHeartbeat._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)) {
                    this.$outer.heartbeat();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof HeartbeatRsp) {
                    HeartbeatRsp response = (HeartbeatRsp)object;
                    this.$outer.heartbeatRsp(response);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    this.$outer.removeMember(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent evt = (ClusterEvent.MemberEvent)object;
                    this.$outer.addMember(evt.member());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    Member member;
                    ClusterEvent.UnreachableMember unreachableMember = ClusterEvent$UnreachableMember$.MODULE$.unapply((ClusterEvent.UnreachableMember)object);
                    Member m = member = unreachableMember._1();
                    this.$outer.unreachableMember(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    Member member;
                    ClusterEvent.ReachableMember reachableMember = ClusterEvent$ReachableMember$.MODULE$.unapply((ClusterEvent.ReachableMember)object);
                    Member m = member = reachableMember._1();
                    this.$outer.reachableMember(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ExpectedFirstHeartbeat) {
                    UniqueAddress uniqueAddress;
                    ExpectedFirstHeartbeat expectedFirstHeartbeat = ClusterHeartbeatSender$ExpectedFirstHeartbeat$.MODULE$.unapply((ExpectedFirstHeartbeat)object);
                    UniqueAddress from = uniqueAddress = expectedFirstHeartbeat._1();
                    this.$outer.triggerFirstHeartbeat(from);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet nodes = (SortedSet)snapshot.members().collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ ClusterHeartbeatSender $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Member x) {
                Member member;
                Member m = member = x;
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)m));
            }

            public final Object applyOrElse(Member x, Function1 function1) {
                Member member;
                Member m = member = x;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)m))) {
                    return m.uniqueAddress();
                }
                return function1.apply((Object)x);
            }
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Set unreachable = (Set)snapshot.unreachable().collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ ClusterHeartbeatSender $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Member x) {
                Member member;
                Member m = member = x;
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)m));
            }

            public final Object applyOrElse(Member x, Function1 function1) {
                Member member;
                Member m = member = x;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.filterInternalClusterMembers().apply((Object)m))) {
                    return m.uniqueAddress();
                }
                return function1.apply((Object)x);
            }
        });
        this.state_$eq(this.state().init((Set<UniqueAddress>)nodes, (Set<UniqueAddress>)unreachable));
    }

    public void addMember(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
        if ((uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) && !this.state().contains(m.uniqueAddress()) && BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) {
            this.state_$eq(this.state().addMember(m.uniqueAddress()));
            return;
        }
    }

    public void removeMember(Member m) {
        if (BoxesRunTime.unboxToBoolean((Object)this.filterInternalClusterMembers().apply((Object)m))) {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                this.context().stop(this.self());
                return;
            }
            this.state_$eq(this.state().removeMember(m.uniqueAddress()));
            return;
        }
    }

    public void unreachableMember(Member m) {
        this.state_$eq(this.state().unreachableMember(m.uniqueAddress()));
    }

    public void reachableMember(Member m) {
        this.state_$eq(this.state().reachableMember(m.uniqueAddress()));
    }

    public void heartbeat() {
        Heartbeat nextHB = this.selfHeartbeat();
        this.state().activeReceivers().foreach((Function1)(JProcedure1 & Serializable)to -> {
            BoxedUnit boxedUnit;
            if (this.failureDetector().isMonitoring((Object)to.address())) {
                if (this.verboseHeartbeat()) {
                    this.clusterLogger.logDebug("Heartbeat to [{}]", to.address());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (this.verboseHeartbeat()) {
                    this.clusterLogger.logDebug("First Heartbeat to [{}]", to.address());
                }
                boxedUnit = this.cluster().scheduler().scheduleOnce(this.cluster().settings().HeartbeatExpectedResponseAfter(), this.self(), (Object)ClusterHeartbeatSender$ExpectedFirstHeartbeat$.MODULE$.apply((UniqueAddress)to), (ExecutionContext)this.context().dispatcher(), this.self());
            }
            ActorSelection$.MODULE$.toScala(this.heartbeatReceiver(to.address())).$bang((Object)nextHB, this.self());
        });
        this.checkTickInterval();
    }

    private void checkTickInterval() {
        long now = System.nanoTime();
        if (now - this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp >= this.cluster().settings().HeartbeatInterval().toNanos() * 2L) {
            this.clusterLogger.logWarning(ClusterLogMarker$.MODULE$.heartbeatStarvation(), "Scheduled sending of heartbeat was delayed. Previous heartbeat was sent [{}] ms ago, expected interval is [{}] ms. This may cause failure detection to mark members as unreachable. The reason can be thread starvation, CPU overload, or GC.", (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(now - this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp)), (Object)BoxesRunTime.boxToLong((long)this.cluster().settings().HeartbeatInterval().toMillis()));
        }
        this.org$apache$pekko$cluster$ClusterHeartbeatSender$$tickTimestamp = now;
    }

    public void heartbeatRsp(HeartbeatRsp response) {
        if (this.verboseHeartbeat()) {
            this.clusterLogger.logDebug("Heartbeat response from [{}]", response.from().address());
        }
        this.state_$eq(this.state().heartbeatRsp(response.from()));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        if (this.state().activeReceivers().apply((Object)from) && !this.failureDetector().isMonitoring((Object)from.address())) {
            if (this.verboseHeartbeat()) {
                this.clusterLogger.logDebug("Trigger extra expected heartbeat from [{}]", from.address());
            }
            this.failureDetector().heartbeat((Object)from.address());
            return;
        }
    }

    public static final class ExpectedFirstHeartbeat
    implements Product,
    Serializable {
        private final UniqueAddress from;

        public static ExpectedFirstHeartbeat apply(UniqueAddress uniqueAddress) {
            return ClusterHeartbeatSender$ExpectedFirstHeartbeat$.MODULE$.apply(uniqueAddress);
        }

        public static ExpectedFirstHeartbeat fromProduct(Product product) {
            return ClusterHeartbeatSender$ExpectedFirstHeartbeat$.MODULE$.fromProduct(product);
        }

        public static ExpectedFirstHeartbeat unapply(ExpectedFirstHeartbeat expectedFirstHeartbeat) {
            return ClusterHeartbeatSender$ExpectedFirstHeartbeat$.MODULE$.unapply(expectedFirstHeartbeat);
        }

        public ExpectedFirstHeartbeat(UniqueAddress from) {
            this.from = from;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExpectedFirstHeartbeat)) return false;
            ExpectedFirstHeartbeat expectedFirstHeartbeat = (ExpectedFirstHeartbeat)object;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = expectedFirstHeartbeat.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExpectedFirstHeartbeat;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ExpectedFirstHeartbeat";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "from";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UniqueAddress from() {
            return this.from;
        }

        public ExpectedFirstHeartbeat copy(UniqueAddress from) {
            return new ExpectedFirstHeartbeat(from);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public UniqueAddress _1() {
            return this.from();
        }
    }

    public static final class Heartbeat
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final Address from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public static Heartbeat apply(Address address, long l, long l2) {
            return ClusterHeartbeatSender$Heartbeat$.MODULE$.apply(address, l, l2);
        }

        public static Heartbeat fromProduct(Product product) {
            return ClusterHeartbeatSender$Heartbeat$.MODULE$.fromProduct(product);
        }

        public static Heartbeat unapply(Heartbeat heartbeat) {
            return ClusterHeartbeatSender$Heartbeat$.MODULE$.unapply(heartbeat);
        }

        public Heartbeat(Address from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Heartbeat)) return false;
            Heartbeat heartbeat = (Heartbeat)object;
            if (this.sequenceNr() != heartbeat.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeat.creationTimeNanos()) return false;
            Address address = this.from();
            Address address2 = heartbeat.from();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Heartbeat;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Heartbeat";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "from";
                }
                case 1: {
                    return "sequenceNr";
                }
                case 2: {
                    return "creationTimeNanos";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public Heartbeat copy(Address from, long sequenceNr, long creationTimeNanos) {
            return new Heartbeat(from, sequenceNr, creationTimeNanos);
        }

        public Address copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public Address _1() {
            return this.from();
        }

        public long _2() {
            return this.sequenceNr();
        }

        public long _3() {
            return this.creationTimeNanos();
        }
    }

    public static final class HeartbeatRsp
    implements ClusterMessage,
    HeartbeatMessage,
    DeadLetterSuppression,
    Product {
        private final UniqueAddress from;
        private final long sequenceNr;
        private final long creationTimeNanos;

        public static HeartbeatRsp apply(UniqueAddress uniqueAddress, long l, long l2) {
            return ClusterHeartbeatSender$HeartbeatRsp$.MODULE$.apply(uniqueAddress, l, l2);
        }

        public static HeartbeatRsp fromProduct(Product product) {
            return ClusterHeartbeatSender$HeartbeatRsp$.MODULE$.fromProduct(product);
        }

        public static HeartbeatRsp unapply(HeartbeatRsp heartbeatRsp) {
            return ClusterHeartbeatSender$HeartbeatRsp$.MODULE$.unapply(heartbeatRsp);
        }

        public HeartbeatRsp(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            this.from = from;
            this.sequenceNr = sequenceNr;
            this.creationTimeNanos = creationTimeNanos;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.from()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sequenceNr()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.creationTimeNanos()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HeartbeatRsp)) return false;
            HeartbeatRsp heartbeatRsp = (HeartbeatRsp)object;
            if (this.sequenceNr() != heartbeatRsp.sequenceNr()) return false;
            if (this.creationTimeNanos() != heartbeatRsp.creationTimeNanos()) return false;
            UniqueAddress uniqueAddress = this.from();
            UniqueAddress uniqueAddress2 = heartbeatRsp.from();
            if (uniqueAddress != null) {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
            if (uniqueAddress2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HeartbeatRsp;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "HeartbeatRsp";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "from";
                }
                case 1: {
                    return "sequenceNr";
                }
                case 2: {
                    return "creationTimeNanos";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UniqueAddress from() {
            return this.from;
        }

        public long sequenceNr() {
            return this.sequenceNr;
        }

        public long creationTimeNanos() {
            return this.creationTimeNanos;
        }

        public HeartbeatRsp copy(UniqueAddress from, long sequenceNr, long creationTimeNanos) {
            return new HeartbeatRsp(from, sequenceNr, creationTimeNanos);
        }

        public UniqueAddress copy$default$1() {
            return this.from();
        }

        public long copy$default$2() {
            return this.sequenceNr();
        }

        public long copy$default$3() {
            return this.creationTimeNanos();
        }

        public UniqueAddress _1() {
            return this.from();
        }

        public long _2() {
            return this.sequenceNr();
        }

        public long _3() {
            return this.creationTimeNanos();
        }
    }
}

