/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterHeartbeatSenderState$;
import org.apache.pekko.cluster.HeartbeatNodeRing;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.remote.FailureDetectorRegistry;
import scala.Function1;
import scala.Product;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class ClusterHeartbeatSenderState
implements Product,
Serializable {
    private final HeartbeatNodeRing ring;
    private final Set oldReceiversNowUnreachable;
    private final FailureDetectorRegistry failureDetector;
    private final Set activeReceivers;

    public static ClusterHeartbeatSenderState apply(HeartbeatNodeRing heartbeatNodeRing, Set<UniqueAddress> set, FailureDetectorRegistry<Address> failureDetectorRegistry) {
        return ClusterHeartbeatSenderState$.MODULE$.apply(heartbeatNodeRing, set, failureDetectorRegistry);
    }

    public static ClusterHeartbeatSenderState fromProduct(Product product) {
        return ClusterHeartbeatSenderState$.MODULE$.fromProduct(product);
    }

    public static ClusterHeartbeatSenderState unapply(ClusterHeartbeatSenderState clusterHeartbeatSenderState) {
        return ClusterHeartbeatSenderState$.MODULE$.unapply(clusterHeartbeatSenderState);
    }

    public ClusterHeartbeatSenderState(HeartbeatNodeRing ring, Set<UniqueAddress> oldReceiversNowUnreachable, FailureDetectorRegistry<Address> failureDetector) {
        this.ring = ring;
        this.oldReceiversNowUnreachable = oldReceiversNowUnreachable;
        this.failureDetector = failureDetector;
        this.activeReceivers = (Set)ring.myReceivers().union(oldReceiversNowUnreachable);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ClusterHeartbeatSenderState)) return false;
        ClusterHeartbeatSenderState clusterHeartbeatSenderState = (ClusterHeartbeatSenderState)object;
        HeartbeatNodeRing heartbeatNodeRing = this.ring();
        HeartbeatNodeRing heartbeatNodeRing2 = clusterHeartbeatSenderState.ring();
        if (heartbeatNodeRing == null) {
            if (heartbeatNodeRing2 != null) {
                return false;
            }
        } else if (!((Object)heartbeatNodeRing).equals(heartbeatNodeRing2)) return false;
        Set<UniqueAddress> set = this.oldReceiversNowUnreachable();
        Set<UniqueAddress> set2 = clusterHeartbeatSenderState.oldReceiversNowUnreachable();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        FailureDetectorRegistry<Address> failureDetectorRegistry = this.failureDetector();
        FailureDetectorRegistry<Address> failureDetectorRegistry2 = clusterHeartbeatSenderState.failureDetector();
        if (failureDetectorRegistry == null) {
            if (failureDetectorRegistry2 == null) return true;
            return false;
        } else {
            if (!failureDetectorRegistry.equals(failureDetectorRegistry2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ClusterHeartbeatSenderState;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "ClusterHeartbeatSenderState";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "ring";
            }
            case 1: {
                return "oldReceiversNowUnreachable";
            }
            case 2: {
                return "failureDetector";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public HeartbeatNodeRing ring() {
        return this.ring;
    }

    public Set<UniqueAddress> oldReceiversNowUnreachable() {
        return this.oldReceiversNowUnreachable;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public Set<UniqueAddress> activeReceivers() {
        return this.activeReceivers;
    }

    public UniqueAddress selfAddress() {
        return this.ring().selfAddress();
    }

    public ClusterHeartbeatSenderState init(Set<UniqueAddress> nodes, Set<UniqueAddress> unreachable) {
        Set set = (Set)nodes.$plus((Object)this.selfAddress());
        UniqueAddress uniqueAddress = this.ring().copy$default$1();
        int n = this.ring().copy$default$4();
        return this.copy(this.ring().copy(uniqueAddress, (Set<UniqueAddress>)set, unreachable, n), this.copy$default$2(), this.copy$default$3());
    }

    public boolean contains(UniqueAddress node) {
        return this.ring().nodes().apply((Object)node);
    }

    public ClusterHeartbeatSenderState addMember(UniqueAddress node) {
        return this.membershipChange(this.ring().$colon$plus(node));
    }

    public ClusterHeartbeatSenderState removeMember(UniqueAddress node) {
        ClusterHeartbeatSenderState newState = this.membershipChange(this.ring().$colon$minus(node));
        this.failureDetector().remove((Object)node.address());
        if (newState.oldReceiversNowUnreachable().apply((Object)node)) {
            Set set = (Set)newState.oldReceiversNowUnreachable().$minus((Object)node);
            HeartbeatNodeRing heartbeatNodeRing = newState.copy$default$1();
            FailureDetectorRegistry<Address> failureDetectorRegistry = newState.copy$default$3();
            return newState.copy(heartbeatNodeRing, (Set<UniqueAddress>)set, failureDetectorRegistry);
        }
        return newState;
    }

    public ClusterHeartbeatSenderState unreachableMember(UniqueAddress node) {
        Set set = (Set)this.ring().unreachable().$plus((Object)node);
        UniqueAddress uniqueAddress = this.ring().copy$default$1();
        Set<UniqueAddress> set2 = this.ring().copy$default$2();
        int n = this.ring().copy$default$4();
        return this.membershipChange(this.ring().copy(uniqueAddress, set2, (Set<UniqueAddress>)set, n));
    }

    public ClusterHeartbeatSenderState reachableMember(UniqueAddress node) {
        Set set = (Set)this.ring().unreachable().$minus((Object)node);
        UniqueAddress uniqueAddress = this.ring().copy$default$1();
        Set<UniqueAddress> set2 = this.ring().copy$default$2();
        int n = this.ring().copy$default$4();
        return this.membershipChange(this.ring().copy(uniqueAddress, set2, (Set<UniqueAddress>)set, n));
    }

    private ClusterHeartbeatSenderState membershipChange(HeartbeatNodeRing newRing) {
        Set<UniqueAddress> oldReceivers = this.ring().myReceivers();
        Set removedReceivers = (Set)oldReceivers.diff(newRing.myReceivers());
        ObjectRef adjustedOldReceiversNowUnreachable = ObjectRef.create(this.oldReceiversNowUnreachable());
        removedReceivers.foreach((Function1)(JProcedure1 & Serializable)a -> {
            if (this.failureDetector().isAvailable((Object)a.address())) {
                this.failureDetector().remove((Object)a.address());
                return;
            }
            Set set = (Set)((Set)adjustedOldReceiversNowUnreachable$1.elem).$plus(a);
            adjustedOldReceiversNowUnreachable$1.elem = set;
            set = null;
        });
        return this.copy(newRing, (Set<UniqueAddress>)((Set)adjustedOldReceiversNowUnreachable.elem), this.copy$default$3());
    }

    public ClusterHeartbeatSenderState heartbeatRsp(UniqueAddress from) {
        if (this.activeReceivers().apply((Object)from)) {
            this.failureDetector().heartbeat((Object)from.address());
            if (this.oldReceiversNowUnreachable().apply((Object)from)) {
                if (!this.ring().myReceivers().apply((Object)from)) {
                    this.failureDetector().remove((Object)from.address());
                }
                Set set = (Set)this.oldReceiversNowUnreachable().$minus((Object)from);
                HeartbeatNodeRing heartbeatNodeRing = this.copy$default$1();
                FailureDetectorRegistry<Address> failureDetectorRegistry = this.copy$default$3();
                return this.copy(heartbeatNodeRing, (Set<UniqueAddress>)set, failureDetectorRegistry);
            }
            return this;
        }
        return this;
    }

    public ClusterHeartbeatSenderState copy(HeartbeatNodeRing ring, Set<UniqueAddress> oldReceiversNowUnreachable, FailureDetectorRegistry<Address> failureDetector) {
        return new ClusterHeartbeatSenderState(ring, oldReceiversNowUnreachable, failureDetector);
    }

    public HeartbeatNodeRing copy$default$1() {
        return this.ring();
    }

    public Set<UniqueAddress> copy$default$2() {
        return this.oldReceiversNowUnreachable();
    }

    public FailureDetectorRegistry<Address> copy$default$3() {
        return this.failureDetector();
    }

    public HeartbeatNodeRing _1() {
        return this.ring();
    }

    public Set<UniqueAddress> _2() {
        return this.oldReceiversNowUnreachable();
    }

    public FailureDetectorRegistry<Address> _3() {
        return this.failureDetector();
    }
}

