/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.AddressFromURIString$;
import org.apache.pekko.cluster.ClusterSettings$;
import org.apache.pekko.cluster.ClusterSettings$Debug$;
import org.apache.pekko.cluster.ClusterSettings$MultiDataCenter$;
import org.apache.pekko.cluster.NoDowning;
import org.apache.pekko.util.Helpers;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Version;
import org.apache.pekko.util.Version$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.java8.JFunction1;

public final class ClusterSettings {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ClusterSettings.class.getDeclaredField("Debug$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ClusterSettings.class.getDeclaredField("MultiDataCenter$lzy1"));
    private final Config config;
    private final String systemName;
    public final Config org$apache$pekko$cluster$ClusterSettings$$cc;
    private final boolean LogInfoVerbose;
    private final boolean LogInfo;
    private final Config FailureDetectorConfig;
    private final String FailureDetectorImplementationClass;
    private final FiniteDuration HeartbeatInterval;
    private final FiniteDuration HeartbeatExpectedResponseAfter;
    private final int MonitoredByNrOfMembers;
    private volatile Object MultiDataCenter$lzy1;
    private final IndexedSeq SeedNodes;
    private final FiniteDuration SeedNodeTimeout;
    private final Duration RetryUnsuccessfulJoinAfter;
    private final Duration ShutdownAfterUnsuccessfulJoinSeedNodes;
    private final FiniteDuration PeriodicTasksInitialDelay;
    private final FiniteDuration GossipInterval;
    private final FiniteDuration GossipTimeToLive;
    private final FiniteDuration LeaderActionsInterval;
    private final FiniteDuration UnreachableNodesReaperInterval;
    private final Duration PublishStatsInterval;
    private final Duration PruneGossipTombstonesAfter;
    private final FiniteDuration DownRemovalMargin;
    private final String DowningProviderClassName;
    private final FiniteDuration QuarantineRemovedNodeAfter;
    private final FiniteDuration WeaklyUpAfter;
    private final boolean AllowWeaklyUpMembers;
    private final String SelfDataCenter;
    private final Set Roles;
    private final Version AppVersion;
    private final int MinNrOfMembers;
    private final scala.collection.immutable.Map MinNrOfMembersOfRole;
    private final boolean RunCoordinatedShutdownWhenDown;
    private final boolean JmxEnabled;
    private final boolean JmxMultiMbeansInSameEnabled;
    private final String UseDispatcher;
    private final double GossipDifferentViewProbability;
    private final int ReduceGossipDifferentViewProbability;
    private final FiniteDuration SchedulerTickDuration;
    private final int SchedulerTicksPerWheel;
    private final boolean ByPassConfigCompatCheck;
    private final Set ConfigCompatCheckers;
    private final Set SensitiveConfigPaths;
    private volatile Object Debug$lzy1;

    public static String DcRolePrefix() {
        return ClusterSettings$.MODULE$.DcRolePrefix();
    }

    public static String DefaultDataCenter() {
        return ClusterSettings$.MODULE$.DefaultDataCenter();
    }

    public ClusterSettings(Config config, String systemName) {
        FiniteDuration finiteDuration;
        FiniteDuration finiteDuration2;
        Duration.Infinite infinite;
        Duration.Infinite infinite2;
        Duration.Infinite infinite3;
        this.config = config;
        this.systemName = systemName;
        this.org$apache$pekko$cluster$ClusterSettings$$cc = config.getConfig("pekko.cluster");
        this.LogInfoVerbose = this.org$apache$pekko$cluster$ClusterSettings$$cc.getBoolean("log-info-verbose");
        this.LogInfo = this.LogInfoVerbose() || this.org$apache$pekko$cluster$ClusterSettings$$cc.getBoolean("log-info");
        this.FailureDetectorConfig = this.org$apache$pekko$cluster$ClusterSettings$$cc.getConfig("failure-detector");
        this.FailureDetectorImplementationClass = this.FailureDetectorConfig().getString("implementation-class");
        FiniteDuration finiteDuration3 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.FailureDetectorConfig()), "heartbeat-interval"));
        this.HeartbeatInterval = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration3, (Function1 & Serializable)_$1 -> _$1.$greater((Object)Duration$.MODULE$.Zero()), ClusterSettings::$init$$$anonfun$2);
        FiniteDuration finiteDuration4 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.FailureDetectorConfig()), "expected-response-after"));
        this.HeartbeatExpectedResponseAfter = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration4, (Function1 & Serializable)_$2 -> _$2.$greater((Object)Duration$.MODULE$.Zero()), ClusterSettings::$init$$$anonfun$4);
        Integer n = (Integer)Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)this.FailureDetectorConfig().getInt("monitored-by-nr-of-members")));
        this.MonitoredByNrOfMembers = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension((Object)n, (Function1)(JFunction1.mcZI.sp & Serializable)_$3 -> _$3 > 0, ClusterSettings::$init$$$anonfun$6));
        this.SeedNodes = ((IterableOnceOps)package.JavaConverters$.MODULE$.ListHasAsScala(this.org$apache$pekko$cluster$ClusterSettings$$cc.getStringList("seed-nodes")).asScala().map((Function1 & Serializable)x$1 -> {
            Option option;
            String string = x$1;
            if (string != null && !(option = AddressFromURIString$.MODULE$.unapply(string)).isEmpty()) {
                Address address;
                Address address2 = address = (Address)option.get();
                return address2;
            }
            throw new RuntimeException();
        })).toVector();
        this.SeedNodeTimeout = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), "seed-node-timeout");
        String key = "retry-unsuccessful-join-after";
        String string = Helpers$.MODULE$.toRootLowerCase(this.org$apache$pekko$cluster$ClusterSettings$$cc.getString(key));
        if ("off".equals(string)) {
            infinite3 = Duration$.MODULE$.Undefined();
        } else {
            FiniteDuration finiteDuration5 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), key));
            infinite3 = (Duration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration5, (Function1 & Serializable)_$7 -> _$7.$greater((Object)Duration$.MODULE$.Zero()), () -> ClusterSettings.$init$$$anonfun$9(key));
        }
        this.RetryUnsuccessfulJoinAfter = infinite3;
        String key2 = "shutdown-after-unsuccessful-join-seed-nodes";
        String string2 = Helpers$.MODULE$.toRootLowerCase(this.org$apache$pekko$cluster$ClusterSettings$$cc.getString(key2));
        if ("off".equals(string2)) {
            infinite2 = Duration$.MODULE$.Undefined();
        } else {
            FiniteDuration finiteDuration6 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), key2));
            infinite2 = (Duration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration6, (Function1 & Serializable)_$8 -> _$8.$greater((Object)Duration$.MODULE$.Zero()), () -> ClusterSettings.$init$$$anonfun$11(key2));
        }
        this.ShutdownAfterUnsuccessfulJoinSeedNodes = infinite2;
        this.PeriodicTasksInitialDelay = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), "periodic-tasks-initial-delay");
        this.GossipInterval = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), "gossip-interval");
        FiniteDuration finiteDuration7 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), "gossip-time-to-live"));
        this.GossipTimeToLive = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration7, (Function1 & Serializable)_$9 -> _$9.$greater((Object)Duration$.MODULE$.Zero()), ClusterSettings::$init$$$anonfun$13);
        this.LeaderActionsInterval = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), "leader-actions-interval");
        this.UnreachableNodesReaperInterval = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), "unreachable-nodes-reaper-interval");
        String key3 = "publish-stats-interval";
        String string3 = Helpers$.MODULE$.toRootLowerCase(this.org$apache$pekko$cluster$ClusterSettings$$cc.getString(key3));
        if ("off".equals(string3)) {
            infinite = Duration$.MODULE$.Undefined();
        } else {
            FiniteDuration finiteDuration8 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), key3));
            infinite = (Duration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration8, (Function1 & Serializable)_$10 -> _$10.$greater$eq((Object)Duration$.MODULE$.Zero()), () -> ClusterSettings.$init$$$anonfun$15(key3));
        }
        this.PublishStatsInterval = infinite;
        String key4 = "prune-gossip-tombstones-after";
        FiniteDuration finiteDuration9 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), key4));
        this.PruneGossipTombstonesAfter = (Duration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration9, (Function1 & Serializable)_$11 -> _$11.$greater$eq((Object)Duration$.MODULE$.Zero()), () -> ClusterSettings.$init$$$anonfun$17(key4));
        String key5 = "down-removal-margin";
        String string4 = Helpers$.MODULE$.toRootLowerCase(this.org$apache$pekko$cluster$ClusterSettings$$cc.getString(key5));
        if ("off".equals(string4)) {
            finiteDuration2 = Duration$.MODULE$.Zero();
        } else {
            FiniteDuration finiteDuration10 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), key5));
            finiteDuration2 = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration10, (Function1 & Serializable)_$12 -> _$12.$greater$eq((Object)Duration$.MODULE$.Zero()), () -> ClusterSettings.$init$$$anonfun$19(key5));
        }
        this.DownRemovalMargin = finiteDuration2;
        String name = this.org$apache$pekko$cluster$ClusterSettings$$cc.getString("downing-provider-class");
        this.DowningProviderClassName = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name)) ? name : NoDowning.class.getName();
        FiniteDuration finiteDuration11 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), "quarantine-removed-node-after"));
        this.QuarantineRemovedNodeAfter = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration11, (Function1 & Serializable)_$13 -> _$13.$greater((Object)Duration$.MODULE$.Zero()), ClusterSettings::$init$$$anonfun$21);
        String key6 = "allow-weakly-up-members";
        String string5 = Helpers$.MODULE$.toRootLowerCase(this.org$apache$pekko$cluster$ClusterSettings$$cc.getString(key6));
        if ("off".equals(string5)) {
            finiteDuration = Duration$.MODULE$.Zero();
        } else if ("on".equals(string5)) {
            finiteDuration = new package.DurationInt(package$.MODULE$.DurationInt(7)).seconds();
        } else {
            FiniteDuration finiteDuration12 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), key6));
            finiteDuration = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration12, (Function1 & Serializable)_$14 -> _$14.$greater((Object)Duration$.MODULE$.Zero()), () -> ClusterSettings.$init$$$anonfun$23(key6));
        }
        this.WeaklyUpAfter = finiteDuration;
        FiniteDuration finiteDuration13 = this.WeaklyUpAfter();
        FiniteDuration finiteDuration14 = Duration$.MODULE$.Zero();
        this.AllowWeaklyUpMembers = finiteDuration13 == null ? finiteDuration14 != null : !finiteDuration13.equals(finiteDuration14);
        this.SelfDataCenter = this.org$apache$pekko$cluster$ClusterSettings$$cc.getString("multi-data-center.self-data-center");
        Set set = (Set)Helpers$.MODULE$.Requiring((Object)package.JavaConverters$.MODULE$.ListHasAsScala(this.org$apache$pekko$cluster$ClusterSettings$$cc.getStringList("roles")).asScala().toSet());
        Set configuredRoles = (Set)Helpers.Requiring$.MODULE$.requiring$extension((Object)set, (Function1 & Serializable)_$15 -> _$15.forall((Function1 & Serializable)_$16 -> !_$16.startsWith(ClusterSettings$.MODULE$.DcRolePrefix())), ClusterSettings::$anonfun$2);
        this.Roles = (Set)configuredRoles.$plus((Object)new StringBuilder(0).append(ClusterSettings$.MODULE$.DcRolePrefix()).append(this.SelfDataCenter()).toString());
        this.AppVersion = Version$.MODULE$.apply(this.org$apache$pekko$cluster$ClusterSettings$$cc.getString("app-version"));
        Integer n2 = (Integer)Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)this.org$apache$pekko$cluster$ClusterSettings$$cc.getInt("min-nr-of-members")));
        this.MinNrOfMembers = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension((Object)n2, (Function1)(JFunction1.mcZI.sp & Serializable)_$17 -> _$17 > 0, ClusterSettings::$init$$$anonfun$25));
        this.MinNrOfMembersOfRole = package.JavaConverters$.MODULE$.MapHasAsScala((Map)this.org$apache$pekko$cluster$ClusterSettings$$cc.getConfig("role").root()).asScala().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    ConfigValue configValue = (ConfigValue)tuple2._2();
                    String key = (String)tuple2._1();
                    if (configValue instanceof ConfigObject) {
                        ConfigObject value = (ConfigObject)configValue;
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    ConfigValue configValue = (ConfigValue)tuple2._2();
                    String key = (String)tuple2._1();
                    if (configValue instanceof ConfigObject) {
                        ConfigObject value = (ConfigObject)configValue;
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)value.toConfig().getInt("min-nr-of-members")));
                    }
                }
                return function1.apply((Object)x);
            }
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.RunCoordinatedShutdownWhenDown = this.org$apache$pekko$cluster$ClusterSettings$$cc.getBoolean("run-coordinated-shutdown-when-down");
        this.JmxEnabled = this.org$apache$pekko$cluster$ClusterSettings$$cc.getBoolean("jmx.enabled");
        this.JmxMultiMbeansInSameEnabled = this.org$apache$pekko$cluster$ClusterSettings$$cc.getBoolean("jmx.multi-mbeans-in-same-jvm");
        this.UseDispatcher = this.org$apache$pekko$cluster$ClusterSettings$$cc.getString("use-dispatcher");
        this.GossipDifferentViewProbability = this.org$apache$pekko$cluster$ClusterSettings$$cc.getDouble("gossip-different-view-probability");
        this.ReduceGossipDifferentViewProbability = this.org$apache$pekko$cluster$ClusterSettings$$cc.getInt("reduce-gossip-different-view-probability");
        this.SchedulerTickDuration = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(this.org$apache$pekko$cluster$ClusterSettings$$cc), "scheduler.tick-duration");
        this.SchedulerTicksPerWheel = this.org$apache$pekko$cluster$ClusterSettings$$cc.getInt("scheduler.ticks-per-wheel");
        this.ByPassConfigCompatCheck = !this.org$apache$pekko$cluster$ClusterSettings$$cc.getBoolean("configuration-compatibility-check.enforce-on-join");
        this.ConfigCompatCheckers = package.JavaConverters$.MODULE$.CollectionHasAsScala(this.org$apache$pekko$cluster$ClusterSettings$$cc.getConfig("configuration-compatibility-check.checkers").root().unwrapped().values()).asScala().iterator().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                Object s = object;
                return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s.toString().trim()));
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                Object s = object;
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s.toString().trim()))) {
                    return s.toString();
                }
                return function1.apply(x);
            }
        }).toSet();
        Iterable sensitiveKeys = (Iterable)package.JavaConverters$.MODULE$.CollectionHasAsScala(this.org$apache$pekko$cluster$ClusterSettings$$cc.getConfig("configuration-compatibility-check.sensitive-config-paths").root().unwrapped().values()).asScala().flatMap((Function1 & Serializable)_$18 -> package.JavaConverters$.MODULE$.ListHasAsScala((List)_$18).asScala());
        this.SensitiveConfigPaths = sensitiveKeys.toSet();
    }

    public Config config() {
        return this.config;
    }

    public String systemName() {
        return this.systemName;
    }

    public boolean LogInfoVerbose() {
        return this.LogInfoVerbose;
    }

    public boolean LogInfo() {
        return this.LogInfo;
    }

    public Config FailureDetectorConfig() {
        return this.FailureDetectorConfig;
    }

    public String FailureDetectorImplementationClass() {
        return this.FailureDetectorImplementationClass;
    }

    public FiniteDuration HeartbeatInterval() {
        return this.HeartbeatInterval;
    }

    public FiniteDuration HeartbeatExpectedResponseAfter() {
        return this.HeartbeatExpectedResponseAfter;
    }

    public int MonitoredByNrOfMembers() {
        return this.MonitoredByNrOfMembers;
    }

    public final ClusterSettings$MultiDataCenter$ MultiDataCenter() {
        Object object = this.MultiDataCenter$lzy1;
        if (object instanceof ClusterSettings$MultiDataCenter$) {
            return (ClusterSettings$MultiDataCenter$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClusterSettings$MultiDataCenter$)this.MultiDataCenter$lzyINIT1();
    }

    private Object MultiDataCenter$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.MultiDataCenter$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClusterSettings$MultiDataCenter$ clusterSettings$MultiDataCenter$ = null;
                    try {
                        clusterSettings$MultiDataCenter$ = new ClusterSettings$MultiDataCenter$(this);
                        object2 = clusterSettings$MultiDataCenter$ == null ? LazyVals.NullValue$.MODULE$ : clusterSettings$MultiDataCenter$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.MultiDataCenter$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clusterSettings$MultiDataCenter$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public IndexedSeq<Address> SeedNodes() {
        return this.SeedNodes;
    }

    public FiniteDuration SeedNodeTimeout() {
        return this.SeedNodeTimeout;
    }

    public Duration RetryUnsuccessfulJoinAfter() {
        return this.RetryUnsuccessfulJoinAfter;
    }

    public Duration ShutdownAfterUnsuccessfulJoinSeedNodes() {
        return this.ShutdownAfterUnsuccessfulJoinSeedNodes;
    }

    public FiniteDuration PeriodicTasksInitialDelay() {
        return this.PeriodicTasksInitialDelay;
    }

    public FiniteDuration GossipInterval() {
        return this.GossipInterval;
    }

    public FiniteDuration GossipTimeToLive() {
        return this.GossipTimeToLive;
    }

    public FiniteDuration LeaderActionsInterval() {
        return this.LeaderActionsInterval;
    }

    public FiniteDuration UnreachableNodesReaperInterval() {
        return this.UnreachableNodesReaperInterval;
    }

    public Duration PublishStatsInterval() {
        return this.PublishStatsInterval;
    }

    public Duration PruneGossipTombstonesAfter() {
        return this.PruneGossipTombstonesAfter;
    }

    public FiniteDuration DownRemovalMargin() {
        return this.DownRemovalMargin;
    }

    public String DowningProviderClassName() {
        return this.DowningProviderClassName;
    }

    public FiniteDuration QuarantineRemovedNodeAfter() {
        return this.QuarantineRemovedNodeAfter;
    }

    public FiniteDuration WeaklyUpAfter() {
        return this.WeaklyUpAfter;
    }

    public boolean AllowWeaklyUpMembers() {
        return this.AllowWeaklyUpMembers;
    }

    public String SelfDataCenter() {
        return this.SelfDataCenter;
    }

    public Set<String> Roles() {
        return this.Roles;
    }

    public Version AppVersion() {
        return this.AppVersion;
    }

    public int MinNrOfMembers() {
        return this.MinNrOfMembers;
    }

    public scala.collection.immutable.Map<String, Object> MinNrOfMembersOfRole() {
        return this.MinNrOfMembersOfRole;
    }

    public boolean RunCoordinatedShutdownWhenDown() {
        return this.RunCoordinatedShutdownWhenDown;
    }

    public boolean JmxEnabled() {
        return this.JmxEnabled;
    }

    public boolean JmxMultiMbeansInSameEnabled() {
        return this.JmxMultiMbeansInSameEnabled;
    }

    public String UseDispatcher() {
        return this.UseDispatcher;
    }

    public double GossipDifferentViewProbability() {
        return this.GossipDifferentViewProbability;
    }

    public int ReduceGossipDifferentViewProbability() {
        return this.ReduceGossipDifferentViewProbability;
    }

    public FiniteDuration SchedulerTickDuration() {
        return this.SchedulerTickDuration;
    }

    public int SchedulerTicksPerWheel() {
        return this.SchedulerTicksPerWheel;
    }

    public boolean ByPassConfigCompatCheck() {
        return this.ByPassConfigCompatCheck;
    }

    public Set<String> ConfigCompatCheckers() {
        return this.ConfigCompatCheckers;
    }

    public Set<String> SensitiveConfigPaths() {
        return this.SensitiveConfigPaths;
    }

    public final ClusterSettings$Debug$ Debug() {
        Object object = this.Debug$lzy1;
        if (object instanceof ClusterSettings$Debug$) {
            return (ClusterSettings$Debug$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClusterSettings$Debug$)this.Debug$lzyINIT1();
    }

    private Object Debug$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Debug$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClusterSettings$Debug$ clusterSettings$Debug$ = null;
                    try {
                        clusterSettings$Debug$ = new ClusterSettings$Debug$(this);
                        object2 = clusterSettings$Debug$ == null ? LazyVals.NullValue$.MODULE$ : clusterSettings$Debug$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Debug$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clusterSettings$Debug$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final Object $init$$$anonfun$2() {
        return "failure-detector.heartbeat-interval must be > 0";
    }

    private static final Object $init$$$anonfun$4() {
        return "failure-detector.expected-response-after > 0";
    }

    private static final Object $init$$$anonfun$6() {
        return "failure-detector.monitored-by-nr-of-members must be > 0";
    }

    private static final Object $init$$$anonfun$9(String key$1) {
        return new StringBuilder(13).append(key$1).append(" > 0s, or off").toString();
    }

    private static final Object $init$$$anonfun$11(String key$2) {
        return new StringBuilder(13).append(key$2).append(" > 0s, or off").toString();
    }

    private static final Object $init$$$anonfun$13() {
        return "gossip-time-to-live must be > 0";
    }

    private static final Object $init$$$anonfun$15(String key$3) {
        return new StringBuilder(14).append(key$3).append(" >= 0s, or off").toString();
    }

    private static final Object $init$$$anonfun$17(String key$4) {
        return new StringBuilder(6).append(key$4).append(" >= 0s").toString();
    }

    private static final Object $init$$$anonfun$19(String key$5) {
        return new StringBuilder(14).append(key$5).append(" >= 0s, or off").toString();
    }

    private static final Object $init$$$anonfun$21() {
        return "quarantine-removed-node-after must be > 0";
    }

    private static final Object $init$$$anonfun$23(String key$6) {
        return new StringBuilder(13).append(key$6).append(" > 0s, or off").toString();
    }

    private static final Object $anonfun$2() {
        return new StringBuilder(89).append("Roles must not start with '").append(ClusterSettings$.MODULE$.DcRolePrefix()).append("' as that is reserved for the cluster self-data-center setting").toString();
    }

    private static final Object $init$$$anonfun$25() {
        return "min-nr-of-members must be > 0";
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$ClusterSettings$CrossDcFailureDetectorSettings$$_$$lessinit$greater$$anonfun$26(FiniteDuration _$4) {
        return _$4.$greater((Object)Duration$.MODULE$.Zero());
    }

    public static final Object org$apache$pekko$cluster$ClusterSettings$CrossDcFailureDetectorSettings$$_$$lessinit$greater$$anonfun$27() {
        return "failure-detector.heartbeat-interval must be > 0";
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$ClusterSettings$CrossDcFailureDetectorSettings$$_$$lessinit$greater$$anonfun$28(FiniteDuration _$5) {
        return _$5.$greater((Object)Duration$.MODULE$.Zero());
    }

    public static final Object org$apache$pekko$cluster$ClusterSettings$CrossDcFailureDetectorSettings$$_$$lessinit$greater$$anonfun$29() {
        return "failure-detector.expected-response-after > 0";
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$ClusterSettings$MultiDataCenter$$$_$$lessinit$greater$$anonfun$30(int _$6) {
        return _$6 > 0;
    }

    public static final Object org$apache$pekko$cluster$ClusterSettings$MultiDataCenter$$$_$$lessinit$greater$$anonfun$31() {
        return "cross-data-center-connections must be > 0";
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$ClusterSettings$MultiDataCenter$$$_$$lessinit$greater$$anonfun$32(double d) {
        return d >= 0.0 && d <= 1.0;
    }

    public static final Object org$apache$pekko$cluster$ClusterSettings$MultiDataCenter$$$_$$lessinit$greater$$anonfun$33() {
        return "cross-data-center-gossip-probability must be >= 0.0 and <= 1.0";
    }

    public final class CrossDcFailureDetectorSettings {
        private final Config config;
        private final String ImplementationClass;
        private final FiniteDuration HeartbeatInterval;
        private final FiniteDuration HeartbeatExpectedResponseAfter;
        private final /* synthetic */ ClusterSettings $outer;

        public CrossDcFailureDetectorSettings(ClusterSettings $outer, Config config) {
            this.config = config;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.ImplementationClass = config.getString("implementation-class");
            FiniteDuration finiteDuration = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"));
            this.HeartbeatInterval = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration, ClusterSettings::org$apache$pekko$cluster$ClusterSettings$CrossDcFailureDetectorSettings$$_$$lessinit$greater$$anonfun$26, ClusterSettings::org$apache$pekko$cluster$ClusterSettings$CrossDcFailureDetectorSettings$$_$$lessinit$greater$$anonfun$27);
            FiniteDuration finiteDuration2 = (FiniteDuration)Helpers$.MODULE$.Requiring((Object)Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "expected-response-after"));
            this.HeartbeatExpectedResponseAfter = (FiniteDuration)Helpers.Requiring$.MODULE$.requiring$extension((Object)finiteDuration2, ClusterSettings::org$apache$pekko$cluster$ClusterSettings$CrossDcFailureDetectorSettings$$_$$lessinit$greater$$anonfun$28, ClusterSettings::org$apache$pekko$cluster$ClusterSettings$CrossDcFailureDetectorSettings$$_$$lessinit$greater$$anonfun$29);
        }

        public Config config() {
            return this.config;
        }

        public String ImplementationClass() {
            return this.ImplementationClass;
        }

        public FiniteDuration HeartbeatInterval() {
            return this.HeartbeatInterval;
        }

        public FiniteDuration HeartbeatExpectedResponseAfter() {
            return this.HeartbeatExpectedResponseAfter;
        }

        public int NrOfMonitoringActors() {
            return this.$outer.MultiDataCenter().CrossDcConnections();
        }

        public final /* synthetic */ ClusterSettings org$apache$pekko$cluster$ClusterSettings$CrossDcFailureDetectorSettings$$$outer() {
            return this.$outer;
        }
    }
}

