/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$MemberRemoved$;
import org.apache.pekko.cluster.ClusterHeartbeatReceiver$;
import org.apache.pekko.cluster.ClusterHeartbeatSender;
import org.apache.pekko.cluster.ClusterHeartbeatSender$ExpectedFirstHeartbeat$;
import org.apache.pekko.cluster.ClusterHeartbeatSender$Heartbeat$;
import org.apache.pekko.cluster.ClusterHeartbeatSender$HeartbeatRsp$;
import org.apache.pekko.cluster.ClusterHeartbeatSender$HeartbeatTick$;
import org.apache.pekko.cluster.ClusterLogClass$;
import org.apache.pekko.cluster.ClusterSettings;
import org.apache.pekko.cluster.CrossDcHeartbeatSender$MonitoringActive$;
import org.apache.pekko.cluster.CrossDcHeartbeatSender$MonitoringDormant$;
import org.apache.pekko.cluster.CrossDcHeartbeatSender$ReportStatus$;
import org.apache.pekko.cluster.CrossDcHeartbeatingState;
import org.apache.pekko.cluster.CrossDcHeartbeatingState$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.event.ActorWithLogClass$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.remote.FailureDetectorRegistry;
import scala.Function1;
import scala.PartialFunction;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public class CrossDcHeartbeatSender
implements Actor {
    private ActorContext context;
    private ActorRef self;
    private final Cluster cluster;
    private final boolean verboseHeartbeat;
    private final Cluster.ClusterLogger clusterLogger;
    private boolean activelyMonitoring;
    private final Function1 isExternalClusterMember;
    private final ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings;
    private final FailureDetectorRegistry crossDcFailureDetector;
    private long sequenceNr;
    private CrossDcHeartbeatingState dataCentersState;
    private final Cancellable heartbeatTask;

    public CrossDcHeartbeatSender() {
        Actor.$init$((Actor)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseHeartbeat = this.cluster().settings().Debug().VerboseHeartbeatLogging();
        this.clusterLogger = new Cluster.ClusterLogger(this.cluster(), Logging$.MODULE$.withMarker(this.context().system(), (Object)ActorWithLogClass$.MODULE$.apply((Actor)this, ClusterLogClass$.MODULE$.ClusterHeartbeat()), LogSource$.MODULE$.fromActorWithLoggerClass()));
        this.activelyMonitoring = false;
        this.isExternalClusterMember = (Function1 & Serializable)member -> {
            String string = member.dataCenter();
            String string2 = this.cluster().selfDataCenter();
            return string == null ? string2 != null : !string.equals(string2);
        };
        this.crossDcSettings = this.cluster().settings().MultiDataCenter().CrossDcFailureDetectorSettings();
        this.crossDcFailureDetector = this.cluster().crossDcFailureDetector();
        this.sequenceNr = 0L;
        this.dataCentersState = CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), this.crossDcSettings().NrOfMonitoringActors(), (SortedSet<Member>)((SortedSet)SortedSet$.MODULE$.empty(Member$.MODULE$.ordering())));
        this.heartbeatTask = this.cluster().scheduler().scheduleWithFixedDelay(this.cluster().settings().PeriodicTasksInitialDelay().max(this.crossDcSettings().HeartbeatInterval()), this.crossDcSettings().HeartbeatInterval(), this.self(), (Object)ClusterHeartbeatSender$HeartbeatTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public boolean verboseHeartbeat() {
        return this.verboseHeartbeat;
    }

    public boolean activelyMonitoring() {
        return this.activelyMonitoring;
    }

    public void activelyMonitoring_$eq(boolean x$1) {
        this.activelyMonitoring = x$1;
    }

    public Function1<Member, Object> isExternalClusterMember() {
        return this.isExternalClusterMember;
    }

    public ClusterSettings.CrossDcFailureDetectorSettings crossDcSettings() {
        return this.crossDcSettings;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    public long sequenceNr() {
        return this.sequenceNr;
    }

    public void sequenceNr_$eq(long x$1) {
        this.sequenceNr = x$1;
    }

    public ClusterHeartbeatSender.Heartbeat nextHeartBeat() {
        this.sequenceNr_$eq(this.sequenceNr() + 1L);
        return ClusterHeartbeatSender$Heartbeat$.MODULE$.apply(this.cluster().selfAddress(), this.sequenceNr(), System.nanoTime());
    }

    public CrossDcHeartbeatingState dataCentersState() {
        return this.dataCentersState;
    }

    public void dataCentersState_$eq(CrossDcHeartbeatingState x$1) {
        this.dataCentersState = x$1;
    }

    public Cancellable heartbeatTask() {
        return this.heartbeatTask;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
        if (this.verboseHeartbeat()) {
            this.clusterLogger.logDebug("Initialized cross-dc heartbeat sender as DORMANT in DC: [{}]", this.cluster().selfDataCenter());
            return;
        }
    }

    public void postStop() {
        this.dataCentersState().activeReceivers().foreach((Function1)(JProcedure1 & Serializable)a -> this.crossDcFailureDetector().remove((Object)a.address()));
        this.heartbeatTask().cancel();
        this.cluster().unsubscribe(this.self());
    }

    public ActorSelection heartbeatReceiver(Address address) {
        return this.context().actorSelection(ClusterHeartbeatReceiver$.MODULE$.path(address));
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.dormant().orElse(this.introspecting());
    }

    public PartialFunction<Object, BoxedUnit> dormant() {
        return new Serializable(this){
            private final /* synthetic */ CrossDcHeartbeatSender $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState s = (ClusterEvent.CurrentClusterState)object;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent evt = (ClusterEvent.MemberEvent)object;
                    return true;
                }
                return ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState s = (ClusterEvent.CurrentClusterState)object;
                    this.$outer.init(s);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    this.$outer.removeMember(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent evt = (ClusterEvent.MemberEvent)object;
                    this.$outer.addMember(evt.member());
                    return BoxedUnit.UNIT;
                }
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)) {
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private final /* synthetic */ CrossDcHeartbeatSender $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ClusterHeartbeatSender.HeartbeatRsp) {
                    ClusterHeartbeatSender.HeartbeatRsp heartbeatRsp = ClusterHeartbeatSender$HeartbeatRsp$.MODULE$.unapply((ClusterHeartbeatSender.HeartbeatRsp)object);
                    UniqueAddress uniqueAddress = heartbeatRsp._1();
                    long l = heartbeatRsp._2();
                    long l2 = heartbeatRsp._3();
                    UniqueAddress from = uniqueAddress;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent evt = (ClusterEvent.MemberEvent)object;
                    return true;
                }
                if (object instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat) {
                    UniqueAddress uniqueAddress;
                    ClusterHeartbeatSender.ExpectedFirstHeartbeat expectedFirstHeartbeat = ClusterHeartbeatSender$ExpectedFirstHeartbeat$.MODULE$.unapply((ClusterHeartbeatSender.ExpectedFirstHeartbeat)object);
                    UniqueAddress from = uniqueAddress = expectedFirstHeartbeat._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (ClusterHeartbeatSender$HeartbeatTick$.MODULE$.equals(object)) {
                    this.$outer.heartbeat();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterHeartbeatSender.HeartbeatRsp) {
                    ClusterHeartbeatSender.HeartbeatRsp heartbeatRsp = ClusterHeartbeatSender$HeartbeatRsp$.MODULE$.unapply((ClusterHeartbeatSender.HeartbeatRsp)object);
                    UniqueAddress uniqueAddress = heartbeatRsp._1();
                    long l = heartbeatRsp._2();
                    long l2 = heartbeatRsp._3();
                    UniqueAddress from = uniqueAddress;
                    this.$outer.heartbeatRsp(from);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    this.$outer.removeMember(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent evt = (ClusterEvent.MemberEvent)object;
                    this.$outer.addMember(evt.member());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterHeartbeatSender.ExpectedFirstHeartbeat) {
                    UniqueAddress uniqueAddress;
                    ClusterHeartbeatSender.ExpectedFirstHeartbeat expectedFirstHeartbeat = ClusterHeartbeatSender$ExpectedFirstHeartbeat$.MODULE$.unapply((ClusterHeartbeatSender.ExpectedFirstHeartbeat)object);
                    UniqueAddress from = uniqueAddress = expectedFirstHeartbeat._1();
                    this.$outer.triggerFirstHeartbeat(from);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> introspecting() {
        return new Serializable(this){
            private final /* synthetic */ CrossDcHeartbeatSender $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return object instanceof ReportStatus && CrossDcHeartbeatSender$ReportStatus$.MODULE$.unapply((ReportStatus)object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ReportStatus && CrossDcHeartbeatSender$ReportStatus$.MODULE$.unapply((ReportStatus)object)) {
                    this.$outer.sender().$bang((Object)(this.$outer.activelyMonitoring() ? CrossDcHeartbeatSender$MonitoringActive$.MODULE$.apply(this.$outer.dataCentersState()) : CrossDcHeartbeatSender$MonitoringDormant$.MODULE$.apply()), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void init(ClusterEvent.CurrentClusterState snapshot) {
        SortedSet<Member> nodes = snapshot.members();
        int nrOfMonitoredNodes = this.crossDcSettings().NrOfMonitoringActors();
        this.dataCentersState_$eq(CrossDcHeartbeatingState$.MODULE$.init(this.cluster().selfDataCenter(), this.crossDcFailureDetector(), nrOfMonitoredNodes, nodes));
        this.becomeActiveIfResponsibleForHeartbeat();
    }

    public void addMember(Member m) {
        if (CrossDcHeartbeatingState$.MODULE$.atLeastInUpState(m)) {
            this.dataCentersState_$eq(this.dataCentersState().addMember(m));
            if (this.verboseHeartbeat()) {
                String string = m.dataCenter();
                String string2 = this.cluster().selfDataCenter();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.clusterLogger.logDebug("Register member {} for cross DC heartbeat (will only heartbeat if oldest)", m);
                }
            }
            this.becomeActiveIfResponsibleForHeartbeat();
            return;
        }
    }

    public void removeMember(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
        if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
            this.context().stop(this.self());
            return;
        }
        this.dataCentersState_$eq(this.dataCentersState().removeMember(m));
        this.becomeActiveIfResponsibleForHeartbeat();
    }

    public void heartbeat() {
        ClusterHeartbeatSender.Heartbeat nextHB = this.nextHeartBeat();
        this.dataCentersState().activeReceivers().foreach((Function1)(JProcedure1 & Serializable)to -> {
            BoxedUnit boxedUnit;
            if (this.crossDcFailureDetector().isMonitoring((Object)to.address())) {
                if (this.verboseHeartbeat()) {
                    this.clusterLogger.logDebug("(Cross) Heartbeat to [{}]", to.address());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (this.verboseHeartbeat()) {
                    this.clusterLogger.logDebug("First (Cross) Heartbeat to [{}]", to.address());
                }
                boxedUnit = this.cluster().scheduler().scheduleOnce(this.crossDcSettings().HeartbeatExpectedResponseAfter(), this.self(), (Object)ClusterHeartbeatSender$ExpectedFirstHeartbeat$.MODULE$.apply((UniqueAddress)to), (ExecutionContext)this.context().dispatcher(), this.self());
            }
            ActorSelection$.MODULE$.toScala(this.heartbeatReceiver(to.address())).$bang((Object)nextHB, this.self());
        });
    }

    public void heartbeatRsp(UniqueAddress from) {
        if (this.verboseHeartbeat()) {
            this.clusterLogger.logDebug("(Cross) Heartbeat response from [{}]", from.address());
        }
        this.dataCentersState_$eq(this.dataCentersState().heartbeatRsp(from));
    }

    public void triggerFirstHeartbeat(UniqueAddress from) {
        if (this.dataCentersState().activeReceivers().contains((Object)from) && !this.crossDcFailureDetector().isMonitoring((Object)from.address())) {
            if (this.verboseHeartbeat()) {
                this.clusterLogger.logDebug("Trigger extra expected (cross) heartbeat from [{}]", from.address());
            }
            this.crossDcFailureDetector().heartbeat((Object)from.address());
            return;
        }
    }

    private boolean selfIsResponsibleForCrossDcHeartbeat() {
        int activeDcs = this.dataCentersState().dataCenters().size();
        if (activeDcs > 1) {
            return this.dataCentersState().shouldActivelyMonitorNodes(this.cluster().selfDataCenter(), this.cluster().selfUniqueAddress());
        }
        return false;
    }

    private void becomeActiveIfResponsibleForHeartbeat() {
        if (!this.activelyMonitoring() && this.selfIsResponsibleForCrossDcHeartbeat()) {
            this.clusterLogger.logInfo("Cross DC heartbeat becoming ACTIVE on this node (for DC: {}), monitoring other DCs oldest nodes", (Object)this.cluster().selfDataCenter());
            this.activelyMonitoring_$eq(true);
            this.context().become(this.active().orElse(this.introspecting()));
            return;
        }
        if (!this.activelyMonitoring()) {
            if (this.verboseHeartbeat()) {
                this.clusterLogger.logInfo("Remaining DORMANT; others in {} handle heartbeating other DCs", (Object)this.cluster().selfDataCenter());
                return;
            }
            return;
        }
    }

    public static interface InspectionCommand
    extends NoSerializationVerificationNeeded {
    }

    public static final class MonitoringActive
    implements MonitoringStateReport,
    Product,
    Serializable {
        private final CrossDcHeartbeatingState state;

        public static MonitoringActive apply(CrossDcHeartbeatingState crossDcHeartbeatingState) {
            return CrossDcHeartbeatSender$MonitoringActive$.MODULE$.apply(crossDcHeartbeatingState);
        }

        public static MonitoringActive fromProduct(Product product) {
            return CrossDcHeartbeatSender$MonitoringActive$.MODULE$.fromProduct(product);
        }

        public static MonitoringActive unapply(MonitoringActive monitoringActive) {
            return CrossDcHeartbeatSender$MonitoringActive$.MODULE$.unapply(monitoringActive);
        }

        public MonitoringActive(CrossDcHeartbeatingState state) {
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MonitoringActive)) return false;
            MonitoringActive monitoringActive = (MonitoringActive)object;
            CrossDcHeartbeatingState crossDcHeartbeatingState = this.state();
            CrossDcHeartbeatingState crossDcHeartbeatingState2 = monitoringActive.state();
            if (crossDcHeartbeatingState != null) {
                if (!((Object)crossDcHeartbeatingState).equals(crossDcHeartbeatingState2)) return false;
                return true;
            }
            if (crossDcHeartbeatingState2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MonitoringActive;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MonitoringActive";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public CrossDcHeartbeatingState state() {
            return this.state;
        }

        public MonitoringActive copy(CrossDcHeartbeatingState state) {
            return new MonitoringActive(state);
        }

        public CrossDcHeartbeatingState copy$default$1() {
            return this.state();
        }

        public CrossDcHeartbeatingState _1() {
            return this.state();
        }
    }

    public static final class MonitoringDormant
    implements MonitoringStateReport,
    Product,
    Serializable {
        public static MonitoringDormant apply() {
            return CrossDcHeartbeatSender$MonitoringDormant$.MODULE$.apply();
        }

        public static MonitoringDormant fromProduct(Product product) {
            return CrossDcHeartbeatSender$MonitoringDormant$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(MonitoringDormant monitoringDormant) {
            return CrossDcHeartbeatSender$MonitoringDormant$.MODULE$.unapply(monitoringDormant);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MonitoringDormant)) return false;
            MonitoringDormant monitoringDormant = (MonitoringDormant)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MonitoringDormant;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "MonitoringDormant";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public MonitoringDormant copy() {
            return new MonitoringDormant();
        }
    }

    public static interface MonitoringStateReport
    extends StatusReport {
    }

    public static final class ReportStatus
    implements Product,
    Serializable {
        public static ReportStatus apply() {
            return CrossDcHeartbeatSender$ReportStatus$.MODULE$.apply();
        }

        public static ReportStatus fromProduct(Product product) {
            return CrossDcHeartbeatSender$ReportStatus$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(ReportStatus reportStatus) {
            return CrossDcHeartbeatSender$ReportStatus$.MODULE$.unapply(reportStatus);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReportStatus)) return false;
            ReportStatus reportStatus = (ReportStatus)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReportStatus;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "ReportStatus";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ReportStatus copy() {
            return new ReportStatus();
        }
    }

    public static interface StatusReport
    extends NoSerializationVerificationNeeded {
    }
}

