/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.CrossDcHeartbeatingState$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.remote.FailureDetectorRegistry;
import org.apache.pekko.util.ConstantFun$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedSet;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class CrossDcHeartbeatingState
implements Product,
Serializable {
    private final String selfDataCenter;
    private final FailureDetectorRegistry failureDetector;
    private final int nrOfMonitoredNodesPerDc;
    private final Map state;
    private final Set activeReceivers;

    public static CrossDcHeartbeatingState apply(String string, FailureDetectorRegistry<Address> failureDetectorRegistry, int n, Map<String, SortedSet<Member>> map) {
        return CrossDcHeartbeatingState$.MODULE$.apply(string, failureDetectorRegistry, n, map);
    }

    public static boolean atLeastInUpState(Member member) {
        return CrossDcHeartbeatingState$.MODULE$.atLeastInUpState(member);
    }

    public static CrossDcHeartbeatingState fromProduct(Product product) {
        return CrossDcHeartbeatingState$.MODULE$.fromProduct(product);
    }

    public static CrossDcHeartbeatingState init(String string, FailureDetectorRegistry<Address> failureDetectorRegistry, int n, SortedSet<Member> sortedSet) {
        return CrossDcHeartbeatingState$.MODULE$.init(string, failureDetectorRegistry, n, sortedSet);
    }

    public static CrossDcHeartbeatingState unapply(CrossDcHeartbeatingState crossDcHeartbeatingState) {
        return CrossDcHeartbeatingState$.MODULE$.unapply(crossDcHeartbeatingState);
    }

    public CrossDcHeartbeatingState(String selfDataCenter, FailureDetectorRegistry<Address> failureDetector, int nrOfMonitoredNodesPerDc, Map<String, SortedSet<Member>> state) {
        this.selfDataCenter = selfDataCenter;
        this.failureDetector = failureDetector;
        this.nrOfMonitoredNodesPerDc = nrOfMonitoredNodesPerDc;
        this.state = state;
        Map otherDcs = (Map)state.filter((Function1 & Serializable)_$4 -> {
            Object object = _$4._1();
            String string = selfDataCenter;
            return object == null ? string != null : !object.equals(string);
        });
        Iterable allOtherNodes = otherDcs.values();
        this.activeReceivers = ((IterableOnceOps)allOtherNodes.flatMap((Function1 & Serializable)_$5 -> (IterableOnce)((IterableOnce)_$5.take(nrOfMonitoredNodesPerDc)).iterator().map((Function1 & Serializable)_$6 -> _$6.uniqueAddress()).to(IterableFactory$.MODULE$.toFactory((IterableFactory)IndexedSeq$.MODULE$)))).toSet();
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.selfDataCenter()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.failureDetector()));
        n = Statics.mix((int)n, (int)this.nrOfMonitoredNodesPerDc());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.state()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof CrossDcHeartbeatingState)) return false;
        CrossDcHeartbeatingState crossDcHeartbeatingState = (CrossDcHeartbeatingState)object;
        if (this.nrOfMonitoredNodesPerDc() != crossDcHeartbeatingState.nrOfMonitoredNodesPerDc()) return false;
        String string = this.selfDataCenter();
        String string2 = crossDcHeartbeatingState.selfDataCenter();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        FailureDetectorRegistry<Address> failureDetectorRegistry = this.failureDetector();
        FailureDetectorRegistry<Address> failureDetectorRegistry2 = crossDcHeartbeatingState.failureDetector();
        if (failureDetectorRegistry == null) {
            if (failureDetectorRegistry2 != null) {
                return false;
            }
        } else if (!failureDetectorRegistry.equals(failureDetectorRegistry2)) return false;
        Map<String, SortedSet<Member>> map = this.state();
        Map<String, SortedSet<Member>> map2 = crossDcHeartbeatingState.state();
        if (map == null) {
            if (map2 == null) return true;
            return false;
        } else {
            if (!map.equals(map2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof CrossDcHeartbeatingState;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "CrossDcHeartbeatingState";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this._3());
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "selfDataCenter";
            }
            case 1: {
                return "failureDetector";
            }
            case 2: {
                return "nrOfMonitoredNodesPerDc";
            }
            case 3: {
                return "state";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String selfDataCenter() {
        return this.selfDataCenter;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public int nrOfMonitoredNodesPerDc() {
        return this.nrOfMonitoredNodesPerDc;
    }

    public Map<String, SortedSet<Member>> state() {
        return this.state;
    }

    public boolean shouldActivelyMonitorNodes(String selfDc, UniqueAddress selfAddress) {
        scala.collection.SortedSet selfDcNeighbours = (scala.collection.SortedSet)this.state().getOrElse((Object)selfDc, CrossDcHeartbeatingState::$anonfun$2);
        scala.collection.SortedSet selfDcOldOnes = (scala.collection.SortedSet)((IterableOps)selfDcNeighbours.filter((Function1 & Serializable)m -> CrossDcHeartbeatingState$.MODULE$.atLeastInUpState((Member)m))).take(this.nrOfMonitoredNodesPerDc());
        boolean shouldMonitorActively = selfDcOldOnes.exists((Function1 & Serializable)_$1 -> {
            UniqueAddress uniqueAddress = _$1.uniqueAddress();
            UniqueAddress uniqueAddress2 = selfAddress;
            return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
        });
        return shouldMonitorActively;
    }

    public CrossDcHeartbeatingState addMember(Member m2) {
        String dc = m2.dataCenter();
        SortedSet oldMembersWithoutM = (SortedSet)((IterableOps)this.state().getOrElse((Object)dc, CrossDcHeartbeatingState::$anonfun$5)).filterNot((Function1 & Serializable)_$2 -> {
            UniqueAddress uniqueAddress = _$2.uniqueAddress();
            UniqueAddress uniqueAddress2 = m2.uniqueAddress();
            return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
        });
        SortedSet updatedMembers = (SortedSet)oldMembersWithoutM.$plus((Object)m2);
        Map map = (Map)this.state().updated((Object)dc, (Object)updatedMembers);
        String string = this.copy$default$1();
        FailureDetectorRegistry<Address> failureDetectorRegistry = this.copy$default$2();
        int n = this.copy$default$3();
        CrossDcHeartbeatingState updatedState = this.copy(string, failureDetectorRegistry, n, (Map<String, SortedSet<Member>>)map);
        Set stoppedMonitoringReceivers = (Set)updatedState.activeReceiversIn(dc).diff(this.activeReceiversIn(dc));
        stoppedMonitoringReceivers.foreach((Function1)(JProcedure1 & Serializable)m -> this.failureDetector().remove((Object)m.address()));
        return updatedState;
    }

    public CrossDcHeartbeatingState removeMember(Member m) {
        String dc = m.dataCenter();
        Option option = this.state().get((Object)dc);
        if (option instanceof Some) {
            SortedSet dcMembers = (SortedSet)((Some)option).value();
            SortedSet updatedMembers = (SortedSet)dcMembers.filterNot((Function1 & Serializable)_$3 -> {
                UniqueAddress uniqueAddress = _$3.uniqueAddress();
                UniqueAddress uniqueAddress2 = m.uniqueAddress();
                return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
            });
            this.failureDetector().remove((Object)m.address());
            Map map = (Map)this.state().updated((Object)dc, (Object)updatedMembers);
            String string = this.copy$default$1();
            FailureDetectorRegistry<Address> failureDetectorRegistry = this.copy$default$2();
            int n = this.copy$default$3();
            return this.copy(string, failureDetectorRegistry, n, (Map<String, SortedSet<Member>>)map);
        }
        if (None$.MODULE$.equals(option)) {
            return this;
        }
        throw new MatchError((Object)option);
    }

    public Set<UniqueAddress> activeReceivers() {
        return this.activeReceivers;
    }

    private Set<UniqueAddress> activeReceiversIn(String dc) {
        String string = dc;
        String string2 = this.selfDataCenter();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return Predef$.MODULE$.Set().empty();
        }
        SortedSet otherNodes = (SortedSet)this.state().getOrElse((Object)dc, CrossDcHeartbeatingState::$anonfun$8);
        return (Set)((IterableOnce)otherNodes.take(this.nrOfMonitoredNodesPerDc())).iterator().map((Function1 & Serializable)_$7 -> _$7.uniqueAddress()).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Set$.MODULE$));
    }

    public Iterable<Member> allMembers() {
        return (Iterable)this.state().values().flatMap(ConstantFun$.MODULE$.scalaIdentityFunction());
    }

    public CrossDcHeartbeatingState heartbeatRsp(UniqueAddress from) {
        if (this.activeReceivers().contains((Object)from)) {
            this.failureDetector().heartbeat((Object)from.address());
        }
        return this;
    }

    public Set<String> dataCenters() {
        return this.state().keys().toSet();
    }

    public CrossDcHeartbeatingState copy(String selfDataCenter, FailureDetectorRegistry<Address> failureDetector, int nrOfMonitoredNodesPerDc, Map<String, SortedSet<Member>> state) {
        return new CrossDcHeartbeatingState(selfDataCenter, failureDetector, nrOfMonitoredNodesPerDc, state);
    }

    public String copy$default$1() {
        return this.selfDataCenter();
    }

    public FailureDetectorRegistry<Address> copy$default$2() {
        return this.failureDetector();
    }

    public int copy$default$3() {
        return this.nrOfMonitoredNodesPerDc();
    }

    public Map<String, SortedSet<Member>> copy$default$4() {
        return this.state();
    }

    public String _1() {
        return this.selfDataCenter();
    }

    public FailureDetectorRegistry<Address> _2() {
        return this.failureDetector();
    }

    public int _3() {
        return this.nrOfMonitoredNodesPerDc();
    }

    public Map<String, SortedSet<Member>> _4() {
        return this.state();
    }

    private static final SortedSet $anonfun$2() {
        return CrossDcHeartbeatingState$.MODULE$.org$apache$pekko$cluster$CrossDcHeartbeatingState$$$emptyMembersSortedSet();
    }

    private static final SortedSet $anonfun$5() {
        return CrossDcHeartbeatingState$.MODULE$.org$apache$pekko$cluster$CrossDcHeartbeatingState$$$emptyMembersSortedSet();
    }

    private static final SortedSet $anonfun$8() {
        return CrossDcHeartbeatingState$.MODULE$.org$apache$pekko$cluster$CrossDcHeartbeatingState$$$emptyMembersSortedSet();
    }
}

