/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.Gossip$;
import org.apache.pekko.cluster.GossipOverview;
import org.apache.pekko.cluster.GossipOverview$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.MemberStatus$Removed$;
import org.apache.pekko.cluster.Reachability;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.VectorClock;
import org.apache.pekko.cluster.VectorClock$Node$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class Gossip
implements Product,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(Gossip.class.getDeclaredField("reachabilityExcludingDownedObservers$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Gossip.class.getDeclaredField("isMultiDc$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Gossip.class.getDeclaredField("membersMap$lzy1"));
    private final SortedSet members;
    private final GossipOverview overview;
    private final VectorClock version;
    private final Map tombstones;
    private volatile transient Object membersMap$lzy1;
    private volatile transient Object isMultiDc$lzy1;
    private volatile Object reachabilityExcludingDownedObservers$lzy1;

    public static Gossip apply(SortedSet<Member> sortedSet) {
        return Gossip$.MODULE$.apply(sortedSet);
    }

    public static Gossip apply(SortedSet<Member> sortedSet, GossipOverview gossipOverview, VectorClock vectorClock, Map<UniqueAddress, Object> map) {
        return Gossip$.MODULE$.apply(sortedSet, gossipOverview, vectorClock, map);
    }

    public static Gossip empty() {
        return Gossip$.MODULE$.empty();
    }

    public static SortedSet<Member> emptyMembers() {
        return Gossip$.MODULE$.emptyMembers();
    }

    public static Gossip fromProduct(Product product) {
        return Gossip$.MODULE$.fromProduct(product);
    }

    public static Gossip unapply(Gossip gossip) {
        return Gossip$.MODULE$.unapply(gossip);
    }

    public static String vclockName(UniqueAddress uniqueAddress) {
        return Gossip$.MODULE$.vclockName(uniqueAddress);
    }

    public static GossipOverview $lessinit$greater$default$2() {
        return Gossip$.MODULE$.$lessinit$greater$default$2();
    }

    public static VectorClock $lessinit$greater$default$3() {
        return Gossip$.MODULE$.$lessinit$greater$default$3();
    }

    public static Map<UniqueAddress, Object> $lessinit$greater$default$4() {
        return Gossip$.MODULE$.$lessinit$greater$default$4();
    }

    public Gossip(SortedSet<Member> members, GossipOverview overview, VectorClock version, Map<UniqueAddress, Object> tombstones) {
        this.members = members;
        this.overview = overview;
        this.version = version;
        this.tombstones = tombstones;
        if (Cluster$.MODULE$.isAssertInvariantsEnabled()) {
            this.assertInvariants();
        }
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Gossip)) return false;
        Gossip gossip = (Gossip)object;
        SortedSet<Member> sortedSet = this.members();
        SortedSet<Member> sortedSet2 = gossip.members();
        if (sortedSet == null) {
            if (sortedSet2 != null) {
                return false;
            }
        } else if (!sortedSet.equals(sortedSet2)) return false;
        GossipOverview gossipOverview = this.overview();
        GossipOverview gossipOverview2 = gossip.overview();
        if (gossipOverview == null) {
            if (gossipOverview2 != null) {
                return false;
            }
        } else if (!((Object)gossipOverview).equals(gossipOverview2)) return false;
        if (!this.version().$eq$eq(gossip.version())) return false;
        Map<UniqueAddress, Object> map = this.tombstones();
        Map<UniqueAddress, Object> map2 = gossip.tombstones();
        if (map == null) {
            if (map2 == null) return true;
            return false;
        } else {
            if (!map.equals(map2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof Gossip;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "Gossip";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "members";
            }
            case 1: {
                return "overview";
            }
            case 2: {
                return "version";
            }
            case 3: {
                return "tombstones";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public SortedSet<Member> members() {
        return this.members;
    }

    public GossipOverview overview() {
        return this.overview;
    }

    public VectorClock version() {
        return this.version;
    }

    public Map<UniqueAddress, Object> tombstones() {
        return this.tombstones;
    }

    private void assertInvariants() {
        Gossip.ifTrueThrow$1(this::assertInvariants$$anonfun$1, new StringBuilder(36).append("Live members must not have status [").append(MemberStatus$Removed$.MODULE$).append("]").toString(), String.valueOf(this.members().filter((Function1 & Serializable)_$2 -> {
            MemberStatus memberStatus = _$2.status();
            MemberStatus$Removed$ memberStatus$Removed$ = MemberStatus$Removed$.MODULE$;
            return !(memberStatus != null ? !memberStatus.equals(memberStatus$Removed$) : memberStatus$Removed$ != null);
        })));
        scala.collection.immutable.Set inReachabilityButNotMember = (scala.collection.immutable.Set)this.overview().reachability().allObservers().diff((Set)this.members().map((Function1 & Serializable)_$3 -> _$3.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        Gossip.ifTrueThrow$1(() -> Gossip.assertInvariants$$anonfun$3(inReachabilityButNotMember), "Nodes not part of cluster in reachability table", inReachabilityButNotMember.mkString(", "));
        scala.collection.immutable.Set inReachabilityVersionsButNotMember = (scala.collection.immutable.Set)this.overview().reachability().versions().keySet().diff((Set)this.members().map((Function1 & Serializable)_$4 -> _$4.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        Gossip.ifTrueThrow$1(() -> Gossip.assertInvariants$$anonfun$4(inReachabilityVersionsButNotMember), "Nodes not part of cluster in reachability versions table", inReachabilityVersionsButNotMember.mkString(", "));
        scala.collection.immutable.Set seenButNotMember = (scala.collection.immutable.Set)this.overview().seen().diff((Set)this.members().map((Function1 & Serializable)_$5 -> _$5.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        Gossip.ifTrueThrow$1(() -> Gossip.assertInvariants$$anonfun$5(seenButNotMember), "Nodes not part of cluster have marked the Gossip as seen", seenButNotMember.mkString(", "));
    }

    private Map<UniqueAddress, Member> membersMap() {
        Object object = this.membersMap$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.membersMap$lzyINIT1();
    }

    private Object membersMap$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.membersMap$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        map = this.members().iterator().map((Function1 & Serializable)m -> {
                            UniqueAddress uniqueAddress = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)m.uniqueAddress());
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress, m);
                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.membersMap$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean isMultiDc() {
        Object object = this.isMultiDc$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isMultiDc$lzyINIT1());
    }

    private Object isMultiDc$lzyINIT1() {
        Object object;
        block10: {
            while (true) {
                if ((object = this.isMultiDc$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        boolean bl2;
                        if (this.members().size() <= 1) {
                            bl2 = false;
                        } else {
                            String dc1 = ((Member)this.members().head()).dataCenter();
                            bl2 = this.members().exists((Function1 & Serializable)_$6 -> {
                                String string = _$6.dataCenter();
                                String string2 = dc1;
                                return string == null ? string2 != null : !string.equals(string2);
                            });
                        }
                        bl = BoxesRunTime.boxToBoolean((boolean)bl2);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isMultiDc$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block10;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Gossip $colon$plus(String node) {
        VectorClock vectorClock = this.version().$colon$plus(node);
        SortedSet<Member> sortedSet = this.copy$default$1();
        GossipOverview gossipOverview = this.copy$default$2();
        Map<UniqueAddress, Object> map = this.copy$default$4();
        return this.copy(sortedSet, gossipOverview, vectorClock, map);
    }

    public Gossip $colon$plus(Member member) {
        if (this.members().contains((Object)member)) {
            return this;
        }
        return this.copy((SortedSet<Member>)((SortedSet)this.members().$plus((Object)member)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public Gossip seen(UniqueAddress node) {
        if (this.seenByNode(node)) {
            return this;
        }
        GossipOverview gossipOverview = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)this.overview().seen().$plus((Object)node)), this.overview().copy$default$2());
        SortedSet<Member> sortedSet = this.copy$default$1();
        VectorClock vectorClock = this.copy$default$3();
        Map<UniqueAddress, Object> map = this.copy$default$4();
        return this.copy(sortedSet, gossipOverview, vectorClock, map);
    }

    public Gossip onlySeen(UniqueAddress node) {
        GossipOverview gossipOverview = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{node}))), this.overview().copy$default$2());
        SortedSet<Member> sortedSet = this.copy$default$1();
        VectorClock vectorClock = this.copy$default$3();
        Map<UniqueAddress, Object> map = this.copy$default$4();
        return this.copy(sortedSet, gossipOverview, vectorClock, map);
    }

    public Gossip clearSeen() {
        GossipOverview gossipOverview = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)Predef$.MODULE$.Set().empty(), this.overview().copy$default$2());
        SortedSet<Member> sortedSet = this.copy$default$1();
        VectorClock vectorClock = this.copy$default$3();
        Map<UniqueAddress, Object> map = this.copy$default$4();
        return this.copy(sortedSet, gossipOverview, vectorClock, map);
    }

    public scala.collection.immutable.Set<UniqueAddress> seenBy() {
        return this.overview().seen();
    }

    public boolean seenByNode(UniqueAddress node) {
        return this.overview().seen().apply((Object)node);
    }

    public Gossip mergeSeen(Gossip that) {
        GossipOverview gossipOverview = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)this.overview().seen().union(that.overview().seen())), this.overview().copy$default$2());
        SortedSet<Member> sortedSet = this.copy$default$1();
        VectorClock vectorClock = this.copy$default$3();
        Map<UniqueAddress, Object> map = this.copy$default$4();
        return this.copy(sortedSet, gossipOverview, vectorClock, map);
    }

    public Gossip merge(Gossip that) {
        Map mergedTombstones = (Map)this.tombstones().$plus$plus(that.tombstones());
        VectorClock mergedVClock = (VectorClock)mergedTombstones.keys().foldLeft((Object)this.version().merge(that.version()), (Function2 & Serializable)(vclock, node) -> vclock.prune(VectorClock$Node$.MODULE$.apply(Gossip$.MODULE$.vclockName((UniqueAddress)node))));
        SortedSet mergedMembers = (SortedSet)Gossip$.MODULE$.emptyMembers().union(Member$.MODULE$.pickHighestPriority((scala.collection.immutable.Set<Member>)this.members(), (scala.collection.immutable.Set<Member>)that.members(), (Map<UniqueAddress, Object>)mergedTombstones));
        Reachability mergedReachability = this.overview().reachability().merge((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)mergedMembers.map((Function1 & Serializable)_$7 -> _$7.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))), that.overview().reachability());
        scala.collection.immutable.Set mergedSeen = Predef$.MODULE$.Set().empty();
        return Gossip$.MODULE$.apply((SortedSet<Member>)mergedMembers, GossipOverview$.MODULE$.apply((scala.collection.immutable.Set<UniqueAddress>)mergedSeen, mergedReachability), mergedVClock, (Map<UniqueAddress, Object>)mergedTombstones);
    }

    public Reachability reachabilityExcludingDownedObservers() {
        Object object = this.reachabilityExcludingDownedObservers$lzy1;
        if (object instanceof Reachability) {
            return (Reachability)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Reachability)this.reachabilityExcludingDownedObservers$lzyINIT1();
    }

    private Object reachabilityExcludingDownedObservers$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.reachabilityExcludingDownedObservers$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Reachability reachability = null;
                    try {
                        SortedSet downed = (SortedSet)this.members().collect((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(Member x) {
                                Member member;
                                Member m = member = x;
                                MemberStatus memberStatus = m.status();
                                MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                                return !(memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null);
                            }

                            public final Object applyOrElse(Member x, Function1 function1) {
                                Member member;
                                Member m = member = x;
                                MemberStatus memberStatus = m.status();
                                MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                                if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Down$) : memberStatus$Down$ != null)) {
                                    return m;
                                }
                                return function1.apply((Object)x);
                            }
                        }, Member$.MODULE$.ordering());
                        reachability = this.overview().reachability().removeObservers((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)downed.map((Function1 & Serializable)_$8 -> _$8.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))));
                        object2 = reachability == null ? LazyVals.NullValue$.MODULE$ : reachability;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.reachabilityExcludingDownedObservers$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.reachabilityExcludingDownedObservers$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return reachability;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public scala.collection.immutable.Set<String> allDataCenters() {
        return (scala.collection.immutable.Set)this.members().map((Function1 & Serializable)_$9 -> _$9.dataCenter(), (Ordering)Ordering.String$.MODULE$);
    }

    public scala.collection.immutable.Set<String> allRoles() {
        return (scala.collection.immutable.Set)this.members().flatMap((Function1 & Serializable)_$10 -> _$10.roles(), (Ordering)Ordering.String$.MODULE$);
    }

    public boolean isSingletonCluster() {
        return this.members().size() == 1;
    }

    public boolean isReachable(UniqueAddress fromAddress, UniqueAddress toAddress) {
        if (!this.hasMember(toAddress)) {
            return false;
        }
        return this.overview().reachability().isReachable(fromAddress, toAddress);
    }

    public Member member(UniqueAddress node) {
        return (Member)this.membersMap().getOrElse((Object)node, () -> Gossip.member$$anonfun$1(node));
    }

    public boolean hasMember(UniqueAddress node) {
        return this.membersMap().contains((Object)node);
    }

    public Gossip removeAll(Iterable<UniqueAddress> nodes, long removalTimestamp) {
        return (Gossip)nodes.foldLeft((Object)this, (Function2 & Serializable)(gossip, node) -> gossip.remove((UniqueAddress)node, removalTimestamp));
    }

    public Gossip update(SortedSet<Member> updatedMembers) {
        return this.copy((SortedSet<Member>)((SortedSet)updatedMembers.union((Set)this.members().diff(updatedMembers))), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public Gossip remove(UniqueAddress node, long removalTimestamp) {
        scala.collection.immutable.Set newSeen = (scala.collection.immutable.Set)this.overview().seen().$minus((Object)node);
        Reachability newReachability = this.overview().reachability().remove((Iterable<UniqueAddress>)package$.MODULE$.Nil().$colon$colon((Object)node));
        GossipOverview newOverview = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)newSeen, newReachability);
        VectorClock newVersion = this.version().prune(VectorClock$Node$.MODULE$.apply(Gossip$.MODULE$.vclockName(node)));
        SortedSet newMembers = (SortedSet)this.members().filterNot((Function1 & Serializable)_$11 -> {
            UniqueAddress uniqueAddress = _$11.uniqueAddress();
            UniqueAddress uniqueAddress2 = node;
            return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
        });
        UniqueAddress uniqueAddress = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)node);
        Map newTombstones = (Map)this.tombstones().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress, (Object)BoxesRunTime.boxToLong((long)removalTimestamp)));
        return this.copy((SortedSet<Member>)newMembers, newOverview, newVersion, (Map<UniqueAddress, Object>)newTombstones);
    }

    public Gossip markAsDown(Member member) {
        SortedSet newMembers = (SortedSet)this.members().$minus((Object)member).$plus((Object)member.copy(MemberStatus$Down$.MODULE$));
        scala.collection.immutable.Set newSeen = (scala.collection.immutable.Set)this.overview().seen().$minus((Object)member.uniqueAddress());
        GossipOverview newOverview = this.overview().copy((scala.collection.immutable.Set<UniqueAddress>)newSeen, this.overview().copy$default$2());
        return this.copy((SortedSet<Member>)newMembers, newOverview, this.copy$default$3(), this.copy$default$4());
    }

    public Gossip prune(String removedNode) {
        VectorClock newVersion = this.version().prune(removedNode);
        if (newVersion == this.version()) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), newVersion, this.copy$default$4());
    }

    public Gossip pruneTombstones(long removeEarlierThan) {
        Map newTombstones = (Map)this.tombstones().filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long timestamp = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return timestamp > removeEarlierThan;
            }
            throw new MatchError((Object)tuple2);
        });
        if (newTombstones.size() == this.tombstones().size()) {
            return this;
        }
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), (Map<UniqueAddress, Object>)newTombstones);
    }

    public byte[] seenDigest() {
        return this.overview().seenDigest();
    }

    public String toString() {
        return new StringBuilder(60).append("Gossip(members = [").append(this.members().mkString(", ")).append("], overview = ").append(this.overview()).append(", version = ").append(this.version()).append(", tombstones = ").append(this.tombstones()).append(")").toString();
    }

    public Gossip copy(SortedSet<Member> members, GossipOverview overview, VectorClock version, Map<UniqueAddress, Object> tombstones) {
        return new Gossip(members, overview, version, tombstones);
    }

    public SortedSet<Member> copy$default$1() {
        return this.members();
    }

    public GossipOverview copy$default$2() {
        return this.overview();
    }

    public VectorClock copy$default$3() {
        return this.version();
    }

    public Map<UniqueAddress, Object> copy$default$4() {
        return this.tombstones();
    }

    public SortedSet<Member> _1() {
        return this.members();
    }

    public GossipOverview _2() {
        return this.overview();
    }

    public VectorClock _3() {
        return this.version();
    }

    public Map<UniqueAddress, Object> _4() {
        return this.tombstones();
    }

    private static final void ifTrueThrow$1(Function0 func, String expected, String actual) {
        if (func.apply$mcZ$sp()) {
            throw new IllegalArgumentException(new StringBuilder(14).append(expected).append(", but found [").append(actual).append("]").toString());
        }
    }

    private final boolean assertInvariants$$anonfun$1() {
        return this.members().exists((Function1 & Serializable)_$1 -> {
            MemberStatus memberStatus = _$1.status();
            MemberStatus$Removed$ memberStatus$Removed$ = MemberStatus$Removed$.MODULE$;
            return !(memberStatus != null ? !memberStatus.equals(memberStatus$Removed$) : memberStatus$Removed$ != null);
        });
    }

    private static final boolean assertInvariants$$anonfun$3(scala.collection.immutable.Set inReachabilityButNotMember$1) {
        return inReachabilityButNotMember$1.nonEmpty();
    }

    private static final boolean assertInvariants$$anonfun$4(scala.collection.immutable.Set inReachabilityVersionsButNotMember$1) {
        return inReachabilityVersionsButNotMember$1.nonEmpty();
    }

    private static final boolean assertInvariants$$anonfun$5(scala.collection.immutable.Set seenButNotMember$1) {
        return seenButNotMember$1.nonEmpty();
    }

    private static final Member member$$anonfun$1(UniqueAddress node$1) {
        return Member$.MODULE$.removed(node$1);
    }
}

