/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.cluster.HeartbeatNodeRing$;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.UniqueAddress;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class HeartbeatNodeRing
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HeartbeatNodeRing.class.getDeclaredField("myReceivers$lzy1"));
    private final UniqueAddress selfAddress;
    private final Set nodes;
    private final Set unreachable;
    private final int monitoredByNrOfMembers;
    private final SortedSet<UniqueAddress> nodeRing;
    private volatile Object myReceivers$lzy1;
    private final boolean useAllAsReceivers;

    public static HeartbeatNodeRing apply(UniqueAddress uniqueAddress, Set<UniqueAddress> set, Set<UniqueAddress> set2, int n) {
        return HeartbeatNodeRing$.MODULE$.apply(uniqueAddress, set, set2, n);
    }

    public static HeartbeatNodeRing fromProduct(Product product) {
        return HeartbeatNodeRing$.MODULE$.fromProduct(product);
    }

    public static HeartbeatNodeRing unapply(HeartbeatNodeRing heartbeatNodeRing) {
        return HeartbeatNodeRing$.MODULE$.unapply(heartbeatNodeRing);
    }

    public HeartbeatNodeRing(UniqueAddress selfAddress, Set<UniqueAddress> nodes, Set<UniqueAddress> unreachable, int monitoredByNrOfMembers) {
        this.selfAddress = selfAddress;
        this.nodes = nodes;
        this.unreachable = unreachable;
        this.monitoredByNrOfMembers = monitoredByNrOfMembers;
        Predef$.MODULE$.require(nodes.contains((Object)selfAddress), () -> HeartbeatNodeRing.$init$$$anonfun$2(nodes, selfAddress));
        Ordering ringOrdering = package$.MODULE$.Ordering().fromLessThan((Function2 & Serializable)(a, b) -> {
            int hb;
            int ha = Statics.anyHash((Object)a);
            return ha < (hb = Statics.anyHash((Object)b)) || ha == hb && Member$.MODULE$.addressOrdering().compare((Object)a.address(), (Object)b.address()) < 0;
        });
        this.nodeRing = (SortedSet)((SetOps)SortedSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[0]), (Object)ringOrdering)).union(nodes);
        this.useAllAsReceivers = monitoredByNrOfMembers >= this.nodeRing.size() - 1;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.selfAddress()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.nodes()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.unreachable()));
        n = Statics.mix((int)n, (int)this.monitoredByNrOfMembers());
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof HeartbeatNodeRing)) return false;
        HeartbeatNodeRing heartbeatNodeRing = (HeartbeatNodeRing)object;
        if (this.monitoredByNrOfMembers() != heartbeatNodeRing.monitoredByNrOfMembers()) return false;
        UniqueAddress uniqueAddress = this.selfAddress();
        UniqueAddress uniqueAddress2 = heartbeatNodeRing.selfAddress();
        if (uniqueAddress == null) {
            if (uniqueAddress2 != null) {
                return false;
            }
        } else if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
        Set<UniqueAddress> set = this.nodes();
        Set<UniqueAddress> set2 = heartbeatNodeRing.nodes();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        Set<UniqueAddress> set3 = this.unreachable();
        Set<UniqueAddress> set4 = heartbeatNodeRing.unreachable();
        if (set3 == null) {
            if (set4 == null) return true;
            return false;
        } else {
            if (!set3.equals(set4)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof HeartbeatNodeRing;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "HeartbeatNodeRing";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "selfAddress";
            }
            case 1: {
                return "nodes";
            }
            case 2: {
                return "unreachable";
            }
            case 3: {
                return "monitoredByNrOfMembers";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public UniqueAddress selfAddress() {
        return this.selfAddress;
    }

    public Set<UniqueAddress> nodes() {
        return this.nodes;
    }

    public Set<UniqueAddress> unreachable() {
        return this.unreachable;
    }

    public int monitoredByNrOfMembers() {
        return this.monitoredByNrOfMembers;
    }

    public Set<UniqueAddress> myReceivers() {
        Object object = this.myReceivers$lzy1;
        if (object instanceof Set) {
            return (Set)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Set)this.myReceivers$lzyINIT1();
    }

    private Object myReceivers$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.myReceivers$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Set<UniqueAddress> set = null;
                    Set<UniqueAddress> set2 = null;
                    try {
                        set2 = this.receivers(this.selfAddress());
                        set = set2 == null ? LazyVals.NullValue$.MODULE$ : set2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, set)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.myReceivers$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, set);
                            waiting.countDown();
                        }
                    }
                    return set2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Set<UniqueAddress> receivers(UniqueAddress sender) {
        Set set;
        if (this.useAllAsReceivers) {
            return (Set)this.nodeRing.$minus((Object)sender);
        }
        Tuple2 tuple2 = this.take$1(this.monitoredByNrOfMembers(), ((IterableOnce)((IterableOps)this.nodeRing.rangeFrom((Object)sender)).tail()).iterator(), Predef$.MODULE$.Set().empty());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int remaining = BoxesRunTime.unboxToInt((Object)tuple2._1());
        Set slice1 = (Set)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)remaining), (Object)slice1);
        int remaining2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        Set slice12 = (Set)tuple22._2();
        if (remaining2 == 0) {
            set = slice12;
        } else {
            Set slice2;
            Tuple2 tuple23 = this.take$1(remaining2, this.nodeRing.rangeTo((Object)sender).iterator().filterNot((Function1 & Serializable)_$2 -> {
                UniqueAddress uniqueAddress = _$2;
                UniqueAddress uniqueAddress2 = sender;
                return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
            }), slice12);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Set slice22 = (Set)tuple23._2();
            set = slice2 = slice22;
        }
        Set slice = set;
        return slice;
    }

    public HeartbeatNodeRing $colon$plus(UniqueAddress node) {
        if (this.nodes().contains((Object)node)) {
            return this;
        }
        Set set = (Set)this.nodes().$plus((Object)node);
        UniqueAddress uniqueAddress = this.copy$default$1();
        Set<UniqueAddress> set2 = this.copy$default$3();
        int n = this.copy$default$4();
        return this.copy(uniqueAddress, (Set<UniqueAddress>)set, set2, n);
    }

    public HeartbeatNodeRing $colon$minus(UniqueAddress node) {
        if (this.nodes().contains((Object)node) || this.unreachable().contains((Object)node)) {
            Set set = (Set)this.nodes().$minus((Object)node);
            Set set2 = (Set)this.unreachable().$minus((Object)node);
            UniqueAddress uniqueAddress = this.copy$default$1();
            int n = this.copy$default$4();
            return this.copy(uniqueAddress, (Set<UniqueAddress>)set, (Set<UniqueAddress>)set2, n);
        }
        return this;
    }

    public HeartbeatNodeRing copy(UniqueAddress selfAddress, Set<UniqueAddress> nodes, Set<UniqueAddress> unreachable, int monitoredByNrOfMembers) {
        return new HeartbeatNodeRing(selfAddress, nodes, unreachable, monitoredByNrOfMembers);
    }

    public UniqueAddress copy$default$1() {
        return this.selfAddress();
    }

    public Set<UniqueAddress> copy$default$2() {
        return this.nodes();
    }

    public Set<UniqueAddress> copy$default$3() {
        return this.unreachable();
    }

    public int copy$default$4() {
        return this.monitoredByNrOfMembers();
    }

    public UniqueAddress _1() {
        return this.selfAddress();
    }

    public Set<UniqueAddress> _2() {
        return this.nodes();
    }

    public Set<UniqueAddress> _3() {
        return this.unreachable();
    }

    public int _4() {
        return this.monitoredByNrOfMembers();
    }

    private static final Object $init$$$anonfun$2(Set nodes$6, UniqueAddress selfAddress$6) {
        return new StringBuilder(36).append("nodes [").append(nodes$6.mkString(", ")).append("] must contain selfAddress [").append(selfAddress$6).append("]").toString();
    }

    private final Tuple2 take$1(int n, Iterator iter, Set acc) {
        while (!iter.isEmpty() && n != 0) {
            UniqueAddress next = (UniqueAddress)iter.next();
            boolean isUnreachable = this.unreachable().apply((Object)next);
            if (isUnreachable && acc.size() >= this.monitoredByNrOfMembers()) continue;
            if (isUnreachable) {
                acc = (Set)acc.$plus((Object)next);
                continue;
            }
            int n2 = n - 1;
            Set set = (Set)acc.$plus((Object)next);
            n = n2;
            acc = set;
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n), (Object)acc);
    }
}

