/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ReceiveTimeout$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.cluster.ClusterLogMarker$;
import org.apache.pekko.cluster.InternalClusterAction;
import org.apache.pekko.cluster.InternalClusterAction$IncompatibleConfig$;
import org.apache.pekko.cluster.InternalClusterAction$InitJoinAck$;
import org.apache.pekko.cluster.InternalClusterAction$InitJoinNack$;
import org.apache.pekko.cluster.InternalClusterAction$JoinSeedNode$;
import org.apache.pekko.cluster.InternalClusterAction$UncheckedConfig$;
import org.apache.pekko.cluster.JoinConfigCompatChecker;
import org.apache.pekko.cluster.SeedNodeProcess;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@InternalApi
public final class JoinSeedNodeProcess
extends SeedNodeProcess {
    public final IndexedSeq<Address> org$apache$pekko$cluster$JoinSeedNodeProcess$$seedNodes;
    private int attempt;
    private final Set otherSeedNodes;

    public JoinSeedNodeProcess(IndexedSeq<Address> seedNodes, JoinConfigCompatChecker joinConfigCompatChecker) {
        block3: {
            block2: {
                this.org$apache$pekko$cluster$JoinSeedNodeProcess$$seedNodes = seedNodes;
                super(joinConfigCompatChecker);
                if (seedNodes.isEmpty()) break block2;
                Object object = seedNodes.head();
                Address address = this.selfAddress();
                if (object != null ? !object.equals(address) : address != null) break block3;
            }
            throw new IllegalArgumentException("Join seed node should not be done");
        }
        this.context().setReceiveTimeout((Duration)this.cluster().settings().SeedNodeTimeout());
        this.attempt = 0;
        this.otherSeedNodes = (Set)seedNodes.toSet().$minus((Object)this.selfAddress());
    }

    public int attempt() {
        return this.attempt;
    }

    public void attempt_$eq(int x$1) {
        this.attempt = x$1;
    }

    public Set<Address> otherSeedNodes() {
        return this.otherSeedNodes;
    }

    @Override
    public void preStart() {
        this.self().$bang((Object)InternalClusterAction$JoinSeedNode$.MODULE$, this.self());
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ JoinSeedNodeProcess $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (InternalClusterAction$JoinSeedNode$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof InternalClusterAction.InitJoinAck) {
                    InternalClusterAction.InitJoinAck initJoinAck = InternalClusterAction$InitJoinAck$.MODULE$.unapply((InternalClusterAction.InitJoinAck)object);
                    Address address = initJoinAck._1();
                    InternalClusterAction.ConfigCheck configCheck = initJoinAck._2();
                    Address address2 = address;
                    if (configCheck instanceof InternalClusterAction.CompatibleConfig) {
                        InternalClusterAction.CompatibleConfig compatible = (InternalClusterAction.CompatibleConfig)configCheck;
                        return true;
                    }
                    Address address3 = address;
                    if (InternalClusterAction$UncheckedConfig$.MODULE$.equals(configCheck)) {
                        return true;
                    }
                    Address address4 = address;
                    if (InternalClusterAction$IncompatibleConfig$.MODULE$.equals(configCheck)) {
                        return true;
                    }
                }
                if (object instanceof InternalClusterAction.InitJoinNack) {
                    InternalClusterAction.InitJoinNack initJoinNack = InternalClusterAction$InitJoinNack$.MODULE$.unapply((InternalClusterAction.InitJoinNack)object);
                    Address address = initJoinNack._1();
                    return true;
                }
                return ReceiveTimeout$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (InternalClusterAction$JoinSeedNode$.MODULE$.equals(object)) {
                    this.$outer.attempt_$eq(this.$outer.attempt() + 1);
                    this.$outer.receiveJoinSeedNode(this.$outer.otherSeedNodes());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof InternalClusterAction.InitJoinAck) {
                    InternalClusterAction.InitJoinAck initJoinAck = InternalClusterAction$InitJoinAck$.MODULE$.unapply((InternalClusterAction.InitJoinAck)object);
                    Address address = initJoinAck._1();
                    InternalClusterAction.ConfigCheck configCheck = initJoinAck._2();
                    Address address2 = address;
                    if (configCheck instanceof InternalClusterAction.CompatibleConfig) {
                        InternalClusterAction.CompatibleConfig compatible = (InternalClusterAction.CompatibleConfig)configCheck;
                        this.$outer.receiveInitJoinAckCompatibleConfig(address2, this.$outer.sender(), compatible, (Option<PartialFunction<Object, BoxedUnit>>)Some$.MODULE$.apply(this.$outer.done()));
                        return BoxedUnit.UNIT;
                    }
                    Address address3 = address;
                    if (InternalClusterAction$UncheckedConfig$.MODULE$.equals(configCheck)) {
                        this.$outer.receiveInitJoinAckUncheckedConfig(address3, this.$outer.sender(), (Option<PartialFunction<Object, BoxedUnit>>)Some$.MODULE$.apply(this.$outer.done()));
                        return BoxedUnit.UNIT;
                    }
                    Address address4 = address;
                    if (InternalClusterAction$IncompatibleConfig$.MODULE$.equals(configCheck)) {
                        this.$outer.receiveInitJoinAckIncompatibleConfig(address4, this.$outer.sender(), (Option<PartialFunction<Object, BoxedUnit>>)Some$.MODULE$.apply(this.$outer.done()));
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof InternalClusterAction.InitJoinNack) {
                    InternalClusterAction.InitJoinNack initJoinNack = InternalClusterAction$InitJoinNack$.MODULE$.unapply((InternalClusterAction.InitJoinNack)object);
                    Address address = initJoinNack._1();
                    return BoxedUnit.UNIT;
                }
                if (ReceiveTimeout$.MODULE$.equals(object)) {
                    if (this.$outer.attempt() >= 2) {
                        this.$outer.cluster().ClusterLogger().logWarning(ClusterLogMarker$.MODULE$.joinFailed(), "Couldn't join seed nodes after [{}] attempts, will try again. seed-nodes=[{}]", (Object)BoxesRunTime.boxToInteger((int)this.$outer.attempt()), (Object)((IterableOnceOps)this.$outer.org$apache$pekko$cluster$JoinSeedNodeProcess$$seedNodes.filterNot((Function1 & Serializable)_$1 -> {
                            Address address = _$1;
                            Address address2 = this.$outer.selfAddress();
                            return !(address != null ? !address.equals(address2) : address2 != null);
                        })).mkString(", "));
                    }
                    this.$outer.self().$bang((Object)InternalClusterAction$JoinSeedNode$.MODULE$, this.$outer.self());
                    this.$outer.onReceiveTimeout(this.$outer.org$apache$pekko$cluster$JoinSeedNodeProcess$$seedNodes, this.$outer.attempt());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(org.apache.pekko.actor.Address )}, serializedLambda);
            }
        };
    }

    @InternalStableApi
    public void onReceiveTimeout(IndexedSeq<Address> seedNodes, int attempt) {
    }

    public PartialFunction<Object, BoxedUnit> done() {
        return new Serializable(this){
            private final /* synthetic */ JoinSeedNodeProcess $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof InternalClusterAction.InitJoinAck) {
                    InternalClusterAction.InitJoinAck initJoinAck = InternalClusterAction$InitJoinAck$.MODULE$.unapply((InternalClusterAction.InitJoinAck)object);
                    Address address = initJoinAck._1();
                    InternalClusterAction.ConfigCheck configCheck = initJoinAck._2();
                    return true;
                }
                return ReceiveTimeout$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof InternalClusterAction.InitJoinAck) {
                    InternalClusterAction.InitJoinAck initJoinAck = InternalClusterAction$InitJoinAck$.MODULE$.unapply((InternalClusterAction.InitJoinAck)object);
                    Address address = initJoinAck._1();
                    InternalClusterAction.ConfigCheck configCheck = initJoinAck._2();
                    return BoxedUnit.UNIT;
                }
                if (ReceiveTimeout$.MODULE$.equals(object)) {
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }
}

