/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ClusterSettings$;
import org.apache.pekko.cluster.Gossip;
import org.apache.pekko.cluster.GossipOverview;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.MemberStatus$Joining$;
import org.apache.pekko.cluster.MemberStatus$WeaklyUp$;
import org.apache.pekko.cluster.MembershipState$;
import org.apache.pekko.cluster.Reachability;
import org.apache.pekko.cluster.UniqueAddress;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class MembershipState
implements Product,
Serializable {
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(MembershipState.class.getDeclaredField("ageSortedTopOldestMembersPerDc$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(MembershipState.class.getDeclaredField("dcReachabilityNoOutsideNodes$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(MembershipState.class.getDeclaredField("dcReachabilityExcludingDownedObservers$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(MembershipState.class.getDeclaredField("dcReachabilityWithoutObservationsWithin$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MembershipState.class.getDeclaredField("dcReachability$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MembershipState.class.getDeclaredField("selfMember$lzy1"));
    private final Gossip latestGossip;
    private final UniqueAddress selfUniqueAddress;
    private final String selfDc;
    private final int crossDcConnections;
    private volatile Object selfMember$lzy1;
    private volatile Object dcReachability$lzy1;
    private volatile Object dcReachabilityWithoutObservationsWithin$lzy1;
    private volatile Object dcReachabilityExcludingDownedObservers$lzy1;
    private volatile Object dcReachabilityNoOutsideNodes$lzy1;
    private volatile Object ageSortedTopOldestMembersPerDc$lzy1;

    public static Set<MemberStatus> allowedToPrepareToShutdown() {
        return MembershipState$.MODULE$.allowedToPrepareToShutdown();
    }

    public static MembershipState apply(Gossip gossip, UniqueAddress uniqueAddress, String string, int n) {
        return MembershipState$.MODULE$.apply(gossip, uniqueAddress, string, n);
    }

    public static Set<MemberStatus> convergenceSkipUnreachableWithMemberStatus() {
        return MembershipState$.MODULE$.convergenceSkipUnreachableWithMemberStatus();
    }

    public static MembershipState fromProduct(Product product) {
        return MembershipState$.MODULE$.fromProduct(product);
    }

    public static Set<MemberStatus> prepareForShutdownStates() {
        return MembershipState$.MODULE$.prepareForShutdownStates();
    }

    public static Set<MemberStatus> removeUnreachableWithMemberStatus() {
        return MembershipState$.MODULE$.removeUnreachableWithMemberStatus();
    }

    public static MembershipState unapply(MembershipState membershipState) {
        return MembershipState$.MODULE$.unapply(membershipState);
    }

    public MembershipState(Gossip latestGossip, UniqueAddress selfUniqueAddress, String selfDc, int crossDcConnections) {
        this.latestGossip = latestGossip;
        this.selfUniqueAddress = selfUniqueAddress;
        this.selfDc = selfDc;
        this.crossDcConnections = crossDcConnections;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.latestGossip()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.selfUniqueAddress()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.selfDc()));
        n = Statics.mix((int)n, (int)this.crossDcConnections());
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof MembershipState)) return false;
        MembershipState membershipState = (MembershipState)object;
        if (this.crossDcConnections() != membershipState.crossDcConnections()) return false;
        Gossip gossip = this.latestGossip();
        Gossip gossip2 = membershipState.latestGossip();
        if (gossip == null) {
            if (gossip2 != null) {
                return false;
            }
        } else if (!((Object)gossip).equals(gossip2)) return false;
        UniqueAddress uniqueAddress = this.selfUniqueAddress();
        UniqueAddress uniqueAddress2 = membershipState.selfUniqueAddress();
        if (uniqueAddress == null) {
            if (uniqueAddress2 != null) {
                return false;
            }
        } else if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
        String string = this.selfDc();
        String string2 = membershipState.selfDc();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof MembershipState;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "MembershipState";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this._4());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "latestGossip";
            }
            case 1: {
                return "selfUniqueAddress";
            }
            case 2: {
                return "selfDc";
            }
            case 3: {
                return "crossDcConnections";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Gossip latestGossip() {
        return this.latestGossip;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public String selfDc() {
        return this.selfDc;
    }

    public int crossDcConnections() {
        return this.crossDcConnections;
    }

    public Member selfMember() {
        Object object = this.selfMember$lzy1;
        if (object instanceof Member) {
            return (Member)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Member)this.selfMember$lzyINIT1();
    }

    private Object selfMember$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.selfMember$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Member member = null;
                    try {
                        member = this.latestGossip().member(this.selfUniqueAddress());
                        object2 = member == null ? LazyVals.NullValue$.MODULE$ : member;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.selfMember$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return member;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public SortedSet<Member> members() {
        return this.latestGossip().members();
    }

    public GossipOverview overview() {
        return this.latestGossip().overview();
    }

    public MembershipState seen() {
        return this.copy(this.latestGossip().seen(this.selfUniqueAddress()), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public boolean convergence(Set<UniqueAddress> exitingConfirmed) {
        boolean firstMemberInDc = !this.members().exists((Function1 & Serializable)member -> {
            String string = member.dataCenter();
            String string2 = this.selfDc();
            return !(string != null ? !string.equals(string2) : string2 != null) && MembershipState$.org$apache$pekko$cluster$MembershipState$$$convergenceMemberStatus.apply((Object)member.status());
        });
        Set unreachableInDc = (Set)this.dcReachabilityExcludingDownedObservers().allUnreachableOrTerminated().collect((PartialFunction)new Serializable(exitingConfirmed, this){
            private final Set exitingConfirmed$3;
            private final /* synthetic */ MembershipState $outer;
            {
                this.exitingConfirmed$3 = exitingConfirmed$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(UniqueAddress x) {
                UniqueAddress uniqueAddress;
                UniqueAddress node;
                UniqueAddress uniqueAddress2 = node = (uniqueAddress = x);
                UniqueAddress uniqueAddress3 = this.$outer.selfUniqueAddress();
                return (uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3)) && !this.exitingConfirmed$3.apply((Object)node);
            }

            public final Object applyOrElse(UniqueAddress x, Function1 function1) {
                UniqueAddress uniqueAddress;
                UniqueAddress node;
                UniqueAddress uniqueAddress2 = node = (uniqueAddress = x);
                UniqueAddress uniqueAddress3 = this.$outer.selfUniqueAddress();
                if ((uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3)) && !this.exitingConfirmed$3.apply((Object)node)) {
                    return this.$outer.latestGossip().member(node);
                }
                return function1.apply((Object)x);
            }
        });
        boolean allUnreachablesCanBeIgnored = unreachableInDc.forall((Function1 & Serializable)unreachable -> MembershipState$.MODULE$.convergenceSkipUnreachableWithMemberStatus().apply((Object)unreachable.status()));
        return allUnreachablesCanBeIgnored && !this.memberHinderingConvergenceExists$1(firstMemberInDc, exitingConfirmed);
    }

    public Reachability dcReachability() {
        Object object = this.dcReachability$lzy1;
        if (object instanceof Reachability) {
            return (Reachability)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Reachability)this.dcReachability$lzyINIT1();
    }

    private Object dcReachability$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.dcReachability$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Reachability reachability = null;
                    try {
                        reachability = this.overview().reachability().removeObservers((Set<UniqueAddress>)((Set)this.members().collect((PartialFunction)new Serializable(this){
                            private final /* synthetic */ MembershipState $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public final boolean isDefinedAt(Member x) {
                                Member member;
                                Member m = member = x;
                                String string = m.dataCenter();
                                String string2 = this.$outer.selfDc();
                                return string == null ? string2 != null : !string.equals(string2);
                            }

                            public final Object applyOrElse(Member x, Function1 function1) {
                                Member member;
                                Member m = member = x;
                                String string = m.dataCenter();
                                String string2 = this.$outer.selfDc();
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    return m.uniqueAddress();
                                }
                                return function1.apply((Object)x);
                            }
                        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))));
                        object2 = reachability == null ? LazyVals.NullValue$.MODULE$ : reachability;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dcReachability$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.dcReachability$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return reachability;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Reachability dcReachabilityWithoutObservationsWithin() {
        Object object = this.dcReachabilityWithoutObservationsWithin$lzy1;
        if (object instanceof Reachability) {
            return (Reachability)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Reachability)this.dcReachabilityWithoutObservationsWithin$lzyINIT1();
    }

    private Object dcReachabilityWithoutObservationsWithin$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.dcReachabilityWithoutObservationsWithin$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Reachability reachability = null;
                    try {
                        reachability = this.dcReachability().filterRecords((Function1<Reachability.Record, Object>)(Function1 & Serializable)r -> {
                            String string = this.latestGossip().member(r.subject()).dataCenter();
                            String string2 = this.selfDc();
                            return string == null ? string2 != null : !string.equals(string2);
                        });
                        object2 = reachability == null ? LazyVals.NullValue$.MODULE$ : reachability;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dcReachabilityWithoutObservationsWithin$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return reachability;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Reachability dcReachabilityExcludingDownedObservers() {
        Object object = this.dcReachabilityExcludingDownedObservers$lzy1;
        if (object instanceof Reachability) {
            return (Reachability)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Reachability)this.dcReachabilityExcludingDownedObservers$lzyINIT1();
    }

    private Object dcReachabilityExcludingDownedObservers$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.dcReachabilityExcludingDownedObservers$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Reachability reachability = null;
                    try {
                        SortedSet membersToExclude = (SortedSet)this.members().collect((PartialFunction)new Serializable(this){
                            private final /* synthetic */ MembershipState $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public final boolean isDefinedAt(Member x) {
                                block3: {
                                    block2: {
                                        Member member;
                                        Member m = member = x;
                                        MemberStatus memberStatus = m.status();
                                        MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                                        if (!(memberStatus == null ? memberStatus$Down$ != null : !memberStatus.equals(memberStatus$Down$))) break block2;
                                        String string = m.dataCenter();
                                        String string2 = this.$outer.selfDc();
                                        if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
                                    }
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(Member x, Function1 function1) {
                                block3: {
                                    Member m;
                                    block2: {
                                        Member member;
                                        m = member = x;
                                        MemberStatus memberStatus = m.status();
                                        MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                                        if (!(memberStatus == null ? memberStatus$Down$ != null : !memberStatus.equals(memberStatus$Down$))) break block2;
                                        String string = m.dataCenter();
                                        String string2 = this.$outer.selfDc();
                                        if (!(string == null ? string2 != null : !string.equals(string2))) break block3;
                                    }
                                    return m.uniqueAddress();
                                }
                                return function1.apply((Object)x);
                            }
                        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                        reachability = this.overview().reachability().removeObservers((Set<UniqueAddress>)membersToExclude).remove((Iterable<UniqueAddress>)this.members().collect((PartialFunction)new Serializable(this){
                            private final /* synthetic */ MembershipState $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public final boolean isDefinedAt(Member x) {
                                Member member;
                                Member m = member = x;
                                String string = m.dataCenter();
                                String string2 = this.$outer.selfDc();
                                return string == null ? string2 != null : !string.equals(string2);
                            }

                            public final Object applyOrElse(Member x, Function1 function1) {
                                Member member;
                                Member m = member = x;
                                String string = m.dataCenter();
                                String string2 = this.$outer.selfDc();
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    return m.uniqueAddress();
                                }
                                return function1.apply((Object)x);
                            }
                        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
                        object2 = reachability == null ? LazyVals.NullValue$.MODULE$ : reachability;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dcReachabilityExcludingDownedObservers$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.dcReachabilityExcludingDownedObservers$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return reachability;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Reachability dcReachabilityNoOutsideNodes() {
        Object object = this.dcReachabilityNoOutsideNodes$lzy1;
        if (object instanceof Reachability) {
            return (Reachability)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Reachability)this.dcReachabilityNoOutsideNodes$lzyINIT1();
    }

    private Object dcReachabilityNoOutsideNodes$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.dcReachabilityNoOutsideNodes$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Reachability reachability = null;
                    try {
                        reachability = this.overview().reachability().remove((Iterable<UniqueAddress>)this.members().collect((PartialFunction)new Serializable(this){
                            private final /* synthetic */ MembershipState $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }

                            public final boolean isDefinedAt(Member x) {
                                Member member;
                                Member m = member = x;
                                String string = m.dataCenter();
                                String string2 = this.$outer.selfDc();
                                return string == null ? string2 != null : !string.equals(string2);
                            }

                            public final Object applyOrElse(Member x, Function1 function1) {
                                Member member;
                                Member m = member = x;
                                String string = m.dataCenter();
                                String string2 = this.$outer.selfDc();
                                if (string == null ? string2 != null : !string.equals(string2)) {
                                    return m.uniqueAddress();
                                }
                                return function1.apply((Object)x);
                            }
                        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
                        object2 = reachability == null ? LazyVals.NullValue$.MODULE$ : reachability;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dcReachabilityNoOutsideNodes$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.dcReachabilityNoOutsideNodes$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return reachability;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Map<String, SortedSet<Member>> ageSortedTopOldestMembersPerDc() {
        Object object = this.ageSortedTopOldestMembersPerDc$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.ageSortedTopOldestMembersPerDc$lzyINIT1();
    }

    private Object ageSortedTopOldestMembersPerDc$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ageSortedTopOldestMembersPerDc$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        map = (Map)this.latestGossip().members().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(acc, member) -> {
                            Option option = acc.get((Object)member.dataCenter());
                            if (option instanceof Some) {
                                SortedSet set = (SortedSet)((Some)option).value();
                                if (set.size() < this.crossDcConnections()) {
                                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)member.dataCenter());
                                    return (Map)acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)set.$plus(member)));
                                }
                                if (set.exists((Function1 & Serializable)other -> member.isOlderThan((Member)other))) {
                                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)member.dataCenter());
                                    return (Map)acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, set.$plus(member).take(this.crossDcConnections())));
                                }
                                return acc;
                            }
                            if (None$.MODULE$.equals(option)) {
                                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)member.dataCenter());
                                return (Map)acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((SetOps)SortedSet$.MODULE$.empty(Member$.MODULE$.ageOrdering())).$plus(member)));
                            }
                            throw new MatchError((Object)option);
                        });
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ageSortedTopOldestMembersPerDc$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean isReachableExcludingDownedObservers(UniqueAddress toAddress) {
        if (!this.latestGossip().hasMember(toAddress)) {
            return false;
        }
        Member to = this.latestGossip().member(toAddress);
        String string = this.selfDc();
        String string2 = to.dataCenter();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.dcReachabilityExcludingDownedObservers().isReachable(toAddress);
        }
        return this.latestGossip().reachabilityExcludingDownedObservers().isReachable(toAddress);
    }

    public scala.collection.SortedSet<Member> dcMembers() {
        if (this.latestGossip().isMultiDc()) {
            return (scala.collection.SortedSet)this.members().filter((Function1 & Serializable)_$1 -> {
                String string = _$1.dataCenter();
                String string2 = this.selfDc();
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
        }
        return this.members();
    }

    public boolean isLeader(UniqueAddress node) {
        return this.leader().contains((Object)node);
    }

    public Option<UniqueAddress> leader() {
        return this.leaderOf(this.members());
    }

    public Option<UniqueAddress> roleLeader(String role) {
        return this.leaderOf((SortedSet<Member>)((SortedSet)this.members().filter((Function1 & Serializable)_$2 -> _$2.hasRole(role))));
    }

    public Option<UniqueAddress> leaderOf(SortedSet<Member> mbrs) {
        SortedSet reachableMembersInDc;
        Reachability reachability = this.dcReachability();
        SortedSet sortedSet = reachableMembersInDc = reachability.isAllReachable() ? (SortedSet)mbrs.filter((Function1 & Serializable)m -> {
            String string = m.dataCenter();
            String string2 = this.selfDc();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            MemberStatus memberStatus = m.status();
            MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
            if (memberStatus == null) {
                if (memberStatus$Down$ == null) return false;
                return true;
            } else if (memberStatus.equals(memberStatus$Down$)) return false;
            return true;
        }) : (SortedSet)mbrs.filter((Function1 & Serializable)m -> {
            String string = m.dataCenter();
            String string2 = this.selfDc();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            MemberStatus memberStatus = m.status();
            MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
            if (memberStatus == null) {
                if (memberStatus$Down$ == null) return false;
            } else if (memberStatus.equals(memberStatus$Down$)) return false;
            if (reachability.isReachable(m.uniqueAddress())) return true;
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
            if (uniqueAddress == null) {
                if (uniqueAddress2 == null) return true;
                return false;
            } else {
                if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                return true;
            }
        });
        if (reachableMembersInDc.isEmpty()) {
            return None$.MODULE$;
        }
        return reachableMembersInDc.find((Function1 & Serializable)m -> MembershipState$.org$apache$pekko$cluster$MembershipState$$$leaderMemberStatus.apply((Object)m.status())).orElse(() -> MembershipState.leaderOf$$anonfun$2(reachableMembersInDc)).map((Function1 & Serializable)_$3 -> _$3.uniqueAddress());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInSameDc(UniqueAddress node) {
        UniqueAddress uniqueAddress = node;
        UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
        if (uniqueAddress == null) {
            if (uniqueAddress2 == null) return true;
        } else if (((Object)uniqueAddress).equals(uniqueAddress2)) return true;
        String string = this.latestGossip().member(node).dataCenter();
        String string2 = this.selfDc();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean validNodeForGossip(UniqueAddress node) {
        UniqueAddress uniqueAddress = node;
        UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
        return (uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) && this.overview().reachability().isReachable(this.selfUniqueAddress(), node);
    }

    public Member youngestMember() {
        scala.collection.SortedSet<Member> mbrs = this.dcMembers();
        Predef$.MODULE$.require(mbrs.nonEmpty(), MembershipState::youngestMember$$anonfun$1);
        return (Member)mbrs.maxBy((Function1 & Serializable)m -> {
            if (m.upNumber() == Integer.MAX_VALUE) {
                return 0;
            }
            return m.upNumber();
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    public Set<Member> gossipTargetsForExitingMembers(Set<Member> exitingMembers) {
        if (exitingMembers.nonEmpty()) {
            Set roles = (Set)((IterableOps)exitingMembers.flatten((Function1 & Serializable)_$4 -> _$4.roles())).filterNot((Function1 & Serializable)_$5 -> _$5.startsWith(ClusterSettings$.MODULE$.DcRolePrefix()));
            List membersSortedByAge = (List)this.latestGossip().members().toList().filter((Function1 & Serializable)_$6 -> {
                String string = _$6.dataCenter();
                String string2 = this.selfDc();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).sorted(Member$.MODULE$.ageOrdering());
            ObjectRef targets = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            if (membersSortedByAge.nonEmpty()) {
                Set set = (Set)((Set)targets.elem).$plus(membersSortedByAge.head());
                targets.elem = set;
                set = null;
                if (((IterableOnceOps)membersSortedByAge.tail()).nonEmpty()) {
                    Set set2 = (Set)((Set)targets.elem).$plus(((IterableOps)membersSortedByAge.tail()).head());
                    targets.elem = set2;
                    set2 = null;
                }
                roles.foreach((Function1)(JProcedure1 & Serializable)role -> membersSortedByAge.find((Function1 & Serializable)_$7 -> _$7.hasRole((String)role)).foreach((Function1)(JProcedure1 & Serializable)first -> {
                    Set set = (Set)((Set)targets$2.elem).$plus(first);
                    targets$2.elem = set;
                    set = null;
                    membersSortedByAge.find((Function1 & Serializable)m -> {
                        Member member = m;
                        Member member2 = first;
                        return (member == null ? member2 != null : !((Object)member).equals(member2)) && m.hasRole((String)role);
                    }).foreach((Function1)(JProcedure1 & Serializable)next -> {
                        Set set = (Set)((Set)targets$3.elem).$plus(next);
                        targets$3.elem = set;
                        set = null;
                    });
                }));
            }
            return (Set)targets.elem;
        }
        return Predef$.MODULE$.Set().empty();
    }

    public MembershipState copy(Gossip latestGossip, UniqueAddress selfUniqueAddress, String selfDc, int crossDcConnections) {
        return new MembershipState(latestGossip, selfUniqueAddress, selfDc, crossDcConnections);
    }

    public Gossip copy$default$1() {
        return this.latestGossip();
    }

    public UniqueAddress copy$default$2() {
        return this.selfUniqueAddress();
    }

    public String copy$default$3() {
        return this.selfDc();
    }

    public int copy$default$4() {
        return this.crossDcConnections();
    }

    public Gossip _1() {
        return this.latestGossip();
    }

    public UniqueAddress _2() {
        return this.selfUniqueAddress();
    }

    public String _3() {
        return this.selfDc();
    }

    public int _4() {
        return this.crossDcConnections();
    }

    private final boolean memberHinderingConvergenceExists$1(boolean firstMemberInDc$1, Set exitingConfirmed$1) {
        Set memberStatus = firstMemberInDc$1 ? (Set)MembershipState$.org$apache$pekko$cluster$MembershipState$$$convergenceMemberStatus.$plus((Object)MemberStatus$Joining$.MODULE$).$plus((Object)MemberStatus$WeaklyUp$.MODULE$) : MembershipState$.org$apache$pekko$cluster$MembershipState$$$convergenceMemberStatus;
        return this.members().exists((Function1 & Serializable)member -> {
            if (!firstMemberInDc$1) {
                String string = member.dataCenter();
                String string2 = this.selfDc();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
            }
            if (!memberStatus.apply((Object)member.status())) return false;
            if (this.latestGossip().seenByNode(member.uniqueAddress())) return false;
            if (exitingConfirmed$1.apply((Object)member.uniqueAddress())) return false;
            return true;
        });
    }

    private static final Option leaderOf$$anonfun$2(SortedSet reachableMembersInDc$1) {
        return Some$.MODULE$.apply(reachableMembersInDc$1.min(Member$.MODULE$.leaderStatusOrdering()));
    }

    private static final Object youngestMember$$anonfun$1() {
        return "No youngest when no members";
    }
}

