/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Reachability$;
import org.apache.pekko.cluster.Reachability$Reachable$;
import org.apache.pekko.cluster.Reachability$Record$;
import org.apache.pekko.cluster.Reachability$Terminated$;
import org.apache.pekko.cluster.Reachability$Unreachable$;
import org.apache.pekko.cluster.UniqueAddress;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.Map$;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public class Reachability
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Reachability.class.getDeclaredField("cache$lzy1"));
    private final IndexedSeq records;
    private final Map versions;
    private volatile transient Object cache$lzy1;

    public static Reachability apply(IndexedSeq<Record> indexedSeq, Map<UniqueAddress, Object> map) {
        return Reachability$.MODULE$.apply(indexedSeq, map);
    }

    public static Reachability create(Seq<Record> seq, Map<UniqueAddress, Object> map) {
        return Reachability$.MODULE$.create(seq, map);
    }

    public static Reachability empty() {
        return Reachability$.MODULE$.empty();
    }

    public Reachability(IndexedSeq<Record> records, Map<UniqueAddress, Object> versions) {
        this.records = records;
        this.versions = versions;
    }

    public IndexedSeq<Record> records() {
        return this.records;
    }

    public Map<UniqueAddress, Object> versions() {
        return this.versions;
    }

    private Cache cache() {
        Object object = this.cache$lzy1;
        if (object instanceof Cache) {
            return (Cache)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Cache)this.cache$lzyINIT1();
    }

    private Object cache$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cache$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Cache cache = null;
                    try {
                        cache = new Cache();
                        object2 = cache == null ? LazyVals.NullValue$.MODULE$ : cache;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cache$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cache;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<Map<UniqueAddress, Record>> observerRows(UniqueAddress observer) {
        return this.cache().observerRowsMap().get((Object)observer);
    }

    public Reachability unreachable(UniqueAddress observer, UniqueAddress subject) {
        return this.change(observer, subject, Reachability$Unreachable$.MODULE$);
    }

    public Reachability reachable(UniqueAddress observer, UniqueAddress subject) {
        return this.change(observer, subject, Reachability$Reachable$.MODULE$);
    }

    public Reachability terminated(UniqueAddress observer, UniqueAddress subject) {
        return this.change(observer, subject, Reachability$Terminated$.MODULE$);
    }

    private long currentVersion(UniqueAddress observer) {
        Option option = this.versions().get((Object)observer);
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        if (option instanceof Some) {
            long v = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return v;
        }
        throw new MatchError((Object)option);
    }

    private long nextVersion(UniqueAddress observer) {
        return this.currentVersion(observer) + 1L;
    }

    private Reachability change(UniqueAddress observer, UniqueAddress subject, ReachabilityStatus status) {
        Option<Map<UniqueAddress, Record>> option;
        block8: {
            Option option2;
            block9: {
                Record oldRecord;
                Map oldObserverRows;
                Record newRecord;
                Map newVersions;
                block11: {
                    block10: {
                        long v = this.nextVersion(observer);
                        newVersions = (Map)this.versions().updated((Object)observer, (Object)BoxesRunTime.boxToLong((long)v));
                        newRecord = Reachability$Record$.MODULE$.apply(observer, subject, status, v);
                        option = this.observerRows(observer);
                        if (None$.MODULE$.equals(option)) {
                            ReachabilityStatus reachabilityStatus = status;
                            Reachability$Reachable$ reachability$Reachable$ = Reachability$Reachable$.MODULE$;
                            if (!(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Reachable$) : reachability$Reachable$ != null)) {
                                return this;
                            }
                            return new Reachability((IndexedSeq<Record>)((IndexedSeq)this.records().$colon$plus((Object)newRecord)), (Map<UniqueAddress, Object>)newVersions);
                        }
                        if (!(option instanceof Some)) break block8;
                        oldObserverRows = (Map)((Some)option).value();
                        option2 = oldObserverRows.get((Object)subject);
                        if (None$.MODULE$.equals(option2)) {
                            ReachabilityStatus reachabilityStatus = status;
                            Reachability$Reachable$ reachability$Reachable$ = Reachability$Reachable$.MODULE$;
                            if (!(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Reachable$) : reachability$Reachable$ != null) && oldObserverRows.forall((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    Record r = (Record)tuple2._2();
                                    ReachabilityStatus reachabilityStatus = r.status();
                                    Reachability$Reachable$ reachability$Reachable$ = Reachability$Reachable$.MODULE$;
                                    return !(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Reachable$) : reachability$Reachable$ != null);
                                }
                                throw new MatchError((Object)tuple2);
                            })) {
                                return new Reachability((IndexedSeq<Record>)((IndexedSeq)this.records().filterNot((Function1 & Serializable)_$1 -> {
                                    UniqueAddress uniqueAddress = _$1.observer();
                                    UniqueAddress uniqueAddress2 = observer;
                                    return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
                                })), (Map<UniqueAddress, Object>)newVersions);
                            }
                            return new Reachability((IndexedSeq<Record>)((IndexedSeq)this.records().$colon$plus((Object)newRecord)), (Map<UniqueAddress, Object>)newVersions);
                        }
                        if (!(option2 instanceof Some)) break block9;
                        oldRecord = (Record)((Some)option2).value();
                        ReachabilityStatus reachabilityStatus = oldRecord.status();
                        Reachability$Terminated$ reachability$Terminated$ = Reachability$Terminated$.MODULE$;
                        if (!(reachabilityStatus == null ? reachability$Terminated$ != null : !reachabilityStatus.equals(reachability$Terminated$))) break block10;
                        ReachabilityStatus reachabilityStatus2 = oldRecord.status();
                        ReachabilityStatus reachabilityStatus3 = status;
                        if (reachabilityStatus2 != null ? !reachabilityStatus2.equals(reachabilityStatus3) : reachabilityStatus3 != null) break block11;
                    }
                    return this;
                }
                ReachabilityStatus reachabilityStatus = status;
                Reachability$Reachable$ reachability$Reachable$ = Reachability$Reachable$.MODULE$;
                if (!(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Reachable$) : reachability$Reachable$ != null) && oldObserverRows.forall((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    Record r = (Record)tuple2._2();
                    ReachabilityStatus reachabilityStatus = r.status();
                    Reachability$Reachable$ reachability$Reachable$ = Reachability$Reachable$.MODULE$;
                    if (reachabilityStatus == null) {
                        if (reachability$Reachable$ == null) return true;
                    } else if (reachabilityStatus.equals(reachability$Reachable$)) return true;
                    UniqueAddress uniqueAddress = r.subject();
                    UniqueAddress uniqueAddress2 = subject;
                    if (uniqueAddress != null) {
                        if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
                        return true;
                    }
                    if (uniqueAddress2 == null) return true;
                    return false;
                })) {
                    return new Reachability((IndexedSeq<Record>)((IndexedSeq)this.records().filterNot((Function1 & Serializable)_$2 -> {
                        UniqueAddress uniqueAddress = _$2.observer();
                        UniqueAddress uniqueAddress2 = observer;
                        return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
                    })), (Map<UniqueAddress, Object>)newVersions);
                }
                IndexedSeq newRecords = (IndexedSeq)this.records().updated(this.records().indexOf((Object)oldRecord), (Object)newRecord);
                return new Reachability((IndexedSeq<Record>)newRecords, (Map<UniqueAddress, Object>)newVersions);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    public Reachability merge(scala.collection.immutable.Set<UniqueAddress> allowed, Reachability other) {
        VectorBuilder recordBuilder = new VectorBuilder();
        recordBuilder.sizeHint(scala.math.package$.MODULE$.max(this.records().size(), other.records().size()));
        ObjectRef newVersions = ObjectRef.create(this.versions());
        allowed.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> this.merge$$anonfun$1(other, recordBuilder, allowed, newVersions, arg_0)));
        Map map = (Map)((Map)newVersions.elem).filterNot((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UniqueAddress k = (UniqueAddress)tuple2._1();
                return !allowed.apply((Object)k);
            }
            throw new MatchError((Object)tuple2);
        });
        newVersions.elem = map;
        map = null;
        return new Reachability((IndexedSeq<Record>)recordBuilder.result(), (Map<UniqueAddress, Object>)((Map)newVersions.elem));
    }

    public Reachability remove(Iterable<UniqueAddress> nodes) {
        scala.collection.immutable.Set nodesSet = nodes.toSet();
        IndexedSeq newRecords = (IndexedSeq)this.records().filterNot((Function1 & Serializable)r -> nodesSet.apply((Object)r.observer()) || nodesSet.apply((Object)r.subject()));
        Map newVersions = (Map)this.versions().$minus$minus(nodes);
        return Reachability$.MODULE$.apply((IndexedSeq<Record>)newRecords, (Map<UniqueAddress, Object>)newVersions);
    }

    public Reachability removeObservers(scala.collection.immutable.Set<UniqueAddress> nodes) {
        if (nodes.isEmpty()) {
            return this;
        }
        IndexedSeq newRecords = (IndexedSeq)this.records().filterNot((Function1 & Serializable)r -> nodes.apply((Object)r.observer()));
        Map newVersions = (Map)this.versions().$minus$minus(nodes);
        return Reachability$.MODULE$.apply((IndexedSeq<Record>)newRecords, (Map<UniqueAddress, Object>)newVersions);
    }

    public Reachability filterRecords(Function1<Record, Object> f) {
        return Reachability$.MODULE$.apply((IndexedSeq<Record>)((IndexedSeq)this.records().filter(f)), this.versions());
    }

    public ReachabilityStatus status(UniqueAddress observer, UniqueAddress subject) {
        Option<Map<UniqueAddress, Record>> option = this.observerRows(observer);
        if (None$.MODULE$.equals(option)) {
            return Reachability$Reachable$.MODULE$;
        }
        if (option instanceof Some) {
            Map observerRows = (Map)((Some)option).value();
            Option option2 = observerRows.get((Object)subject);
            if (None$.MODULE$.equals(option2)) {
                return Reachability$Reachable$.MODULE$;
            }
            if (option2 instanceof Some) {
                Record record = (Record)((Some)option2).value();
                return record.status();
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    public ReachabilityStatus status(UniqueAddress node) {
        if (this.cache().allTerminated().apply((Object)node)) {
            return Reachability$Terminated$.MODULE$;
        }
        return (ReachabilityStatus)(this.cache().allUnreachable().apply((Object)node) ? Reachability$Unreachable$.MODULE$ : Reachability$Reachable$.MODULE$);
    }

    public boolean isReachable(UniqueAddress node) {
        return this.isAllReachable() || !this.allUnreachableOrTerminated().contains((Object)node);
    }

    public boolean isReachable(UniqueAddress observer, UniqueAddress subject) {
        ReachabilityStatus reachabilityStatus = this.status(observer, subject);
        Reachability$Reachable$ reachability$Reachable$ = Reachability$Reachable$.MODULE$;
        return !(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Reachable$) : reachability$Reachable$ != null);
    }

    public boolean isAllReachable() {
        return this.records().isEmpty();
    }

    public scala.collection.immutable.Set<UniqueAddress> allUnreachable() {
        return this.cache().allUnreachable();
    }

    public scala.collection.immutable.Set<UniqueAddress> allUnreachableOrTerminated() {
        return this.cache().allUnreachableOrTerminated();
    }

    public scala.collection.immutable.Set<UniqueAddress> allUnreachableFrom(UniqueAddress observer) {
        Option<Map<UniqueAddress, Record>> option = this.observerRows(observer);
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Set().empty();
        }
        if (option instanceof Some) {
            Map observerRows = (Map)((Some)option).value();
            return (scala.collection.immutable.Set)observerRows.iterator().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        UniqueAddress subject = (UniqueAddress)tuple2._1();
                        Record record = (Record)tuple2._2();
                        ReachabilityStatus reachabilityStatus = record.status();
                        Reachability$Unreachable$ reachability$Unreachable$ = Reachability$Unreachable$.MODULE$;
                        if (!(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Unreachable$) : reachability$Unreachable$ != null)) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        UniqueAddress subject = (UniqueAddress)tuple2._1();
                        Record record = (Record)tuple2._2();
                        ReachabilityStatus reachabilityStatus = record.status();
                        Reachability$Unreachable$ reachability$Unreachable$ = Reachability$Unreachable$.MODULE$;
                        if (!(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Unreachable$) : reachability$Unreachable$ != null)) {
                            return subject;
                        }
                    }
                    return function1.apply((Object)x);
                }
            }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Set$.MODULE$));
        }
        throw new MatchError(option);
    }

    public Map<UniqueAddress, scala.collection.immutable.Set<UniqueAddress>> observersGroupedByUnreachable() {
        return (Map)this.records().groupBy((Function1 & Serializable)_$3 -> _$3.subject()).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    UniqueAddress subject = (UniqueAddress)tuple2._1();
                    IndexedSeq records = (IndexedSeq)tuple2._2();
                    if (records.exists(Reachability::org$apache$pekko$cluster$Reachability$$anon$5$$_$isDefinedAt$$anonfun$1)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    UniqueAddress subject = (UniqueAddress)tuple2._1();
                    IndexedSeq records = (IndexedSeq)tuple2._2();
                    if (records.exists(Reachability::org$apache$pekko$cluster$Reachability$$anon$5$$_$applyOrElse$$anonfun$1)) {
                        scala.collection.immutable.Set observers = (scala.collection.immutable.Set)records.iterator().collect((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(Record x) {
                                Record record;
                                Record r = record = x;
                                ReachabilityStatus reachabilityStatus = r.status();
                                Reachability$Unreachable$ reachability$Unreachable$ = Reachability$Unreachable$.MODULE$;
                                return !(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Unreachable$) : reachability$Unreachable$ != null);
                            }

                            public final Object applyOrElse(Record x, Function1 function1) {
                                Record record;
                                Record r = record = x;
                                ReachabilityStatus reachabilityStatus = r.status();
                                Reachability$Unreachable$ reachability$Unreachable$ = Reachability$Unreachable$.MODULE$;
                                if (!(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Unreachable$) : reachability$Unreachable$ != null)) {
                                    return r.observer();
                                }
                                return function1.apply((Object)x);
                            }
                        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Set$.MODULE$));
                        UniqueAddress uniqueAddress = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)subject);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress, (Object)observers);
                    }
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$cluster$Reachability$$anon$5$$_$isDefinedAt$$anonfun$1(org.apache.pekko.cluster.Reachability$Record ), org$apache$pekko$cluster$Reachability$$anon$5$$_$applyOrElse$$anonfun$1(org.apache.pekko.cluster.Reachability$Record )}, serializedLambda);
            }
        });
    }

    public scala.collection.immutable.Set<UniqueAddress> allObservers() {
        return this.records().iterator().map((Function1 & Serializable)_$5 -> _$5.observer()).toSet();
    }

    public IndexedSeq<Record> recordsFrom(UniqueAddress observer) {
        Option<Map<UniqueAddress, Record>> option = this.observerRows(observer);
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Vector().empty();
        }
        if (option instanceof Some) {
            Map rows = (Map)((Some)option).value();
            return rows.valuesIterator().toVector();
        }
        throw new MatchError(option);
    }

    public int hashCode() {
        return this.versions().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Reachability)) return false;
        Reachability other = (Reachability)object;
        if (this.records().size() != other.records().size()) return false;
        Map<UniqueAddress, Object> map = this.versions();
        Map<UniqueAddress, Object> map2 = other.versions();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<UniqueAddress, Map<UniqueAddress, Record>> map3 = this.cache().observerRowsMap();
        Map<UniqueAddress, Map<UniqueAddress, Record>> map4 = other.cache().observerRowsMap();
        if (map3 == null) {
            if (map4 == null) return true;
            return false;
        } else {
            if (!map3.equals(map4)) return false;
            return true;
        }
    }

    public String toString() {
        Seq rows = (Seq)((IterableOps)((IterableOps)((IterableOps)this.versions().keys().toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)observer -> {
            Option<Map<UniqueAddress, Record>> rowsOption = this.observerRows((UniqueAddress)observer);
            return Tuple2$.MODULE$.apply(observer, rowsOption);
        })).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UniqueAddress observer = (UniqueAddress)tuple2._1();
                Option rowsOption = (Option)tuple2._2();
                return rowsOption.isDefined();
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UniqueAddress observer = (UniqueAddress)tuple2._1();
                Option rowsOption = (Option)tuple2._2();
                Tuple2 $2$ = tuple2;
                Map rows = (Map)rowsOption.get();
                return Tuple2$.MODULE$.apply((Object)$2$, (Object)rows);
            }
            throw new MatchError((Object)tuple2);
        })).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                UniqueAddress observer = (UniqueAddress)tuple2._1();
                Option rowsOption = (Option)tuple2._2();
                Map rows = (Map)tuple22._2();
                return (Seq)((IterableOps)rows.keys().toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1 & Serializable)subject -> {
                    Record record = (Record)rows.apply(subject);
                    ReachabilityStatus aggregated = this.status((UniqueAddress)subject);
                    return new StringBuilder(12).append(observer.address()).append(" -> ").append(subject.address()).append(": ").append(record.status()).append(" [").append(aggregated).append("] (").append(record.version()).append(")").toString();
                });
            }
            throw new MatchError((Object)tuple22);
        });
        return rows.mkString(", ");
    }

    public static final /* synthetic */ void org$apache$pekko$cluster$Reachability$Cache$$_$_$$lessinit$greater$$anonfun$1(scala.collection.mutable.Map mapBuilder$1, ObjectRef allUnreachable$1, ObjectRef allTerminated$1, Record r) {
        Map map;
        Option option = mapBuilder$1.get((Object)r.observer());
        if (None$.MODULE$.equals(option)) {
            Object[] objectArray = new Tuple2[1];
            UniqueAddress uniqueAddress = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)r.subject());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress, (Object)r);
            map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else if (option instanceof Some) {
            Map m = (Map)((Some)option).value();
            map = (Map)m.updated((Object)r.subject(), (Object)r);
        } else {
            throw new MatchError((Object)option);
        }
        Map m = map;
        UniqueAddress uniqueAddress = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)r.observer());
        mapBuilder$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress, (Object)m));
        ReachabilityStatus reachabilityStatus = r.status();
        Reachability$Unreachable$ reachability$Unreachable$ = Reachability$Unreachable$.MODULE$;
        if (!(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Unreachable$) : reachability$Unreachable$ != null)) {
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)((scala.collection.immutable.Set)allUnreachable$1.elem).$plus((Object)r.subject());
            allUnreachable$1.elem = set;
            set = null;
            return;
        }
        ReachabilityStatus reachabilityStatus2 = r.status();
        Reachability$Terminated$ reachability$Terminated$ = Reachability$Terminated$.MODULE$;
        if (!(reachabilityStatus2 != null ? !reachabilityStatus2.equals(reachability$Terminated$) : reachability$Terminated$ != null)) {
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)((scala.collection.immutable.Set)allTerminated$1.elem).$plus((Object)r.subject());
            allTerminated$1.elem = set;
            set = null;
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ void merge$$anonfun$1(Reachability other$1, VectorBuilder recordBuilder$1, scala.collection.immutable.Set allowed$1, ObjectRef newVersions$1, UniqueAddress observer) {
        block12: {
            block11: {
                observerVersion1 = this.currentVersion(observer);
                observerVersion2 = other$1.currentVersion(observer);
                var10_8 = Tuple2$.MODULE$.apply(this.observerRows(observer), other$1.observerRows(observer));
                if (var10_8 == null) ** GOTO lbl-1000
                var11_9 = (Option)var10_8._1();
                var12_10 = (Option)var10_8._2();
                if (!None$.MODULE$.equals(var11_9) || !None$.MODULE$.equals(var12_10)) break block11;
                v0 = BoxedUnit.UNIT;
                break block12;
            }
            if (!(var11_9 instanceof Some)) ** GOTO lbl-1000
            rows1 = var13_11 = (Map)((Some)var11_9).value();
            if (var12_10 instanceof Some) {
                rows2 = (Map)((Some)var12_10).value();
                rows = observerVersion1 > observerVersion2 ? rows1 : rows2;
                v0 = recordBuilder$1.$plus$plus$eq((IterableOnce)rows.collect((PartialFunction)new Serializable(allowed$1){
                    private final scala.collection.immutable.Set allowed$2;
                    {
                        this.allowed$2 = allowed$6;
                    }

                    public final boolean isDefinedAt(Tuple2 x) {
                        Record r;
                        Tuple2 tuple2 = x;
                        return tuple2 != null && this.allowed$2.apply((Object)(r = (Record)tuple2._2()).subject());
                    }

                    public final Object applyOrElse(Tuple2 x, Function1 function1) {
                        Record r;
                        Tuple2 tuple2 = x;
                        if (tuple2 != null && this.allowed$2.apply((Object)(r = (Record)tuple2._2()).subject())) {
                            return r;
                        }
                        return function1.apply((Object)x);
                    }
                }));
            } else {
                rows1 = var13_11;
                if (None$.MODULE$.equals(var12_10)) {
                    if (observerVersion1 > observerVersion2) {
                        recordBuilder$1.$plus$plus$eq((IterableOnce)rows1.collect((PartialFunction)new Serializable(allowed$1){
                            private final scala.collection.immutable.Set allowed$3;
                            {
                                this.allowed$3 = allowed$7;
                            }

                            public final boolean isDefinedAt(Tuple2 x) {
                                Record r;
                                Tuple2 tuple2 = x;
                                return tuple2 != null && this.allowed$3.apply((Object)(r = (Record)tuple2._2()).subject());
                            }

                            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                                Record r;
                                Tuple2 tuple2 = x;
                                if (tuple2 != null && this.allowed$3.apply((Object)(r = (Record)tuple2._2()).subject())) {
                                    return r;
                                }
                                return function1.apply((Object)x);
                            }
                        }));
                        v0 = BoxedUnit.UNIT;
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                } else if (None$.MODULE$.equals(var11_9) && var12_10 instanceof Some) {
                    rows2 = (Map)((Some)var12_10).value();
                    if (observerVersion2 > observerVersion1) {
                        recordBuilder$1.$plus$plus$eq((IterableOnce)rows2.collect((PartialFunction)new Serializable(allowed$1){
                            private final scala.collection.immutable.Set allowed$4;
                            {
                                this.allowed$4 = allowed$8;
                            }

                            public final boolean isDefinedAt(Tuple2 x) {
                                Record r;
                                Tuple2 tuple2 = x;
                                return tuple2 != null && this.allowed$4.apply((Object)(r = (Record)tuple2._2()).subject());
                            }

                            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                                Record r;
                                Tuple2 tuple2 = x;
                                if (tuple2 != null && this.allowed$4.apply((Object)(r = (Record)tuple2._2()).subject())) {
                                    return r;
                                }
                                return function1.apply((Object)x);
                            }
                        }));
                        v0 = BoxedUnit.UNIT;
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    throw new MatchError((Object)var10_8);
                }
            }
        }
        if (observerVersion2 > observerVersion1) {
            var20_17 = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)observer);
            var19_18 = (Map)((Map)newVersions$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var20_17, (Object)BoxesRunTime.boxToLong((long)observerVersion2)));
            newVersions$1.elem = var19_18;
            var19_18 = null;
            return;
        }
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$Reachability$$anon$5$$_$isDefinedAt$$anonfun$1(Record _$4) {
        ReachabilityStatus reachabilityStatus = _$4.status();
        Reachability$Unreachable$ reachability$Unreachable$ = Reachability$Unreachable$.MODULE$;
        return !(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Unreachable$) : reachability$Unreachable$ != null);
    }

    public static final /* synthetic */ boolean org$apache$pekko$cluster$Reachability$$anon$5$$_$applyOrElse$$anonfun$1(Record _$4) {
        ReachabilityStatus reachabilityStatus = _$4.status();
        Reachability$Unreachable$ reachability$Unreachable$ = Reachability$Unreachable$.MODULE$;
        return !(reachabilityStatus != null ? !reachabilityStatus.equals(reachability$Unreachable$) : reachability$Unreachable$ != null);
    }

    public class Cache {
        private final Map observerRowsMap;
        private final scala.collection.immutable.Set allUnreachable;
        private final scala.collection.immutable.Set allTerminated;
        private final scala.collection.immutable.Set allUnreachableOrTerminated;

        public Cache() {
            Tuple3 tuple3;
            if (Reachability.this == null) {
                throw new NullPointerException();
            }
            if (Reachability.this.records().isEmpty()) {
                Map observerRowsMap = Predef$.MODULE$.Map().empty();
                scala.collection.immutable.Set allTerminated = Predef$.MODULE$.Set().empty();
                scala.collection.immutable.Set allUnreachable = Predef$.MODULE$.Set().empty();
                tuple3 = Tuple3$.MODULE$.apply((Object)observerRowsMap, (Object)allUnreachable, (Object)allTerminated);
            } else {
                scala.collection.mutable.Map mapBuilder = (scala.collection.mutable.Map)Map$.MODULE$.empty();
                ObjectRef allTerminated = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
                ObjectRef allUnreachable = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
                Reachability.this.records().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> Reachability.org$apache$pekko$cluster$Reachability$Cache$$_$_$$lessinit$greater$$anonfun$1(mapBuilder, allUnreachable, allTerminated, arg_0)));
                Map observerRowsMap = mapBuilder.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                tuple3 = Tuple3$.MODULE$.apply((Object)observerRowsMap, (Object)((scala.collection.immutable.Set)allUnreachable.elem).diff((Set)((scala.collection.immutable.Set)allTerminated.elem)), (Object)((scala.collection.immutable.Set)allTerminated.elem));
            }
            Tuple3 tuple32 = tuple3;
            this.observerRowsMap = (Map)tuple32._1();
            this.allUnreachable = (scala.collection.immutable.Set)tuple32._2();
            this.allTerminated = (scala.collection.immutable.Set)tuple32._3();
            this.allUnreachableOrTerminated = this.allTerminated().isEmpty() ? this.allUnreachable() : (scala.collection.immutable.Set)this.allUnreachable().union(this.allTerminated());
        }

        public Map<UniqueAddress, Map<UniqueAddress, Record>> observerRowsMap() {
            return this.observerRowsMap;
        }

        public scala.collection.immutable.Set<UniqueAddress> allUnreachable() {
            return this.allUnreachable;
        }

        public scala.collection.immutable.Set<UniqueAddress> allTerminated() {
            return this.allTerminated;
        }

        public scala.collection.immutable.Set<UniqueAddress> allUnreachableOrTerminated() {
            return this.allUnreachableOrTerminated;
        }

        public final /* synthetic */ Reachability org$apache$pekko$cluster$Reachability$Cache$$$outer() {
            return Reachability.this;
        }
    }

    public static interface ReachabilityStatus {
    }

    public static final class Record
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final UniqueAddress observer;
        private final UniqueAddress subject;
        private final ReachabilityStatus status;
        private final long version;

        public static Record apply(UniqueAddress uniqueAddress, UniqueAddress uniqueAddress2, ReachabilityStatus reachabilityStatus, long l) {
            return Reachability$Record$.MODULE$.apply(uniqueAddress, uniqueAddress2, reachabilityStatus, l);
        }

        public static Record fromProduct(Product product) {
            return Reachability$Record$.MODULE$.fromProduct(product);
        }

        public static Record unapply(Record record) {
            return Reachability$Record$.MODULE$.unapply(record);
        }

        public Record(UniqueAddress observer, UniqueAddress subject, ReachabilityStatus status, long version) {
            this.observer = observer;
            this.subject = subject;
            this.status = status;
            this.version = version;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.observer()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.subject()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.status()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.version()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Record)) return false;
            Record record = (Record)object;
            if (this.version() != record.version()) return false;
            UniqueAddress uniqueAddress = this.observer();
            UniqueAddress uniqueAddress2 = record.observer();
            if (uniqueAddress == null) {
                if (uniqueAddress2 != null) {
                    return false;
                }
            } else if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
            UniqueAddress uniqueAddress3 = this.subject();
            UniqueAddress uniqueAddress4 = record.subject();
            if (uniqueAddress3 == null) {
                if (uniqueAddress4 != null) {
                    return false;
                }
            } else if (!((Object)uniqueAddress3).equals(uniqueAddress4)) return false;
            ReachabilityStatus reachabilityStatus = this.status();
            ReachabilityStatus reachabilityStatus2 = record.status();
            if (reachabilityStatus == null) {
                if (reachabilityStatus2 == null) return true;
                return false;
            } else {
                if (!reachabilityStatus.equals(reachabilityStatus2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Record;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Record";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "observer";
                }
                case 1: {
                    return "subject";
                }
                case 2: {
                    return "status";
                }
                case 3: {
                    return "version";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UniqueAddress observer() {
            return this.observer;
        }

        public UniqueAddress subject() {
            return this.subject;
        }

        public ReachabilityStatus status() {
            return this.status;
        }

        public long version() {
            return this.version;
        }

        public Record copy(UniqueAddress observer, UniqueAddress subject, ReachabilityStatus status, long version) {
            return new Record(observer, subject, status, version);
        }

        public UniqueAddress copy$default$1() {
            return this.observer();
        }

        public UniqueAddress copy$default$2() {
            return this.subject();
        }

        public ReachabilityStatus copy$default$3() {
            return this.status();
        }

        public long copy$default$4() {
            return this.version();
        }

        public UniqueAddress _1() {
            return this.observer();
        }

        public UniqueAddress _2() {
            return this.subject();
        }

        public ReachabilityStatus _3() {
            return this.status();
        }

        public long _4() {
            return this.version();
        }
    }
}

