/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.routing;

import java.io.Serializable;
import org.apache.pekko.actor.ActorInitializationException$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.routing.ClusterRouterActor;
import org.apache.pekko.cluster.routing.ClusterRouterGroupSettings;
import org.apache.pekko.routing.Group;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.RouterActor;
import org.apache.pekko.routing.RouterConfig;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.SortedSet;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class ClusterRouterGroupActor
extends RouterActor
implements ClusterRouterActor {
    private SortedSet nodes;
    private final ClusterRouterGroupSettings settings;
    private final Group group;
    private Map usedRouteePaths;

    public ClusterRouterGroupActor(ClusterRouterGroupSettings settings) {
        Map map;
        this.settings = settings;
        ClusterRouterActor.$init$(this);
        RouterConfig routerConfig = this.cell().routerConfig();
        if (!(routerConfig instanceof Group)) {
            RouterConfig other = routerConfig;
            throw ActorInitializationException$.MODULE$.apply(new StringBuilder(57).append("ClusterRouterGroupActor can only be used with group, not ").append(other.getClass()).toString());
        }
        Group x = (Group)routerConfig;
        this.group = x;
        if (settings.allowLocalRoutees()) {
            Object[] objectArray = new Tuple2[1];
            Address address = (Address)Predef$.MODULE$.ArrowAssoc((Object)this.cluster().selfAddress());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address, (Object)settings.routeesPaths().toSet());
            map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        this.usedRouteePaths = map;
    }

    public SortedSet nodes() {
        return this.nodes;
    }

    public void nodes_$eq(SortedSet x$1) {
        this.nodes = x$1;
    }

    @Override
    public ClusterRouterGroupSettings settings() {
        return this.settings;
    }

    public Group group() {
        return this.group;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.clusterReceive().orElse(super.receive());
    }

    public Map<Address, Set<String>> usedRouteePaths() {
        return this.usedRouteePaths;
    }

    public void usedRouteePaths_$eq(Map<Address, Set<String>> x$1) {
        this.usedRouteePaths = x$1;
    }

    @Override
    public void addRoutees() {
        this.doAddRoutees$2();
    }

    public Option<Tuple2<Address, String>> selectDeploymentTarget() {
        IndexedSeq currentRoutees = this.cell().router().routees();
        SortedSet currentNodes = this.availableNodes();
        if (currentNodes.isEmpty() || currentRoutees.size() >= this.settings().totalInstances()) {
            return None$.MODULE$;
        }
        Map<Address, Set<String>> map = this.usedRouteePaths();
        SortedSet unusedNodes = (SortedSet)currentNodes.filterNot((Function1 & Serializable)key -> map.contains(key));
        if (unusedNodes.nonEmpty()) {
            return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(unusedNodes.head(), this.settings().routeesPaths().head()));
        }
        Tuple2 tuple2 = (Tuple2)this.usedRouteePaths().minBy((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Set used = (Set)tuple2._2();
                return used.size();
            }
            throw new MatchError((Object)tuple2);
        }, (Ordering)Ordering.Int$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Address address = (Address)tuple2._1();
        Set used = (Set)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)address, (Object)used);
        Address address2 = (Address)tuple22._1();
        Set used2 = (Set)tuple22._2();
        return this.settings().routeesPaths().collectFirst((PartialFunction)new Serializable(used2, address2){
            private final Set used$1;
            private final Address address$1;
            {
                this.used$1 = used$2;
                this.address$1 = address$3;
            }

            public final boolean isDefinedAt(String x) {
                String string = x;
                String p = string;
                return !this.used$1.contains((Object)p);
            }

            public final Object applyOrElse(String x, Function1 function1) {
                String string = x;
                String p = string;
                if (!this.used$1.contains((Object)p)) {
                    return Tuple2$.MODULE$.apply((Object)this.address$1, (Object)p);
                }
                return function1.apply((Object)x);
            }
        });
    }

    @Override
    public void removeMember(Member member) {
        this.usedRouteePaths_$eq((Map<Address, Set<String>>)((Map)this.usedRouteePaths().$minus((Object)member.address())));
        ClusterRouterActor.removeMember$(this, member);
    }

    private static final Set doAddRoutees$2$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private final void doAddRoutees$2() {
        Option<Tuple2<Address, String>> option;
        while (true) {
            Tuple2 tuple2;
            if (None$.MODULE$.equals(option = this.selectDeploymentTarget())) {
                return;
            }
            if (!(option instanceof Some) || (tuple2 = (Tuple2)((Some)option).value()) == null) break;
            Address address = (Address)tuple2._1();
            String path = (String)tuple2._2();
            Routee routee = this.group().routeeFor(new StringBuilder(0).append(address.toString()).append(path).toString(), this.context());
            this.usedRouteePaths_$eq((Map<Address, Set<String>>)((Map)this.usedRouteePaths().updated((Object)address, (Object)((SetOps)this.usedRouteePaths().getOrElse((Object)address, ClusterRouterGroupActor::doAddRoutees$2$$anonfun$1)).$plus((Object)path))));
            this.cell().addRoutee(routee);
        }
        throw new MatchError(option);
    }
}

