/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.routing;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.routing.ClusterRouterConfigBase;
import org.apache.pekko.cluster.routing.ClusterRouterPool$;
import org.apache.pekko.cluster.routing.ClusterRouterPoolActor;
import org.apache.pekko.cluster.routing.ClusterRouterPoolSettings;
import org.apache.pekko.routing.ActorRefRoutee$;
import org.apache.pekko.routing.Pool;
import org.apache.pekko.routing.Resizer;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.RouterActor;
import org.apache.pekko.routing.RouterConfig;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ClusterRouterPool
implements RouterConfig,
Pool,
ClusterRouterConfigBase,
Product {
    private static final long serialVersionUID = 1L;
    private final Pool local;
    private final ClusterRouterPoolSettings settings;
    private final transient AtomicInteger childNameCounter;

    public static ClusterRouterPool apply(Pool pool, ClusterRouterPoolSettings clusterRouterPoolSettings) {
        return ClusterRouterPool$.MODULE$.apply(pool, clusterRouterPoolSettings);
    }

    public static ClusterRouterPool fromProduct(Product product) {
        return ClusterRouterPool$.MODULE$.fromProduct(product);
    }

    public static ClusterRouterPool unapply(ClusterRouterPool clusterRouterPool) {
        return ClusterRouterPool$.MODULE$.unapply(clusterRouterPool);
    }

    public ClusterRouterPool(Pool local, ClusterRouterPoolSettings settings) {
        this.local = local;
        this.settings = settings;
        Predef$.MODULE$.require(local.resizer().isEmpty(), ClusterRouterPool::$init$$$anonfun$6);
        this.childNameCounter = new AtomicInteger();
    }

    @Override
    public /* synthetic */ boolean org$apache$pekko$cluster$routing$ClusterRouterConfigBase$$super$isManagementMessage(Object msg) {
        return RouterConfig.isManagementMessage$((RouterConfig)this, (Object)msg);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ClusterRouterPool)) return false;
        ClusterRouterPool clusterRouterPool = (ClusterRouterPool)object;
        Pool pool = this.local();
        Pool pool2 = clusterRouterPool.local();
        if (pool == null) {
            if (pool2 != null) {
                return false;
            }
        } else if (!pool.equals(pool2)) return false;
        ClusterRouterPoolSettings clusterRouterPoolSettings = this.settings();
        ClusterRouterPoolSettings clusterRouterPoolSettings2 = clusterRouterPool.settings();
        if (clusterRouterPoolSettings == null) {
            if (clusterRouterPoolSettings2 == null) return true;
            return false;
        } else {
            if (!((Object)clusterRouterPoolSettings).equals(clusterRouterPoolSettings2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ClusterRouterPool;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ClusterRouterPool";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "local";
        }
        if (1 == n2) {
            return "settings";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Pool local() {
        return this.local;
    }

    @Override
    public ClusterRouterPoolSettings settings() {
        return this.settings;
    }

    public Routee newRoutee(Props routeeProps, ActorContext context) {
        String name = new StringBuilder(1).append("c").append(this.childNameCounter.incrementAndGet()).toString();
        ActorRef ref = ((ActorCell)context).attachChild(this.local().enrichWithPoolDispatcher(routeeProps, context), name, false);
        return ActorRefRoutee$.MODULE$.apply(ref);
    }

    public int nrOfInstances(ActorSystem sys) {
        if (this.settings().allowLocalRoutees() && this.settings().useRoles().nonEmpty()) {
            if (this.settings().useRoles().subsetOf(((Cluster)Cluster$.MODULE$.apply(sys)).selfRoles())) {
                return this.settings().maxInstancesPerNode();
            }
            return 0;
        }
        if (this.settings().allowLocalRoutees() && this.settings().useRoles().isEmpty()) {
            return this.settings().maxInstancesPerNode();
        }
        return 0;
    }

    public Option<Resizer> resizer() {
        return this.local().resizer();
    }

    public RouterActor createRouterActor() {
        return new ClusterRouterPoolActor(this.local().supervisorStrategy(), this.settings());
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.local().supervisorStrategy();
    }

    public RouterConfig withFallback(RouterConfig other) {
        RouterConfig routerConfig = other;
        if (routerConfig instanceof ClusterRouterPool) {
            ClusterRouterPool clusterRouterPool = ClusterRouterPool$.MODULE$.unapply((ClusterRouterPool)routerConfig);
            Pool pool = clusterRouterPool._1();
            ClusterRouterPoolSettings clusterRouterPoolSettings = clusterRouterPool._2();
            if (pool instanceof ClusterRouterPool) {
                throw new IllegalStateException("ClusterRouterPool is not allowed to wrap a ClusterRouterPool");
            }
            Pool otherLocal = pool;
            return this.copy((Pool)this.local().withFallback((RouterConfig)otherLocal), this.copy$default$2());
        }
        return this.copy((Pool)this.local().withFallback(other), this.copy$default$2());
    }

    public ClusterRouterPool copy(Pool local, ClusterRouterPoolSettings settings) {
        return new ClusterRouterPool(local, settings);
    }

    public Pool copy$default$1() {
        return this.local();
    }

    public ClusterRouterPoolSettings copy$default$2() {
        return this.settings();
    }

    public Pool _1() {
        return this.local();
    }

    public ClusterRouterPoolSettings _2() {
        return this.settings();
    }

    private static final Object $init$$$anonfun$6() {
        return "Resizer can't be used together with cluster router";
    }
}

