/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.routing;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.Deploy;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Scope;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.cluster.routing.ClusterRouterActor;
import org.apache.pekko.cluster.routing.ClusterRouterPoolSettings;
import org.apache.pekko.remote.RemoteScope;
import org.apache.pekko.remote.RemoteScope$;
import org.apache.pekko.routing.Routee;
import org.apache.pekko.routing.RouterConfig;
import org.apache.pekko.routing.RouterPoolActor;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.SortedSet;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class ClusterRouterPoolActor
extends RouterPoolActor
implements ClusterRouterActor {
    private SortedSet nodes;
    private final ClusterRouterPoolSettings settings;

    public ClusterRouterPoolActor(SupervisorStrategy supervisorStrategy, ClusterRouterPoolSettings settings) {
        this.settings = settings;
        super(supervisorStrategy);
        ClusterRouterActor.$init$(this);
    }

    public SortedSet nodes() {
        return this.nodes;
    }

    public void nodes_$eq(SortedSet x$1) {
        this.nodes = x$1;
    }

    private SupervisorStrategy supervisorStrategy$accessor() {
        return super.supervisorStrategy();
    }

    @Override
    public ClusterRouterPoolSettings settings() {
        return this.settings;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.clusterReceive().orElse(super.receive());
    }

    @Override
    public void addRoutees() {
        this.doAddRoutees$1();
    }

    public Option<Address> selectDeploymentTarget() {
        IndexedSeq currentRoutees = this.cell().router().routees();
        SortedSet currentNodes = this.availableNodes();
        if (currentNodes.isEmpty() || currentRoutees.size() >= this.settings().totalInstances()) {
            return None$.MODULE$;
        }
        Map nodeMap = currentNodes.map((Function1 & Serializable)_$1 -> {
            Address address = (Address)Predef$.MODULE$.ArrowAssoc(_$1);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address, (Object)BoxesRunTime.boxToInteger((int)0));
        }, Ordering$.MODULE$.Tuple2(Address$.MODULE$.addressOrdering(), (Ordering)Ordering.Int$.MODULE$)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)0));
        Map numberOfRouteesPerNode = (Map)currentRoutees.foldLeft((Object)nodeMap, (Function2 & Serializable)(acc, x) -> {
            Address address = this.fullAddress((Routee)x);
            Address address2 = (Address)Predef$.MODULE$.ArrowAssoc((Object)address);
            return (Map)acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address2, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)acc.apply((Object)address)) + 1))));
        });
        Tuple2 tuple2 = (Tuple2)numberOfRouteesPerNode.minBy((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToInt((Object)_$2._2()), (Ordering)Ordering.Int$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Address address = (Address)tuple2._1();
        int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)address, (Object)BoxesRunTime.boxToInteger((int)count));
        Address address2 = (Address)tuple22._1();
        int count2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        if (count2 < this.settings().maxInstancesPerNode()) {
            return Some$.MODULE$.apply((Object)address2);
        }
        return None$.MODULE$;
    }

    private final void doAddRoutees$1() {
        Option<Address> option;
        while (true) {
            if (None$.MODULE$.equals(option = this.selectDeploymentTarget())) {
                return;
            }
            if (!(option instanceof Some)) break;
            Address target = (Address)((Some)option).value();
            Props routeeProps = this.cell().routeeProps();
            Config config = ConfigFactory.empty();
            RouterConfig routerConfig = routeeProps.routerConfig();
            RemoteScope remoteScope = RemoteScope$.MODULE$.apply(target);
            String string = Deploy$.MODULE$.apply$default$1();
            String string2 = Deploy$.MODULE$.apply$default$5();
            String string3 = Deploy$.MODULE$.apply$default$6();
            Deploy deploy = Deploy$.MODULE$.apply(string, config, routerConfig, (Scope)remoteScope, string2, string3);
            Routee routee = this.pool().newRoutee(routeeProps.withDeploy(deploy), this.context());
            this.cell().addRoutee(routee);
        }
        throw new MatchError(option);
    }
}

